<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ApiAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (!empty($request->user())) {
            if($request->user()->active_flg == INACTIVE || $request->user()->delete_flg == DELETED){
                $request->user()->currentAccessToken()->delete();
                return response()->json([
                    'status' => HTTP_NOT_FOUND,
                    'message' => 'Tài khoản của bạn không còn hoạt động'
                ]);
            }
            return $next($request);
        }else{
            return response()->json([
                'status' => HTTP_UNAUTHORIZED,
                'message' => 'Bạn chưa đăng nhập tài khoản'
            ]);
        }
    }
}
