<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Wallet;
use App\Models\Recharge;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\WalletFluctuation;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

class WalletController extends Controller
{

    public function getWalletByUser(Request $request)
    {
        $request_data = $request->all();
        $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;

        if ($is_api) {
            $user = $request->user();
        } else {
            $user = auth()->user();
        }

        $wallet = Wallet::where('user_id', $user->user_id)->first();
        if (!$wallet) {
            $wallet = Wallet::create([
                'user_id' => $user->user_id,
                'amount' => 0
            ]);
        }

        return response()->json([
            'status' => HTTP_OK,
            'wallet' => $wallet
        ]);
    }

    //Tạo yêu cầu rút tiền
    public function handleRecharge(Request $request)
    {

        $request->validate([
            'amount' => 'required|min:0',
            'image' => 'required',
        ]);

        $request_data = $request->all();
        $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;

        $user = $is_api ? $request->user() : auth()->user();
        $user_id = $user->user_id;
        try {

            if (isset($request_data['type']) && !in_array($request_data['type'], [PAY_DIRECT, PAY_VNPAY, PAY_USDT, PAY_PERSONAL])) {
                return response()->json([
                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                    'message' => "Dữ liệu truyền vào lỗi",
                ]);
            }
            // Lưu lại hình ảnh bằng chứng nạp
            $image_name  = '';

            if ($is_api) {
                $user = $request->user();
                $name_img = $user['user_code'] . '-' . time();
                convertImagesBase64ToDirectory([$request_data['image']], PUBLIC_PATH_RECHARGE_IMAGE, $name_img);
                $image_name = PUBLIC_PATH_RECHARGE_IMAGE . '/' .  $name_img . '.jpg';
            } else {
                $file = $request->file('image');
                if ($file) {
                    $user = auth()->user();
                    $path = PUBLIC_PATH_RECHARGE_IMAGE; // Đường dẫn đích tùy chỉnh
                    $fileName = time() . '-' . 'RC' . time() . rand(100, 999) . '.jpg'; // Lấy tên gốc của tệp
                    $file->move(public_path(PUBLIC_PATH_RECHARGE_IMAGE), $fileName);
                    // Lấy đường dẫn tới tệp video sau khi đã lưu trữ
                    $image_name = $path .  '/' . $fileName;
                } else if (strpos($request_data['image'], "data:image")) {
                }
            }

            if ($request_data['type'] == PAY_USDT) {
                $path = 'public/config/setting-recharge.json';
                $settings = json_decode(Storage::get($path), true);
                $request_data['usdt_price'] = $request_data['amount'];
                $request_data['amount'] = $request_data['usdt_price'] * ($settings['usdt']['data']['price'] ?? 1);
            }

            // Các dữ liệu mặc phải có
            $data = [
                'user_id' => $user_id,
                'amount' => $request_data['amount'],
                'price_other' => $request_data['usdt_price'] ?? null,
                'note' => isset($request_data['note']) ? $request_data['note'] : '',
                'image' => $image_name,
                'code' => "KG" . time(),
                'type' => isset($request_data['type']) && is_numeric($request_data['type']) ? $request_data['type'] : PAY_USDT,
            ];

            // Dành cho khi admin khởi tạo nạp tiền cho tài khoản khác
            if ($user['position_id'] == 1 && isset($request_data['created_by']) && $request_data['created_by'] == 'admin') {
                if (isset($request_data['user_id'])) {
                    $data['user_id'] =  $request_data['user_id'];
                }
                $data['status'] = 1;
                $data['admin_id'] =  auth()->id();
                if (isset($request_data['admin_note'])) {
                    $data['admin_note'] =  $request_data['admin_note'];
                }
            }

            DB::beginTransaction();
            $res = [
                'status' => HTTP_OK,
                'message' => "Khởi tạo yêu cầu nạp tiền thành công"
            ];
            $recharge = Recharge::create($data);

            if (isset($data['status']) && $data['status'] == 1 && isGetAllData()) {
                $res = $this->handleUpdateRecharge($request_data);
                $data = [
                    "user_id" => $recharge->user_id,
                    "amount" => $recharge->amount,
                    "kind" => PLUS,
                    "content" => "Cộng tiền vào tài khoản thành công"
                ];
                $res = actionWallet($data);
            }

            DB::commit();

            return response()->json($res);
        } catch (\Throwable $th) {
            if (isset($image_name) && File::exists($image_name)) {
                File::delete($image_name);
            }
            return response()->json([
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'message' => "Xảy ra lỗi không xác đinh!",
                'errors' => $th->getMessage(),
            ]);
            // return showMessageError();
        }
    }

    // Hàm lấy danh sách các yêu cầu
    public function showListRecharge(Request $request)
    {
        $request_data = $request->all();
        $is_api = $request->is('api/*');
        try {
            $recharges = Recharge::isActive();

            if (empty($request_data['get'])) {
                if ($is_api) {
                    $user = $request->user();
                } else {
                    $user = auth()->user();
                }
                if (!isGetAllData()) {
                    $recharges->where('recharges.user_id', $user->user_id);
                }
            }

            $limit = isset($request_data['limit']) ? $request_data['limit'] : 10;
            $page = isset($request_data['page']) ? $request_data['page'] : 1;

            if (isset($request_data['get'])) {
            }
            $recharges = $recharges->leftJoin('users as user', 'recharges.user_id', '=', 'user.user_id')
                ->leftJoin('users as admin', 'recharges.admin_id', '=', 'admin.user_id');

            $recharges = $recharges->isFilters($request->filters)
                ->select(
                    'recharges.*',
                    'admin.user_name as admin_email',
                    'admin.user_contact_name as admin_contact_name',
                    'user.user_name as user_email',
                    DB::raw("
                    CASE 
                        WHEN recharges.status = 0 THEN 'Chờ xác nhận'
                        WHEN recharges.status = 1 THEN 'Thành công'
                        WHEN recharges.status = 2 THEN 'Thất bại'
                        ELSE 'Không xác định'
                    END as status_label
                    "),
                    DB::raw("
                    CASE 
                        WHEN type = 0 THEN 'Chuyển khoản'
                        WHEN type = 1 THEN 'Tiền mặt'
                        ELSE 'Không xác định'
                    END as type_label
                ")
                );
            if (isset($request_data['filters']['key_type']) && $request_data['filters']['key_type'] == 'email') {
                $keywords = $request_data['filters']['keywords'] ?? "";
                $recharges = $recharges->where("user.user_name", 'like', '%' . $keywords . '%');
                // $recharges = $recharges->where(function ($query) use ($keywords) {
                //     return $query->where("admin_email", 'like', '%' . $keywords . '%')
                //         ->orWhere("user_email", 'like', '%' . $keywords . '%');
                // });
            }
            if (isset($request->orders)) {
                $recharges = $recharges->isOrderBy($request->orders);
            } else {
                $recharges = $recharges->orderBy('recharges.updated_at', 'desc');
            }
            $recharges = $recharges->groupBy('recharge_id')->paginate($limit, ['*'], 'page', $page);
            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $recharges->toArray()['data'],
                    'message' => 'Danh sách yêu cầu nạp tiền'
                ]);
            } else {
                if (isset($request_data['get'])) {
                    $html = view('recharge.ajax.table-recharge', compact('recharges'))->render();
                } else {
                    $html = view('profile.ajax.table-recharge', compact('recharges'))->render();
                }
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html,
                    'message' => 'Danh sách yêu cầu nạp tiền'
                ]);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'message' => "Xảy ra lỗi không xác đinh!",
                'errors' => $th->getMessage(),
            ]);
        }
    }

    public function showListWalletFlut(Request $request)
    {
        $request_data = $request->all();
        $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
        try {
            $wallet_fluts = WalletFluctuation::where('wallet_fluctuations.delete_flg', NO_DELETE);
            if (empty($request_data['get'])) {
                if ($is_api) {
                    $user = $request->user();
                } else {
                    $user = auth()->user();
                }
                if (!isGetAllData()) {
                    $wallet_fluts->where('wallet_fluctuations.user_id', $user->user_id);
                }
            }

            $limit = isset($request_data['limit']) ? $request_data['limit'] : 10;
            $page = isset($request_data['page']) ? $request_data['page'] : 1;

            $wallet_fluts = $wallet_fluts->isFilters($request->filters)
            ->orderBy('wallet_fluctuation_id', 'desc')
                ->select(
                    'wallet_fluctuations.*',
                    DB::raw("
                    CASE 
                        WHEN wallet_fluctuations.kind = 0 THEN 'Cộng tiền'
                        WHEN wallet_fluctuations.kind = 1 THEN 'Trừ tiền'
                        ELSE 'Không xác định'
                    END as kind_label
                    ")
                )->groupBy('wallet_fluctuation_id')->paginate($limit, ['*'], 'page', $page);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $wallet_fluts->toArray()['data'],
                    'message' => 'Danh sách yêu cầu nạp tiền'
                ]);
            } else {
               
                $html = view('profile.ajax.table-wallet-flut', compact('wallet_fluts'))->render();
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html,
                    'message' => 'Danh sách yêu cầu nạp tiền'
                ]);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'message' => "Xảy ra lỗi không xác định!",
                'errors' => $th->getMessage(),
            ]);
        }
    }

    // Đi đến layout danh sách các yêu cầu
    public function displayAllRecharge()
    {
        $users = User::where('delete_flg', NO_DELETE)->where('active_flg', ACTIVE)
            ->select('user_id', 'user_name')->get();
        $path = 'public/config/setting-recharge.json';
        $recharge_settings = json_decode(Storage::get($path), true);
        return view('recharge.index', compact('users', 'recharge_settings'));
    }

    // Hàm lấy thông tin chi tiết của yêu cầu
    public function handleShowDetailRecharge(Request $request)
    {
        $request_data = $request->all();
        $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;

        try {
            if ($is_api) {
                $user = $request->user();
            } else {
                $user = auth()->user();
            }

            $recharges = Recharge::where('recharges.delete_flg', NO_DELETE);
            if (isset($request_data['code'])) {
                $recharges = $recharges->where('code', $request_data['code']);
            } else {
                $recharges = $recharges->where('recharge_id', $request_data['recharge_id']);
            }

            // if (!$is_api && isset($request_data['user_id'])) {
            //     $recharges->where('recharges.user_id', $request_data['user_id']);
            // } else {
            //     $recharges->where('recharges.user_id', $user->user_id);
            // }

            $recharges = $recharges->select(
                'recharges.*',
                DB::raw("
                    CASE 
                        WHEN recharges.status = 0 THEN 'Chờ xác nhận'
                        WHEN recharges.status = 1 THEN 'Thành công'
                        WHEN recharges.status = 2 THEN 'Thất bại'
                        ELSE 'Không xác định'
                    END as status_label
                    "),
                DB::raw("
                    CASE 
                        WHEN type = 0 THEN 'Chuyển khoản'
                        WHEN type = 1 THEN 'Tiền mặt'
                        ELSE 'Không xác định'
                    END as type_label
                ")
            )->first();

            $user = User::where('user_id', $recharges->user_id)
                ->leftJoin('positions', 'users.position_id', 'positions.position_id')
                ->select('users.*', 'positions.position_name')
                ->first();
            $admin = [];
            if (isset($recharges->admin_id)) {
                $admin = User::find($recharges->admin_id);
            }

            $data = [
                "recharge" => $recharges,
                "user" => $user,
                "admin" => $admin
            ];

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $data,
                    'message' => 'Thông tin chi tiết yêu cầu'
                ]);
            } else {
                if ($request->is('*user')) {
                    $data['hidden'] = true;
                } else {
                    $data['hidden'] = false;
                }
                $html = view('recharge.ajax.detail-recharge', compact('data'))->render();
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html,
                    'message' => 'Thông tin chi tiết yêu cầu'
                ]);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'message' => 'Serve xảy ra lỗi',
                'error' => $th->getMessage()
            ]);
        }
    }

    // Hàm để admin xác nhận là yêu cầu rút tiền thất bại
    public function onFailRecharge(Request $request)
    {

        $request->validate([
            'key' => 'required',
        ]);

        $request_data = $request->all();
        $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;

        $request_data['status'] = FAIL;
        $res = $this->handleUpdateRecharge($request_data);
        return $res;
    }

    // Hàm để admin xác nhận là yêu cầu rút tiền thành công
    public function onSuccessRecharge(Request $request)
    {
        $request->validate([
            'key' => 'required',
        ]);

        $request_data = $request->all();
        $request_data['status'] = SUCCESS;
        // $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;

        $res = $this->handleUpdateRecharge($request_data);
        return $res;
    }

    // Hàm để cập nhật Yêu cầu rút tiền
    private function handleUpdateRecharge($data)
    {
        try {
            DB::beginTransaction();
            $res = [];
            $recharge = Recharge::find($data['key']);

            $recharge->update([
                'status' => $data['status'],
                'admin_id' => auth()->id(),
                'admin_note' => isset($data['admin_note']) ? $data['admin_note'] : null,
            ]);

            if ($data['status'] == SUCCESS) {
                $data = [
                    "user_id" => $recharge->user_id,
                    "amount" => $recharge->amount,
                    "kind" => PLUS,
                    "content" => "Công tiền giao dịch nạp, mã: " . $recharge->code
                ];
                $res = actionWallet($data);
            } else if ($data['status'] == FAIL) {
                $res = [
                    'status' => HTTP_OK,
                    'message' => 'Đã từ chối yêu cầu'
                ];
            } else {
                $res = [
                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                    'message' => 'Trạng thái cập nhật yêu cầu bất thường'
                ];
            }

            DB::commit();

            return response()->json($res);
        } catch (\Throwable $th) {
            DB::rollBack();
            return response()->json([
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'message' => "Xảy ra lỗi không xác đinh!",
                'errors' => $th->getMessage(),
            ]);
        }
    }

    // Hàm lấy thống kê danh sách yêu cầu nạp
    public function getStatistical(Request $request)
    {

        try {

            $startDate = Carbon::parse($request->start_date);
            $endDate = Carbon::parse($request->end_date);

            $status = isset($request->status) ? $request->status : 1;
            $statiscal = Recharge::where('status', $status)->isActive()->orderBy('updated_at');
            switch ($request->kind) {
                case 'day':
                    $statiscal = $statiscal->selectRaw('DATE(updated_at) as name, SUM(amount) as total_revenue')
                        ->whereBetween('updated_at', [$startDate, $endDate])
                        ->groupBy('name')
                        ->get()->toArray();
                    break;

                case 'month':
                    $statiscal = $statiscal->selectRaw('YEAR(updated_at) as year, CONCAT("Tháng ", MONTH(updated_at)) as name, SUM(amount) as total_revenue')
                        ->whereBetween('updated_at', [$startDate, $endDate])
                        ->groupBy('year', 'name')
                        ->get()->toArray();
                    break;

                case 'year':
                    $statiscal = $statiscal->selectRaw('CONCAT("Năm ", YEAR(updated_at)) as name, SUM(amount) as total_revenue')
                        ->whereBetween('updated_at', [$startDate, $endDate])
                        ->groupBy('name')
                        ->get();
                    break;

                default:
                    # code...
                    break;
            }

            $name_tbl = ["Chờ xác nhận", "Thành công", "Thất bại"];

            $name_chart = [];
            $revenue_chart = [];
            foreach ($statiscal as $key => $value) {
                $name_chart[$key] = $value['name'];
                $revenue_chart[$key] = $value['total_revenue'];
            }
            return response()->json([
                'status' => HTTP_OK,
                'data' => [
                    'name_tbl' => $name_tbl[$status],
                    'name_chart' => $name_chart,
                    'revenue_chart' => $revenue_chart
                ]
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'message' => "Xảy ra lỗi không xác đinh!",
                'errors' => $th->getMessage(),
            ]);
        }
    }

    public function handleVNPAY(Request $request)
    {
        $this->validate($request, [
            'amount' => 'required|numeric|min:10000',
        ]);
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
            $user = $is_api ? $request->user() : auth()->user();

            $amount = $request_data['amount'];
            // $code_token = 'achau-' . Str::random(12) . '|' . time();
            $code_token = "KG" . time();
            $ip = request()->ip();
            $url = route('recharge.vnpay.return');
            $note = isset($request_data['note']) ? $request_data['note'] : '';
            $vnp_Url = $this->getVNPAY($amount, $code_token, $ip, $url, $note);


            DB::beginTransaction();

            $recharge = Recharge::create([
                'user_id' => $user['position_id'] == 1 ? (isset($request_data['user_id']) ? $request_data['user_id'] : $user['user_id']) : $user['user_id'],
                // 'token' => $code_token,
                'amount' => $request_data['amount'],
                'note' => $note,
                'type' => PAY_VNPAY,
                'admin_id' => auth()->id(),
                'active_flg' => INACTIVE,
                // 'token' => $code_token,
                'code' => $code_token
            ]);

            DB::commit();

            return response()->json([
                'status' => HTTP_OK,
                'message' => "thành công",
                'url' => $vnp_Url,
                'recharge' => $recharge
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return response()->json([
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'message' => "Xảy ra lỗi không xác định",
            ]);
        }
    }


    public function returnVNPAY(Request $request)
    {
        try {
            $request_data = $request->all();
            $result = onReturnVnpay($request_data);
            DB::beginTransaction();
            $recharge = Recharge::where('code', $request_data['vnp_TxnRef'])->first();
            if ($result['status'] == 200) {
                // $recharge->update([
                //     'status' => SUCCESS,
                //     'active_flg' => ACTIVE
                // ]);

                // $data = [
                //     "user_id" => $recharge->user_id,
                //     "amount" => $recharge->amount,
                //     "kind" => PLUS,
                //     "content" => "Công tiền giao dịch nạp, mã: " . $recharge->code
                // ];
                // $res = actionWallet($data);

                $request_data['date'] = Carbon::createFromFormat('YmdHis', $request_data['vnp_PayDate'])->toDateTimeString();
                $result = [
                    'status' => true,
                    'message' => 'Giao dịch thành công',
                    'data' => $request_data
                ];
            } else {
                $resText = config('constans.messages.vnp_ResponseCode');
                $result = [
                    'status' => false,
                    'message' => isset($resText) ? $resText[$request_data['vnp_ResponseCode']] : 'Xảy lỗi  ' . $request_data['vnp_ResponseCode'],
                    'data' => $request_data
                ];
                // $recharge->update([
                //     'status' => FAIL,
                //     'active_flg' => ACTIVE
                // ]);
            }
            return view('recharge.return-vnpay', compact('result'));
        } catch (\Throwable $th) {
            abort('404');
        }
    }

    public function returnVNPAY2(Request $request)
    {
        try {

            $queryParams = $request->query();

            if ($this->checkReturnVNPAY($queryParams) == $queryParams['vnp_SecureHash']) {
                DB::beginTransaction();
                $recharge = Recharge::where('code', $queryParams['vnp_TxnRef'])->first();
                if ($queryParams['vnp_ResponseCode'] == '00') {
                    $recharge->update([
                        'status' => SUCCESS,
                        'active_flg' => ACTIVE
                    ]);

                    $data = [
                        "user_id" => $recharge->user_id,
                        "amount" => $recharge->amount,
                        "kind" => PLUS,
                        "content" => "Công tiền giao dịch nạp, mã: " . $recharge->code
                    ];
                    $res = actionWallet($data);

                    $queryParams['date'] = Carbon::createFromFormat('YmdHis', $queryParams['vnp_PayDate'])->toDateTimeString();
                    $result = [
                        'status' => true,
                        'message' => 'Giao dịch thành công',
                        'data' => $queryParams
                    ];
                } else {
                    $resText = config('constans.messages.vnp_ResponseCode');
                    $result = [
                        'status' => false,
                        'message' => isset($resText) ? $resText[$queryParams['vnp_ResponseCode']] : 'Xảy lỗi  ' . $queryParams['vnp_ResponseCode'],
                    ];
                    $recharge->update([
                        'status' => FAIL,
                        'active_flg' => ACTIVE
                    ]);
                }
                DB::commit();
                return view('recharge.return-vnpay', compact('result'));
            }
            return abort('404');
        } catch (\Throwable $th) {
            return abort('404');
        }
    }

    public function getVNPAY($amount, $code_token, $ip, $route, $note)
    {

        $vnp_TxnRef = $code_token; //Mã giao dịch thanh toán tham chiếu của merchant
        $vnp_Amount = $amount * 100; // Số tiền thanh toán
        $vnp_Locale = 'vn'; //Ngôn ngữ chuyển hướng thanh toán
        $vnp_BankCode = ''; //Mã phương thức thanh toán
        $vnp_IpAddr = $ip; //IP Khách hàng thanh toán
        $vnp_Url = "https://sandbox.vnpayment.vn/paymentv2/vpcpay.html";
        // https://sandbox.vnpayment.vn/paymentv2/vpcpay.html
        $vnp_Returnurl = $route;

        $vnp_apiUrl = "http://sandbox.vnpayment.vn/merchant_webapi/merchant.html";
        $apiUrl = "https://sandbox.vnpayment.vn/merchant_webapi/api/transaction";

        $startTime = date("YmdHis");
        $expire = date('YmdHis', strtotime('+15 minutes', strtotime($startTime)));

        $key_vnpay = getDataVNpay();
        $vnp_HashSecret = $key_vnpay['vnp_HashSecret'];
        $inputData = array(
            "vnp_Version" => "2.1.0",
            "vnp_TmnCode" => $key_vnpay['vnp_TmnCode'],
            "vnp_Amount" => $vnp_Amount,
            "vnp_Command" => "pay",
            "vnp_CreateDate" => date('YmdHis'),
            "vnp_CurrCode" => "VND",
            "vnp_IpAddr" => $vnp_IpAddr,
            "vnp_Locale" => $vnp_Locale,
            "vnp_OrderInfo" => "Thanh-toan-GD-" . $vnp_TxnRef,
            "vnp_OrderType" => "other",
            "vnp_ReturnUrl" => $vnp_Returnurl,
            "vnp_TxnRef" => $vnp_TxnRef,
            "vnp_ExpireDate" => $expire
        );

        if (isset($vnp_BankCode) && $vnp_BankCode != "") {
            $inputData['vnp_BankCode'] = $vnp_BankCode;
        }

        ksort($inputData);
        $query = "";
        $i = 0;
        $hashdata = "";

        foreach ($inputData as $key => $value) {
            if ($i == 1) {
                $hashdata .= '&' . urlencode($key) . "=" . urlencode($value);
            } else {
                $hashdata .= urlencode($key) . "=" . urlencode($value);
                $i = 1;
            }
            $query .= urlencode($key) . "=" . urlencode($value) . '&';
        }

        $vnp_Url = $vnp_Url . "?" . $query;
        if (isset($vnp_HashSecret)) {
            $vnpSecureHash =   hash_hmac('sha512', $hashdata, $vnp_HashSecret); //  
            $vnp_Url .= 'vnp_SecureHash=' . $vnpSecureHash;
        }

        return $vnp_Url;
    }

    function checkReturnVNPAY($userBillData)
    {
        try {
            $vnp_SecureHash = $userBillData['vnp_SecureHash'];
            $inputData = [];
            foreach ($userBillData as $key => $value) {
                if (substr($key, 0, 4) == "vnp_") {
                    $inputData[$key] = $value;
                }
            }

            unset($inputData['vnp_SecureHash']);
            ksort($inputData);
            $i = 0;
            $hashData = "";
            foreach ($inputData as $key => $value) {
                if ($i == 1) {
                    $hashData = $hashData . '&' . urlencode($key) . "=" . urlencode($value);
                } else {
                    $hashData = $hashData . urlencode($key) . "=" . urlencode($value);
                    $i = 1;
                }
            }

            $secureHash = hash_hmac('sha512', $hashData, vnp_HashSecret);

            return $secureHash;
        } catch (\Throwable $th) {
            abort('404');
        }
    }

    public function showRechargeSetting(Request $request)
    {
        try {
            return response()->json([
                'status' => HTTP_OK,
                'setting' => getRechargeSetting()
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'message' => [
                    'icon' => 'warning',
                    'title' => 'Cảnh báo',
                    'text' => "Dữ liệu lỗi!"
                ],
                'errors' => $th->getMessage(),
            ]);
        }
    }

    public function handleRechargeSetting(Request $request)
    {
        $request_data = $request->all();
        try {
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
            $user = $is_api ? $request->user() : auth()->user();

            if (!isGetAllData()) {
                return response()->json([
                    'status' => HTTP_BAD_REQUEST,
                    'message' => [
                        'icon' => 'warning',
                        'title' => 'Cảnh báo',
                        'text' => "Bạn không đủ quyền hạn!"
                    ],
                ]);
            }
            $path = 'public/config/setting-recharge.json';
            $settings = json_decode(Storage::get($path), true);

            switch ($request->kind) {
                case PAY_DIRECT:
                    $settings['direct']['content'] = $request->content;
                    break;

                case PAY_VNPAY:
                    $settings['vnpay']['content'] = $request->content;
                    break;

                case PAY_USDT:
                    if (!($request->usdt_price_convert > 0)) {
                        return returnResponse(HTTP_BAD_REQUEST, 'Số tiền chuyển đổi phải lớn hơn 0');
                    }
                    $settings['usdt']['content'] = $request->content;
                    $settings['usdt']['data'] = ['price' => $request->usdt_price_convert];
                    break;
                case PAY_PERSONAL:
                    $settings['personal']['content'] = $request->content;
                    break;
                default:
                    return response()->json([
                        'status' => HTTP_BAD_REQUEST,
                        'message' => [
                            'icon' => 'warning',
                            'title' => 'Cảnh báo',
                            'text' => "Dữ liệu lỗi!"
                        ],
                    ]);
                    break;
            }

            Storage::put($path, json_encode($settings, JSON_PRETTY_PRINT));
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'icon' => 'success',
                    'title' => 'Thông báo',
                    'text' => "Cập nhật thành công"
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return response()->json([
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'message' => [
                    'icon' => 'warning',
                    'title' => 'Cảnh báo',
                    'text' => "Dữ liệu lỗi!"
                ],
                'errors' => $th->getMessage(),
            ]);
        }
    }
}
