<?php

namespace App\Http\Controllers;

use services;
use Carbon\Carbon;
use App\Models\City;
use App\Models\User;
use App\Models\Debit;
use App\Models\State;
use App\Models\Branch;
use App\Models\CheckedPaymentCash;
use App\Models\Wallet;
use App\Models\Country;
use App\Models\Invoice;
use App\Models\Package;
use App\Models\Service;
use App\Models\Receiver;
use App\Models\Recharge;

use App\Models\Shipment;
use App\Utils\AfterShip;
use Illuminate\Http\Request;
use App\Models\DeleteAccount;
use App\Models\PriceListUser;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use App\Models\CountryAndServiceLink;
use App\Models\HistoryScan;
use App\Models\OrderPickup;
use App\Models\ShipmentOperatingCost;
use App\Models\Statement;
use Illuminate\Support\Facades\Storage;
use function PHPUnit\Framework\returnSelf;

class UtilitiesController extends Controller
{
    public function vnpayIpn(Request $request)
    {
        $returnData = [];
        try {
            $clientIp = $request->ip();

            $vnp_HashSecret = getDataVNpay()['vnp_HashSecret']; // Lấy secret từ file cấu hình

            // Lấy tất cả các tham số từ request
            $inputData = $request->only(array_filter(array_keys($request->all()), function ($key) {
                return substr($key, 0, 4) === 'vnp_';
            }));

            $vnp_SecureHash = $inputData['vnp_SecureHash'];
            unset($inputData['vnp_SecureHash']);

            // Sắp xếp các tham số theo thứ tự từ điển
            ksort($inputData);
            $hashData = urldecode(http_build_query($inputData));

            // Tạo secure hash để kiểm tra tính toàn vẹn của dữ liệu
            $secureHash = hash_hmac('sha512', $hashData, $vnp_HashSecret);

            // Các tham số cần thiết
            $vnpTranId = $inputData['vnp_TransactionNo']; // Mã giao dịch tại VNPAY
            $vnp_BankCode = $inputData['vnp_BankCode'];   // Ngân hàng thanh toán
            $vnp_Amount = $inputData['vnp_Amount'] / 100; // Số tiền thanh toán
            $orderId = $inputData['vnp_TxnRef'];          // Mã đơn hàng
            $Status = 0;


            // Kiểm tra checksum
            if ($secureHash === $vnp_SecureHash) {
                // Lấy thông tin đơn hàng từ database
                $recharge = Recharge::where('code', $inputData['vnp_TxnRef'])->first();
                $resIpVnpay = config('constans.messages.ip_vnpay');
                if (!in_array($clientIp, $resIpVnpay)) {
                    DB::table('ipn_vnpay_histories')->insert([
                        "transaction_code" => $recharge->code ?? $orderId,
                        "res_code" => "404",
                        "note" => "Ip không thuộc của VNPAY",
                        "ip_server" => $clientIp ?? "404",
                        "created_at" => now(),  // Thêm thủ công
                        "updated_at" => now()   // Thêm thủ công
                    ]);
                    $returnData['RspCode'] = '99';
                    $returnData['Message'] = 'Unknown error';
                    return response()->json($returnData);
                }
                if ($recharge) {
                    if ($recharge->amount != $vnp_Amount) {
                        $returnData['RspCode'] = '04';
                        $returnData['Message'] = 'Invalid amount';
                    } else if ($recharge->active_flg != INACTIVE) {
                        $returnData['RspCode'] = '02';
                        $returnData['Message'] = 'Order already confirmed';
                    } else if ($inputData['vnp_ResponseCode'] === '00') {
                        $recharge->update([
                            'status' => SUCCESS,
                            'active_flg' => ACTIVE,
                            'note' => "Thanh toán qua VNpay"
                        ]);
                        $data = [
                            "user_id" => $recharge->user_id,
                            "amount" => $recharge->amount,
                            "kind" => PLUS,
                            "content" => "Công tiền giao dịch nạp, mã: " . $recharge->code
                        ];
                        actionWallet($data);
                        $returnData['RspCode'] = '00';
                        $returnData['Message'] = 'Confirm Success';
                    } else {
                        $recharge->update([
                            'status' => FAIL,
                            'active_flg' => ACTIVE,
                            'note' => 'Thanh toán Vnpay thất bại'
                        ]);
                        $returnData['RspCode'] = '00';
                        $returnData['Message'] = 'Confirm Success';
                    }
                } else {
                    $returnData['RspCode'] = '01';
                    $returnData['Message'] = 'Order not found';
                }
            } else {
                $returnData['RspCode'] = '97';
                $returnData['Message'] = 'Invalid signature';
            }
        } catch (\Throwable $e) {
            $returnData['RspCode'] = '99';
            $returnData['Message'] = 'Unknown error';
        }

        DB::table('ipn_vnpay_histories')->insert([
            "transaction_code" => $recharge->code ?? null,
            "res_code" => $returnData['RspCode'] ?? "422",
            "note" => $returnData['Message'] ?? "Lỗi không xác định",
            "ip_server" => $clientIp ?? "422"
        ]);

        return response()->json($returnData);
    }

    public function displayIntructVnpay()
    {
        return view('template.huong-dan-vnpay');
    }

    public function getAreas(Request $request)
    {
        try {
            $request_data = $request->all();
            $country_id = isset($request_data['country_id']) ? $request_data['country_id'] : null;
            $state_id = isset($request_data['state_id']) ? $request_data['state_id'] : null;

            $countries = Country::isActive(ACTIVE)->isDelete(NO_DELETE)->select('country_id', 'country_name', 'country_code')->get()->toArray();
            $areas = [
                'countries' => $countries,
                'states' => [],
                'cities' => [],
            ];

            if (isset($country_id) || $country_id != "") {
                $areas['states'] = State::isCountry($country_id)->isActive(ACTIVE)->isDelete(NO_DELETE)
                    ->select('state_id', 'state_name', 'state_code', 'state_post_code')
                    ->get()->toArray();
            }
            if ((isset($country_id) || $country_id != "")) {
                // if ((isset($country_id) || $country_id != "") && (isset($state_id) || $state_id != "")) {
                $areas['cities'] = City::isCountry($country_id);
                if (isset($state_id) || $state_id != "") {
                    $areas['cities'] = $areas['cities']->isState($state_id);
                }
                $areas['cities'] = $areas['cities']
                    ->isActive(ACTIVE)->isDelete(NO_DELETE)
                    ->select('city_id', 'city_name', 'city_post_code')
                    ->get()->toArray();
            }

            return response()->json([
                'status' => HTTP_OK,
                'areas' => $areas
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getServicesByCountry(Request $request)
    {
        try {
            $request_data = $request->all();
            $country_id = isset($request_data['country_id']) ? $request_data['country_id'] : null;
            $services = [];
            if (isset($country_id) || $country_id != "") {
                $services = CountryAndServiceLink::isCountry($country_id)->isActive(ACTIVE)->isDelete(NO_DELETE)
                    ->join('services', 'country_and_service_links.service_id', '=', 'services.service_id');

                if (isset($request_data['service_promotion_id']) && $request_data['service_promotion_id'] != "") {
                    $services = $services->where('promotion_flg', $request_data['service_promotion_id'] == 2 ? '=' : '!=', 2);
                }
                $services = $services->where('services.delete_flg', NO_DELETE)->where('services.active_flg', ACTIVE);
                $services = $services->select('services.service_id', 'services.service_name')->get()->toArray();
            }



            return response()->json([
                'status' => HTTP_OK,
                'services' => $services,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getReceiverInformation(Request $request)
    {
        try {
            $request_data = $request->all();
            $receiver_id = isset($request_data['receiver_id']) ? $request_data['receiver_id'] : null;
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $user = $request->user();

            $receiver = Receiver::isUser($user['user_id'])->isActive(ACTIVE)->isDelete(NO_DELETE)->findOrFail($receiver_id)->toArray();

            return response()->json([
                'status' => HTTP_OK,
                'receiver' => $receiver
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getStatesByCountry(Request $request)
    {
        try {
            $request_data = $request->all();
            $filters = $request_data['filters'] ?? null;
            $country_id = isset($request_data['country_id']) ? $request_data['country_id'] : null;

            $states = State::isCountry($country_id)->isFilters($filters)
                ->isActive(ACTIVE)->isDelete(NO_DELETE)
                ->select('state_id', 'state_name', 'state_code', 'state_post_code');
            if (isset($request_data['is_html'])) {
                $states = $states->isPaginate($request->paginate);
                $html = view('supports.areas.ajax.table-states', compact('states'))->render();
                if (!isset($request_data['country_id'])) {
                    $html = '<div class="text-center">Vui lòng chọn quốc gia</div>';
                }
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html
                ]);
            }

            $states = $states->get()->toArray();
            return response()->json([
                'status' => HTTP_OK,
                'states' => $states
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getCitiesByCountryAndState(Request $request)
    {
        try {
            $request_data = $request->all();
            $filters = $request_data['filters'] ?? null;
            $country_id = isset($request_data['country_id']) ? $request_data['country_id'] : null;
            $state_id = isset($request_data['state_id']) ? $request_data['state_id'] : null;

            $cities = City::isCountry($country_id)->isFilters($filters);
            if (isset($state_id)) {
                $cities = $cities->isState($state_id);
            }
            $cities = $cities->isActive(ACTIVE)->isDelete(NO_DELETE)
                ->select('city_id', 'city_name', 'city_post_code');


            $cities = $cities->isPaginate($request->paginate);
            if (isset($request_data['is_html'])) {
                $html = view('supports.areas.ajax.table-cities', compact('cities'))->render();
                if (!isset($request_data['country_id'])) {
                    $html = '<div class="text-center">Vui lòng chọn quốc gia</div>';
                }
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html
                ]);
            }

            // $cities = $cities->get()->toArray();
            return response()->json([
                'status' => HTTP_OK,
                'cities' => $cities->toArray()['data']
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getCitiesByCountry(Request $request)
    {
        try {
            $request_data = $request->all();
            $country_id = isset($request_data['country_id']) ? $request_data['country_id'] : null;

            $cities = City::isCountry($country_id)
                ->isActive(ACTIVE)->isDelete(NO_DELETE)
                ->select('city_id', 'city_name')
                ->get()->toArray();

            return response()->json([
                'status' => HTTP_OK,
                'cities' => $cities
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getAreasInVietNam(Request $request)
    {
        try {
            $request_data = $request->all();
            $city = isset($request_data['city']) ? $request_data['city'] : null;
            $district = isset($request_data['district']) ? $request_data['district'] : null;

            $cities = collect(config('constans.area'))->pluck('name')->toArray();
            $areas = [
                'cities' => $cities,
                'districts' => [],
                'wards' => [],
            ];
            if (isset($city) || $city !== "") {
                $areas['districts'] = collect(config('constans.area.' . $city . '.districts'))->pluck('name')->toArray();
            }
            if ((isset($city) || $city !== "") && (isset($district) || $district !== "")) {
                $areas['wards'] = collect(config('constans.area.' . $city . '.districts.' . $district . '.wards'))->pluck('name')->toArray();
            }

            return response()->json([
                'status' => HTTP_OK,
                'areas' => $areas
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }


    public function downloadExcelItemSubPriceList()
    {
        return view('download.excel.item-sub-price-list');
    }

    public function getCountries(Request $request)
    {
        try {
            $countries = Country::isActive(ACTIVE)->isDelete(NO_DELETE)->select('country_id', 'country_name', 'country_code')->get();

            return response()->json([
                'status' => HTTP_OK,
                'countries' => $countries,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getBranchs(Request $request)
    {
        try {
            $branchs = Branch::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->select('branch_id', 'branch_name', 'branch_description', 'branch_latitude', 'branch_longitude')
                ->get();

            return response()->json([
                'status' => HTTP_OK,
                'branchs' => $branchs
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getCountriesService(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : null;
            $countries_services = CountryAndServiceLink::isShow()
                ->leftJoin('countries', 'country_and_service_links.country_id', 'countries.country_id')
                ->where('countries.active_flg', ACTIVE)->where('countries.delete_flg', NO_DELETE)
                ->leftJoin('services', 'country_and_service_links.service_id', 'services.service_id')
                ->where('services.active_flg', ACTIVE)->where('services.delete_flg', NO_DELETE)
                ->where(function ($query) use ($filters) {
                    $filters['keywords'] = isset($filters['keywords']) ? $filters['keywords'] : '';
                    $query->where('countries.country_code', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('countries.country_name', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('services.service_name', 'like', '%' . $filters['keywords'] . '%');

                    if (isset($filters['country_id'])) {
                        $query->isCountry($filters['country_id']);
                    }
                    return $query;
                });

            if (isset($filters['promotion_flg']) && $filters['promotion_flg'] != "") {
                $countries_services = $countries_services->where('promotion_flg', $filters['promotion_flg']);
            }

            $countries_services = $countries_services->orderByDesc('country_and_service_links.updated_at')
                ->select('country_and_service_link_id', 'country_name', 'country_code', 'service_name', 'service_volumetric_mass')
                ->groupBy('country_and_service_link_id')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $countries_services,
                ]);
            }
            $html = view('bulk-upload.ajax.table-service', compact('countries_services'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }


    public function postUpload(Request $request) {}




    public function displayOtherUtil()
    {
        try {
            try {

                return view('template.util-other');
            } catch (\Throwable $th) {
                return showMessageError();
            }
        } catch (\Throwable $th) {
            return viewError404();
        }
    }

    public function otherUtil(Request $request)
    {
        $this->validate($request, [
            'password' => 'required',
            // 'code' => 'required',
            // 'skip' => 'required',
            // 'take' => 'required',
        ]);
        try {
            $password = $request->password;
            $code = $request->code;
            $take = $request->take;
            $skip = $request->skip;
            if ($password != 'dev_thv123') {
                return showMessageError();
            }
            $count = 0;
            $message = '';
            $datas = [1, 2, 3];
            // $path = 'public/config/system-settings.json';
            // $position_id = collect(json_decode(Storage::get($path), true))->firstWhere('kind', SETTING_FWD_ACCOUNT)['position_id'];


            // $datas = CheckedPaymentCash::isShow()
            //     ->where('checked', 1)
            //     ->skip($skip)->take($take)->get();
            // if (count($datas) <= 0) {
            //     return returnResponse(HTTP_OK, 'Đã hết data', null, 'success');
            // }

            // DB::beginTransaction();
            // foreach ($datas as $key => $value) {
            //     onConfirmCheckedPaymentByAdmin($value['kind'], $value['code'], 1);
            // }
            // DB::commit();
            $datas = $this->getKiotVietProducts(4000, 1);
            $count = count($datas);
            return returnResponse(HTTP_OK, 'Thao tác thành công số data ' . $count . ' ' . $message, null, 'success');
        } catch (\Throwable $th) {
            DB::rollback();
            return returnResponse(HTTP_OK, 'Lỗi: ' . $th->getMessage() . $message);
        }
    }

    function getKiotVietProductsByBranch($branchId, $pageSize = 10, $pageIndex = 1)
    {
        if (empty($branchId)) {
            return [];
        }

        $clientId = '44b25d3c-7bbc-46d3-aa2a-f9242174f350';
        $clientSecret = 'E1D0F0787910BA78A835A0B2DCD90EEE19987D2B';
        $retailCode = 'congtyasia';

        // Lấy access token
        $tokenResponse = Http::asForm()->post("https://id.kiotviet.vn/connect/token", [
            'grant_type' => 'client_credentials',
            'client_id' => $clientId,
            'client_secret' => $clientSecret,
            'scopes' => 'PublicApi.Access'
        ]);

        if ($tokenResponse->failed()) {
            return [];
        }

        $accessToken = $tokenResponse->json()['access_token'] ?? null;
        if (!$accessToken) {
            return [];
        }

        // Lấy danh sách sản phẩm theo chi nhánh
        $productsResponse = Http::withHeaders([
            'Retailer' => $retailCode,
            'Authorization' => "Bearer $accessToken"
        ])->get("https://public.kiotapi.com/products", [
            'pageSize' => $pageSize,
            'pageIndex' => $pageIndex,
            'includeInventory' => 'true'
        ]);

        if ($productsResponse->failed()) {
            return [];
        }

        $products = $productsResponse->json();
        if (!isset($products['data'])) {
            return [];
        }

        // Lọc sản phẩm theo chi nhánh
        $productsWithStock = collect($products['data'])->map(function ($product) use ($branchId) {
            $branchStock = collect($product['inventories'] ?? [])
                ->firstWhere('branchId', $branchId)['onHand'] ?? 0;

            $product['branch_stock'] = (int) $branchStock;
            return $product;
        })->toArray();

        return $productsWithStock;
    }

    function getKiotVietProducts($pageSize = 10, $pageIndex = 1)
    {
        $clientId = env('KIOTVIET_CLIENT_ID', '44b25d3c-7bbc-46d3-aa2a-f9242174f350');
        $clientSecret = env('KIOTVIET_CLIENT_SECRET', 'E1D0F0787910BA78A835A0B2DCD90EEE19987D2B');
        $retailCode = env('KIOTVIET_RETAIL_CODE', 'congtyasia');

        // Lấy access token
        $tokenResponse = Http::asForm()->post("https://id.kiotviet.vn/connect/token", [
            'grant_type' => 'client_credentials',
            'client_id' => $clientId,
            'client_secret' => $clientSecret,
            'scopes' => 'PublicApi.Access'
        ]);

        if ($tokenResponse->failed()) {
            return [];
        }

        $accessToken = $tokenResponse->json()['access_token'] ?? null;
        if (!$accessToken) {
            return [];
        }

        // Lấy danh sách sản phẩm KiotViet (đã bao gồm tồn kho)
        $productsResponse = Http::withHeaders([
            'Retailer' => $retailCode,
            'Authorization' => "Bearer $accessToken"
        ])->get("https://public.kiotapi.com/products", [
            'pageSize' => $pageSize,
            'pageIndex' => $pageIndex,
            'includeInventory' => 'true'
        ]);

        if ($productsResponse->failed()) {
            return [];
        }

        $products = $productsResponse->json();
        if (!isset($products['data'])) {
            return [];
        }

        return $products['data'];
    }


    private function downloadFile($old_name, $path)
    {
        $url = 'https://kango-post.com/kango/view/' . $old_name;

        // Tải nội dung tệp từ URL
        $data = @file_get_contents($url);

        // Lấy tên file
        $position = strpos($old_name, '/');
        if ($position !== false) {
            // Lấy phần tử đến dấu gạch '/'
            $old_name = substr($old_name,  $position + 1);
        }

        $saveAs = public_path($path . $old_name); // Thay đổi đường dẫn lưu trữ nếu cần

        if ($data !== false) {
            // Tạo thư mục nếu chưa tồn tại
            $directory = dirname($saveAs);
            if (!File::exists($directory)) {
                File::makeDirectory($directory, 0755, true);
            }

            // Lưu nội dung vào tệp
            File::put($saveAs, $data);
            return $path;
        } else {
            return null;
        }
    }

    public function getContentPayment(Request $request)
    {
        try {
            $path = 'public/config/setting-recharge.json';
            $is_api = $request->is('api/*');

            $data = json_decode(Storage::get($path), true);
            $kind = $request->kind ?? 'usdt';


            if ($is_api) {
                return  response()->json([
                    'status' => HTTP_OK,
                    'data' => $data[$kind] ?? null,
                ]);
            } else {
                $html = view('template.content-payment-user', compact('kind', 'data'))->render();

                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html,
                    'data' => $data['usdt']['data'] ?? ["price" => 0],
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getSettingsManager(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
            $path = 'public/config/system-settings.json';
            $settings = json_decode(Storage::get($path), true);

            return response()->json([
                'status' => HTTP_OK,
                'settings' => $settings
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }
    public function onRequestRemoveAccount(Request $request)
    {
        $this->validate($request, [
            'user_name' => 'required|email',
            'password' => 'required',
            'is_confirm' => 'required',
        ]);
        try {
            $request_data = $request->all();
            $user = User::isShow()->where('user_name', $request_data['user_name'])->first();
            if (!$user) {
                return returnResponse(HTTP_BAD_REQUEST, 'Không tìm thấy tài khoản');
            }
            if (Hash::check($request_data['password'], $user->password)) {
                if (DeleteAccount::where('email', $request_data['user_name'])->where('status', 0)->first()) {
                    return returnResponse(HTTP_BAD_REQUEST, 'Bạn đã gửi yêu cầu rồi');
                }
                DeleteAccount::create([
                    'email' => $request_data['user_name'],
                    'note' => $request_data['note'] ?? null,
                ]);
            } else {
                return returnResponse(HTTP_BAD_REQUEST, 'Mật khẩu không đúng');
            }

            return returnResponse(HTTP_OK, 'Đã Gửi yêu cầu thành công', null, 'success');
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }



    public function transferShiment(Request $request)
    {
        try {
            $response = $this->getDataOld($request->code, $request->skip, $request->take);
            $area_config = config('constans.address');

            if ($response['status'] != 200) {
                return returnResponse(HTTP_BAD_REQUEST, $response['message'], null, 'warning');
            }
            $data = $response['data'];

            foreach ($data as $key => $value) {
                try {
                    DB::beginTransaction();
                    $shipment = (array) $value['shipment'];
                    $shipment['old_data'] = 1;

                    $user = User::where('user_code', $shipment['user_code'])->first();
                    $shipment['user_id'] = $user->user_id;
                    unset($shipment['user_code']);

                    $service = Service::isShow()->where('service_name', 'like', '%' . $shipment['service_name'] . '%')->first();
                    $shipment['shipment_service_id'] = $service->service_id;
                    unset($shipment['service_name']);

                    $map = $this->getLatLngFromAddress($shipment['sender_address']);
                    $shipment['serder_latitude'] = $map['latitude'];
                    $shipment['sender_longitude'] = $map['longitude'];

                    $address = $this->findByProvinceDistrictWard($area_config, $shipment['sender_city'], $shipment['sender_district'], $shipment['sender_ward']);
                    $shipment['sender_city'] = $address['province'] ?? $shipment['sender_city'];
                    $shipment['sender_district'] = $address['district'] ?? $shipment['sender_district'];
                    $shipment['sender_ward'] = $address['ward'] ?? $shipment['sender_ward'];
                    if (isset($shipment['receiver_city_name'])) {
                        $city = City::isShow()->where('city_name', 'like', '%' . trim($shipment['receiver_city_name']) . '%')->first();

                        $shipment['receiver_city_id'] = $city->city_id  ?? $shipment['receiver_city_id'];
                        $shipment['receiver_state_id'] = $city->state_id ?? $shipment['receiver_state_id'];
                        $shipment['receiver_country_id'] = $city->country_id ?? $shipment['receiver_country_id'];
                    } else {

                        if (isset($shipment['receiver_state_id'])) {
                            $state = State::where('state_code', 'like', '%' . trim($shipment['receiver_state_id']) . '%')->first();
                            $shipment['receiver_state_id'] = $state->state_id ?? null;
                        }

                        $country = Country::where('country_name', 'like', '%' . trim($shipment['receiver_country_name']) . '%')->first();
                        $shipment['receiver_country_id'] = $country->country_id ?? $shipment['receiver_country_id'];
                    }
                    unset($shipment['receiver_city_state']);
                    unset($shipment['receiver_city_name']);
                    unset($shipment['receiver_country_name']);

                    // $shipment['shipment_payment_status'] = 0;
                    $new_sm = Shipment::create($shipment);

                    $shipment_id = $new_sm->shipment_id;
                    // Packages
                    $packages = $value['packages'];
                    foreach ($packages as $key => $package) {
                        $package = (array) $package;
                        $package['shipment_id'] = $shipment_id;
                        if ($package['package_code'] > 320240109001) {
                            $package_code = getCodePackage();
                            $package['package_code'] = $package_code['package_code'];
                            $package['package_hawb_code'] = $package_code['package_code'];
                        }
                        Package::create($package);
                    }

                    // Invoices
                    $invoices =  $value['invoices'];
                    foreach ($invoices as $key => $invoice) {
                        $invoice = (array) $invoice;
                        $invoice['shipment_id'] = $shipment_id;
                        Invoice::create($invoice);
                    }
                    DB::commit();
                } catch (\Throwable $th) {
                    DB::rollBack();
                    continue;
                }
            }
            return returnResponse(HTTP_OK, 'Thao tác thành công', null, 'success');
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }


    private function findByProvinceDistrictWard($array, $provinceCode, $districtCode, $wardCode)
    {
        $array_data = collect($array);

        $provinceKey = $array_data->search(function ($item) use ($provinceCode) {
            return $item['code'] == $provinceCode;
        });
        if ($provinceKey === false) {
            return null; // Không tìm thấy tỉnh
        }

        // Tìm vị trí `district` trong tỉnh
        $districts = $array_data[$provinceKey]['districts'];
        $districtKey = collect($districts)->search(function ($item) use ($districtCode) {
            return $item['code'] == $districtCode;
        });

        if ($districtKey === false) {
            return null; // Không tìm thấy quận/huyện
        }

        // Tìm vị trí `ward` trong quận/huyện
        $wards = $districts[$districtKey]['wards'];
        $wardKey = collect($wards)->search(function ($item) use ($wardCode) {
            return $item['code'] == $wardCode;
        });

        if ($wardKey === false) {
            return null; // Không tìm thấy phường/xã
        }

        return [
            'province' => $provinceKey,
            'district' => $districtKey,
            'ward' => $wardKey,
        ];
    }

    private function getDataOld($code, $skip, $tabke)
    {
        try {
            if (!isset($code) || !isset($skip) || !isset($tabke)) {
                return [
                    'status' => 500,
                    'message' => 'Dữ lieu truyen vo l'
                ];
            }
            // 2
            // $code = 'KG202325';
            // $skip = 0;
            // $tabke = 20;
            $data = [];
            // $user = DB::table('ns_user')->where('cus_code', $code)->first();
            $shipments =  DB::table('ns_package')
                ->where('ns_package.cus_code', $code)
                ->leftJoin('ns_nguoigui', 'ns_package.id_nguoigui', 'ns_nguoigui.id')
                ->leftJoin('ksn_dichvu', 'ns_package.kg_dichvu', 'ksn_dichvu.id')
                ->leftJoin('ns_nguoinhan', 'ns_package.id_nguoinhan', 'ns_nguoinhan.id')
                ->leftJoin('ns_countries', 'ns_nguoinhan.country_id', 'ns_countries.id')
                ->leftJoin('ksn_cities', 'ns_nguoinhan.city', 'ksn_cities.id')
                ->where('ns_package.cuoc_goc', '>', 0)
                ->select(
                    'ns_package.id as shipment_id',

                    // thông tin shipment
                    'ns_package.cus_code as user_code', // trỏ ra user_id
                    'ns_package.id_code as shipment_code',
                    'ksn_dichvu.dichvu as service_name', // trỏ lại service_id vs like 
                    'ns_package.kg_reiceiversign as shipment_signature_flg',
                    // 'ns_package.kg_chinhanh as shipment_branch_name', trỏ lại branch_id tri nhánh
                    DB::raw('CASE 
                            WHEN ns_package.kg_chinhanh LIKE "%HC%" THEN 1
                            WHEN ns_package.kg_chinhanh LIKE "%HN%" THEN 2
                            WHEN ns_package.kg_chinhanh LIKE "%DN%" THEN 3 
                            ELSE 1
                        END as shipment_branch_id'),
                    // shipment_status = auto
                    'ns_package.kg_tenhang as shipment_goods_name',
                    'ns_package.kg_valueinvoice as shipment_value',
                    // 'ns_package.kg_reason as shipment_export_as', trỏ lại vs like
                    DB::raw('CASE 
                            WHEN ns_package.kg_reason LIKE "%Gif%" THEN 0
                            WHEN ns_package.kg_reason LIKE "%Sam%" THEN 1
                            ELSE 1
                        END as shipment_export_as'),
                    // shipment_iosscode = null

                    DB::raw('IFNULL(khach_phuthu, 0) AS shipment_amount_surcharge'),
                    DB::raw('IFNULL(khach_cuocnoidia, 0) AS shipment_domestic_charges'),
                    DB::raw('IFNULL(khach_discount, 0) AS shipment_amount_discount'),
                    DB::raw('IFNULL(khach_thuho, 0) AS shipment_amount_total_customer'),
                    DB::raw('IFNULL(cuoc_goc, 0) AS shipment_amount_original'),
                    DB::raw('IFNULL(khach_cuocbay, 0) AS shipment_final_amount'),
                    'ns_package.date as created_at',

                    // --- sender ---
                    'ns_nguoigui.company_name as sender_company_name',
                    'ns_nguoigui.name as sender_contact_name',
                    'ns_nguoigui.phone as sender_telephone',
                    'ns_nguoigui.province_id as sender_city',
                    'ns_nguoigui.district_id as sender_district',
                    'ns_nguoigui.ward_id as sender_ward',
                    'ns_nguoigui.address as sender_address',
                    // sender_longitude null
                    // serder_latitude null

                    // --- recivewr ---
                    // receiver_id null
                    'ns_nguoinhan.company_name as receiver_company_name',
                    'ns_nguoinhan.name as receiver_contact_name',
                    'ns_nguoinhan.phone as receiver_telephone',
                    'ns_nguoinhan.country_id as receiver_country_id', // 
                    'ns_countries.name as receiver_country_name', // trỏ ra country_id
                    'ns_nguoinhan.state as receiver_state_id',
                    'ns_nguoinhan.city as receiver_city_id', // 
                    'ksn_cities.name as receiver_city_name', // trỏ ra city_id
                    'ksn_cities.state_code as receiver_city_state', // để trỏ state nếu có
                    'ns_nguoinhan.post_code as receiver_postal_code',
                    'ns_nguoinhan.address as receiver_address_1',
                    'ns_nguoinhan.address2 as receiver_address_2',
                    'ns_nguoinhan.address3 as receiver_address_3',


                    // document_id
                    DB::raw('CASE 
                            WHEN ns_package.status = 0 THEN 0
                            WHEN ns_package.status = 1 THEN 1
                            WHEN ns_package.status = 2 THEN 2
                            WHEN ns_package.status = 5 THEN 3
                            ELSE 4
                        END as shipment_status'),

                    DB::raw('CASE 
                            WHEN ns_package.status = 0 THEN 0
                            WHEN ns_package.status = 1 THEN 0
                            WHEN ns_package.status = 5 THEN 0
                            ELSE 1
                        END as shipment_payment_status'),

                    DB::raw('CASE 
                            WHEN ns_package.status = 0 THEN 0
                            WHEN ns_package.status = 1 THEN 0
                            WHEN ns_package.status = 5 THEN 2
                            ELSE 1
                        END as accountant_status'),
                )
                ->skip($skip)->take($tabke)->groupBy('ns_package.id')->get()->toArray();
            if (empty($shipments)) {
                return [
                    'status' => 500,
                    'message' => 'Đã hết data',
                ];
            }
            $data = [];
            foreach ($shipments as $key => $shipment) {
                $invoices = DB::table('ns_mapcatalog')->where('id_bill', $shipment->shipment_id)
                    ->select(
                        'iv_tensanpham as invoice_goods_details',
                        'soluong as invoice_quantity',
                        'iv_unit as invoice_unit',
                        'iv_price as invoice_price',
                        DB::raw('soluong * iv_price as invoice_total_price'),
                    )->get()->toArray();

                $packages = DB::table('ns_listhoadon')->where('id_package', $shipment->shipment_id)
                    ->select(
                        'id_code as package_code',
                        'sokien as package_quantity',
                        DB::raw('CASE 
                            WHEN type LIKE "%Cart%" THEN 0
                            WHEN type LIKE "%Pal%" THEN 1
                            WHEN type LIKE "%Tui%" THEN 2
                            ELSE 0
                        END as package_type'),
                        // 'tenhang as package_description',
                        DB::raw("CASE 
                            WHEN tenhang IS NULL OR tenhang = '' THEN '  ' 
                            ELSE tenhang 
                        END AS package_description"),
                        'length as package_length',
                        'width as package_width',
                        'height as package_height',
                        'cannang as package_weight',
                        'id_code as package_hawb_code',
                        'convert_weight as package_converted_weight',
                        'charge_weight as package_charged_weight',
                        'billketnoi as package_tracking_code',
                        // carrier_code,
                        // package_image
                        // sm_tracktry_id
                        'hangketnoi as branch_connect',
                        // package_status
                        DB::raw('CASE 
                            WHEN status = 0 THEN 0
                            WHEN status = 1 THEN 1
                            WHEN status = 2 THEN 2
                            WHEN status = 5 THEN 3
                            ELSE 4
                        END as package_status'),
                    )->get()->toArray();

                unset($shipment->shipment_id);
                $data[$key] = [
                    'shipment' => $shipment,
                    'invoices' => $invoices,
                    'packages' => $packages,
                ];
            }
            return [
                'status' => 200,
                'data' => $data,
            ];
        } catch (\Throwable $th) {
            return [
                'status' => 500,
                'message' => $th->getMessage(),
            ];
        }
    }

    private function getLatLngFromAddress($address)
    {
        // Lấy API key từ file .env
        $apiKey = env('GOOGLE_MAPS_API_KEY');

        // Gọi API Google Geocoding
        $response = Http::get('https://maps.googleapis.com/maps/api/geocode/json', [
            'address' => $address,
            'key' => $apiKey,
        ]);

        // Chuyển kết quả JSON thành mảng
        $data = $response->json();

        // Kiểm tra nếu có kết quả trả về
        if (!empty($data['results'])) {
            // Lấy latitude và longitude đầu tiên
            $location = $data['results'][0]['geometry']['location'];
            $lat = $location['lat'];
            $lng = $location['lng'];

            // Trả về kết quả
            return [
                'latitude' => $lat,
                'longitude' => $lng,
            ];
        }

        // Nếu không có kết quả trả về
        return [
            'latitude' => 0.00000000,
            'longitude' => 0.000000000,
        ];
    }
}
