<?php

namespace App\Http\Controllers;

use App\Models\LabelNz as ModelsLabelNz;
use App\Utils\DPDApi;
use App\Utils\EtowerApi;
use App\Utils\LabelNzApi;
use App\Utils\TopLogisticsApi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class NzPostController extends Controller
{
    public function displayIndex()
    {
        return view('nz-post.index');
    }

    public function showListLabels(Request $request)
    {

        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = $request_data['filters'] ?? null;
            $labels = ModelsLabelNz::isShow();

            if (isset($filters['label_type'])) {
                // $service_codes = [
                //     'AP-NZPOST', 
                //     'DPD NL', 
                //     'DPD UK', 
                //     'AUSPOST', 
                //     'UBI.AU2AU.PRIORITY', 
                //     'UBI.AU2AU.IPEC', 
                //     'TOP-LOG-AU'
                // ];
                // $service_code = $service_codes[$filters['label_type'] - 1] ?? '';
                $service_code = $filters['label_type'];
                $labels = $labels->where('service_code', 'like', $service_code);
            }
            if (isset($filters['keywords'])) {
                $keywords = convertSearchString($filters['keywords']);
                $labels = $labels->where(function ($q) use ($keywords) {
                    $q->where('label_code', 'like', $keywords)
                        ->orWhere('reference_no', 'like', $keywords)
                        ->orWhere('state', 'like', $keywords)
                        ->orWhere('post_code', 'like', $keywords)
                        ->orWhere('service_code', 'like', $keywords);
                });
            }
            $labels = $labels->orderByDesc('created_at')->isPaginate($request_data['paginate']);
            if ($is_api) {
                # code...
            }

            $html = view('nz-post.ajax.table-labels', compact('labels'))->render();

            return response()->json([
                'status' => 200,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleAddNzPost(Request $request)
    {

        $request_data = $request->all();
        try {

            DB::beginTransaction();

            $labels = [];
            foreach ($request_data['excels'] as $key => $value) {

                $label = $this->createLabel($value);
                if (!$label['status']) {
                    return returnResponse(HTTP_BAD_REQUEST, $label['message']);
                }
                array_push($labels, $label);
            }
            DB::commit();

            return response()->json([
                "status" => HTTP_OK,
                "data" => $labels
            ]);
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    public function createLabel($value)
    {
        $label_nz = new LabelNzApi();

        $data = $label_nz->setDataPostAdd($value['shippingMethodCode'], $value['countryCode'], $value['shippingFirstName'], $value['shippingAddress'], $value['shippingCity'], $value);
        $_data['state'] = $value['shippingState'] ?? '';
        $_data['post_code'] = $value['shippingZip'] ?? '';
        $_data['service_code'] = $value['shippingMethodCode'] ?? '';
        $labels = $label_nz->postBatchAdd([$data]);
        if (!$labels['status']) {
            return $labels;
        }
        ModelsLabelNz::create([
            "label_code" => $labels['data'][0]['CustomerOrderId'],
            "link" => isset($labels['data'][0]['LabelUrl'][0]) ? $labels['data'][0]['LabelUrl'][0] : '',
            "reference_no" => $labels['data'][0]['OrderId'],
            "state" => $_data['state'],
            "post_code" => $_data['post_code'],
            "service_code" => $_data['service_code'],
            "create_by" => auth()->id(),
        ]);

        return $labels;
    }

    public function handleCreateLabelAUK(Request $request)
    {
        try {
            $label_class = new LabelNzApi();
            $data_excels = isset($request->excels) ? $request->excels : [];
            DB::beginTransaction();
            foreach ($data_excels as $key => $data) {
                $label = $label_class->handleCreateAUK($data);
                if ($label['status'] == HTTP_OK) {
                    ModelsLabelNz::create([
                        "label_code" => $label['data']['logisticsNo'],
                        "link" => isset($label['data']['labelUrl']) ? $label['data']['labelUrl'] : '',
                        "reference_no" => $label['data']['orderNo'],
                        "state" => $data['consigneeState'],
                        "post_code" => $data['consignorPostcode'],
                        "service_code" => 'AUK',
                        "create_by" => auth()->id(),
                    ]);
                } else {
                    return returnResponse($label['status'], $label['message']);
                }
            }
            DB::commit();
            return returnResponse(HTTP_OK, 'Khởi tạo label thành công');
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    public function handleCreateLabelDPD(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $excels = isset($request_data['excels']) ? json_decode($request_data['excels'], true) : [];
            $dpd = new DPDApi();

            foreach ($excels as $excel) {
                $response = $dpd->importLabel($excel);

                if ($response['status'] == HTTP_OK) {
                    if ($response['data']['serviceType'] == 'DPD UK') {
                        $response['data']['pdf'] = convertStringToFileTxt($response['data']['referenceNo'], $response['data']['html'], PUBLIC_PATH_SHIPMENT_LABEL);
                    }

                    ModelsLabelNz::create([
                        "label_code" => $response['data']['referenceNo'],
                        "link" => $response['data']['pdf'],
                        "reference_no" => $response['data']['referenceNo'],
                        "state" => $excel['state'],
                        "post_code" => $excel['postcode'],
                        "service_code" => $response['data']['serviceType'],
                        "create_by" => auth()->id(),
                    ]);
                }
            }

            DB::commit();
            return response()->json([
                "status" => HTTP_OK,
                "message" => [
                    'title' => 'Thành công',
                    'text' => 'Khởi tạo label thành công',
                    'icon' => 'success'
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    public function handleCreateLabelETOWER(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $excels = isset($request_data['excels']) ? json_decode($request_data['excels'], true) : [];
            $etower = new EtowerApi();

                $count = 0;
                foreach ($excels as $excel) {
                $response = $etower->createOrderImportExcel($excel);

                if ($response['status'] == HTTP_OK) {
                    $OrderId = $response['data'][0]['orderId'];
                    $data = [
                        "orderIds" => [$response['data'][0]['orderId']]
                    ];

                    $labels = $etower->printLabels($data);
                    $labels = $labels['data'];
                    foreach ($labels as $label) {
                        $label['labelLink'] = convertBase64ToPdf($label['trackingNo'], $label['labelContent'], PUBLIC_PATH_SHIPMENT_LABEL);
                        $data_label_creating = [
                            'create_by' => auth()->id(),
                            'label_code' => $OrderId,
                            'link' => $label['labelLink'],
                            'reference_no' => $response['data'][0]['referenceNo'],
                            'state' => $excel['state'],
                            'post_code' => $excel['postcode'],
                            'service_code' => $excel['serviceType'],
                            'in_directory' => IN_DIRECTORY,
                        ];
                        createLabelEpackage($data_label_creating);
                    }
                    $count++;
                
                }

            }
            if ($count == 0) {
                return response()->json([
                    "status" => HTTP_BAD_REQUEST,
                    "message" => [
                        'title' => 'Thất bại',
                        'text' => 'Không có label nào được tạo',
                        'icon' => 'error'
                    ]
                ]);
            }

            DB::commit();
            return response()->json([
                "status" => HTTP_OK,
                "message" => [
                    'title' => 'Thành công',
                    'text' => 'Khởi tạo label thành công',
                    'icon' => 'success'
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    public function handleCreateLabelTopLogAu(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $excels = isset($request_data['excels']) ? json_decode($request_data['excels'], true) : [];
            $top_logistic_api = new TopLogisticsApi();

            foreach ($excels as $index => $excel) {
                $response = $top_logistic_api->createShipmentImportExcel($excel);

                if ($response['status'] == HTTP_OK) {
                    $OrderId = $response['data']['custref'];
                    $data = [
                        "cust_ref" => $response['data']['custref'],
                        'base64' => true
                    ];

                    $label = $top_logistic_api->getCourierLabel($data);
                    $label['labelLink'] = convertBase64ToPdf($OrderId, $label['data'], PUBLIC_PATH_SHIPMENT_LABEL);

                    $data_label_creating = [
                        'create_by' => auth()->id(),
                        'label_code' => $OrderId,
                        'link' => $label['labelLink'],
                        'reference_no' => $response['data']['lref'],
                        'state' => $excel['state'],
                        'post_code' => $excel['postcode'],
                        'service_code' => 'TOP-LOG-AU',
                        'in_directory' => IN_DIRECTORY,
                    ];
                    createLabelEpackage($data_label_creating);
                }else{
                    
                }

            }

            DB::commit();
            return response()->json([
                "status" => HTTP_OK,
                "message" => [
                    'title' => 'Thành công',
                    'text' => 'Khởi tạo label thành công',
                    'icon' => 'success'
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }
    
    public function handleGetLabelTopLogAu(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $excels = isset($request_data['excels']) ? json_decode($request_data['excels'], true) : [];
            $top_logistic_api = new TopLogisticsApi();
            foreach ($excels as $excel) {
                $cust_ref = $excel['cust_ref'];
                $data = [
                    "cust_ref" => $cust_ref,
                    'base64' => true
                ];

                $res_shipment = $top_logistic_api->getShipmentDetail($data);
                if ($res_shipment['status'] != HTTP_OK) return returnResponse($res_shipment['status'], 'Không lấy được thông tin lô hàng của bạn trên hệ thống Top Logistics');
                
                $res_shipment_convert = json_decode($res_shipment['data'], true);

                $label = $top_logistic_api->getCourierLabel($data);
                $label['labelLink'] = convertBase64ToPdf($cust_ref, $label['data'], PUBLIC_PATH_SHIPMENT_LABEL);

                $shipment = $res_shipment_convert['shipments'][0];


                $data_label_creating = [
                    'create_by' => auth()->id(),
                    'label_code' => $cust_ref,
                    'link' => $label['labelLink'],
                    'reference_no' => $shipment['longref'][0],
                    'state' => $shipment['consignee']['state'],
                    'post_code' => $shipment['consignee']['postcode'],
                    'service_code' => 'TOP-LOG-AU',
                    'in_directory' => IN_DIRECTORY,
                ];
                createLabelEpackage($data_label_creating);
            }

            DB::commit();
            return response()->json([
                "status" => HTTP_OK,
                "message" => [
                    'title' => 'Thành công',
                    'text' => 'Lấy label thành công',
                    'icon' => 'success'
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollback();
            dd($th);
            return showMessageError();
        }
    }
}
