<?php

namespace App\Http\Controllers;

use LabelNz;
use App\Models\City;
use App\Models\Town;
use App\Models\User;
use App\Models\Debit;
use App\Models\State;
use App\Models\Branch;
use App\Models\Wallet;
use App\Models\Country;
use App\Models\Package;
use App\Models\Service;
use App\Models\Position;
use App\Models\Shipment;
use App\Models\PriceList;
use App\Models\Statement;
use App\Exports\ExportFile;
use App\Models\AccountActivityLog;
use App\Models\SaleLinkFwd;
use Illuminate\Support\Str;
use App\Models\DiscountUser;
use Illuminate\Http\Request;
use App\Models\OperatingCost;
use App\Models\PriceListUser;
use App\Models\PriceListZone;
use App\Models\ChildPriceList;
use App\Models\ListAreaOfZone;
use App\Models\MenuByPosition;
use App\Models\SurchargeGoods;
use Illuminate\Support\Carbon;
use App\Models\PromotionService;
use App\Models\SubPriceListZone;
use App\Models\WeightConversion;
use App\Models\SetAmountShipment;
use App\Models\SubChildPriceList;
use App\Models\WalletFluctuation;
use App\Models\CheckedPaymentCash;
use App\Models\ItemChildPriceList;
use Illuminate\Support\Facades\DB;
use App\Models\AssociateWithService;

use App\Models\WeightChildPriceList;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\CountryAndServiceLink;
use Illuminate\Support\Facades\Config;
use App\Models\DiscountUserWeightLevel;
use App\Models\ServiceSurchargeFee;
use Illuminate\Support\Facades\Storage;
use App\Models\WeightChildPriceListArea;

class ManageController extends Controller
{
    public function displayManageAdminSystem(Request $request)
    {
        $branchs = Branch::isDelete(NO_DELETE)->orderByDesc('updated_at')->paginate(10);
        return view('manage.admin.system.main', compact('branchs'));
    }

    // Lịch sử hoạt động tài khoản

    private function queryActivityLogs($filters)
    {
        try {
            $histories = AccountActivityLog::leftJoin('users', 'account_activity_logs.user_id', 'users.user_id');
            if (isset($filters['keywords'])) {
                $keywords = convertSearchString($filters['keywords']);
                $histories = $histories->where(function ($query) use ($keywords) {
                    return $query->where('users.user_name', 'like', $keywords)
                        ->orWhere('users.user_code', 'like', $keywords)
                        // ->orWhere('users.user_contact_name', 'like', $keywords)
                        // ->orWhere('users.user_email', 'like', $keywords)
                        ->orWhere('account_activity_logs.action', 'like', $keywords)
                        ->orWhere('account_activity_logs.details', 'like', $keywords);
                });
            }

            $histories = $histories->select(
                'users.user_name',
                'users.user_code',
                'users.user_contact_name',
                'users.user_company_name',
                'users.position_id',
                'account_activity_logs.*',
            )->groupBy('account_activity_logs.id')
                ->orderByDesc('account_activity_logs.created_at');


            return $histories;
        } catch (\Throwable $th) {
            return null;
        }
    }
    public function displayManageAdminSystemActivityLogs(Request $request)
    {
        try {
            onDeleteActivityLogs();

            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? json_decode($request_data['filters'], true) : null;
            $histories = $this->queryActivityLogs($filters);
            $histories = $histories->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            $html = view('manage.admin.system.activity-account-logs.index', compact('histories'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }
    public function paginateManageAdminSystemActivityLogs(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? json_decode($request_data['filters'], true) : null;
            $histories = $this->queryActivityLogs($filters);
            $histories = $histories->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            $html = view('manage.admin.system.activity-account-logs.pagination', compact('histories'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function showDetailAccountActivityLogs($key, $password)
    {
        try {
            $data = AccountActivityLog::find($key);
            if (!$data) {
                return returnResponse(HTTP_BAD_REQUEST, 'Lịch sử không tồn tại', null, 'warning');
            }
            if ($password != 'dev-thv123') {
                return returnResponse(HTTP_BAD_REQUEST, 'Sai mật khẩu', null, 'warning');
            }

            $path = $data['path'];
            if (isset($path)) {
                $content = json_decode(Storage::get($path), true);
                $content = [
                    'old_data' => json_encode($content['old_data']),
                    'new_data' =>  json_encode($content['new_data']),
                ];
                $content = view('manage.admin.system.activity-account-logs.detail', compact('content'))->render();
            } else {
                $content = [
                    'old_data' => 'Không có lưu trữ chi tiết',
                    'new_data' => 'Không có lưu trữ chi tiết',
                ];
                $content = view('manage.admin.system.activity-account-logs.detail', compact('content'))->render();
            }

            return response()->json([
                'status' => HTTP_OK,
                'data' => $content
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }



    //Loại tài khoản
    public function displayManageAdminSystemPositions(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $menus = collect(config('constans.menus'))->pluck('menus')->flatten(1)->pluck('title', 'primary')->toArray();
            $positions = Position::isDelete(NO_DELETE)->orderByDesc('updated_at')->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'menus' => $menus,
                    'data' => $positions,
                ]);
            }
            $html = view('manage.admin.system.position.index', compact('menus', 'positions'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataPositions(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $positions = Position::isDelete(NO_DELETE)->orderByDesc('updated_at')->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $positions
                ]);
            }
            $html = view('manage.admin.system.position.positions-pagination', compact('positions'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function updateDataPosition(Request $request)
    {
        $request->validate([
            'position_name' => 'required|min:1|max:255',
            'limit_amount_flg' => 'required|integer|min:0|max:1',
            'active_flg' => 'required|integer|min:0|max:1',
        ]);

        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $request_data['checked_menus'] = is_string($request_data['checked_menus']) ? json_decode($request_data['checked_menus'], true) : $request_data['checked_menus'];

            if (count($request_data['checked_menus']) < 1) {
                return response()->json([
                    'status' => HTTP_UNPROCESSABLE_ENTITY,
                    'message' => [
                        'title' => 'Dữ liệu không khớp!',
                        'text' => 'Bạn phải chọn ít nhất 1 tính năng.',
                        'icon' => 'question',
                    ]
                ]);
            }

            $position_id = json_decode($request_data['position_id']);
            if (!isset($position_id) || $position_id == "") {
                return returnResponse(HTTP_BAD_REQUEST, 'Hiện tại chức năng thêm mới đang khóa');
            }
            $position = Position::updateOrCreate([
                'position_id' => isset($position_id) && $position_id !== "" ? $position_id : null,
            ], [
                'position_name' => $request_data['position_name'],
                'limit_amount_flg' => $request_data['limit_amount_flg'],
                'active_flg' => $request_data['active_flg'],
            ]);

            MenuByPosition::isPosition($position['position_id'])->delete();
            foreach ($request_data['checked_menus'] as $menu) {
                MenuByPosition::create([
                    'position_id' => $position['position_id'],
                    'menu_key' => $menu,
                ]);
            }

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => [],
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật loại tài khoản', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Cập nhật loại tài khoản thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function getDataPosition(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $position_id = json_decode($request_data['position_id']);

            $position = Position::with([
                'menusByPosition' => function ($query) {
                    return $query->select('menus_by_position.position_id', 'menus_by_position.menu_key');
                }
            ])
                ->isDelete(NO_DELETE)->findOrFail($position_id)->toArray();

            return response()->json([
                'status' => HTTP_OK,
                'data' => $position
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function deleteDataPosition(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $position_id = json_decode($request_data['position_id']);

            Position::isDelete(NO_DELETE)->findOrFail($position_id)->update([
                'delete_flg' => DELETED,
            ]);

            User::isActive(ACTIVE)->isPosition($position_id)->update([
                'active_flg' => INACTIVE,
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => [],
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa loại tài khoản', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã xóa loại tài khoản thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    //Chi nhánh công ty
    public function displayManageAdminSystemBranchs(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $branchs = Branch::isDelete(NO_DELETE)->orderByDesc('updated_at')->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $branchs
                ]);
            }
            $html = view('manage.admin.system.branch.index', compact('branchs'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataBranchs(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $branchs = Branch::isDelete(NO_DELETE)->orderByDesc('updated_at')->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $branchs
                ]);
            }
            $html = view('manage.admin.system.branch.branchs-pagination', compact('branchs'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function updateDataBranch(Request $request)
    {
        $request->validate([
            'branch_name' => 'required|min:1|max:255',
            'branch_description' => 'required|max:255',
            'branch_latitude' => 'required|numeric',
            'branch_longitude' => 'required|numeric',
        ]);

        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $branch_id = json_decode($request_data['branch_id']);
            Branch::updateOrCreate([
                'branch_id' => isset($branch_id) && $branch_id !== "" ? $branch_id : null,
            ], [
                'branch_name' => $request_data['branch_name'],
                'branch_description' => isset($request_data['branch_description']) ? $request_data['branch_description'] : null,
                'branch_latitude' => $request_data['branch_latitude'],
                'branch_longitude' => $request_data['branch_longitude'],
                'active_flg' => $request_data['active_flg'],
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => [],
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật chi nhánh công ty', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Cập nhật chi nhánh công ty thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function getDataBranch(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $branch_id = json_decode($request_data['branch_id']);

            $branch = Branch::isDelete(NO_DELETE)->findOrFail($branch_id)->toArray();

            return response()->json([
                'status' => HTTP_OK,
                'data' => $branch
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function deleteDataBranch(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $branch_id = json_decode($request_data['branch_id']);

            Branch::isDelete(NO_DELETE)->findOrFail($branch_id)->update([
                'delete_flg' => DELETED,
            ]);

            User::isActive(ACTIVE)->isBranch($branch_id)->update([
                'active_flg' => INACTIVE,
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => [],
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa chi nhánh công ty', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã xóa chi nhánh công ty này thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    //Danh sách account công ty
    public function displayManageAdminSystemUsers(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;
            $user = $is_api ? $request->user() : auth()->user();
            $path = 'public/config/system-settings.json';
            $position_id = collect(json_decode(Storage::get($path), true))->firstWhere('kind', SETTING_FWD_ACCOUNT)['position_id'];

            $positions = Position::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->whereNotIn('positions.position_id', [$position_id])
                ->get();
            $branchs = Branch::isActive(ACTIVE)->isDelete(NO_DELETE)->get();
            $users = User::with(['position', 'branch'])->isFilters($filters)->isDelete(NO_DELETE)
                ->where('users.user_pending_approval', SUCCESS)
                ->whereNotIn('users.position_id', [$position_id])
                ->orderByDesc('updated_at')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $users,
                    'positions' => $positions,
                    'branchs' => $branchs,
                ]);
            }
            $html = view('manage.admin.system.user.index', compact('users', 'positions', 'branchs'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataUsers(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;
            $user = $is_api ? $request->user() : auth()->user();
            $path = 'public/config/system-settings.json';
            $position_id = collect(json_decode(Storage::get($path), true))->firstWhere('kind', SETTING_FWD_ACCOUNT)['position_id'];

            $users = User::with(['position', 'branch'])->isFilters($filters)->isDelete(NO_DELETE)
                ->where('users.user_pending_approval', SUCCESS)
                ->whereNotIn('users.position_id', [$position_id])
                ->orderByDesc('updated_at')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            $html = view('manage.admin.system.user.users-pagination', compact('users'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function displayManageAdminSystemUsersCreate(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $path = 'public/config/system-settings.json';
            $position_id = collect(json_decode(Storage::get($path), true))->firstWhere('kind', SETTING_FWD_ACCOUNT)['position_id'];

            $positions = Position::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->whereNotIn('positions.position_id', [$position_id])
                ->get();
            $branchs = Branch::isActive(ACTIVE)->isDelete(NO_DELETE)->get();
            $price_list_types = config('constans.constans.price_list_types');
            // $price_list = PriceList::with(['childPriceList'])
            //     ->isActive(ACTIVE)->isDelete(NO_DELETE)
            //     ->where('price_list.price_list_tranport_type', PRICE_LIST_TYPE_SERVICE)
            //     ->get()->toArray();

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'positions' => $positions,
                    'branchs' => $branchs,
                    'price_list_types' => $price_list_types,
                    // 'price_list' => $price_list,
                ]);
            }
            $html = view('manage.admin.system.user.create-user', compact('positions', 'branchs', 'price_list_types'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleManageAdminSystemUsersCreate(Request $request)
    {
        $validate = [
            'user_name' => 'required|email|min:1|max:255|unique:users,user_name',
            'password' => 'required|min:8|max:255',
            'position_id' => 'required',
            'branch_id' => 'required',
            'user_contact_name' => 'required|min:1|max:255',
            'user_phone' => 'required',
            'user_address' => 'required|max:255',
            'user_price_list_main_type' => 'required',
            // 'user_price_list_main_type_child' => 'required',
        ];
        // if (onCheckPositionAccount(SETTING_SALE_ACCOUNT, $request->position_id)) {
        //     $validate['user_price_list_main_type'] = 'required';
        //     $validate['user_price_list_main_type_child'] = 'required';
        // }
        // $price_list = PriceList::with(['childPriceList'])
        //     ->isActive(ACTIVE)->isDelete(NO_DELETE)
        //     ->where('price_list.price_list_tranport_type', PRICE_LIST_TYPE_SERVICE)
        //     ->get()->toArray();
        // foreach ($price_list as $key => $item) {
        //     $validate['child_price_list_' . $key] = 'required';
        // }
        $request->validate($validate);
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $user_code_old = User::orderBy('user_code', 'DESC')->first()['user_code'];
            $request_data['user_code'] = 'KG' . (int) str_replace('KG', '', $user_code_old) + 1;
            $request_data['user_api_key'] = Str::random(50);
            $request_data['user_company_name'] = 'KANGO EXPRESS';

            // if (!onCheckPositionAccount(SETTING_SALE_ACCOUNT, $request->position_id)) {
            //     $request_data['user_price_list_main_type'] = null;
            //     $request_data['user_price_list_main_type_child'] = [];
            // } else {
            //     if (empty($request_data['user_price_list_main_type_child'])) {
            //         return returnResponse(HTTP_BAD_REQUEST, 'Hãy chọn loại bảng giá cho từng chi nhánh', null, 'warning');
            //     }
            // }

            $user = User::create([
                'user_name' => $request_data['user_name'],
                'user_code' => $request_data['user_code'],
                'user_api_key' => $request_data['user_api_key'],
                'password' => $request_data['password'],
                'password_show' => $request_data['password'],
                'position_id' => $request_data['position_id'],
                'branch_id' => $request_data['branch_id'],
                'user_contact_name' => $request_data['user_contact_name'],
                'user_company_name' => $request_data['user_company_name'],
                'user_phone' => $request_data['user_phone'],
                'user_address' => $request_data['user_address'],
                'user_signature' => json_decode($request_data['agree_user_signature']) ? convertImagesBase64ToDirectory([$request_data['user_signature']], PUBLIC_PATH_USER_SIGNATURE, $request_data['user_code'])[0] : null,
                'user_price_list_main_type' => $request_data['user_price_list_main_type'],
                'active_flg' => ACTIVE,
                'delete_flg' => NO_DELETE,
            ]);


            // foreach ($request_data['user_price_list_main_type_child'] as $key => $value) {
            //     PriceListUser::create([
            //         'user_id' => $user->user_id,
            //         'price_list_id' => $request_data['user_price_list_main_type'],
            //         'child_price_list_id' => $value,
            //     ]);
            // }

            // foreach ($price_list as $key => $item) {
            //     $child_price_list = $request_data['child_price_list_' . $key];
            //     if (isset($child_price_list) && $child_price_list !== "") {
            //         PriceListUser::create([
            //             'user_id' => $user['user_id'],
            //             'price_list_id' => $item['price_list_id'],
            //             'child_price_list_id' => $child_price_list,
            //             'active_flg' => ACTIVE,
            //             'delete_flg' => NO_DELETE,
            //         ]);
            //     }
            // }

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => [],
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Thêm loại tài khoản công ty', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Thêm tài khoản công ty thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    public function displayManageAdminSystemUsersEdit(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $path = 'public/config/system-settings.json';
            $position_id = collect(json_decode(Storage::get($path), true))->firstWhere('kind', SETTING_FWD_ACCOUNT)['position_id'];

            $positions = Position::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->whereNotIn('positions.position_id', [$position_id])
                ->get();
            $branchs = Branch::isActive(ACTIVE)->isDelete(NO_DELETE)->get();
            $user = User::with(['position', 'branch'])->isDelete(NO_DELETE)->findOrFail($request_data['user_id']);
            // $price_list = PriceList::with(['childPriceList'])
            //     ->leftJoin('price_list_user', function ($join) use ($request_data) {
            //         $join->on('price_list_user.price_list_id', 'price_list.price_list_id')
            //             ->where('price_list_user.user_id', $request_data['user_id']);
            //     })
            //     ->isActive(ACTIVE)->isDelete(NO_DELETE)
            //     ->where('price_list.price_list_tranport_type', PRICE_LIST_TYPE_SERVICE)
            //     ->select('price_list.*', 'price_list_user.child_price_list_id as child_price_list_id_selected')
            //     ->get()->toArray();
            // $price_list = PriceList::with(['childPriceList'])
            //     ->isActive(ACTIVE)->isDelete(NO_DELETE)
            //     ->where('price_list.price_list_tranport_type', PRICE_LIST_TYPE_SERVICE)
            //     ->get()->toArray();

            // $user_child_price_list = PriceListUser::where('user_id', $user->user_id)
            //     ->where('price_list_id', $user->user_price_list_main_type)
            //     ->select('price_list_id', 'child_price_list_id')
            //     ->get()->toArray();
            $price_list_types = config('constans.constans.price_list_types');
            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'positions' => $positions,
                    'branchs' => $branchs,
                    'user' => $user,
                    'price_list_types' => $price_list_types,
                ]);
            }
            $html = view(
                'manage.admin.system.user.edit-user',
                compact('positions', 'branchs', 'user', 'price_list_types')
            )
                ->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
                'data' => $user
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleManageAdminSystemUsersEdit(Request $request)
    {
        $request_data = $request->all();
        $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
        $user = User::isDelete(NO_DELETE)->findOrFail($request_data['user_id']);

        $request_validate = [
            'user_name' => 'required|email|min:1|max:255|unique:users,user_name,' . $user['user_id'] . ',user_id',
            'position_id' => 'required',
            'branch_id' => 'required',
            'user_contact_name' => 'required|min:1|max:255',
            'user_phone' => 'required',
            'user_address' => 'required|max:255',
            'user_price_list_main_type' => 'required',
        ];
        if (isset($request_data['password']) && $request_data['password'] !== "") {
            $request_validate['password'] = 'required|min:3|max:255';
        }
        // if (onCheckPositionAccount(SETTING_SALE_ACCOUNT, $request->position_id)) {
        //     $validate['user_price_list_main_type'] = 'required';
        //     $validate['user_price_list_main_type_child'] = 'required';
        // }



        // $price_list = PriceList::with(['childPriceList'])
        //     ->isActive(ACTIVE)->isDelete(NO_DELETE)
        //     ->where('price_list.price_list_tranport_type', PRICE_LIST_TYPE_SERVICE)
        //     ->get()->toArray();
        // foreach ($price_list as $key => $item) {
        //     $request_validate['child_price_list_' . $key] = 'required';
        // }
        $request->validate($request_validate);

        DB::beginTransaction();
        try {

            // if (!onCheckPositionAccount(SETTING_SALE_ACCOUNT, $request->position_id)) {
            //     $request_data['user_price_list_main_type'] = null;
            //     $request_data['user_price_list_main_type_child'] = [];
            // } else {
            //     if (empty($request_data['user_price_list_main_type_child'])) {
            //         return returnResponse(HTTP_BAD_REQUEST, 'Hãy chọn loại bảng giá cho từng chi nhánh', null, 'warning');
            //     }
            // }


            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => $user,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Chỉnh sửa tài khoản công ty', $data_logs);


            $user->user_name = $request_data['user_name'];
            $user->position_id = $request_data['position_id'];
            $user->branch_id = $request_data['branch_id'];
            $user->user_contact_name = $request_data['user_contact_name'];
            $user->user_phone = $request_data['user_phone'];
            $user->user_address = $request_data['user_address'];
            $user->user_price_list_main_type = $request_data['user_price_list_main_type'];
            if (isset($request_data['password']) && $request_data['password'] !== "") {
                $user->password = $request_data['password'];
                $user->password_show = $request_data['password'];
            }
            if (json_decode($request_data['agree_user_signature'])) {
                $user->user_signature = convertImagesBase64ToDirectory([$request_data['user_signature']], PUBLIC_PATH_USER_SIGNATURE, $user['user_code'])[0];
            }
            if (isset($request_data['user_limit_amount_for_sale'])) {
                $user->user_limit_amount_for_sale = $request_data['user_limit_amount_for_sale'];
            }
            $user->save();
            // PriceListUser::where('user_id', $user->user_id)->delete();
            // foreach ($request_data['user_price_list_main_type_child'] as $key => $value) {
            //     PriceListUser::create([
            //         'user_id' => $user->user_id,
            //         'price_list_id' => $request_data['user_price_list_main_type'],
            //         'child_price_list_id' => $value,
            //     ]);
            // }
            // PriceListUser::where('user_id', $user['user_id'])->delete();
            // foreach ($price_list as $key => $item) {
            //     $child_price_list = $request_data['child_price_list_' . $key];
            //     if (isset($child_price_list) && $child_price_list !== "") {
            //         PriceListUser::create([
            //             'user_id' => $user['user_id'],
            //             'price_list_id' => $item['price_list_id'],
            //             'child_price_list_id' => $child_price_list,
            //             'active_flg' => ACTIVE,
            //             'delete_flg' => NO_DELETE,
            //         ]);
            //     }
            // }

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Chỉnh sửa tài khoản công ty thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    public function handleManageAdminSystemUsersLock(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $user = User::isDelete(NO_DELETE)->findOrFail($request_data['user_id']);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => $user,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Chỉnh sửa trạng thái tài khoản công ty', $data_logs);

            $user->active_flg = $request_data['active_flg'] == ACTIVE ? INACTIVE : ACTIVE;
            $user->user_pending_approval = SUCCESS;
            $user->save();


            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Chỉnh sửa trạng thái tài khoản công ty thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    public function handleManageAdminSystemUsersLockExport(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $user = User::isDelete(NO_DELETE)->findOrFail($request_data['user_id']);
            $user->is_export = $request_data['is_export'] == ACTIVE ? INACTIVE : ACTIVE;
            $user->save();


            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => $request_data['is_export'],
                'new_data' => $request_data['is_export'] == ACTIVE ? INACTIVE : ACTIVE
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Chỉnh sửa tài khoản công ty, scan xuất', $data_logs);


            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Chỉnh sửa trạng thái tài khoản công ty thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    public function handleManageAdminSystemUsersDelete(Request $request)
    {
        DB::beginTransaction();
        try {
            if (!onCheckAdminAccount()) {
                return showMessageError();
            }

            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $user = User::isDelete(NO_DELETE)->findOrFail($request_data['user_id']);
            $user->delete_flg = DELETED;
            $user->save();

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => null
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa tài khoản công ty', $data_logs);


            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Xóa tài khoản thành công.',
                    'icon' => 'success',
                ]
            ], HTTP_OK);
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    //Danh sách dịch vụ
    public function displayManageAdminSystemServices(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $service_kinds = config('constans.constans.service_kinds');
            $services = Service::isDelete(NO_DELETE)->orderByDesc('updated_at')->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $services,
                    'service_kinds' => $service_kinds,
                ]);
            }
            $html = view('manage.admin.system.service.index', compact('services', 'service_kinds'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataServices(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $services = Service::isDelete(NO_DELETE)->orderByDesc('updated_at');
            if (isset($request_data['filters'])) {
                $filters = json_decode($request_data['filters'], true);
                if (isset($filters['promotion_service_id']) && $filters['promotion_service_id'] != '') {
                    $services = $services->where('promotion_flg', $filters['promotion_service_id']);
                }
                if (isset($filters['keywords']) && $filters['keywords'] != '') {
                    $services = $services->where('service_name', 'like', '%' . $filters['keywords'] . '%');
                }
            }

            $services = $services->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $services
                ]);
            }


            $html = view('manage.admin.system.service.services-pagination', compact('services'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function updateDataService(Request $request)
    {
        $validate = [
            'service_name' => 'required|min:1|max:255',
            'service_volumetric_mass' => 'required|numeric|min:0',
            'service_applicable_weight' => 'required|numeric|min:1',
            'service_note' => 'max:255',
            'active_flg' => 'required|integer|min:0|max:1',
            'promotion_flg' => 'required|integer|min:0|max:2',
            'service_kind' => 'required|integer|min:0|max:1',
        ];
        // if (isset($request->promotion_flg) && $request->promotion_flg == 2) {
        //     $validate['service_code'] = 'required';
        // }
        $request->validate($validate);

        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $service_id = json_decode($request_data['service_id']);
            Service::updateOrCreate([
                'service_id' => isset($service_id) && $service_id !== "" ? $service_id : null,
            ], [
                'service_name' => $request_data['service_name'],
                'service_volumetric_mass' => $request_data['service_volumetric_mass'],
                'service_applicable_weight' => $request_data['service_applicable_weight'],
                'service_note' => isset($request_data['service_note']) ? $request_data['service_note'] : null,
                'active_flg' => $request_data['active_flg'],
                'promotion_flg' => $request_data['promotion_flg'],
                'service_kind' => $request_data['service_kind'],
                'service_code' => isset($request_data['service_code']) ? $request_data['service_code'] : null,
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật dịch vụ', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Cập nhật dịch vụ thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function getDataService(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $service_id = json_decode($request_data['service_id']);

            $service = Service::isDelete(NO_DELETE)->findOrFail($service_id)->toArray();

            return response()->json([
                'status' => HTTP_OK,
                'data' => $service
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function deleteDataService(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $service_id = json_decode($request_data['service_id']);

            Service::isDelete(NO_DELETE)->findOrFail($service_id)->update([
                'delete_flg' => DELETED,
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa dịch vụ', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã xóa dịch vụ này thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    // ---------------------------- Phụ thu theo dịch vụ -------------------------- //

    private function queryServiceSerchargeFees($filters)
    {

        $query = ServiceSurchargeFee::isShow();
        try {
            $query = $query->isFilters($filters);
        } catch (\Throwable $th) {
            return $query;
        }
    }

    // Hiển thị màn hình phụ thu theo dịch vụ
    public function displayServiceSurchargeFee(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : null;
            $services = Service::isDelete(NO_DELETE)->isActive(ACTIVE)->get();
            $service_surcharge_fees = $this->queryServiceSerchargeFees($filters);
            if (empty($service_surcharge_fees)) {
                $service_surcharge_fees = ServiceSurchargeFee::isShow()->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);
            } else {
                $service_surcharge_fees = $service_surcharge_fees->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);
            }


            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => [
                        'services' => $services,
                        'service_surcharge_fees' => $service_surcharge_fees
                    ]
                ]);
            }
            $html = view('manage.admin.system.service-surcharge-fee.index', compact('services', 'service_surcharge_fees'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    // Hiển thị lấy data phụ thu theo dịch vụ
    public function getServiceSurchargeFees(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : null;

            $service_surcharge_fees = $this->queryServiceSerchargeFees($filters);
            if (empty($service_surcharge_fees)) {
                $service_surcharge_fees = ServiceSurchargeFee::isShow()->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);
            } else {
                $service_surcharge_fees = $service_surcharge_fees->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);
            }
            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => [
                        'service_surcharge_fees' => $service_surcharge_fees
                    ]
                ]);
            }
            $html = view('manage.admin.system.service-surcharge-fee.pagination', compact('service_surcharge_fees'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    // Hiển thị lấy data 1 phụ thu theo dịch vụ
    public function getServiceSurchargeFee(Request $request)
    {
        $this->validate($request, [
            'service_surcharge_fee_id' => 'required'
        ]);
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $surcharge = ServiceSurchargeFee::isShow()->find($request_data['service_surcharge_fee_id']);
            if (!$surcharge) return returnResponse(HTTP_BAD_REQUEST, 'Không tìm thấy phụ thu');

            return response()->json([
                'status' => HTTP_OK,
                'data' => [
                    'service_surcharge_fees' => $surcharge
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    // Create/Edit 

    public function handleServiceSurchargeFee(Request $request)
    {
        $this->validate($request, [
            'service_id' => 'required',
            'condition_type' => 'required|integer|min:0|max:1',
            'condition_value' => 'required|numeric|min:0',
            'surcharge_name' => 'required|min:0|max:225',
            'amount' => 'required|numeric|min:0',
        ]);
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            if (isset($request_data['service_surcharge_fee_id'])) {
                $surcharge = ServiceSurchargeFee::isShow()->find($request_data['service_surcharge_fee_id']);
                if (!$surcharge) return returnResponse(HTTP_BAD_REQUEST, 'Không tìm thấy phụ thu');
            } else {
                $surcharge = ServiceSurchargeFee::isShow()->where('service_id', $request_data['service_id'])->first();
                if ($surcharge) return returnResponse(HTTP_BAD_REQUEST, 'Dịch vụ này đã được thêm rồi', null, 'warning');
            }

            DB::beginTransaction();

            ServiceSurchargeFee::updateOrCreate([
                'service_surcharge_fee_id' => isset($request_data['service_surcharge_fee_id']) && $request_data['service_surcharge_fee_id'] !== "" ? $request_data['service_surcharge_fee_id'] : null,
            ], [
                'service_id' => $request_data['service_id'],
                'condition_type' => $request_data['condition_type'],
                'condition_value' => $request_data['condition_value'],
                'surcharge_name' => $request_data['surcharge_name'],
                'amount' => $request_data['amount'],
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => $surcharge ?? null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', isset($request_data['service_surcharge_fee_id']) ? 'Cập nhật' : 'Thêm' . " phụ thu theo dịch vụ", $data_logs);

            DB::commit();
            return returnResponse(HTTP_OK, 'Cập nhật dữ liệu thành công', null, 'success');
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    // Delete

    public function deleteServiceSurchargeFee(Request $request)
    {
        $this->validate($request, [
            'service_surcharge_fee_id' => 'required'
        ]);
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $surcharge = ServiceSurchargeFee::isShow()->find($request_data['service_surcharge_fee_id']);
            if (!$surcharge) return returnResponse(HTTP_BAD_REQUEST, 'Không tìm thấy phụ thu');

            DB::beginTransaction();
            $surcharge->delete_flg = DELETED;
            $surcharge->save();

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => $surcharge,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', "Xóa phụ thu theo dịch vụ", $data_logs);

            DB::commit();
            return returnResponse(HTTP_OK, 'Xóa dữ liệu thành công', null, 'success');
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    // ---------------------------- END Phụ thu theo dịch vụ -------------------------- //

    //Danh sách quốc gia
    public function displayManageAdminSystemCountries(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $countries = Country::isDelete(NO_DELETE)->orderByDesc('country_id')->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $countries
                ]);
            }
            $html = view('manage.admin.system.country.index', compact('countries'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataCountries(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;

            $countries = Country::isDelete(NO_DELETE)
                ->isFilters($filters)
                ->orderByDesc('country_id')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $countries
                ]);
            }
            $html = view('manage.admin.system.country.countries-pagination', compact('countries'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function updateDataCountry(Request $request)
    {
        $request->validate([
            'country_name' => 'required|min:1|max:255',
            'country_code' => 'required|min:1|max:255',
            'active_flg' => 'required|integer|min:0|max:1',
        ]);

        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $country_id = json_decode($request_data['country_id']);
            Country::updateOrCreate([
                'country_id' => isset($country_id) && $country_id !== "" ? $country_id : null,
            ], [
                'country_name' => $request_data['country_name'],
                'country_code' => $request_data['country_code'],
                'active_flg' => $request_data['active_flg'],
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật quốc gia', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Cập nhật quốc gia thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function getDataCountry(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $country_id = json_decode($request_data['country_id']);

            $country = Country::isDelete(NO_DELETE)->findOrFail($country_id)->toArray();

            return response()->json([
                'status' => HTTP_OK,
                'data' => $country
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function deleteDataCountry(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $country_id = json_decode($request_data['country_id']);

            Country::isDelete(NO_DELETE)->findOrFail($country_id)->update([
                'delete_flg' => DELETED,
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa quốc gia', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã xóa quốc gia này thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    //Danh sách hàng hóa phụ thu
    public function displayManageAdminSystemSurchargeGoods(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $surcharge_goods = SurchargeGoods::isDelete(NO_DELETE)->orderByDesc('updated_at')->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $surcharge_goods
                ]);
            }
            $html = view('manage.admin.system.surcharge-goods.index', compact('surcharge_goods'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataSurchargeGoodsList(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $surcharge_goods = SurchargeGoods::isDelete(NO_DELETE)->orderByDesc('updated_at')->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $surcharge_goods
                ]);
            }
            $html = view('manage.admin.system.surcharge-goods.surcharge-goods-pagination', compact('surcharge_goods'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataSurchargeGoods(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $surcharge_goods_id = json_decode($request_data['surcharge_goods_id']);

            $surcharge_goods = SurchargeGoods::isDelete(NO_DELETE)->findOrFail($surcharge_goods_id)->toArray();

            return response()->json([
                'status' => HTTP_OK,
                'data' => $surcharge_goods
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function updateDataSurchargeGoods(Request $request)
    {
        $request->validate([
            'surcharge_goods_name' => 'required|min:1|max:255',
            'surcharge_goods_type' => 'required|min:1|max:255',
            'surcharge_goods_price' => 'required|numeric|min:0',
            'active_flg' => 'required|integer|min:0|max:1',
        ]);

        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $surcharge_goods_id = json_decode($request_data['surcharge_goods_id']);
            SurchargeGoods::updateOrCreate([
                'surcharge_goods_id' => isset($surcharge_goods_id) && $surcharge_goods_id !== "" ? $surcharge_goods_id : null,
            ], [
                'surcharge_goods_name' => $request_data['surcharge_goods_name'],
                'surcharge_goods_type' => $request_data['surcharge_goods_type'],
                'surcharge_goods_price' => $request_data['surcharge_goods_price'],
                'active_flg' => $request_data['active_flg'],
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật phụ thu hàng hóa', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Cập nhật hàng hóa phụ thu thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function deleteDataSurchargeGoods(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $surcharge_goods_id = json_decode($request_data['surcharge_goods_id']);

            SurchargeGoods::isDelete(NO_DELETE)->findOrFail($surcharge_goods_id)->update([
                'delete_flg' => DELETED,
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa phụ thu hàng hóa', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã xóa hàng hóa phụ thu thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    //Danh sách State/Province
    public function displayManageAdminSystemStates(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;

            $countries = Country::isActive(ACTIVE)->isDelete(NO_DELETE)->get()->toArray();
            $states = State::with(['country'])->isFilters($filters)->isDelete(NO_DELETE)->orderByDesc('updated_at')->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'countries' => $countries,
                    'data' => $states,
                ]);
            }
            $html = view('manage.admin.system.state.index', compact('countries', 'states'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataStates(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;

            $states = State::with(['country'])->isFilters($filters)->isDelete(NO_DELETE)->orderByDesc('updated_at')->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $states
                ]);
            }
            $html = view('manage.admin.system.state.states-pagination', compact('states'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataState(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $state_id = json_decode($request_data['state_id']);

            $state = State::with(['country'])->isDelete(NO_DELETE)->findOrFail($state_id)->toArray();

            return response()->json([
                'status' => HTTP_OK,
                'data' => $state
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function updateDataState(Request $request)
    {
        $request->validate([
            'country_id' => 'required',
            // 'state_post_code' => 'required|min:1|max:255',
            // 'state_code' => 'required|min:1|max:255',
            'state_name' => 'required|min:1|max:255',
            'state_details' => 'required|min:1|max:255',
            'active_flg' => 'required|integer|min:0|max:1',
        ]);

        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $state_id = json_decode($request_data['state_id']);
            State::updateOrCreate([
                'state_id' => isset($state_id) && $state_id !== "" ? $state_id : null,
            ], [
                'country_id' => $request_data['country_id'],
                'state_post_code' => $request_data['state_post_code'] ?? null,
                'state_code' => $request_data['state_code'] ?? "",
                'state_name' => $request_data['state_name'],
                'state_details' => $request_data['state_details'],
                'active_flg' => $request_data['active_flg'],
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật khu vực', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Cập nhật state thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function deleteDataState(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $state_id = json_decode($request_data['state_id']);

            State::isDelete(NO_DELETE)->findOrFail($state_id)->update([
                'delete_flg' => DELETED,
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa dịch vụ', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã xóa state thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    //Danh sách Liên Kết Quốc Gia - Dịch Vụ
    public function displayManageAdminSystemCountriesServicesList(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $countries = Country::with(['countriesServices'])
                ->isActive(ACTIVE)
                ->isDelete(NO_DELETE)
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            $services = Service::isActive(ACTIVE)
                ->isDelete(NO_DELETE)
                ->select('service_id', 'service_name')
                ->get()
                ->toArray();

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'countries' => $countries,
                ]);
            }
            $html = view('manage.admin.system.country-service.index', compact('countries', 'services'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataCountriesServices(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;

            $countries = Country::with(['countriesServices'])
                ->isActive(ACTIVE)
                ->isDelete(NO_DELETE)
                ->isFilters($filters)
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            $services = Service::isActive(ACTIVE)
                ->isDelete(NO_DELETE)
                ->select('service_id', 'service_name')
                ->get()
                ->toArray();

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $countries
                ]);
            }
            $html = view('manage.admin.system.country-service.countries-services-pagination', compact('countries', 'services'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataCountryService(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $country_and_service_link_id = json_decode($request_data['country_and_service_link_id']);

            $country_and_service_link = CountryAndServiceLink::with(['country', 'service'])->isDelete(NO_DELETE)->findOrFail($country_and_service_link_id)->toArray();

            return response()->json([
                'status' => HTTP_OK,
                'data' => $country_and_service_link
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function updateDataCountryService(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $countries_services = isset($request_data['countries_services']) ? json_decode($request_data['countries_services'], true) : [];

            foreach ($countries_services as $key => $value) {
                CountryAndServiceLink::where('country_id', $key)->delete();
                foreach ($value as $service) {
                    CountryAndServiceLink::create([
                        'country_id' => $key,
                        'service_id' => $service,
                        'active_flg' => ACTIVE,
                    ]);
                }
            }

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật liên kết quốc gia - dịch vụ', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Cập nhật liên kết quốc gia - dịch vụ thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function deleteDataCountryService(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $country_and_service_link_id = json_decode($request_data['country_and_service_link_id']);

            CountryAndServiceLink::isDelete(NO_DELETE)->findOrFail($country_and_service_link_id)->update([
                'delete_flg' => DELETED,
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa liên kết quốc gia - dịch vụ', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã xóa liên kết quốc gia - dịch vụ thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    //Thêm Thành Phố Vào Hệ Thống
    public function displayManageAdminSystemCities(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;

            $countries = Country::isActive(ACTIVE)->isDelete(NO_DELETE)->get()->toArray();
            $cities = City::with(['country', 'state'])->isFilters($filters)->isDelete(NO_DELETE)->orderByDesc('updated_at')->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'countries' => $countries,
                    'cities' => $cities,
                ]);
            }
            $html = view('manage.admin.system.city.index', compact('countries', 'cities'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataCities(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;

            $cities = City::with(['country', 'state'])->isFilters($filters)->isDelete(NO_DELETE)->orderByDesc('updated_at')->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $cities
                ]);
            }
            $html = view('manage.admin.system.city.cities-pagination', compact('cities'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataCity(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $city_id = json_decode($request_data['city_id']);

            $city = City::with(['country', 'state'])->isDelete(NO_DELETE)->findOrFail($city_id)->toArray();

            return response()->json([
                'status' => HTTP_OK,
                'data' => $city
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function updateDataCity(Request $request)
    {
        $request->validate([
            'country_id' => 'required',
            // 'state_id' => 'required',
            'city_name' => 'required|min:1|max:255',
            'city_post_code' => 'required|min:1|max:255',
            'active_flg' => 'required|integer|min:0|max:1',
        ]);

        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $city_id = json_decode($request_data['city_id']);
            City::updateOrCreate([
                'city_id' => isset($city_id) && $city_id !== "" ? $city_id : null,
            ], [
                'country_id' => $request_data['country_id'],
                'state_id' => $request_data['state_id'] ?? null,
                'city_name' => $request_data['city_name'],
                'city_post_code' => $request_data['city_post_code'],
                'active_flg' => $request_data['active_flg'],
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật thành phố', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Cập nhật thành phố thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function deleteDataCity(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $city_id = json_decode($request_data['city_id']);

            City::isDelete(NO_DELETE)->findOrFail($city_id)->update([
                'delete_flg' => DELETED,
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa thành phố', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã xóa thành phố thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    //Danh Sách Dịch Vụ Khuyến Mãi
    public function displayManageAdminSystemPromotionServices(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $users = User::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->leftJoin('promotion_services', 'promotion_services.user_id', 'users.user_id')
                ->whereNull('promotion_services.promotion_service_id')
                ->select('users.user_id', 'users.user_name', 'users.user_contact_name', 'promotion_services.promotion_service_id')
                ->get()->toArray();
            $services = Service::isActive(ACTIVE)->isDelete(NO_DELETE)->isPromotion(IS_PROMOTION)->select('service_name')->get()->toArray();
            $promotion_services = PromotionService::with(['user'])->isDelete(NO_DELETE)
                ->orderByDesc('updated_at')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'users' => $users,
                    'services' => $services,
                    'data' => $promotion_services
                ]);
            }
            $html = view('manage.admin.system.promotion-service.index', compact('users', 'services', 'promotion_services'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataPromotionServices(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $promotion_services = PromotionService::with(['user'])->isDelete(NO_DELETE)
                ->orderByDesc('updated_at')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $promotion_services
                ]);
            }
            $html = view('manage.admin.system.promotion-service.promotion-services-pagination', compact('promotion_services'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function updateDataPromotionService(Request $request)
    {
        $request->validate([
            'user_id' => 'required',
        ]);

        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $user = $is_api ? $request_data['user'] : auth()->user();

            $check_promotion_service = PromotionService::where('user_id', $user['user_id'])->first();
            if (isset($check_promotion_service)) {
                return response()->json([
                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                    'message' => [
                        'title' => 'Thất bại!',
                        'text' => 'Tài khoản này đã được thêm!.',
                        'icon' => 'error',
                    ],
                ]);
            }

            $promotion_service_id = json_decode($request_data['promotion_service_id']);
            PromotionService::updateOrCreate([
                'promotion_service_id' => isset($promotion_service_id) && $promotion_service_id !== "" ? $promotion_service_id : null,
            ], [
                'user_id' => $request_data['user_id'],
                'active_flg' => ACTIVE,
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật dịch vụ khuyến mãi', $data_logs);

            DB::commit();
            $users = User::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->leftJoin('promotion_services', 'promotion_services.user_id', 'users.user_id')
                ->whereNull('promotion_services.promotion_service_id')
                ->select('users.user_id', 'users.user_name', 'users.user_contact_name', 'promotion_services.promotion_service_id')
                ->get()->toArray();

            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Cập nhật dịch vụ khuyến mãi thành công.',
                    'icon' => 'success',
                ],
                'users' => $users
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function deleteDataPromotionService(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $promotion_service_id = json_decode($request_data['promotion_service_id']);

            PromotionService::findOrFail($promotion_service_id)->delete();

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa dịch vụ khuyến mãi', $data_logs);

            DB::commit();
            $users = User::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->leftJoin('promotion_services', 'promotion_services.user_id', 'users.user_id')
                ->whereNull('promotion_services.promotion_service_id')
                ->select('users.user_id', 'users.user_name', 'users.user_contact_name', 'promotion_services.promotion_service_id')
                ->get()->toArray();

            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã xóa dịch vụ khuyến mãi thành công.',
                    'icon' => 'success',
                ],
                'users' => $users,
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    //Chỉnh sửa Hệ Thống
    public function displayManageAdminSystemSettings(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $path = 'public/config/system-settings.json';
            $system_settings = json_decode(Storage::get($path), true);
            $data_positions = [];
            foreach ($system_settings as $key_setting => $system_setting) {
                if (in_array($system_setting['kind'], [SETTING_ADMIN_ACCOUNT, SETTING_ACCOUNTANT_ACCOUNT, SETTING_DOCUMENT_ACCOUNT, SETTING_SALE_ACCOUNT, SETTING_FWD_ACCOUNT, SETTING_SHIPPER_ACCOUNT, SETTING_DRIVER_ACCOUNT, SETTING_ACCOUNT_EDIT_ORDER_PICKUP, SETTING_ACCOUNT_UPDATE_NOTIFICATIONS, SETTING_ACCOUNT_VIEW_AND_UPDATE_SHIPMENT_OPERATING_COST, SETTING_ACCOUNT_SCAN, SETTING_ACCOUNT_TICKET, SETTING_SHIPPER_ACCOUNT, SETTING_ACCOUNT_DEBITS, SETTING_OPS_LEADER_ACCOUNT, SETTING_PRINT_BILL_TYPE])) {
                    if (!empty($data_positions)) {
                        $system_settings[$key_setting]['data'] = $data_positions;
                        continue;
                    }
                    $model = ucfirst($system_setting['model']);
                    $model_path = "App\Models\\$model";
                    if (class_exists($model_path)) {
                        $model = app($model_path);
                        $data_positions = $model::isDelete(ACTIVE)->isDelete(NO_DELETE)->get()->toArray();
                        $system_settings[$key_setting]['data'] = $data_positions;
                    }
                }
            }

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'system_settings' => $system_settings
                ]);
            }



            $html = view('manage.admin.system.setting.index', compact('system_settings'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function updateDataSettings(Request $request)
    {
        $request->validate([
            'setting_admin_account' => 'required',
            'setting_accountant_account' => 'required',
            'setting_document_account' => 'required',
            'setting_sale_account' => 'required',
            'setting_fwd_account' => 'required',
        ]);
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $service_accountant_status = isset($request_data['service_accountant_status']) ? json_decode($request_data['service_accountant_status']) : false;
            $authenticator_all_user_status = isset($request_data['authenticator_all_user_status']) ? json_decode($request_data['authenticator_all_user_status']) : false;
            $setting_admin_account = isset($request_data['setting_admin_account']) ? $request_data['setting_admin_account'] : '';
            $setting_accountant_account = isset($request_data['setting_accountant_account']) ? $request_data['setting_accountant_account'] : '';
            $setting_document_account = isset($request_data['setting_document_account']) ? $request_data['setting_document_account'] : '';
            $setting_sale_account = isset($request_data['setting_sale_account']) ? $request_data['setting_sale_account'] : '';
            $setting_fwd_account = isset($request_data['setting_fwd_account']) ? $request_data['setting_fwd_account'] : '';
            $setting_shipper_account = isset($request_data['setting_shipper_account']) ? $request_data['setting_shipper_account'] : '';
            $setting_driver_account = isset($request_data['setting_driver_account']) ? $request_data['setting_driver_account'] : '';
            $setting_ops_leader_account = isset($request_data['setting_ops_leader_account']) ? $request_data['setting_ops_leader_account'] : '';
            $setting_account_edit_order_pickup = isset($request_data['setting_account_edit_order_pickup']) ? $request_data['setting_account_edit_order_pickup'] : '';
            $setting_account_update_notifications = isset($request_data['setting_account_update_notifications']) ? $request_data['setting_account_update_notifications'] : '';
            $setting_account_view_and_update_shipment_operating_cost = isset($request_data['setting_account_view_and_update_shipment_operating_cost']) ? $request_data['setting_account_view_and_update_shipment_operating_cost'] : '';
            $setting_account_scan = isset($request_data['setting_account_scan']) ? $request_data['setting_account_scan'] : '';
            $setting_account_ticket = isset($request_data['setting_account_ticket']) ? $request_data['setting_account_ticket'] : '';
            $setting_account_debits = isset($request_data['setting_account_debits']) ? $request_data['setting_account_debits'] : [];
            $setting_print_bill_type = isset($request_data['setting_print_bill_type']) ? $request_data['setting_print_bill_type'] : [];
            $setting_company_name = isset($request_data['setting_company_name']) ? $request_data['setting_company_name'] : '';
            $setting_headquarters_address = isset($request_data['setting_headquarters_address']) ? $request_data['setting_headquarters_address'] : '';
            $setting_email_address = isset($request_data['setting_email_address']) ? $request_data['setting_email_address'] : '';
            $setting_website_address = isset($request_data['setting_website_address']) ? $request_data['setting_website_address'] : '';
            $setting_hotline = isset($request_data['setting_hotline']) ? $request_data['setting_hotline'] : '';
            $setting_zalo = isset($request_data['setting_zalo']) ? $request_data['setting_zalo'] : '';
            $setting_facebook = isset($request_data['setting_facebook']) ? $request_data['setting_facebook'] : '';

            $path = 'public/config/system-settings.json';
            // Check không cho phép 1 tk có 2 chức vụ 
            $values = [$setting_admin_account, $setting_accountant_account, $setting_sale_account, $setting_fwd_account, $setting_shipper_account];
            $counts = array_count_values($values);
            $duplicates = array_filter($counts, function ($count) {
                return $count > 1;
            });
            if (!empty($duplicates)) {
                return returnResponse(HTTP_BAD_REQUEST, 'Một tài khoản chỉ có 1 chức vụ');
            }

            $system_settings = config('constans.system-settings');
            foreach ($system_settings as $key_setting => $system_setting) {
                if (in_array($system_setting['kind'], [SETTING_ALL_ACCOUNT])) {
                    foreach ($system_setting['data'] as $key_data => $item) {
                        $name = $item['name'];
                        ${$name} = ${$name} ? ACTIVE : INACTIVE;
                        Config::set("constans.system-settings.$key_setting.data.$key_data.active_flg", ${$name});
                    }
                } else if (in_array($system_setting['kind'], [SETTING_ADMIN_ACCOUNT, SETTING_ACCOUNTANT_ACCOUNT, SETTING_DOCUMENT_ACCOUNT, SETTING_SALE_ACCOUNT, SETTING_FWD_ACCOUNT, SETTING_SHIPPER_ACCOUNT, SETTING_DRIVER_ACCOUNT, SETTING_OPS_LEADER_ACCOUNT])) {

                    $name = $system_setting['name'];
                    // $position_id = collect(json_decode(Storage::get($path), true))->firstWhere('kind', $system_setting['kind'])['position_id'];
                    // User::isPosition($position_id)->update([
                    //     'position_id' => ${$name},
                    // ]);
                    Config::set("constans.system-settings.$key_setting.position_id", ${$name});
                } else if (in_array($system_setting['kind'], [SETTING_ACCOUNT_EDIT_ORDER_PICKUP, SETTING_ACCOUNT_UPDATE_NOTIFICATIONS, SETTING_ACCOUNT_VIEW_AND_UPDATE_SHIPMENT_OPERATING_COST, SETTING_ACCOUNT_SCAN, SETTING_ACCOUNT_TICKET, SETTING_ACCOUNT_DEBITS, SETTING_PRINT_BILL_TYPE])) {
                    $name = $system_setting['name'];
                    Config::set("constans.system-settings.$key_setting.position_ids", ${$name});
                } else if (in_array($system_setting['kind'], [SETTING_COMPANY_NAME, SETTING_HEADQUARTERS_ADDRESS, SETTING_EMAIL_ADDRESS, SETTING_WEBSITE_ADDRESS, SETTING_HOTLINE, SETTING_ZALO, SETTING_FACEBOOK])) {
                    $name = $system_setting['name'];
                    Config::set("constans.system-settings.$key_setting.value", ${$name});
                }

                if ($system_setting['name'] == "setting_key_vnp") {
                    $path = 'public/config/system-settings.json';
                    $settings = json_decode(Storage::get($path), true);

                    $_data = isset($settings[$key_setting]['data']) ? $settings[$key_setting]['data'] : [
                        "hash_secret" => "",
                        "tmn_code" => "",
                    ];
                    Config::set("constans.system-settings.$key_setting.data", $_data);
                }
            }
            Storage::put($path, json_encode(config('constans.system-settings')));

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật hệ thống', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã cập nhật cấu hình hệ thống thành công.',
                    'icon' => 'success',
                ],
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    //Chỉnh sửa hiển thị menu setting
    public function displayManageAdminSystemMenuSettings(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $path = 'public/config/system-sidebars-settings.json';
            $contents = config('constans.integrations-app-sidebars.manage_admin_system');
            $system_settings = [];
            // if (!Storage::exists($path)) {
            //     // Tạo file nếu chưa có và ghi nội dung mặc định vào file
            //     $defaultSettings = json_encode($new_contents, JSON_PRETTY_PRINT);
            //     Storage::put($path, $defaultSettings);
            // }

            $route_sidebars = [];
            foreach ($contents as $key => $content) {

                $system_settings[$key] = [
                    'title' => $content['title'],
                    'menus' => []
                ];
                foreach ($content['menus'] as $index => $menu) {
                    if (isset($menu['route'])) {
                        array_push($route_sidebars, $menu['route']);
                    }
                    $system_settings[$key]['menus'][$index] = [
                        'title' => $menu['title'],
                        'route' => $menu['route'],
                        'type' => getItemSettingSideBar($menu['route'], "type") ?? 1,
                        'position_ids' => getItemSettingSideBar($menu['route'], "position_ids") ?? [],
                        'is_all' => getItemSettingSideBar($menu['route'], "is_all") ?? false,
                        'user_ids' => getItemSettingSideBar($menu['route'], "user_ids") ?? [],
                    ];
                }
            }

            $position_not_in = [
                getPositionAccountSetting(SETTING_FWD_ACCOUNT),
                getPositionAccountSetting(SETTING_ADMIN_ACCOUNT)
            ];

            $users = User::isShow()
                ->whereNotIn('position_id', $position_not_in)
                ->select('user_id', 'user_contact_name', 'user_code')
                ->get();

            $position_admin = getPositionAccountSetting(SETTING_ADMIN_ACCOUNT);
            $positions = Position::isShow()->where('position_id', '!=', $position_admin)->select('position_id', 'position_name')->get();

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'system_settings' => $system_settings
                ]);
            }

            $html = view('manage.admin.system.setting.sidebars', compact('system_settings', 'users', 'positions'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
                'route_sidebars' => $route_sidebars
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleManageAdminSystemMenuSettings(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $path = 'public/config/system-sidebars-settings.json';
            $contents = config('constans.integrations-app-sidebars.manage_admin_system');
            $system_settings = [];


            foreach ($contents as $key => $content) {
                $system_settings[$key] = [
                    'title' => $content['title'],
                    'menus' => []
                ];

                foreach ($content['menus'] as $index => $menu) {
                    $converted = str_replace('.', '_', $menu['route']);
                    $system_settings[$key]['menus'][$index] = [
                        'title' => $menu['title'],
                        'route' => $menu['route'],
                        'position_ids' => $request_data[$converted]['position_ids'] ?? [],
                        'is_all' => isset($request_data[$converted]['is_all']) ? json_decode($request_data[$converted]['is_all']) : false,
                        'user_ids' => $request_data[$converted]['user_ids'] ?? [],
                    ];
                }
            }
            if (!Storage::exists($path)) {
                // Tạo file nếu chưa có và ghi nội dung mặc định vào file
                $defaultSettings = json_encode($system_settings, JSON_PRETTY_PRINT);
                Storage::put($path, $defaultSettings);
            } else {
                Storage::put($path, json_encode($system_settings));
            }

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật menu hệ thống', $data_logs);

            return returnResponse(HTTP_OK, 'Cập nhật thành công', null, 'success');
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    // Chỉnh sửa hiển thị menu sale 
    public function displayManageAdminSystemMenuSale(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $contents = config('constans.menu-sale-manager');
            $system_settings = [];
            $keys = [];
            foreach ($contents as $key => $content) {
                $system_settings[$key] = $content;
                $system_settings[$key]['position_ids'] = getStorageMenuSaleSetting('key', $content['key'], 'position_ids') ?? [];
                array_push($keys, $content['key']);
            }
            // $position_in = [
            //     getPositionAccountSetting(SETTING_ACCOUNTANT_ACCOUNT),
            //     getPositionAccountSetting(SETTING_DOCUMENT_ACCOUNT),
            //     getPositionAccountSetting(SETTING_SALE_ACCOUNT),
            //     getPositionAccountSetting(SETTING_ADMIN_ACCOUNT),
            // ];
            $users = [];
            // $users = User::isShow()
            //     ->whereNotIn('position_id', $position_in)
            //     ->select('user_id', 'user_contact_name', 'user_code')
            //     ->get();

            $position_admin = getPositionAccountSetting(SETTING_ADMIN_ACCOUNT);
            $positions = Position::isShow()->where('position_id', '!=', $position_admin)->select('position_id', 'position_name')->get();

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'system_settings' => $system_settings,
                    'keys' => $keys
                ]);
            }

            $html = view('manage.admin.system.setting.menu-sale-manager', compact('system_settings', 'users', 'positions'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
                'route_sidebars' => $keys
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleManageAdminSystemMenuSale(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $path = 'public/config/system-menu-sale.json';
            $contents = config('constans.menu-sale-manager');
            $system_settings = [];


            foreach ($contents as $key => $value) {
                $contents[$key]['position_ids'] = $request_data[$value['key']]['position_ids'] ?? [];
            }
            $system_settings = $contents;
            if (!Storage::exists($path)) {
                // Tạo file nếu chưa có và ghi nội dung mặc định vào file
                $defaultSettings = json_encode($system_settings, JSON_PRETTY_PRINT);
                Storage::put($path, $defaultSettings);
            } else {
                Storage::put($path, json_encode($system_settings));
            }

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật menu sale', $data_logs);

            return returnResponse(HTTP_OK, 'Cập nhật thành công', null, 'success');
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function updateInfoVnpay(Request $request)
    {
        try {
            $request_data = $request->all();
            $request_data['hash_secret'] = isset($request_data['hash_secret']) ? trim($request_data['hash_secret']) : '';
            $request_data['tmn_code'] = isset($request_data['tmn_code']) ? trim($request_data['tmn_code']) : '';
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            if (auth()->user()['position_id'] != 1) {
                return returnResponse(HTTP_BAD_REQUEST, 'Chỉ có admin mới có thể sử dụng chức năng này');
            }

            $path = 'public/config/system-settings.json';
            $settings = json_decode(Storage::get($path), true);

            $index = array_search('setting_key_vnp', array_column($settings, 'name'));

            $info_vnpay = isset($settings[$index]) ? $settings[$index] :
                [
                    'title' => 'Cài đặt thông tin thanh toán',
                    'kind' => SETTING_KEY_VNP,
                    'name' => 'setting_key_vnp',
                    'data' => [
                        "hash_secret" => "",
                        "tmn_code" => "",
                        "token_payment" => "",
                        "match_pattern" => "",
                    ],
                ];

            switch ($request_data['kind']) {
                case 'checked':
                    if (Hash::check($request_data['password'], auth()->user()->password)) {

                        $html = view('manage.admin.system.setting.vnpay', compact('info_vnpay'))->render();

                        // Lịch sử hoạt động tài khoản
                        $data_logs = [
                            'old_data' => null,
                            'new_data' => $request_data
                        ];
                        onCreateAccountActivityLogs('Quản lý hệ thống', 'Truy cập key thanh toán QR', $data_logs);

                        return response()->json([
                            'status' => HTTP_OK,
                            'html' => $html,
                            'message' => [
                                'icon' => 'success',
                                'title' => 'Thông báo',
                                'text' => 'Xác nhận thành công'
                            ]
                        ]);
                    } else {
                        return returnResponse(HTTP_BAD_REQUEST, 'Mật khẩu không đúng');
                    }
                case 'update':
                    if (!isset($settings[$index])) {
                        return returnResponse(HTTP_BAD_REQUEST, 'file lưu dữ liệu lỗi');
                    }

                    $settings[$index]['data']['hash_secret'] = trim($request_data['hash_secret']);
                    $settings[$index]['data']['tmn_code'] = trim($request_data['tmn_code']);
                    $settings[$index]['data']['token_payment'] = trim($request_data['token_payment'] ?? '');
                    $settings[$index]['data']['match_pattern'] = trim($request_data['match_pattern'] ?? '');

                    Storage::put($path, json_encode($settings, JSON_PRETTY_PRINT));

                    // Lịch sử hoạt động tài khoản
                    $data_logs = [
                        'old_data' => null,
                        'new_data' => $request_data
                    ];
                    onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật key thanh toán QR', $data_logs);

                    return returnResponse(HTTP_OK, 'Cập nhật thành công', 'Thông báo', 'success');

                default:
                    return showMessageError();
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    //Danh Sách Discount Tài Khoản
    public function displayManageAdminSystemDiscountUsers(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $path = 'public/config/system-settings.json';

            $system_settings = json_decode(Storage::get($path), true);
            $position_id = collect($system_settings)->firstWhere('kind', SETTING_FWD_ACCOUNT)['position_id'];

            $users = User::isActive(ACTIVE)->isDelete(NO_DELETE)->isPosition($position_id)
                ->select('users.user_id', 'users.user_name', 'users.user_company_name')
                ->get()->toArray();
            $services = Service::isActive(ACTIVE)->isDelete(NO_DELETE)->isPromotion(NO_PROMOTION)
                ->select('services.service_id', 'services.service_name')
                ->get()->toArray();
            $discount_users = DiscountUser::with(['user', 'service', 'discountUserWeightLevels'])->isActive(ACTIVE)->isDelete(NO_DELETE)
                ->orderByDesc('updated_at')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'users' => $users,
                    'services' => $services,
                    'data' => $discount_users
                ]);
            }
            $html = view('manage.admin.system.discount-user.index', compact('users', 'services', 'discount_users'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function getDataDiscountUsers(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $discount_users = DiscountUser::with(['user', 'service', 'discountUserWeightLevels'])->isActive(ACTIVE)->isDelete(NO_DELETE)
                ->orderByDesc('updated_at')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $discount_users
                ]);
            }
            $html = view('manage.admin.system.discount-user.discount-users-pagination', compact('discount_users'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataDiscountUser(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $discount_user_id = json_decode($request_data['discount_user_id']);

            $discount_user = DiscountUser::with(['user', 'service', 'discountUserWeightLevels'])->isDelete(NO_DELETE)->findOrFail($discount_user_id)->toArray();

            return response()->json([
                'status' => HTTP_OK,
                'data' => $discount_user
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function updateDataDiscountUser(Request $request)
    {
        $request->validate([
            'user_id' => 'required',
            'service_id' => 'required',
            'discount_start_date' => 'required',
            'discount_end_date' => 'required',
        ]);
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $discount_user_id = json_decode($request_data['discount_user_id']);
            $discount_start_date = Carbon::parse($request_data['discount_start_date'])->format('Y-m-d');
            $discount_end_date = Carbon::parse($request_data['discount_end_date'])->format('Y-m-d');
            $discount_user_kg_levels = isset($request_data['discount_user_kg_levels']) ? json_decode($request_data['discount_user_kg_levels'], true) : [];

            $check_discount_user = DiscountUser::isDelete(NO_DELETE)
                ->isUser($request_data['user_id'])
                ->isService($request_data['service_id'])
                ->where('discount_users.discount_start_date', '<=', $discount_end_date)
                ->where('discount_users.discount_end_date', '>=', $discount_start_date)
                ->where(function ($query) use ($discount_user_id) {
                    if (isset($discount_user_id) && $discount_user_id !== "") {
                        $query->where('discount_users.discount_user_id', '!=', $discount_user_id);
                    }
                    return $query;
                })
                ->exists();

            if ($check_discount_user) {
                return response()->json([
                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                    'message' => [
                        'title' => 'Dữ liệu đã tồn tại!',
                        'text' => 'Bảng giá dịch vụ giảm cho người dùng này đã tồn tại.',
                        'icon' => 'error',
                    ],
                ], HTTP_INTERNAL_SERVER_ERROR);
            }

            $discount_user = DiscountUser::updateOrCreate([
                'discount_user_id' => isset($discount_user_id) && $discount_user_id !== "" ? $discount_user_id : null,
            ], [
                'user_id' => $request_data['user_id'],
                'service_id' => $request_data['service_id'],
                'discount_start_date' => Carbon::parse($request_data['discount_start_date']),
                'discount_end_date' => Carbon::parse($request_data['discount_end_date']),
                'active_flg' => ACTIVE,
            ]);

            DiscountUserWeightLevel::where('discount_user_id', $discount_user->discount_user_id)->delete();
            foreach ($discount_user_kg_levels as $discount_user_kg_level) {
                DiscountUserWeightLevel::create([
                    'discount_user_id' => $discount_user->discount_user_id,
                    'discount_user_weight' => $discount_user_kg_level['discount_user_weight'],
                    'discount_user_amount' => $discount_user_kg_level['discount_user_amount'],
                ]);
            }

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật giảm giá cho tài khoản', $data_logs);

            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã cập nhật giảm giá tài khoản thành công.',
                    'icon' => 'success',
                ],
            ], HTTP_OK);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function deleteDataDiscountUser(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $discount_user_id = json_decode($request_data['discount_user_id']);

            DiscountUser::findOrFail($discount_user_id)->delete();
            // DiscountUser::isDelete(NO_DELETE)->findOrFail($discount_user_id)->update([
            //     'delete_flg' => DELETED
            // ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa giảm giá cho tài khoản', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã xóa giảm giá tài khoản này thành công.',
                    'icon' => 'success',
                ]
            ], HTTP_OK);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }


    private function getListChangeAmountOriginShipment($filters)
    {


        $query = SetAmountShipment::isShow()->isFilters($filters)
            ->leftJoin('shipments', 'set_amount_origin_shipment.shipment_code', 'shipments.shipment_code')
            ->where('shipments.delete_flg', NO_DELETE)
            ->where('shipments.active_flg', ACTIVE)
            ->leftJoin('users', 'set_amount_origin_shipment.created_by', 'users.user_id')
            ->leftJoin('users as user_sm', 'shipments.user_id', 'user_sm.user_id');

        if ($filters) {
        }

        $query = $query->select(
            'set_amount_origin_shipment.*',
            'users.user_code',
            'users.user_contact_name',
            'user_sm.user_company_name as companay_create_shipment'
        );
        return $query;
    }

    // Danh sách áp giá gốc cho shipment
    public function displayManageAmountOriginShipment(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? json_decode($request, true) : null;

            $list = $this->getListChangeAmountOriginShipment($filters);
            if ($filters) {
            }
            $list = $list->groupBy('set_amount_origin_shipment.id')
                ->orderBy('set_amount_origin_shipment.created_at', 'desc')
                ->isPaginate($request->paginate);

            if ($is_api) {
            } else {
                $html = view('manage.admin.system.set-amount-origin-shipment.index', compact('list'))->render();
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function paginateManageAmountOriginShipment(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? json_decode($request, true) : null;

            $list = $this->getListChangeAmountOriginShipment($filters);
            if ($filters) {
            }
            $list = $list->groupBy('set_amount_origin_shipment.id')
                ->orderBy('set_amount_origin_shipment.created_at', 'desc')
                ->isPaginate($request->paginate);

            if ($is_api) {
            } else {
                $html = view('manage.admin.system.set-amount-origin-shipment.paginate', compact('list'))->render();
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleManageAmountOriginShipment(Request $request)
    {
        $this->validate($request, [
            'shipment_code' => 'required|min:10|max:20',
            'set_amount' => 'required|numeric|min:0|max:999999999',
        ]);
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $user = $is_api ? $request->user() : auth()->user();

            $sm = Shipment::isShow()->where('shipment_code', $request_data['shipment_code'])
                ->leftJoin('users', 'shipments.user_id', 'users.user_id')->first();
            if (!$sm) {
                return returnResponse(HTTP_NO_CONTENT, 'Không tìm thấy đơn vận chuyển');
            }
            if (!onCheckPositionAccount(SETTING_FWD_ACCOUNT, $sm->position_id)) {
                return returnResponse(HTTP_BAD_REQUEST, 'Áp giá chỉ áp dụng cho đơn hàng của FWD', null, 'warning');
            }


            // $set_amount = SetAmountShipment::isShow()->where('shipment_code', $request_data['shipment_code'])->first();
            // if ($set_amount) {
            //     return returnResponse(HTTP_BAD_REQUEST, 'Đã áp giá cho đơn vận chuyển này rồi');
            // }

            $packages_weight = Package::isShow()
                ->where('package_status', '!=', SHIPMENT_STATUS_RETURNED)
                ->where('shipment_id', $sm['shipment_id'])->sum('package_charged_weight');

            if ($packages_weight < 21) {
                return returnResponse(HTTP_BAD_REQUEST, 'chức năng này chỉ áp dụng cho đơn hàng trên 21 kg');
            }

            DB::beginTransaction();
            SetAmountShipment::create([
                'shipment_code' => $request_data['shipment_code'],
                'set_amount' => $request_data['set_amount'],
                'old_amount' => $sm['shipment_amount_service'] / $packages_weight,
                'created_by' => $user['user_id']
            ]);

            $new_amount_service = $request_data['set_amount'] * $packages_weight;
            $new_amount_original = $new_amount_service + $sm['shipment_amount_transport'];
            // Cập nhật lại shipment
            Shipment::find($sm['shipment_id'])->update([
                'shipment_amount_service' => $new_amount_service,
                'shipment_amount_original' => $new_amount_original,
                'shipment_amount_profit' => $sm['shipment_amount_total_customer'] - $new_amount_original
            ]);

            onUpdateFinalAmountShipment($sm['shipment_id']);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Áp giá cho đơn vận chuyển', $data_logs);

            DB::commit();
            return returnResponse(HTTP_OK, 'Áp giá cho đơn vận chuyển thành công', null, 'success');
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    public function deleteManageAmountOriginShipment(Request $request)
    {
        $this->validate($request, [
            'shipment_code' => 'required|min:10|max:20',
        ]);
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $user = $is_api ? $request->user() : auth()->user();


            $set_amount = SetAmountShipment::isShow()->where('shipment_code', $request_data['shipment_code'])->first();
            if (!$set_amount) {
                return returnResponse(HTTP_BAD_REQUEST, 'Không tìm thấy áp giá');
            }

            DB::beginTransaction();

            $set_amount->update(['delete_flg' => DELETED]);
            $sm = Shipment::isShow()->where('shipment_code', $request_data['shipment_code'])->first();


            $sm->update([
                'shipment_amount_original' => $set_amount->old_amount,
                'shipment_amount_profit' => $sm->shipment_amount_total_customer - $set_amount->old_amount
            ]);

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa áp giá cho tài khoản', $data_logs);

            DB::commit();
            return returnResponse(HTTP_OK, 'Xóa áp giá thành công', null, 'success');
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    //Danh sách account FWD
    public function displayManageAdminSystemFWDUsers(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;
            $user = $is_api ? $request->user() : auth()->user();
            $path = 'public/config/system-settings.json';
            $position_id = collect(json_decode(Storage::get($path), true))->firstWhere('kind', SETTING_FWD_ACCOUNT)['position_id'];

            $users = User::isFilters($filters)->isDelete(NO_DELETE)
                ->where('users.user_pending_approval', SUCCESS)
                ->isPosition($position_id)
                ->orderByDesc('updated_at')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $users,
                ]);
            }
            $html = view('manage.admin.system.fwd-user.index', compact('users'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataFWDUsers(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;
            $path = 'public/config/system-settings.json';
            $position_id = collect(json_decode(Storage::get($path), true))->firstWhere('kind', SETTING_FWD_ACCOUNT)['position_id'];

            $users = User::isFilters($filters)->isDelete(NO_DELETE)
                ->where('users.user_pending_approval', SUCCESS)
                ->isPosition($position_id)
                ->orderByDesc('updated_at');

            if (isset($request_data['export_excel']) && json_decode($request_data['export_excel'])) {
                $data = $users->get();
                $viewName = 'manage.admin.system.fwd-user.fwd-users-excel';
                $name_excel = $request_data['name_excel'] ?? 'danh sach fwd.xlsx';
                return Excel::download(new ExportFile($data, $viewName), $name_excel);
            }

            $users = $users->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            $html = view('manage.admin.system.fwd-user.fwd-users-pagination', compact('users'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function displayManageAdminSystemFWDUsersCreate(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $debits = config('constans.constans.debits');
            // $price_list = PriceList::with([
            //     'childPriceList' => function ($query) {
            //         $query->where('child_price_list.child_price_list_kind', USE_SERVICE);
            //     }
            // ])
            //     ->isActive(ACTIVE)->isDelete(NO_DELETE)
            //     ->get()->toArray();

            // $price_list = PriceList::with(['childPriceList'])
            //     ->isActive(ACTIVE)->isDelete(NO_DELETE)
            //     ->where('price_list.price_list_tranport_type', PRICE_LIST_TYPE_SERVICE)
            //     ->get()->toArray();
            $price_list_types = config('constans.constans.price_list_types');

            $cities = collect(config('constans.area'))->pluck('name')->toArray();
            $branchs = Branch::isActive(ACTIVE)->isDelete(NO_DELETE)->get();

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'cities' => $cities,
                    'debits' => $debits,
                    // 'price_list' => $price_list,
                    'price_list_types' => $price_list_types,
                    'branchs' => $branchs,
                ]);
            }
            $html = view('manage.admin.system.fwd-user.create-fwd-user', compact('cities', 'debits', 'price_list_types', 'branchs'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleManageAdminSystemFWDUsersCreate(Request $request)
    {
        // $price_list = PriceList::with([
        //     'childPriceList' => function ($query) {
        //         $query->where('child_price_list.child_price_list_kind', USE_SERVICE);
        //     }
        // ])
        //     ->isActive(ACTIVE)->isDelete(NO_DELETE)
        //     ->get()->toArray();
        $validate = [
            'user_logo' => 'required|image|mimes:jpeg,png|mimetypes:image/jpeg,image/png',
            'user_name' => 'required|email|min:1|max:255|unique:users,user_name',
            'password' => 'required|min:8|max:255',
            'user_contact_name' => 'required|min:1|max:255',
            'user_accountant_key' => 'required|min:1|max:255',
            'user_debit_type' => 'required|numeric|min:0',
            'user_company_name' => 'required|min:1|max:255',
            'user_tax_code' => 'required|min:1|max:255',
            'user_phone' => 'required',
            'branch_id' => 'required|numeric',
            'user_address_1' => 'required|numeric',
            'user_address_2' => 'required|numeric',
            'user_address_3' => 'required|numeric',
            'user_address' => 'required|max:255',
            'user_price_list_main_type' => 'required|numeric',
            'user_limit_amount_for_sale' => 'required|numeric|min:0'
        ];

        // foreach ($price_list as $key => $item) {
        //     $validate['child_price_list_' . $key] = 'required';
        // }

        $request->validate($validate);
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $user_code_old = User::orderBy('created_at', 'DESC')->first()['user_code'];
            $request_data['user_code'] = 'KG' . (int) str_replace('KG', '', $user_code_old) + 1;
            $request_data['user_api_key'] = Str::random(50);
            $path = 'public/config/system-settings.json';
            $position_id = collect(json_decode(Storage::get($path), true))->firstWhere('kind', SETTING_FWD_ACCOUNT)['position_id'];
            $user = User::create([
                'user_name' => $request_data['user_name'],
                'user_code' => $request_data['user_code'],
                'user_api_key' => $request_data['user_api_key'],
                'password' => $request_data['password'],
                'password_show' => $request_data['password'],
                'position_id' => $position_id,
                'branch_id' => $request_data['branch_id'],
                'user_contact_name' => $request_data['user_contact_name'],
                'user_accountant_key' => $request_data['user_accountant_key'],
                'user_debit_type' => $request_data['user_debit_type'],
                'user_company_name' => $request_data['user_company_name'],
                'user_tax_code' => $request_data['user_tax_code'],
                'user_phone' => $request_data['user_phone'],
                'user_address_1' => $request_data['user_address_1'],
                'user_address_2' => $request_data['user_address_2'],
                'user_address_3' => $request_data['user_address_3'],
                'contract_years' => $request_data['contract_years'] ?? null,
                'user_address' => $request_data['user_address'],
                'user_latitude' => isset($request_data['user_latitude']) ? $request_data['user_latitude'] : '',
                'user_longitude' => isset($request_data['user_longitude']) ? $request_data['user_longitude'] : '',
                'user_price_list_main_type' => $request_data['user_price_list_main_type'],
                'user_limit_amount_for_sale' => $request_data['user_limit_amount_for_sale'],
                'active_flg' => ACTIVE,
                'delete_flg' => NO_DELETE,
            ]);
            // $user_price_list_child = json_decode($request_data['user_price_list_main_type_child'], true);
            // if (empty($user_price_list_child)) {
            //     return returnResponse(HTTP_BAD_REQUEST, 'Hãy chọn bảng giá cho từng chi nhánh', null, 'warning');
            // }
            // foreach ($user_price_list_child as $key => $value) {
            //     PriceListUser::create([
            //         'user_id' => $user->user_id,
            //         'price_list_id' => $request_data['user_price_list_main_type'],
            //         'child_price_list_id' => $value,
            //     ]);
            // }

            // foreach ($price_list as $key => $item) {
            //     $child_price_list = $request_data['child_price_list_' . $key];
            //     if (isset($child_price_list) && $child_price_list !== "") {
            //         PriceListUser::create([
            //             'user_id' => $user['user_id'],
            //             'price_list_id' => $item['price_list_id'],
            //             'child_price_list_id' => $child_price_list,
            //             'active_flg' => ACTIVE,
            //             'delete_flg' => NO_DELETE,
            //         ]);
            //     }
            // }

            $upload_path = public_path(PUBLIC_PATH_USER_LOGO);
            if (!File::isDirectory($upload_path)) {
                File::makeDirectory($upload_path, 0777, true, true);
            }
            $file_name = $request_data['user_code'] . '-' . $request->file('user_logo')->getClientOriginalName();
            $request->file('user_logo')->move($upload_path, $file_name);
            $file_path = PUBLIC_PATH_USER_LOGO . '/' . $file_name;
            $user->user_logo = $file_path;
            $user->save();

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Thêm tài khoản công ty', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Thêm tài khoản công ty thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    public function displayManageAdminSystemFWDUsersEdit(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $debits = config('constans.constans.debits');
            $price_list_types = config('constans.constans.price_list_types');
            // $price_list = PriceList::with(['childPriceList'])
            //     ->isActive(ACTIVE)->isDelete(NO_DELETE)
            //     ->where('price_list.price_list_tranport_type', PRICE_LIST_TYPE_SERVICE)
            //     ->get()->toArray();
            $cities = collect(config('constans.area'))->pluck('name')->toArray();
            $branchs = Branch::isActive(ACTIVE)->isDelete(NO_DELETE)->get();
            $user = User::with(['position', 'branch'])->isDelete(NO_DELETE)->findOrFail($request_data['user_id']);
            $discounts_user = DiscountUser::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->isUser($request_data['user_id'])
                ->with(['discountUserWeightLevels'])
                ->orderByDesc('discount_users.updated_at')
                ->leftJoin('services', 'services.service_id', 'discount_users.service_id')
                ->select(
                    'discount_users.discount_user_id',
                    'services.service_name',
                    'discount_users.discount_start_date',
                    'discount_users.discount_end_date',
                )
                ->get()->toArray();

            $city = isset($user['user_address_1']) ? $user['user_address_1'] : null;
            $district = isset($user['user_address_2']) ? $user['user_address_2'] : null;
            $cities = collect(config('constans.area'))->pluck('name')->toArray();
            $areas = [
                'cities' => $cities,
                'districts' => [],
                'wards' => [],
            ];
            if (isset($city) || $city !== "") {
                $areas['districts'] = collect(config('constans.area.' . $city . '.districts'))->pluck('name')->toArray();
            }
            if ((isset($city) || $city !== "") && (isset($district) || $district !== "")) {
                $areas['wards'] = collect(config('constans.area.' . $city . '.districts.' . $district . '.wards'))->pluck('name')->toArray();
            }



            // $user_child_price_list = PriceListUser::where('user_id', $user->user_id)
            //     ->where('price_list_id', $user->user_price_list_main_type)
            //     ->select('price_list_id', 'child_price_list_id')
            //     ->get()->toArray();

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'cities' => $cities,
                    'debits' => $debits,
                    // 'price_list' => $price_list,
                    'price_list_types' => $price_list_types,
                    'branchs' => $branchs,
                    'user' => $user,
                    'areas' => $areas,
                    'discounts_user' => $discounts_user,
                ]);
            }
            $html = view(
                'manage.admin.system.fwd-user.edit-fwd-user',
                compact('cities', 'debits', 'branchs', 'user', 'areas', 'discounts_user', 'price_list_types')
            )
                ->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
                'data' => $user
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function onRefreshWallet(Request $request)
    {
        $this->validate($request, ['user_id' => 'required|numeric']);
        try {
            if (!isGetAllData()) {
                return returnResponse(HTTP_BAD_REQUEST, 'Bạn không đủ quyền hạn');
            }
            $request_data = $request->all();
            $user = User::find($request_data['user_id']);

            if (!$user) {
                return returnResponse(HTTP_NOT_FOUND, 'Không tìm thấy tài khoản');
            }
            $wallet = Wallet::where('user_id', $request_data['user_id'])->first();

            DB::beginTransaction();

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => $wallet,
                'new_data' => $request_data
            ];

            onCreateAccountActivityLogs('Quản lý hệ thống', 'Reset ví về 0', $data_logs);
            if (!$wallet) {
                Wallet::created([
                    'user_id' => $user['user_id'],
                    'amount' => 0,
                ]);
            } else {
                $data = [
                    'kind' => MINUS,
                    'user_id' => $request_data['user_id'],
                    'amount' => $wallet['amount'],
                    'content' => 'Quản lý hệ thống: ' . auth()->user()['user_contact_name'] . ' reset ví tiền',
                ];
                $result = actionWallet($data);
                if ($result['status'] != HTTP_OK) {
                    return returnResponse($result['status'], $result['message']);
                }
                // $wallet->update(['amount' => 0]);
            }


            DB::commit();
            return returnResponse(HTTP_OK, 'Đã reset ví về 0', null, 'success');
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function onDeductWallet(Request $request)
    {
        $this->validate($request, ['user_id' => 'required|numeric']);
        try {
            DB::beginTransaction();
            $manager = $request->user();
            if (!isGetAllData()) {
                return returnResponse(HTTP_BAD_REQUEST, 'Bạn không đủ quyền hạn');
            }

            $request_data = $request->all();
            $user = User::find($request_data['user_id']);
            if (!$user) {
                return returnResponse(HTTP_NOT_FOUND, 'Không tìm thấy tài khoản');
            }
            $wallet = Wallet::where('user_id', $request_data['user_id'])->first();

            if (!isset($wallet)) {
                $wallet = Wallet::create([
                    'user_id' => $request_data['user_id'],
                    'amount' => 0
                ]);
            }


            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => $wallet,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Khấu trừ ví tiền', $data_logs);

            $wallet['amount'] -= floatval($request_data['amount']);
            $wallet->save();

            $wf = [
                "wallet_id" => $wallet['wallet_id'],
                "secure_hash" => "WF" . Carbon::now()->format('YmdHisv'),
                "user_id" => $user['user_id'],
                "amount" => $request_data['amount'],
                "wallet_amount" => $wallet['amount'],
                "content" => 'Quản lý ' . $manager['user_contact_name'] . '-' . $manager['user_code'] . ' trừ ví tiền note(' . $request_data['note'] . ')',
                "kind" => MINUS,
            ];
            WalletFluctuation::create($wf);

            DB::commit();
            return returnResponse(HTTP_OK, 'Đã trừ ví', null, 'success');
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function onDeductDebit(Request $request)
    {
        $this->validate($request, ['user_id' => 'required|numeric']);

        try {
            DB::beginTransaction();
            $manager = $request->user();
            if (!isGetAllData()) {
                return returnResponse(HTTP_BAD_REQUEST, 'Bạn không đủ quyền hạn');
            }
            $request_data = $request->all();
            $user = User::find($request_data['user_id']);
            if (!$user) {
                return returnResponse(HTTP_NOT_FOUND, 'Không tìm thấy tài khoản');
            }

            // Trừ công nợ
            $user['user_remaining_limit'] -= floatval($request_data['amount']);
            $user->save();

            $this->saveHistoryDebit(
                'history_debit',
                $user['user_id'],
                $manager['user_id'],
                $request_data['amount'],
                MINUS,
                'Quản lý ' . $manager['user_contact_name'] . '-' . $manager['user_code'] . ' trừ công nợ note(' . (isset($request_data['note']) ? $request_data['note'] : '') . ')'
            );

            DB::commit();
            return returnResponse(HTTP_OK, 'Đã trừ công nợ', null, 'success');
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }
    public function onResetDebit(Request $request)
    {
        $this->validate($request, ['user_id' => 'required|numeric']);
        try {
            DB::beginTransaction();
            if (!isGetAllData()) {
                return returnResponse(HTTP_BAD_REQUEST, 'Bạn không đủ quyền hạn');
            }

            $request_data = $request->all();
            $manager = $request->user();
            $user = User::find($request_data['user_id']);

            if (!$user) {
                return returnResponse(HTTP_NOT_FOUND, 'Không tìm thấy tài khoản');
            }

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => $user,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Reset công nợ', $data_logs);

            // Reset công nợ
            $user['user_remaining_limit'] = 0;
            $user->save();

            $this->saveHistoryDebit(
                'history_debit',
                $user['user_id'],
                $manager['user_id'],
                0,
                MINUS,
                'Quản lý ' . $manager['user_contact_name'] . '-' . $manager['user_code'] . ' reset công nợ note(' . (isset($request_data['note']) ? $request_data['note'] : '') . ')'
            );

            DB::commit();
            return returnResponse(HTTP_OK, 'Reset công nợ thành công', null, 'success');
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    protected function saveHistoryDebit($table = "history_debit", $user_id, $manager_id, $amount, $kind, $content)
    {
        DB::table($table)
            ->insert([
                "user_id" => $user_id,
                "manager_id" => $manager_id,
                "content" => $content,
                "amount" => $amount,
                "kind" => $kind,
                "created_at" => Carbon::now(),
                "updated_at" => Carbon::now(),
            ]);
    }
    public function handleManageAdminSystemFWDUsersEdit(Request $request)
    {
        $request_data = $request->all();
        $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
        $user = User::isDelete(NO_DELETE)->findOrFail($request_data['user_id']);
        $request_validate = [
            'user_name' => 'required|email|min:1|max:255|unique:users,user_name,' . $user['user_id'] . ',user_id',
            'user_contact_name' => 'required|min:1|max:255',
            'user_accountant_key' => 'required|min:1|max:255',
            'user_debit_type' => 'required|numeric|min:0',
            'user_company_name' => 'required|min:1|max:255',
            'user_tax_code' => 'required|min:1|max:255',
            'user_phone' => 'required',
            'branch_id' => 'required|numeric',
            'user_address_1' => 'required|numeric',
            'user_address_2' => 'required|numeric',
            'user_address_3' => 'required|numeric',
            'user_address' => 'required|max:255',
            'user_price_list_main_type' => 'required|numeric',
            'user_limit_amount_for_sale' => 'required|numeric|min:0'
        ];
        if (isset($request_data['password']) && $request_data['password'] !== "") {
            $request_validate['password'] = 'required|min:8|max:255';
        }
        if ($request->file('user_logo')) {
            $request_validate['user_logo'] = 'required|image|mimes:jpeg,png|mimetypes:image/jpeg,image/png';
        }
        // $price_list = PriceList::with([
        //     'childPriceList' => function ($query) {
        //         $query->where('child_price_list.child_price_list_kind', USE_SERVICE);
        //     }
        // ])
        //     ->isActive(ACTIVE)->isDelete(NO_DELETE)
        //     ->get()->toArray();
        // foreach ($price_list as $key => $item) {
        //     $request_validate['child_price_list_' . $key] = 'required';
        // }

        $request->validate($request_validate);

        DB::beginTransaction();
        try {


            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => $user,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật tài khoản FWD', $data_logs);

            $old_user_debit_type = $user->user_debit_type;

            $user->user_name = $request_data['user_name'];
            $user->branch_id = $request_data['branch_id'];
            $user->user_contact_name = $request_data['user_contact_name'];
            $user->user_accountant_key = $request_data['user_accountant_key'];
            $user->user_debit_type = $request_data['user_debit_type'];
            $user->user_company_name = $request_data['user_company_name'];
            $user->user_tax_code = $request_data['user_tax_code'];
            $user->user_phone = $request_data['user_phone'];
            $user->user_address_1 = $request_data['user_address_1'];
            $user->user_address_2 = $request_data['user_address_2'];
            $user->user_address_3 = $request_data['user_address_3'];
            $user->contract_years = $request_data['contract_years'] ?? null;
            $user->user_address = $request_data['user_address'];
            $user->user_latitude = isset($request_data['user_latitude']) ? $request_data['user_latitude'] : '';
            $user->user_longitude = isset($request_data['user_longitude']) ? $request_data['user_longitude'] : '';
            $user->user_price_list_main_type = $request_data['user_price_list_main_type'];
            $user->user_limit_amount_for_sale = $request_data['user_limit_amount_for_sale'];
            if (isset($request_data['password']) && $request_data['password'] !== "") {
                $user->password = $request_data['password'];
                $user->password_show = $request_data['password'];
            }

            // PriceListUser::where('user_id', $user->user_id)->delete();
            // $user_price_list_child = json_decode($request_data['user_price_list_main_type_child'], true);
            // if (empty($user_price_list_child)) {
            //     return returnResponse(HTTP_BAD_REQUEST, 'Hãy chọn bảng giá cho từng chi nhánh', null, 'warning');
            // }
            // foreach ($user_price_list_child as $key => $value) {
            //     PriceListUser::create([
            //         'user_id' => $user->user_id,
            //         'price_list_id' => $request_data['user_price_list_main_type'],
            //         'child_price_list_id' => $value,
            //     ]);
            // }
            // PriceListUser::where('user_id', $user['user_id'])->delete();
            // foreach ($price_list as $key => $item) {
            //     $child_price_list = $request_data['child_price_list_' . $key];
            //     if (isset($child_price_list) && $child_price_list !== "") {
            //         PriceListUser::create([
            //             'user_id' => $user['user_id'],
            //             'price_list_id' => $item['price_list_id'],
            //             'child_price_list_id' => $child_price_list,
            //             'active_flg' => ACTIVE,
            //             'delete_flg' => NO_DELETE,
            //         ]);
            //     }
            // }
            if ($request->file('user_logo')) {
                if (File::exists(public_path($user->user_logo))) {
                    File::delete(public_path($user->user_logo));
                }
                $upload_path = public_path(PUBLIC_PATH_USER_LOGO);
                if (!File::isDirectory($upload_path)) {
                    File::makeDirectory($upload_path, 0777, true, true);
                }
                $file_name = $user['user_code'] . '-' . $request->file('user_logo')->getClientOriginalName();
                $request->file('user_logo')->move($upload_path, $file_name);
                $file_path = PUBLIC_PATH_USER_LOGO . '/' . $file_name;
                $user->user_logo = $file_path;
            }
            $user->save();


            if ($old_user_debit_type != $user->user_debit_type && !in_array($user->user_debit_type, [DEBIT_TYPE_DAY])) {
                Shipment::isShow()->where('accountant_status', 0)
                    ->where('user_id', $user->user_id)->update([
                        'accountant_status' => 1
                    ]);
                Debit::isShow()->where('debit_payment_status', '!=', 1)
                    ->where('customer_id', $user->user_id)
                    ->update();
            }

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Chỉnh sửa tài khoản FWD này thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }
    public function handleManageAdminSystemFWDUsersLock(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $user = User::isDelete(NO_DELETE)->findOrFail($request_data['user_id']);
            $user->active_flg = $request_data['active_flg'] == ACTIVE ? INACTIVE : ACTIVE;
            $user->save();


            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => $request_data['active_flg'],
                'new_data' => $request_data['active_flg'] == ACTIVE ? INACTIVE : ACTIVE
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật trạng thái tài khoản', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Chỉnh sửa trạng thái tài khoản FWD này thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    // Hiển thị danh sách user chờ xét duyệt 
    public function displayListWaitUsers(Request $request)
    {

        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $wait_users = User::where('active_flg', INACTIVE)->where('delete_flg', NO_DELETE)
                ->where('user_pending_approval', PENDING)
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api == true) {
                $html = $wait_users;
            } else {
                if ($request->is('*pagination')) {
                    // URL hiện tại kết thúc bằng "pagination"
                    $html = view('manage.admin.system.wait-user.users-pagination', compact('wait_users'))->render();
                } else {
                    $html = view('manage.admin.system.wait-user.index', compact('wait_users'))->render();
                }
            }

            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
                'mess' => 'Lấy danh sách user chờ xác nhận thành công'
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    // Xóa hoàn toàn user chờ xét duyệt
    public function deleteWaitUser(Request $request)
    {

        try {
            User::find($request->id)->delete();

            return response()->json([
                'status' => HTTP_OK,
                'mess' => 'Lấy danh sách user chờ xác nhận thành công'
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    //Cài đặt bảng giá
    public function displayManageAdminSystemPriceListSettings(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;

            $price_list = PriceList::isFilters($filters)->isActive(ACTIVE)->isDelete(NO_DELETE)->orderByDesc('updated_at')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $price_list,
                ]);
            }
            $html = view('manage.admin.system.price-list.setting.index', compact('price_list'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataPriceListSettings(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;

            $price_list = PriceList::isFilters($filters)->isActive(ACTIVE)->isDelete(NO_DELETE)->orderByDesc('updated_at')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            $html = view('manage.admin.system.price-list.setting.price-list-pagination', compact('price_list'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    // QUẢN LÝ KẾ TOÁN

    private function queryShipments($filters, $type = null, $position_id = null)
    {
        $shipments = Shipment::isShow()->isFiltersInDashboard($filters)
            ->leftJoin('packages', function ($join) {
                return $join->on('shipments.shipment_id', 'packages.shipment_id')
                    ->where('packages.delete_flg', NO_DELETE)
                    ->where('packages.active_flg', ACTIVE);
            })
            ->leftJoin('users', 'shipments.user_id', 'users.user_id')
            ->leftJoin('positions', 'users.position_id', 'positions.position_id')
            ->leftJoin('services', 'shipments.shipment_service_id', 'services.service_id')
            ->leftJoin('branchs', 'shipments.shipment_branch_id', 'branchs.branch_id')
            ->leftJoin('countries', 'shipments.receiver_country_id', 'countries.country_id');

        if (isset($position_id)) {
            $shipments = $shipments->where('users.position_id', $position_id);
        } else if (isset($type)) {
            $position_id = getPositionAccountSetting(SETTING_FWD_ACCOUNT);
            if ($type == 'company') {
                $shipments = $shipments->where('users.position_id', '!=', $position_id);
            } else if ($type == 'fwd') {
                $shipments = $shipments->where('users.position_id', $position_id);
            }
        }
        $shipments = $shipments->select(
            'shipments.*',
            'users.user_contact_name',
            'users.user_code',
            'users.user_limit_amount_for_sale',
            'users.user_remaining_limit',
            'positions.limit_amount_flg',
            'branchs.branch_name',
            'countries.country_name',
            'services.service_name',

        )->groupBy('shipments.shipment_id');
        return $shipments;
    }

    public function displayReportSale(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? json_decode($request_data['filters'], true) : null;

            $position_id = getPositionAccountSetting(SETTING_FWD_ACCOUNT);
            $shipments = $this->queryShipments($filters, null, $position_id);

            $branchs = Branch::isShow()->get();
            $shipment_status = config('constans.constans.shipment_status');

            $paginate = [
                'page' => 1,
                'limit' => 20
            ];
            $shipments = $shipments->isPaginate($paginate);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'shipments' => $shipments,
                ]);
            } else {

                $html = view('manage.admin.system.accountant.index', compact('shipments', 'branchs', 'shipment_status'))->render();
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function displayReportSalePaginate(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? json_decode($request_data['filters'], true) : null;
            $position_id = getPositionAccountSetting(SETTING_SALE_ACCOUNT);
            $shipments = $this->queryShipments($filters, null, $position_id);

            if (isset($request_data['export_excel']) && json_decode($request_data['export_excel'])) {
                $data = $shipments->get()->toArray();
                $viewName = 'manage.admin.system.accountant.export-excel';
                $name_excel = $request_data['name_excel'] ?? 'report-sale.xlsx';
                return Excel::download(new ExportFile($data, $viewName), $name_excel);
            }

            $paginate = [
                'page' => $request_data['page'] ?? 1,
                'limit' => $request_data['limit'] ?? 10
            ];
            $shipments = $shipments->isPaginate($paginate);
            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'shipments' => $shipments,
                ]);
            } else {

                $html = view('manage.admin.system.accountant.shipments-paginate', compact('shipments'))->render();
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    // ------------------------------------- END -------------------------------------

    // Quản lý thu tiền mặt
    public function queryPaymentCash($filters)
    {
        $query = CheckedPaymentCash::where('checked_payment_cashs.delete_flg', NO_DELETE)
            ->leftJoin('users as customer', 'checked_payment_cashs.customer_id', 'customer.user_id')
            ->leftJoin('users as creator', 'checked_payment_cashs.account_id', 'creator.user_id');

        $query = $query->leftJoinSub(
            Debit::isShow()
                ->leftJoin('shipments', 'debits.debit_id', '=', 'shipments.shipment_debit_id')
                ->where('shipments.delete_flg', NO_DELETE)
                ->where('shipments.active_flg', ACTIVE)
                ->select(
                    'debits.debit_no',
                    DB::raw('SUM(shipment_final_amount) as debit_total_price')
                )
                ->groupBy('debits.debit_no'),
            'debit_data',
            function ($join) {
                $join->on('checked_payment_cashs.code', '=', 'debit_data.debit_no');
            }
        )
            ->leftJoinSub(
                Statement::isShow()
                    ->join('statement_items', 'statements.statement_id', '=', 'statement_items.statement_id')
                    ->where('statement_items.delete_flg', NO_DELETE)
                    ->where('statement_items.active_flg', ACTIVE)
                    ->leftJoin('shipments', 'statement_items.debit_id', '=', 'shipments.shipment_debit_id')
                    ->select(
                        'statements.statement_code',
                        DB::raw('SUM(shipment_final_amount) as statement_total_price')
                    )
                    ->groupBy('statements.statement_code'),
                'statement_data',
                function ($join) {
                    $join->on('checked_payment_cashs.code', '=', 'statement_data.statement_code');
                }
            );

        $query = $query->select(
            'customer.user_company_name as customer_company',
            'customer.user_contact_name as customer_name',
            'customer.position_id as customer_position_id',
            'customer.user_code as customer_code',
            'creator.user_contact_name as creator_name',
            'creator.user_code as creator_code',
            'checked_payment_cashs.*',
            DB::raw('
            CASE
                WHEN checked_payment_cashs.kind = 1 THEN COALESCE(debit_data.debit_total_price, 0)
                WHEN checked_payment_cashs.kind = 2 THEN COALESCE(statement_data.statement_total_price, 0)
                ELSE 0
            END as origin_amount
        ')
        );

        if (isset($filters['keywords']) && $filters['keywords'] != '') {
            $query = $query->where(function ($qr) use ($filters) {
                return $qr->where('customer.user_company_name', 'like', '%' . $filters['keywords'] . '%')
                    ->orWhere('customer.user_code', 'like', '%' . $filters['keywords'] . '%')
                    ->orWhere('creator.user_contact_name', 'like', '%' . $filters['keywords'] . '%')
                    ->orWhere('creator.user_code', 'like', '%' . $filters['keywords'] . '%')
                    ->orWhere('checked_payment_cashs.code', 'like', '%' . $filters['keywords'] . '%');
            });
        }
        if (isset($filters['position_id']) && $filters['position_id'] != '') {
            $query = $query->where("customer.position_id", $filters['position_id']);
        }
        if (isset($filters['payment_method']) && $filters['payment_method'] != '') {
            // $query = $query->where("checked_payment_cashs.payment_method", $filters['payment_method']);
            $query = $query->where(function ($qr) use ($filters) {
                if ($filters['payment_method'] == BANK) {
                    $qr->where("checked_payment_cashs.amount_bank", '!=', 0)
                        ->where("checked_payment_cashs.amount_cash", '=', 0);
                } else if ($filters['payment_method'] == CASH) {
                    $qr->where("checked_payment_cashs.amount_cash", '!=', 0)
                        ->where("checked_payment_cashs.amount_bank", '=', 0);
                } else if ($filters['payment_method'] == 2) {
                    $qr->where("checked_payment_cashs.amount_cash", '!=', 0)
                        ->where("checked_payment_cashs.amount_bank", '!=', 0);
                }
            });
        }
        if (
            (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
            && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
        ) {
            $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->format('Y-m-d H:i:s');
            $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->format('Y-m-d H:i:s');
            // $query = $query->whereBetween("checked_payment_cashs.payment_at", [$start_date, $end_date]);
            $query = $query->where(function ($q) use ($start_date, $end_date) {
                $q->whereBetween("checked_payment_cashs.payment_at", [$start_date, $end_date]);
                // Nếu start_date <= 6/11/2024, thêm orWhereNull trong nhóm điều kiện
                $specific_date = Carbon::create(2024, 11, 6)->endOfDay();
                if ($start_date <= $specific_date) {
                    $q->orWhereNull("checked_payment_cashs.payment_at");
                }
            });
        }
        if (isset($filters['checked']) && in_array($filters['checked'], [0, 1])) {
            $query = $query->where("checked_payment_cashs.checked", $filters['checked']);
        }

        if (isset($filters['bill_type']) && in_array($filters['bill_type'], [0, 1, 2])) {
            $query = $query->where("checked_payment_cashs.kind", $filters['bill_type']);
        }

        if (isset($filters['difference_amount']) && $filters['difference_amount'] != '') {
            $query = $query->where("checked_payment_cashs.kind", '!=', 0)
                ->havingRaw('origin_amount != amount');;
        }
        return $query;
    }

    private function getDataChart($filters)
    {
        try {
            $data = $this->queryPaymentCash($filters)
                ->where('checked_payment_cashs.active_flg', ACTIVE)->get()->toArray();
            $position_fwd_id = getPositionAccountSetting(SETTING_FWD_ACCOUNT);

            $fwd_cash = collect($data)->where('customer_position_id', $position_fwd_id)
                ->sum('amount_cash');
            $fwd_bank = collect($data)->where('customer_position_id', $position_fwd_id)
                ->sum('amount_bank');

            $sale_cash = collect($data)->where('customer_position_id', '!=', $position_fwd_id)
                ->sum('amount_cash');
            $sale_bank = collect($data)->where('customer_position_id', '!=', $position_fwd_id)
                ->sum('amount_bank');

            return [
                'fwd_cash' => $fwd_cash,
                'fwd_bank' => $fwd_bank,
                'sale_cash' => $sale_cash,
                'sale_bank' => $sale_bank,
            ];
        } catch (\Throwable $th) {
            return [
                'fwd_cash' => 0,
                'fwd_bank' => 0,
                'sale_cash' => 0,
                'sale_bank' => 0
            ];
        }
    }

    public function displayManagePayCash(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? json_decode($request_data['filters'], true) : null;
            $paycashs = $this->queryPaymentCash($filters);
            $positions = Position::isShow()->select('position_id', 'position_name')->get();

            $paginate = [
                'page' => $request_data['page'] ?? 1,
                'limit' => $request_data['limit'] ?? 20
            ];
            $paycashs = $paycashs->groupBy('id')
                ->orderBy('checked_payment_cashs.active_flg', 'asc')
                ->orderBy('checked_payment_cashs.payment_at', 'desc')
                ->isPaginate($paginate);
            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'paycashs' => $paycashs,
                ]);
            } else {
                $chart = $this->getDataChart($filters);

                $is_check_all = $filters['is_check_all'] ?? false;
                $choosed_paycash = $filters['choosed_paycash'] ?? [];


                $html = view('manage.admin.system.manage-pay-cash.index', compact('paycashs', 'chart', 'is_check_all', 'choosed_paycash', 'positions'))->render();
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html,
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function paginateManagePayCash(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? json_decode($request_data['filters'], true) : null;
            $paycashs = $this->queryPaymentCash($filters);

            $paginate = [
                'page' => $request_data['page'] ?? 1,
                'limit' => $request_data['limit'] ?? 20
            ];

            $paycashs = $paycashs->groupBy('id')
                ->orderBy('checked_payment_cashs.active_flg', 'asc')
                ->orderBy('checked_payment_cashs.payment_at', 'desc');

            if (isset($request_data['export_excel']) && json_decode($request_data['export_excel'])) {
                $data = $paycashs->get()->toArray();
                $viewName = 'manage.admin.system.manage-pay-cash.export-excel';
                $name_excel = $request_data['name_excel'] ?? 'report-sale.xlsx';
                return Excel::download(new ExportFile($data, $viewName), $name_excel);
            }

            $paycashs = $paycashs->isPaginate($paginate);
            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'paycashs' => $paycashs,
                ]);
            } else {
                $chart = $this->getDataChart($filters);

                $is_check_all = $filters['is_check_all'] ?? false;
                $choosed_paycash = $filters['choosed_paycash'] ?? [];

                $html = view('manage.admin.system.manage-pay-cash.paginate', compact('paycashs', 'chart', 'is_check_all', 'choosed_paycash'))->render();
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html,
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function onCheckAllPayCash(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? json_decode($request_data['filters'], true) : null;
            $paycashs = [];
            if (isset($filters['is_check_all']) && $filters['is_check_all']) {
                $paycashs = $this->queryPaymentCash($filters)
                    ->where('checked_payment_cashs.active_flg', ACTIVE)->groupBy('id');
                $paycashs = $paycashs->pluck('id');
            }
            return response()->json([
                'status' => HTTP_OK,
                'choosed_paycash' => $paycashs,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function onConfirmPayCash(Request $request)
    {
        try {
            $request_data = $request->all();
            $choosed_paycash = $request_data['choosed_paycash'] ?? null;
            if (!isset($choosed_paycash)) {
                return returnResponse(HTTP_BAD_REQUEST, 'Vui lòng chọn đơn bạn muốn xác nhận', null, 'warning');
            }
            DB::beginTransaction();
            $checkeds = CheckedPaymentCash::whereIn('id', $choosed_paycash)->get();
            foreach ($checkeds as $key => $value) {
                onConfirmCheckedPaymentByAdmin($value['kind'], $value['code'], 1);
                CheckedPaymentCash::where('id', $value['id'])->update([
                    'checked' => SUCCESS,
                    'checked_by' => auth()->id()
                ]);
            }


            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Quản lý dòng tiền: xác nhận', $data_logs);

            DB::commit();
            return returnResponse(HTTP_OK, 'Xác nhận thành công', null, 'success');
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }


    public function onCheckConfirmOnePayment(Request $request)
    {
        $this->validate($request, [
            'checked_id' => 'required',
            'checked_amount_cash' => 'numeric|required|min:0',
            'checked_amount_bank' => 'numeric|required|min:0',
            'checked_note' => 'max:255',
        ]);
        try {
            $request_data = $request->all();
            $checkpayment = CheckedPaymentCash::isShow()->find($request_data['checked_id']);
            if (!$checkpayment) {
                return returnResponse(HTTP_BAD_REQUEST, 'Vui lòng chọn đơn bạn muốn xác nhận', null, 'warning');
            }

            DB::beginTransaction();
            onConfirmCheckedPaymentByAdmin($checkpayment['kind'], $checkpayment['code'], 1);
            CheckedPaymentCash::find($checkpayment['id'])->update([
                'checked' => SUCCESS,
                'checked_note' => $request_data['checked_note'] ?? '',
                'amount_cash' => $request_data['checked_amount_cash'] ?? 0,
                'amount_bank' => $checkpayment['amount'] - $request_data['checked_amount_cash'] ?? 0,
                'checked_by' => auth()->id()
            ]);

            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Quản lý dòng tiền: xác nhận', $data_logs);

            DB::commit();
            return returnResponse(HTTP_OK, 'Xác nhận thành công', null, 'success');
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    public function onRefundCheckedPaymentStatus(Request $request)
    {
        try {
            $request_data = $request->all();
            $checked_id = $request_data['checked_id'] ?? null;
            if (!isset($checked_id)) {
                return returnResponse(HTTP_BAD_REQUEST, 'Vui lòng chọn đơn bạn muốn hoàn lại', null, 'warning');
            }
            $checked = CheckedPaymentCash::find($checked_id);
            DB::beginTransaction();
            CheckedPaymentCash::find($checked_id)->update([
                'checked' => 0,
                'amount_cash' => $checked['payment_method'] == CASH ? $checked['amount'] : 0,
                'amount_bank' => $checked['payment_method'] == BANK ? $checked['amount'] : 0,
                'checked_note' => null
            ]);
            onConfirmCheckedPaymentByAdmin($checked['kind'], $checked['code'], 0);

            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Quản lý dòng tiền: hoàn lại xác nhận', $data_logs);

            DB::commit();
            return returnResponse(HTTP_OK, 'Hoàn lại đơn thành công', null, 'success');
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    public function onRemoveCheckedPayment(Request $request)
    {
        $this->validate($request, [
            'checked_id' => 'required',
        ]);
        try {
            $request_data = $request->all();
            $checked_id = $request_data['checked_id'] ?? null;
            $checked = CheckedPaymentCash::find($checked_id);
            if (!isset($checked)) {
                return returnResponse(HTTP_BAD_REQUEST, 'Vui lòng chọn đơn bạn muốn hoàn lại', null, 'warning');
            }
            DB::beginTransaction();
            $data_update = [];
            $is_return = false;
            if ($checked['active_flg'] == ACTIVE) {
                $data_update = [
                    'active_flg' => INACTIVE,
                    'checked_note' => $request_data['checked_note'] ?? null,
                    'checked' => 0,
                ];
            } else {
                $data_update = [
                    'active_flg' => INACTIVE,
                    'delete_flg' => DELETED,
                ];
                $is_return = true;
            }
            CheckedPaymentCash::find($checked_id)->update($data_update);
            if ($is_return) {
                $data_logs = [
                    'old_data' => null,
                    'new_data' => $request_data
                ];
                onCreateAccountActivityLogs('Quản lý hệ thống', 'Quản lý dòng tiền: xóa ghi chú', $data_logs);
                DB::commit();
                return returnResponse(HTTP_OK, 'Đã xóa ghi chú', null, 'success');
            }
            $empty_payment_shipment = [
                'checked_payment_status' => 0,
                'shipment_payment_status' => 0,
                'shipment_payment_step' => 0,
                'shipment_payment_date' => null,
                'shipment_file_proof_of_payment' => null,
            ];

            $empty_payment_debit = [
                'checked_payment_status' => 0,
                'debit_status' => 0,
                'debit_images' => null,
                'debit_payment_date' => null,
                'debit_payment_amount' => 0,
                'debit_note' => null,
                'debit_advance_images' => null,
                'debit_advance_note' => null,
            ];

            $image_payment = [];

            switch ($checked['kind']) {
                case 0:
                    $shipment = Shipment::where('shipment_code', $checked['code'])->first();
                    if (!$shipment) {
                        $data_update = [
                            'active_flg' => INACTIVE,
                            'checked_note' => 'Đơn này đã bị xóa'
                        ];
                        CheckedPaymentCash::find($checked_id)->update($data_update);

                        // Lưu lịch sử tài khoản
                        $data_logs = [
                            'old_data' => null,
                            'new_data' => [$request_data, $data_update]
                        ];
                        onCreateAccountActivityLogs('Quản lý hệ thống', 'Quản lý dòng tiền: hoàn đơn', $data_logs);

                        DB::commit();
                        return returnResponse(HTTP_OK, 'Đơn này không còn tồn tại, hiện tại chỉ còn lưu lại lịch sử', null, 'warning');
                    }
                    if ($shipment) {
                        $customer_id = $shipment['user_id'];

                        $shipment->shipment_paid_by = $shipment->shipment_paid_by;
                        $shipment->shipment_payment_status = 0;
                        $shipment->shipment_payment_step = 0;
                        $shipment->checked_payment_status = 0;

                        $image_payment = onConvertStrArrImage($shipment['shipment_file_proof_of_payment'], false);

                        $shipment->shipment_file_proof_of_payment = null;
                        $shipment->save();
                    }
                    break;

                case 1:
                    $debit = Debit::isShow()->where('debit_no', $checked['code'])->first();
                    if (!$debit) {
                        $data_update = [
                            'active_flg' => INACTIVE,
                            'checked_note' => 'Đơn này đã bị xóa'
                        ];
                        CheckedPaymentCash::find($checked_id)->update($data_update);

                        DB::commit();
                        return returnResponse(HTTP_OK, 'Đơn này không còn tồn tại, hiện tại chỉ còn lưu lại lịch sử', null, 'warning');
                    }
                    $customer_id = $debit['customer_id'];

                    $image_payment = onConvertStrArrImage($debit['debit_images'], false);

                    $shipment = Shipment::isShow()
                        ->where('shipment_debit_id', $debit['debit_id'])
                        ->update($empty_payment_shipment);

                    Debit::find($debit['debit_id'])->update($empty_payment_debit);

                    // Lưu lịch sử tài khoản
                    $data_logs = [
                        'old_data' => null,
                        'new_data' => [$request_data, $data_update]
                    ];
                    onCreateAccountActivityLogs('Quản lý hệ thống', 'Quản lý dòng tiền: hoàn đơn', $data_logs);
                    break;
                case 2:
                    $statment = Statement::isShow()->where('statement_code', $checked['code'])->first();
                    if (!$statment) {
                        $data_update = [
                            'active_flg' => INACTIVE,
                            'checked_note' => 'Đơn này đã bị xóa'
                        ];
                        CheckedPaymentCash::find($checked_id)->update($data_update);
                        // Lưu lịch sử tài khoản
                        $data_logs = [
                            'old_data' => null,
                            'new_data' => [$request_data, $data_update]
                        ];
                        onCreateAccountActivityLogs('Quản lý hệ thống', 'Quản lý dòng tiền: hoàn đơn', $data_logs);

                        DB::commit();
                        return returnResponse(HTTP_OK, 'Đơn này không còn tồn tại, hiện tại chỉ còn lưu lại lịch sử', null, 'warning');
                    }
                    $customer_id = $statment['customer_id'];

                    $debit_ids = Statement::isShow()
                        ->leftJoin('statement_items', 'statements.statement_id', 'statement_items.statement_id')
                        ->where('statement_code', $checked['code'])->pluck('debit_id');

                    Debit::isShow()->whereIn('debit_id', $debit_ids)->update($empty_payment_debit);

                    $shipment = Shipment::isShow()
                        ->whereIn('shipment_debit_id', $debit_ids)
                        ->update($empty_payment_shipment);

                    $image_payment = onConvertStrArrImage($statment['statement_images'], false);

                    $statment->checked_payment_status = 0;
                    $statment->statement_status = 0;
                    $statment->shipment_amount_fsc = 0;
                    $statment->statement_amount = 0;
                    $statment->statement_images = null;
                    $statment->statement_note = null;
                    $statment->save();

                    break;

                default:
                    return returnResponse(HTTP_BAD_REQUEST, 'Lỗi phương thức', null, 'warning');
            }
            if (isset($customer_id)) {
                onUpdateUserRemainingLimit($customer_id);
            }

            if (empty($image_payment) && is_array($image_payment)) {
                foreach ($image_payment as $item) {
                    if (!empty($item) && File::exists($item)) {
                        File::delete($item);
                    }
                };
            }

            // Lưu lịch sử tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => [$request_data, $data_update]
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Quản lý dòng tiền: hoàn đơn', $data_logs);

            DB::commit();
            return returnResponse(HTTP_OK, 'Hoàn lại đơn thành công', null, 'success');
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    // ------------------------------ END -------------------------------------

    public function getDataManageAdminSystemPriceListSettingsSubChildPriceListType(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $sub_child_price_list_type = $request_data['sub_child_price_list_type'];
            $service_id = isset($request_data['service_id']) ? $request_data['service_id'] : null;
            $country_id = isset($request_data['country_id']) ? $request_data['country_id'] : null;
            $keywords = isset($request_data['keywords']) ? $request_data['keywords'] : null;
            $weight_range = isset($request_data['weight_range']) ? $request_data['weight_range'] : [];
            $weight_range = is_string($weight_range) ? json_decode($weight_range, true) : $weight_range;

            $countries = [];
            $states = [];
            $cities = [];
            $town = [];
            $sub_child_price_list_area_cities = [];
            $sub_child_price_list_area_town = [];

            $sub_child_price_list_area = !empty($request_data['sub_child_price_list_area']) ? $request_data['sub_child_price_list_area'] : [];
            $sub_child_price_list_area = is_string($sub_child_price_list_area) ? json_decode($sub_child_price_list_area, true) : $sub_child_price_list_area;
            $filteredWeightRange = collect($weight_range)->pluck('sub_child_price_list_area')->flatten()->filter(function ($item) {
                return $item !== null;
            })->toArray();

            $filteredWeightRange = array_diff($filteredWeightRange, $sub_child_price_list_area);

            if ($sub_child_price_list_type == SUB_CHILD_PRICE_LIST_TYPE_COUNTRY) {
                $countries = CountryAndServiceLink::with([
                    'country' => function ($query) {
                        return $query->select('country_id', 'country_name', 'country_code');
                    }
                ])
                    ->isActive(ACTIVE)->isDelete(NO_DELETE)
                    ->isService($service_id)
                    ->whereNotIn('country_id', $filteredWeightRange)
                    ->select('country_and_service_links.country_id', 'country_and_service_links.service_id')
                    ->get()->toArray();
            } else if ($sub_child_price_list_type == SUB_CHILD_PRICE_LIST_TYPE_STATE) {
                $countries = CountryAndServiceLink::with([
                    'country' => function ($query) {
                        return $query->select('country_id', 'country_name', 'country_code');
                    }
                ])
                    ->isActive(ACTIVE)->isDelete(NO_DELETE)
                    ->isService($service_id)
                    ->select('country_and_service_links.country_id', 'country_and_service_links.service_id')
                    ->get()->toArray();

                if ($country_id) {
                    $states = State::isActive(ACTIVE)->isDelete(NO_DELETE)
                        ->where('country_id', $country_id)
                        ->whereNotIn('state_id', $filteredWeightRange)
                        ->select('state_id', 'state_name')
                        ->get()->toArray();
                }
            } else if ($sub_child_price_list_type == SUB_CHILD_PRICE_LIST_TYPE_CITY) {
                $countries = CountryAndServiceLink::with([
                    'country' => function ($query) {
                        return $query->select('country_id', 'country_name', 'country_code');
                    }
                ])
                    ->isActive(ACTIVE)->isDelete(NO_DELETE)
                    ->isService($service_id)
                    ->select('country_and_service_links.country_id', 'country_and_service_links.service_id')
                    ->get()->toArray();
                if (isset($keywords) && isset($country_id)) {
                    $cities = City::isActive(ACTIVE)->isDelete(NO_DELETE)
                        ->where('country_id', $country_id)
                        ->where('city_name', 'like', '%' . $keywords . '%')
                        ->whereNotIn('city_id', $filteredWeightRange)
                        ->select('city_id', 'city_name')
                        ->get()->toArray();
                }
                $sub_child_price_list_area_cities = City::isActive(ACTIVE)->isDelete(NO_DELETE)
                    ->where('country_id', $country_id)
                    ->whereIn('city_id', $sub_child_price_list_area)
                    ->select('city_id', 'city_name')
                    ->get()
                    ->keyBy('city_id')
                    ->toArray();
            } else if ($sub_child_price_list_type == SUB_CHILD_PRICE_LIST_TYPE_POST_CODE) {
                $countries = CountryAndServiceLink::with([
                    'country' => function ($query) {
                        return $query->select('country_id', 'country_name', 'country_code');
                    }
                ])
                    ->isActive(ACTIVE)->isDelete(NO_DELETE)
                    ->isService($service_id)
                    ->select('country_and_service_links.country_id', 'country_and_service_links.service_id')
                    ->get()->toArray();
                if (isset($keywords) && isset($country_id)) {
                    $town = Town::where('country_id', $country_id)
                        ->where('town_postal_code', 'like', '%' . $keywords . '%')
                        ->whereNotIn('town_id', $filteredWeightRange)
                        ->select('town_id', 'town_postal_code', 'town_zone_code')
                        ->get()->toArray();
                }
                $sub_child_price_list_area_town = Town::where('country_id', $country_id)
                    ->whereIn('town_id', $sub_child_price_list_area)
                    ->select('town_id', 'town_postal_code')
                    ->get()
                    ->keyBy('town_id')
                    ->toArray();
            }
       
            return response()->json([
                'status' => HTTP_OK,
                'country_id' => $country_id,
                'countries' => $countries,
                'states' => $states,
                'cities' => $cities,
                'town' => $town,
                'sub_child_price_list_area' => $sub_child_price_list_area,
                'sub_child_price_list_area_cities' => $sub_child_price_list_area_cities,
                'sub_child_price_list_area_town' => $sub_child_price_list_area_town,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function displayManageAdminSystemPriceListSettingsCreate(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $child_price_list_kinds = config('constans.constans.child_price_list_kinds');
            $branchs = Branch::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->select('branch_id', 'branch_name')
                ->get();
            $positions = Position::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->select('position_id', 'position_name')
                ->get();
            $child_price_list_types = config('constans.constans.price_list_types');
            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'child_price_list_kinds' => $child_price_list_kinds,
                ]);
            }
            $html = view('manage.admin.system.price-list.setting.create-price-list', compact('child_price_list_kinds', 'branchs', 'positions', 'child_price_list_types'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleManageAdminSystemPriceListSettingsCreate(Request $request)
    {
        $request_validate = [
            'price_list_title' => 'required|min:1|max:255',
            'active_flg' => 'required|numeric|min:0|max:1',
            'date_range_flg' => 'required|numeric|min:0|max:1',
        ];
        $request->validate($request_validate);
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $request_data['form_price_list'] = is_string($request_data['form_price_list']) ? json_decode($request_data['form_price_list'], true) : $request_data['form_price_list'];
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $price_list = PriceList::create([
                'price_list_title' => $request_data['price_list_title'],
                'price_list_tranport_type' => $request_data['price_list_tranport_type'],
                'date_range_flg' => $request_data['date_range_flg'],
                'price_list_start_date' => isset($request_data['price_list_start_date']) ? Carbon::parse($request_data['price_list_start_date'])->format('Y-m-d') : null,
                'price_list_end_date' => isset($request_data['price_list_end_date']) ? Carbon::parse($request_data['price_list_end_date'])->format('Y-m-d') : null,
                'active_flg' => $request_data['active_flg'],
            ]);

            if (!empty($request_data['form_price_list'])) {
                foreach ($request_data['form_price_list'] as $key_i => $i) {
                    if ($i['child_price_list_title'] == "" || empty($i['item_child_price_list'])) {
                        return response()->json([
                            'status' => HTTP_INTERNAL_SERVER_ERROR,
                            'message' => [
                                'title' => 'Thất bại!',
                                'text' => 'Bạn phải nhập đây đủ thông tin trước khi tạo mới.',
                                'icon' => 'error',
                            ]
                        ]);
                    }
                    $child_price_list = ChildPriceList::create([
                        'price_list_id' => $price_list['price_list_id'],
                        'child_price_list_title' => $i['child_price_list_title'],
                        'branch_id' => $i['branch_id'],
                        'position_id' => $i['position_id'],
                        'user_type' => $i['user_type'],
                        'child_price_list_kind' => $i['child_price_list_kind'],
                    ]);
                    foreach ($i['item_child_price_list'] as $key_j => $j) {
                        $sub_child_price_list = SubChildPriceList::create([
                            'price_list_id' => $price_list['price_list_id'],
                            'child_price_list_id' => $child_price_list['child_price_list_id'],
                            'country_id' => $request_data['price_list_tranport_type'] == PRICE_LIST_TYPE_DELIVERY ? $j['country_id'] : null,
                            'service_id' => $request_data['price_list_tranport_type'] == PRICE_LIST_TYPE_SERVICE ? $j['service_id'] : null,
                            'sub_child_price_list_type' => isset($j['sub_child_price_list_type']) ? $j['sub_child_price_list_type'] : SUB_CHILD_PRICE_LIST_TYPE_OTHER,
                        ]);
                        foreach ($j['weight_range'] as $key_k => $k) {
                            if ($request_data['price_list_tranport_type'] == PRICE_LIST_TYPE_DELIVERY) {
                                $weight_child_price_list = WeightChildPriceList::create([
                                    'price_list_id' => $price_list['price_list_id'],
                                    'child_price_list_id' => $child_price_list['child_price_list_id'],
                                    'sub_child_price_list_id' => $sub_child_price_list['sub_child_price_list_id'],
                                    'child_price_list_from_weight' => $k['child_price_list_from_weight'],
                                    'child_price_list_to_weight' => $k['child_price_list_to_weight'],
                                    'weight_range_flg' => $k['weight_range_flg'],
                                ]);
                                foreach ($k['cities'] as $key_l => $l) {
                                    ItemChildPriceList::create([
                                        'price_list_id' => $price_list['price_list_id'],
                                        'child_price_list_id' => $child_price_list['child_price_list_id'],
                                        'weight_child_price_list_id' => $weight_child_price_list['weight_child_price_list_id'],
                                        'city_id' => $l['city_id'],
                                        'item_child_price_list_amount' => round($l['item_child_price_list_amount']),
                                    ]);
                                }
                            }
                            if ($request_data['price_list_tranport_type'] == PRICE_LIST_TYPE_SERVICE) {
                                if ($k['title'] == "") {
                                    return response()->json([
                                        'status' => HTTP_INTERNAL_SERVER_ERROR,
                                        'message' => [
                                            'title' => 'Thất bại!',
                                            'text' => 'Bạn phải nhập đây đủ thông tin trước khi tạo mới.',
                                            'icon' => 'error',
                                        ]
                                    ]);
                                }
                                $weight_child_price_list = WeightChildPriceList::create([
                                    'price_list_id' => $price_list['price_list_id'],
                                    'child_price_list_id' => $child_price_list['child_price_list_id'],
                                    'sub_child_price_list_id' => $sub_child_price_list['sub_child_price_list_id'],
                                    'weight_child_price_list_title' => $k['title'],
                                ]);
                                $count_sub_child_price_list_area_empty = 0;
                                foreach (collect($j['weight_range'])->pluck('sub_child_price_list_area') as $key_sub_child_price_list_area => $sub_child_price_list_area) {
                                    if (empty($sub_child_price_list_area)) {
                                        $count_sub_child_price_list_area_empty++;
                                    }
                                }
                                $count_sub_child_price_list_area_selected = collect($j['weight_range'])->pluck('sub_child_price_list_area')->flatten()->count();
                                if ($j['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_COUNTRY) {
                                    $count_contries = CountryAndServiceLink::where('service_id', $j['service_id'])->count();
                                    if ($count_sub_child_price_list_area_selected > 0 && $count_sub_child_price_list_area_selected === $count_contries && $count_sub_child_price_list_area_empty > 0) {
                                        return response()->json([
                                            'status' => HTTP_INTERNAL_SERVER_ERROR,
                                            'message' => [
                                                'title' => 'Thất bại!',
                                                'text' => 'Bạn đã chọn đầy đủ khu vực và có tồn tại cột không có khu vực nên không thể thêm bảng giá ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                'icon' => 'error',
                                            ]
                                        ]);
                                    } else if ($count_sub_child_price_list_area_empty > 1) {
                                        return response()->json([
                                            'status' => HTTP_INTERNAL_SERVER_ERROR,
                                            'message' => [
                                                'title' => 'Thất bại!',
                                                'text' => 'Tồn tại hơn 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                'icon' => 'error',
                                            ]
                                        ]);
                                    } else if ($count_sub_child_price_list_area_selected !== $count_contries && $count_sub_child_price_list_area_empty === 0) {
                                        return response()->json([
                                            'status' => HTTP_INTERNAL_SERVER_ERROR,
                                            'message' => [
                                                'title' => 'Thất bại!',
                                                'text' => 'Bạn chưa chọn hết các khu vực nên bắt buộc phải có 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                'icon' => 'error',
                                            ]
                                        ]);
                                    }
                                    foreach ($k['sub_child_price_list_area'] as $country_id) {
                                        WeightChildPriceListArea::create([
                                            'weight_child_price_list_id' => $weight_child_price_list['weight_child_price_list_id'],
                                            'country_id' => $country_id,
                                        ]);
                                    }
                                } else if ($j['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_STATE) {
                                    $state_id = collect($j['weight_range'])->pluck('sub_child_price_list_area')->flatten()->first();
                                    $country_id = isset($state_id) ? State::where('state_id', $state_id)->first()->country_id : null;
                                    $count_states = isset($country_id) ? State::where('country_id', $country_id)->count() : 0;
                                    if ($count_sub_child_price_list_area_selected > 0 && $count_sub_child_price_list_area_selected === $count_states && $count_sub_child_price_list_area_empty > 0) {
                                        return response()->json([
                                            'status' => HTTP_INTERNAL_SERVER_ERROR,
                                            'message' => [
                                                'title' => 'Thất bại!',
                                                'text' => 'Bạn đã chọn đầy đủ khu vực và có tồn tại cột không có khu vực nên không thể thêm bảng giá ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                'icon' => 'error',
                                            ]
                                        ]);
                                    } else if ($count_sub_child_price_list_area_empty > 1) {
                                        return response()->json([
                                            'status' => HTTP_INTERNAL_SERVER_ERROR,
                                            'message' => [
                                                'title' => 'Thất bại!',
                                                'text' => 'Tồn tại hơn 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                'icon' => 'error',
                                            ]
                                        ]);
                                    } else if ($count_sub_child_price_list_area_selected !== $count_states && $count_sub_child_price_list_area_empty === 0) {
                                        return response()->json([
                                            'status' => HTTP_INTERNAL_SERVER_ERROR,
                                            'message' => [
                                                'title' => 'Thất bại!',
                                                'text' => 'Bạn chưa chọn hết các khu vực nên bắt buộc phải có 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                'icon' => 'error',
                                            ]
                                        ]);
                                    }
                                    foreach ($k['sub_child_price_list_area'] as $state_id) {
                                        WeightChildPriceListArea::create([
                                            'weight_child_price_list_id' => $weight_child_price_list['weight_child_price_list_id'],
                                            'state_id' => $state_id,
                                        ]);
                                    }
                                } else if ($j['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_CITY) {
                                    $city_id = collect($j['weight_range'])->pluck('sub_child_price_list_area')->flatten()->first();
                                    $country_id = isset($city_id) ? City::where('city_id', $city_id)->first()->country_id : null;
                                    $count_cities = isset($country_id) ? City::where('country_id', $country_id)->count() : 0;
                                    if ($count_sub_child_price_list_area_selected > 0 && $count_sub_child_price_list_area_selected === $count_cities && $count_sub_child_price_list_area_empty > 0) {
                                        return response()->json([
                                            'status' => HTTP_INTERNAL_SERVER_ERROR,
                                            'message' => [
                                                'title' => 'Thất bại!',
                                                'text' => 'Bạn đã chọn đầy đủ khu vực và có tồn tại cột không có khu vực nên không thể thêm bảng giá ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                'icon' => 'error',
                                            ]
                                        ]);
                                    } else if ($count_sub_child_price_list_area_empty > 1) {
                                        return response()->json([
                                            'status' => HTTP_INTERNAL_SERVER_ERROR,
                                            'message' => [
                                                'title' => 'Thất bại!',
                                                'text' => 'Tồn tại hơn 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                'icon' => 'error',
                                            ]
                                        ]);
                                    } else if ($count_sub_child_price_list_area_selected !== $count_cities && $count_sub_child_price_list_area_empty === 0) {
                                        return response()->json([
                                            'status' => HTTP_INTERNAL_SERVER_ERROR,
                                            'message' => [
                                                'title' => 'Thất bại!',
                                                'text' => 'Bạn chưa chọn hết các khu vực nên bắt buộc phải có 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                'icon' => 'error',
                                            ]
                                        ]);
                                    }
                                    foreach ($k['sub_child_price_list_area'] as $city_id) {
                                        WeightChildPriceListArea::create([
                                            'weight_child_price_list_id' => $weight_child_price_list['weight_child_price_list_id'],
                                            'city_id' => $city_id,
                                        ]);
                                    }
                                } else if ($j['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_POST_CODE) {
                                    $town_id = collect($j['weight_range'])->pluck('sub_child_price_list_area')->flatten()->first();
                                    $country_id = isset($town_id) ? Town::where('town_id', $town_id)->first()->country_id : null;
                                    $count_towns = isset($country_id) ? Town::where('country_id', $country_id)->count() : 0;
                                    if ($count_sub_child_price_list_area_selected > 0 && $count_sub_child_price_list_area_selected === $count_towns && $count_sub_child_price_list_area_empty > 0) {
                                        // return response()->json([
                                        //     'status' => HTTP_INTERNAL_SERVER_ERROR,
                                        //     'message' => [
                                        //         'title' => 'Thất bại!',
                                        //         'text' => 'Bạn đã chọn đầy đủ khu vực và có tồn tại cột không có khu vực nên không thể thêm bảng giá ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                        //         'icon' => 'error',
                                        //     ]
                                        // ]);
                                    } else if ($count_sub_child_price_list_area_empty > 1) {
                                        return response()->json([
                                            'status' => HTTP_INTERNAL_SERVER_ERROR,
                                            'message' => [
                                                'title' => 'Thất bại!',
                                                'text' => 'Tồn tại hơn 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                'icon' => 'error',
                                            ]
                                        ]);
                                    } else if ($count_sub_child_price_list_area_selected !== $count_towns && $count_sub_child_price_list_area_empty === 0) {
                                        return response()->json([
                                            'status' => HTTP_INTERNAL_SERVER_ERROR,
                                            'message' => [
                                                'title' => 'Thất bại!',
                                                'text' => 'Bạn chưa chọn hết các khu vực nên bắt buộc phải có 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                'icon' => 'error',
                                            ]
                                        ]);
                                    }
                                    foreach ($k['sub_child_price_list_area'] as $town_id) {
                                        WeightChildPriceListArea::create([
                                            'weight_child_price_list_id' => $weight_child_price_list['weight_child_price_list_id'],
                                            'town_id' => $town_id,
                                        ]);
                                    }
                                }
                                foreach ($k['data'] as $key_l => $l) {
                                    ItemChildPriceList::create([
                                        'price_list_id' => $price_list['price_list_id'],
                                        'child_price_list_id' => $child_price_list['child_price_list_id'],
                                        'weight_child_price_list_id' => $weight_child_price_list['weight_child_price_list_id'],
                                        'item_child_price_list_from_weight' => $l['child_price_list_from_weight'],
                                        'item_child_price_list_to_weight' => $l['child_price_list_to_weight'],
                                        'item_child_price_list_amount' => round($l['item_child_price_list_amount']),
                                        'item_child_price_list_weight_range_flg' => $l['weight_range_flg'],
                                    ]);
                                }
                            }
                        }
                    }
                }
            } else {
                return response()->json([
                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                    'message' => [
                        'title' => 'Thất bại!',
                        'text' => 'Phải có ít nhất 1 bảng giá.',
                        'icon' => 'error',
                    ]
                ]);
            }

            // Lưu lịch sử tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Quản lý dòng tiền: xác nhận', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Thêm bảng giá thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    public function displayManageAdminSystemPriceListSettingsCreateItemChildPriceList(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $price_list_tranport_type = $request_data['price_list_tranport_type'];

            $data = [];
            if ($price_list_tranport_type == PRICE_LIST_TYPE_DELIVERY) {
                $data['countries'] = Country::isActive(ACTIVE)->isDelete(NO_DELETE);
                if (isset($request_data['country_ids'])) {
                    if (isset($request_data['country_id'])) {
                        $request_data['country_ids'] = array_diff($request_data['country_ids'], [$request_data['country_id']]);
                    }
                    $data['countries'] = $data['countries']->whereNotIn('country_id', $request_data['country_ids']);
                }
                $data['countries'] = $data['countries']->select('country_id', 'country_name', 'country_code')->get()->toArray();
                $data['country_id'] = isset($request_data['country_id']) ? $request_data['country_id'] : null;
            }
            if ($price_list_tranport_type == PRICE_LIST_TYPE_SERVICE) {
                $data['services'] = Service::isActive(ACTIVE)->isDelete(NO_DELETE)->where('promotion_flg', '!=', IS_PROMOTION);
                if (isset($request_data['service_ids'])) {
                    if (isset($request_data['service_id'])) {
                        $request_data['service_ids'] = array_diff($request_data['service_ids'], [$request_data['service_id']]);
                    }
                    $data['services'] = $data['services']->whereNotIn('service_id', $request_data['service_ids']);
                }
                $data['services'] = $data['services']->select('service_id', 'service_name')->get()->toArray();
                $data['service_id'] = isset($request_data['service_id']) ? $request_data['service_id'] : null;
                $data['sub_child_price_list_types'] = config('constans.constans.sub_child_price_list_types');
                $data['sub_child_price_list_type'] = isset($request_data['sub_child_price_list_type']) ? $request_data['sub_child_price_list_type'] : null;
            }
            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK
                ]);
            }
            $html = view('manage.admin.system.price-list.item-child-price-list.create', compact('price_list_tranport_type', 'data'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function displayManageAdminSystemPriceListSettingsEdit(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $child_price_list_kinds = config('constans.constans.child_price_list_kinds');
            $branchs = Branch::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->select('branch_id', 'branch_name')->get()->toArray();
            $positions = Position::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->select('position_id', 'position_name')->get()->toArray();
            $child_price_list_types = config('constans.constans.price_list_types');
            $price_list = PriceList::with([
                'childPriceList' => function ($query) {
                    return $query->with([
                        'itemChildPriceList' => function ($query) {
                            return $query->leftJoin('services', 'services.service_id', 'sub_child_price_list.service_id')
                                ->leftJoin('countries', 'countries.country_id', 'sub_child_price_list.country_id')
                                ->select(
                                    'sub_child_price_list.sub_child_price_list_id',
                                    'sub_child_price_list.sub_child_price_list_type',
                                    'sub_child_price_list.child_price_list_id',
                                    'sub_child_price_list.price_list_id',
                                    'sub_child_price_list.country_id',
                                    'sub_child_price_list.service_id',
                                    'countries.country_name',
                                    'countries.country_code',
                                    'services.service_name',
                                    'services.service_name as title',
                                );
                        }
                    ])
                        ->leftJoin('branchs', 'branchs.branch_id', 'child_price_list.branch_id')
                        ->select(
                            'child_price_list.child_price_list_kind',
                            'child_price_list.child_price_list_title',
                            'child_price_list.child_price_list_id',
                            'child_price_list.price_list_id',
                            'child_price_list.branch_id',
                            'child_price_list.position_id',
                            'child_price_list.user_type',
                        );
                }
            ])
                ->findOrFail($request_data['price_list_id'])
                ->toArray();

            foreach ($price_list['child_price_list'] as $key_i => $i) {
                foreach ($i['item_child_price_list'] as $key_j => $j) {
                    $price_list_tranport_type = $price_list['price_list_tranport_type'];
                    $sub_child_price_list_id = $j['sub_child_price_list_id'];
                    $country_id = $j['country_id'] ?? null;

                    $weights_child_price_list = WeightChildPriceList::where('weights_child_price_list.sub_child_price_list_id', $sub_child_price_list_id)
                        ->isActive(ACTIVE)->isDelete(NO_DELETE)
                        ->with([
                            'itemsSubChildPriceList' => function ($query) {
                                return $query->leftJoin('cities', 'cities.city_id', 'items_child_price_list.city_id')
                                    ->select(
                                        'items_child_price_list.item_child_price_list_id',
                                        'items_child_price_list.weight_child_price_list_id',
                                        'items_child_price_list.item_child_price_list_amount',
                                        'items_child_price_list.item_child_price_list_from_weight as child_price_list_from_weight',
                                        'items_child_price_list.item_child_price_list_to_weight as child_price_list_to_weight',
                                        'items_child_price_list.item_child_price_list_weight_range_flg as weight_range_flg',
                                        'items_child_price_list.city_id',
                                        'cities.city_id',
                                        'cities.city_name',
                                    );
                            },
                            'weightChildPriceListArea' => function ($query) {
                                $query->leftJoin('cities', 'cities.city_id', 'weight_child_price_list_area.city_id')
                                    ->leftJoin('town', 'town.town_id', 'weight_child_price_list_area.town_id')
                                    ->select(
                                        'weight_child_price_list_area.weight_child_price_list_area_id',
                                        'weight_child_price_list_area.weight_child_price_list_id',
                                        'weight_child_price_list_area.country_id',
                                        'weight_child_price_list_area.state_id',
                                        'weight_child_price_list_area.city_id',
                                        'cities.city_name',
                                        'town.town_id',
                                        'town.town_postal_code',
                                    );
                            }
                        ])
                        ->select(
                            'weights_child_price_list.sub_child_price_list_id',
                            'weights_child_price_list.weight_child_price_list_id',
                            'weights_child_price_list.weight_child_price_list_title as title',
                            'weights_child_price_list.child_price_list_from_weight',
                            'weights_child_price_list.child_price_list_to_weight',
                            'weights_child_price_list.weight_range_flg',
                        )
                        ->get()->toArray();

                    $data = [];

                    if ($price_list_tranport_type == PRICE_LIST_TYPE_DELIVERY) {
                        $data['countries'] = Country::isActive(ACTIVE)->isDelete(NO_DELETE)
                            ->select('country_id', 'country_name', 'country_code')
                            ->get()->toArray();
                        $data['country_id'] = $j['country_id'];
                        foreach ($weights_child_price_list as $key => $value) {
                            $weights_child_price_list[$key]['cities'] = $value['items_sub_child_price_list'];
                            unset($weights_child_price_list[$key]['items_sub_child_price_list']);
                        }
                    }
                    if ($price_list_tranport_type == PRICE_LIST_TYPE_SERVICE) {
                        $data['sub_child_price_list_types'] = config('constans.constans.sub_child_price_list_types');
                        $data['sub_child_price_list_type'] = $j['sub_child_price_list_type'];
                        $data['services'] = Service::isActive(ACTIVE)->isDelete(NO_DELETE)
                            ->where('promotion_flg', '!=', IS_PROMOTION)
                            ->select('service_id', 'service_name')
                            ->get()->toArray();
                        $data['service_id'] = $j['service_id'];
                        foreach ($weights_child_price_list as $key => $value) {
                            $weights_child_price_list[$key]['data'] = $value['items_sub_child_price_list'];
                            unset($weights_child_price_list[$key]['items_sub_child_price_list']);
                            if ($data['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_COUNTRY) {
                                $sub_child_price_list_area = collect($value['weight_child_price_list_area'])->keyBy('country_id')->toArray();
                                $weights_child_price_list[$key]['sub_child_price_list_area'] = [];
                                foreach ($sub_child_price_list_area as $key_sub_child_price_list_area => $value_sub_child_price_list_area) {
                                    $weights_child_price_list[$key]['sub_child_price_list_area'][$key_sub_child_price_list_area] = $value_sub_child_price_list_area['country_id'];
                                }
                            } else if ($data['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_STATE) {
                                $sub_child_price_list_area = collect($value['weight_child_price_list_area'])->keyBy('state_id')->toArray();
                                if (!isset($country_id)) {
                                    $state_id = collect($sub_child_price_list_area)->pluck('state_id')->flatten()->first();
                                    $country_id = isset($state_id) ? State::where('state_id', $state_id)->first()->country_id : null;
                                }
                                $weights_child_price_list[$key]['sub_child_price_list_area'] = [];
                                foreach ($sub_child_price_list_area as $key_sub_child_price_list_area => $value_sub_child_price_list_area) {
                                    $weights_child_price_list[$key]['sub_child_price_list_area'][$key_sub_child_price_list_area] = $value_sub_child_price_list_area['state_id'];
                                }
                            } else if ($data['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_CITY) {
                                $sub_child_price_list_area = collect($value['weight_child_price_list_area'])->keyBy('city_id')->toArray();
                                if (!isset($country_id)) {
                                    $city_id = collect($sub_child_price_list_area)->pluck('city_id')->flatten()->first();
                                    $country_id = isset($city_id) ? City::where('city_id', $city_id)->first()->country_id : null;
                                }
                                $weights_child_price_list[$key]['sub_child_price_list_area'] = [];
                                foreach ($sub_child_price_list_area as $key_sub_child_price_list_area => $value_sub_child_price_list_area) {
                                    $weights_child_price_list[$key]['sub_child_price_list_area'][$key_sub_child_price_list_area] = $value_sub_child_price_list_area['city_id'];
                                }
                            } else if ($data['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_POST_CODE) {
                                $sub_child_price_list_area = collect($value['weight_child_price_list_area'])->keyBy('town_id')->toArray();
                                if (!isset($country_id)) {
                                    $town_id = collect($sub_child_price_list_area)->pluck('town_id')->flatten()->first();
                                    $country_id = isset($town_id) ? Town::where('town_id', $town_id)->first()->country_id : null;
                                }
                                $weights_child_price_list[$key]['sub_child_price_list_area'] = [];
                                foreach ($sub_child_price_list_area as $key_sub_child_price_list_area => $value_sub_child_price_list_area) {
                                    $weights_child_price_list[$key]['sub_child_price_list_area'][$key_sub_child_price_list_area] = $value_sub_child_price_list_area['town_id'];
                                }
                            }
                            unset($weights_child_price_list[$key]['weight_child_price_list_area']);
                        }

                        $price_list['child_price_list'][$key_i]['item_child_price_list'][$key_j]['weight_range'] = $weights_child_price_list;
                    }
                }
            }

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK
                ]);
            }
            $html = view('manage.admin.system.price-list.setting.edit-price-list', compact('price_list', 'child_price_list_kinds', 'branchs', 'positions', 'child_price_list_types'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
                'date_range' => [
                    'date_range_flg' => $price_list['date_range_flg'],
                    'price_list_start_date' => $price_list['price_list_start_date'],
                    'price_list_end_date' => $price_list['price_list_end_date'],
                ]
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleManageAdminSystemPriceListSettingsDelete(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $priceList = PriceList::isDelete(NO_DELETE)->findOrFail($request_data['price_list_id']);
            PriceList::find($request_data['price_list_id'])->update([
                'delete_flg' => DELETED
            ]);
            // Lưu lịch sử tài khoản
            $data_logs = [
                'old_data' => null,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa bảng giá ' . $priceList['price_list_title'], $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã xóa bảng giá này thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function handleManageAdminSystemPriceListEdit(Request $request)
    {
        $request_validate = [
            'price_list_title' => 'required|min:1|max:255',
            'active_flg' => 'required|numeric|min:0|max:1',
            'date_range_flg' => 'required|numeric|min:0|max:1',
        ];
        $request->validate($request_validate);
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $request_data['form_price_list'] = is_string($request_data['form_price_list']) ? json_decode($request_data['form_price_list'], true) : $request_data['form_price_list'];
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            PriceList::isDelete(NO_DELETE)->findOrFail($request_data['price_list_id'])->update([
                'price_list_title' => $request_data['price_list_title'],
                'price_list_tranport_type' => $request_data['price_list_tranport_type'],
                'date_range_flg' => $request_data['date_range_flg'],
                'price_list_start_date' => isset($request_data['price_list_start_date']) ? Carbon::parse($request_data['price_list_start_date'])->format('Y-m-d') : null,
                'price_list_end_date' => isset($request_data['price_list_end_date']) ? Carbon::parse($request_data['price_list_end_date'])->format('Y-m-d') : null,
                'active_flg' => $request_data['active_flg'],
            ]);

            if (!empty($request_data['form_price_list'])) {
                $child_price_list_ids = collect($request_data['form_price_list'])
                    ->whereNotNull('child_price_list_id')
                    ->pluck('child_price_list_id')->toArray();
                ChildPriceList::where('price_list_id', $request_data['price_list_id'])
                    ->whereNotIn('child_price_list_id', $child_price_list_ids)->delete();

                foreach ($request_data['form_price_list'] as $key_i => $i) {
                    if ($i['child_price_list_title'] == "" || empty($i['item_child_price_list'])) {
                        return response()->json([
                            'status' => HTTP_INTERNAL_SERVER_ERROR,
                            'message' => [
                                'title' => 'Thất bại!',
                                'text' => 'Bạn phải nhập đây đủ thông tin trước khi tạo mới.',
                                'icon' => 'error',
                            ]
                        ]);
                    }

                    $child_price_list = ChildPriceList::updateOrCreate([
                        'child_price_list_id' => isset($i['child_price_list_id']) && $i['child_price_list_id'] !== "" ? $i['child_price_list_id'] : null,
                    ], [
                        'price_list_id' => $request_data['price_list_id'],
                        'child_price_list_title' => $i['child_price_list_title'],
                        'branch_id' => $i['branch_id'],
                        'position_id' => $i['position_id'],
                        'user_type' => $i['user_type'],
                        'child_price_list_kind' => $i['child_price_list_kind'],
                    ]);

                    $sub_child_price_list_ids = collect($i['item_child_price_list'])
                        ->whereNotNull('sub_child_price_list_id')
                        ->pluck('sub_child_price_list_id')->toArray();
                    SubChildPriceList::where('child_price_list_id', $child_price_list['child_price_list_id'])
                        ->whereNotIn('sub_child_price_list_id', $sub_child_price_list_ids)->delete();
                    foreach ($i['item_child_price_list'] as $key_j => $j) {
                        $j_is_editing = isset($j['is_editing']) ? $j['is_editing'] : false;
                        if (!$j_is_editing) {
                            continue;
                        }
                        if (isset($j)) {
                            $sub_child_price_list = SubChildPriceList::updateOrCreate([
                                'sub_child_price_list_id' => isset($j['sub_child_price_list_id']) && $j['sub_child_price_list_id'] !== "" ? $j['sub_child_price_list_id'] : null,
                            ], [
                                'price_list_id' => $request_data['price_list_id'],
                                'child_price_list_id' => $child_price_list['child_price_list_id'],
                                'country_id' => $request_data['price_list_tranport_type'] == PRICE_LIST_TYPE_DELIVERY ? $j['country_id'] : null,
                                'service_id' => $request_data['price_list_tranport_type'] == PRICE_LIST_TYPE_SERVICE ? $j['service_id'] : null,
                                'sub_child_price_list_type' => isset($j['sub_child_price_list_type']) ? $j['sub_child_price_list_type'] : SUB_CHILD_PRICE_LIST_TYPE_OTHER,
                            ]);
                            if (!empty($j['weight_range'])) {
                                $weight_child_price_list_ids = collect($j['weight_range'])
                                    ->whereNotNull('weight_child_price_list_id')
                                    ->pluck('weight_child_price_list_id')->toArray();
                                WeightChildPriceList::where('sub_child_price_list_id', $sub_child_price_list['sub_child_price_list_id'])
                                    ->whereNotIn('weight_child_price_list_id', $weight_child_price_list_ids)->delete();

                                foreach ($j['weight_range'] as $key_k => $k) {
                                    if ($request_data['price_list_tranport_type'] == PRICE_LIST_TYPE_DELIVERY) {
                                        $weight_child_price_list = WeightChildPriceList::updateOrCreate([
                                            'weight_child_price_list_id' => isset($k['weight_child_price_list_id']) && $k['weight_child_price_list_id'] !== "" ? $k['weight_child_price_list_id'] : null,
                                        ], [
                                            'price_list_id' => $request_data['price_list_id'],
                                            'child_price_list_id' => $child_price_list['child_price_list_id'],
                                            'sub_child_price_list_id' => $sub_child_price_list['sub_child_price_list_id'],
                                            'child_price_list_from_weight' => $k['child_price_list_from_weight'],
                                            'child_price_list_to_weight' => $k['child_price_list_to_weight'],
                                            'weight_range_flg' => $k['weight_range_flg'],
                                        ]);

                                        $item_child_price_list_ids = collect($k['cities'])
                                            ->whereNotNull('item_child_price_list_id')
                                            ->pluck('item_child_price_list_id')->toArray();
                                        ItemChildPriceList::where('weight_child_price_list_id', $weight_child_price_list['weight_child_price_list_id'])
                                            ->whereNotIn('item_child_price_list_id', $item_child_price_list_ids)->delete();

                                        foreach ($k['cities'] as $key_l => $l) {
                                            ItemChildPriceList::updateOrCreate([
                                                'item_child_price_list_id' => isset($l['item_child_price_list_id']) && $l['item_child_price_list_id'] !== "" ? $l['item_child_price_list_id'] : null,
                                            ], [
                                                'price_list_id' => $request_data['price_list_id'],
                                                'child_price_list_id' => $child_price_list['child_price_list_id'],
                                                'weight_child_price_list_id' => $weight_child_price_list['weight_child_price_list_id'],
                                                'city_id' => $l['city_id'],
                                                'item_child_price_list_amount' => round($l['item_child_price_list_amount']),
                                            ]);
                                        }
                                    }
                                    if ($request_data['price_list_tranport_type'] == PRICE_LIST_TYPE_SERVICE) {
                                        if ($k['title'] == "") {
                                            return response()->json([
                                                'status' => HTTP_INTERNAL_SERVER_ERROR,
                                                'message' => [
                                                    'title' => 'Thất bại!',
                                                    'text' => 'Bạn phải nhập đây đủ thông tin trước khi tạo mới.',
                                                    'icon' => 'error',
                                                ]
                                            ]);
                                        }
                                        $weight_child_price_list = WeightChildPriceList::updateOrCreate([
                                            'weight_child_price_list_id' => isset($k['weight_child_price_list_id']) && $k['weight_child_price_list_id'] !== "" ? $k['weight_child_price_list_id'] : null,
                                        ], [
                                            'price_list_id' => $request_data['price_list_id'],
                                            'child_price_list_id' => $child_price_list['child_price_list_id'],
                                            'sub_child_price_list_id' => $sub_child_price_list['sub_child_price_list_id'],
                                            'weight_child_price_list_title' => $k['title'],
                                        ]);

                                        WeightChildPriceListArea::where('weight_child_price_list_id', $weight_child_price_list['weight_child_price_list_id'])->delete();
                                        $count_sub_child_price_list_area_empty = 0;
                                        foreach (collect($j['weight_range'])->pluck('sub_child_price_list_area') as $key_sub_child_price_list_area => $sub_child_price_list_area) {
                                            if (empty($sub_child_price_list_area)) {
                                                $count_sub_child_price_list_area_empty++;
                                            }
                                        }
                                        $count_sub_child_price_list_area_selected = collect($j['weight_range'])->pluck('sub_child_price_list_area')->flatten()->count();
                                        if ($j['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_COUNTRY) {
                                            $count_contries = CountryAndServiceLink::where('service_id', $j['service_id'])->count();
                                            if ($count_sub_child_price_list_area_selected > 0 && $count_sub_child_price_list_area_selected === $count_contries && $count_sub_child_price_list_area_empty > 0) {
                                                return response()->json([
                                                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                                                    'message' => [
                                                        'title' => 'Thất bại!',
                                                        'text' => 'Bạn đã chọn đầy đủ khu vực và có tồn tại cột không có khu vực nên không thể thêm bảng giá ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                        'icon' => 'error',
                                                    ]
                                                ]);
                                            } else if ($count_sub_child_price_list_area_empty > 1) {
                                                return response()->json([
                                                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                                                    'message' => [
                                                        'title' => 'Thất bại!',
                                                        'text' => 'Tồn tại hơn 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                        'icon' => 'error',
                                                    ]
                                                ]);
                                            } else if ($count_sub_child_price_list_area_selected !== $count_contries && $count_sub_child_price_list_area_empty === 0) {
                                                return response()->json([
                                                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                                                    'message' => [
                                                        'title' => 'Thất bại!',
                                                        'text' => 'Bạn chưa chọn hết các khu vực nên bắt buộc phải có 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                        'icon' => 'error',
                                                    ]
                                                ]);
                                            }
                                            foreach ($k['sub_child_price_list_area'] as $country_id) {
                                                WeightChildPriceListArea::create([
                                                    'weight_child_price_list_id' => $weight_child_price_list['weight_child_price_list_id'],
                                                    'country_id' => $country_id,
                                                ]);
                                            }
                                        } else if ($j['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_STATE) {
                                            $state_id = collect($j['weight_range'])->pluck('sub_child_price_list_area')->flatten()->first();
                                            $country_id = isset($state_id) ? State::where('state_id', $state_id)->first()->country_id : null;
                                            $count_states = isset($country_id) ? State::where('country_id', $country_id)->count() : 0;
                                            if ($count_sub_child_price_list_area_selected > 0 && $count_sub_child_price_list_area_selected === $count_states && $count_sub_child_price_list_area_empty > 0) {
                                                return response()->json([
                                                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                                                    'message' => [
                                                        'title' => 'Thất bại!',
                                                        'text' => 'Bạn đã chọn đầy đủ khu vực và có tồn tại cột không có khu vực nên không thể thêm bảng giá ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                        'icon' => 'error',
                                                    ]
                                                ]);
                                            } else if ($count_sub_child_price_list_area_empty > 1) {
                                                return response()->json([
                                                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                                                    'message' => [
                                                        'title' => 'Thất bại!',
                                                        'text' => 'Tồn tại hơn 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                        'icon' => 'error',
                                                    ]
                                                ]);
                                            } else if ($count_sub_child_price_list_area_selected !== $count_states && $count_sub_child_price_list_area_empty === 0) {
                                                return response()->json([
                                                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                                                    'message' => [
                                                        'title' => 'Thất bại!',
                                                        'text' => 'Bạn chưa chọn hết các khu vực nên bắt buộc phải có 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                        'icon' => 'error',
                                                    ]
                                                ]);
                                            }
                                            foreach ($k['sub_child_price_list_area'] as $state_id) {
                                                WeightChildPriceListArea::create([
                                                    'weight_child_price_list_id' => $weight_child_price_list['weight_child_price_list_id'],
                                                    'state_id' => $state_id,
                                                ]);
                                            }
                                        } else if ($j['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_CITY) {
                                            $city_id = collect($j['weight_range'])->pluck('sub_child_price_list_area')->flatten()->first();
                                            $country_id = isset($city_id) ? City::where('city_id', $city_id)->first()->country_id : null;
                                            $count_cities = isset($country_id) ? City::where('country_id', $country_id)->count() : 0;
                                            if ($count_sub_child_price_list_area_selected > 0 && $count_sub_child_price_list_area_selected === $count_cities && $count_sub_child_price_list_area_empty > 0) {
                                                return response()->json([
                                                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                                                    'message' => [
                                                        'title' => 'Thất bại!',
                                                        'text' => 'Bạn đã chọn đầy đủ khu vực và có tồn tại cột không có khu vực nên không thể thêm bảng giá ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                        'icon' => 'error',
                                                    ]
                                                ]);
                                            } else if ($count_sub_child_price_list_area_empty > 1) {
                                                return response()->json([
                                                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                                                    'message' => [
                                                        'title' => 'Thất bại!',
                                                        'text' => 'Tồn tại hơn 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                        'icon' => 'error',
                                                    ]
                                                ]);
                                            } else if ($count_sub_child_price_list_area_selected !== $count_cities && $count_sub_child_price_list_area_empty === 0) {
                                                return response()->json([
                                                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                                                    'message' => [
                                                        'title' => 'Thất bại!',
                                                        'text' => 'Bạn chưa chọn hết các khu vực nên bắt buộc phải có 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                        'icon' => 'error',
                                                    ]
                                                ]);
                                            }
                                            foreach ($k['sub_child_price_list_area'] as $city_id) {
                                                WeightChildPriceListArea::create([
                                                    'weight_child_price_list_id' => $weight_child_price_list['weight_child_price_list_id'],
                                                    'city_id' => $city_id,
                                                ]);
                                            }
                                        } else if ($j['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_POST_CODE) {
                                            $town_id = collect($j['weight_range'])->pluck('sub_child_price_list_area')->flatten()->first();
                                            $country_id = isset($town_id) ? Town::where('town_id', $town_id)->first()->country_id : null;
                                            $count_towns = isset($country_id) ? Town::where('country_id', $country_id)->count() : 0;
                                            if ($count_sub_child_price_list_area_selected > 0 && $count_sub_child_price_list_area_selected === $count_towns && $count_sub_child_price_list_area_empty > 0) {
                                                // return response()->json([
                                                //     'status' => HTTP_INTERNAL_SERVER_ERROR,
                                                //     'message' => [
                                                //         'title' => 'Thất bại!',
                                                //         'text' => 'Bạn đã chọn đầy đủ khu vực và có tồn tại cột không có khu vực nên không thể thêm bảng giá ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                //         'icon' => 'error',
                                                //     ]
                                                // ]);
                                            } else if ($count_sub_child_price_list_area_empty > 1) {
                                                return response()->json([
                                                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                                                    'message' => [
                                                        'title' => 'Thất bại!',
                                                        'text' => 'Tồn tại hơn 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                        'icon' => 'error',
                                                    ]
                                                ]);
                                            } else if ($count_sub_child_price_list_area_selected !== $count_towns && $count_sub_child_price_list_area_empty === 0) {
                                                return response()->json([
                                                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                                                    'message' => [
                                                        'title' => 'Thất bại!',
                                                        'text' => 'Bạn chưa chọn hết các khu vực nên bắt buộc phải có 1 cột không có khu vực ở ' . $i['child_price_list_title'] . '[' . $j['title'] . ']',
                                                        'icon' => 'error',
                                                    ]
                                                ]);
                                            }
                                            foreach ($k['sub_child_price_list_area'] as $town_id) {
                                                WeightChildPriceListArea::create([
                                                    'weight_child_price_list_id' => $weight_child_price_list['weight_child_price_list_id'],
                                                    'town_id' => $town_id,
                                                ]);
                                            }
                                        }

                                        $item_child_price_list_ids = collect($k['data'])
                                            ->whereNotNull('item_child_price_list_id')
                                            ->pluck('item_child_price_list_id')->toArray();
                                        ItemChildPriceList::where('weight_child_price_list_id', $weight_child_price_list['weight_child_price_list_id'])
                                            ->whereNotIn('item_child_price_list_id', $item_child_price_list_ids)->delete();

                                        foreach ($k['data'] as $key_l => $l) {
                                            ItemChildPriceList::updateOrCreate([
                                                'item_child_price_list_id' => isset($l['item_child_price_list_id']) && $l['item_child_price_list_id'] !== "" ? $l['item_child_price_list_id'] : null,
                                            ], [
                                                'price_list_id' => $request_data['price_list_id'],
                                                'child_price_list_id' => $child_price_list['child_price_list_id'],
                                                'weight_child_price_list_id' => $weight_child_price_list['weight_child_price_list_id'],
                                                'item_child_price_list_from_weight' => $l['child_price_list_from_weight'],
                                                'item_child_price_list_to_weight' => $l['child_price_list_to_weight'],
                                                'item_child_price_list_amount' => round($l['item_child_price_list_amount']),
                                                'item_child_price_list_weight_range_flg' => $l['weight_range_flg'],
                                            ]);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                return response()->json([
                    'status' => HTTP_INTERNAL_SERVER_ERROR,
                    'message' => [
                        'title' => 'Thất bại!',
                        'text' => 'Phải có ít nhất 1 bảng giá.',
                        'icon' => 'error',
                    ]
                ]);
            }

            // Cập nhật lại giá tiền dịch vụ đang created bill
            $start_date = isset($request_data['price_list_start_date']) ? Carbon::parse($request_data['price_list_start_date'])->format('Y-m-d') : null;
            $end_date = isset($request_data['price_list_end_date']) ? Carbon::parse($request_data['price_list_end_date'])->format('Y-m-d') : null;
            $user = $request->user();
            $position_ids = [];
            foreach ($request_data['form_price_list'] as $key => $value) {
                array_push($position_ids, $value['position_id']);
            }
            if (!$this->onUpdatePriceShipmentCreated($user, $start_date, $end_date, $position_ids)) {

                // return returnResponse(HTTP_BAD_REQUEST, 'Quá trình cập nhật các đơn shipment thất bại');
            }

            // Lưu lịch sử hd
            $data_logs = [
                'old_data' => [],
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật bảng giá ' . $request_data['price_list_title'], $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã cập nhật thông tin bảng giá thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function onUpdatePriceShipmentCreated($user, $start, $end, $position_ids = null)
    {
        try {
            $shipments = Shipment::isShow();
            if (isset($start) && isset($end)) {
                // $shipments = $shipments->whereBetween('shipments.created_at', [Carbon::parse($start)->format('Y-m-d'), Carbon::parse($end)->addDay()->format('Y-m-d')]);
                $shipments = $shipments->whereBetween('created_at', [Carbon::parse($start)->format('Y-m-d'), Carbon::parse($end)->addDay()->format('Y-m-d')]);
            }
            if (!empty($position_ids)) {
                $shipments = $shipments
                    ->leftJoin('users', 'shipments.user_id', 'users.user_id')
                    ->whereIn('users.position_id', $position_ids);
            }
            $shipments = $shipments->groupBy('shipments.shipment_id')
                ->select('shipments.*')->get();
            foreach ($shipments as $key => $shipment) {
                $result_save_amount = onSaveAmountShipment($shipment['shipment_id']);

                if ($result_save_amount['status'] === HTTP_INTERNAL_SERVER_ERROR) {
                    // return false;
                    continue;
                }

                onUpdateFinalAmountShipment($shipment['shipment_id']);
                onCreateHistoryShipment(
                    $shipment['shipment_id'],
                    $user['user_id'],
                    'Cập nhật bảng giá'
                );
            }
            return true;
        } catch (\Throwable $th) {
            return false;
        }
    }

    public function displayManageAdminSystemPriceListSettingsEditItemChildPriceList(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? filter_var($request_data['is_api'], FILTER_VALIDATE_BOOLEAN) : false;

            $price_list_tranport_type = $request_data['price_list_tranport_type'];
            $sub_child_price_list_id = $request_data['sub_child_price_list']['sub_child_price_list_id'];
            $country_id = isset($request_data['sub_child_price_list']['country_id']) ? $request_data['sub_child_price_list']['country_id'] : null;

            $weights_child_price_list = WeightChildPriceList::where('weights_child_price_list.sub_child_price_list_id', $sub_child_price_list_id)
                ->isActive(ACTIVE)->isDelete(NO_DELETE)
                ->with([
                    'itemsSubChildPriceList' => function ($query) {
                        return $query->leftJoin('cities', 'cities.city_id', 'items_child_price_list.city_id')
                            ->select(
                                'items_child_price_list.item_child_price_list_id',
                                'items_child_price_list.weight_child_price_list_id',
                                'items_child_price_list.item_child_price_list_amount',
                                'items_child_price_list.item_child_price_list_from_weight as child_price_list_from_weight',
                                'items_child_price_list.item_child_price_list_to_weight as child_price_list_to_weight',
                                'items_child_price_list.item_child_price_list_weight_range_flg as weight_range_flg',
                                'items_child_price_list.city_id',
                                'cities.city_id',
                                'cities.city_name',
                            );
                    },
                    'weightChildPriceListArea' => function ($query) {
                        $query->leftJoin('cities', 'cities.city_id', 'weight_child_price_list_area.city_id')
                            ->leftJoin('town', 'town.town_id', 'weight_child_price_list_area.town_id')
                            ->select(
                                'weight_child_price_list_area.weight_child_price_list_area_id',
                                'weight_child_price_list_area.weight_child_price_list_id',
                                'weight_child_price_list_area.country_id',
                                'weight_child_price_list_area.state_id',
                                'weight_child_price_list_area.city_id',
                                'cities.city_name',
                                'town.town_id',
                                'town.town_postal_code',
                            );
                    }
                ])
                ->select(
                    'weights_child_price_list.sub_child_price_list_id',
                    'weights_child_price_list.weight_child_price_list_id',
                    'weights_child_price_list.weight_child_price_list_title as title',
                    'weights_child_price_list.child_price_list_from_weight',
                    'weights_child_price_list.child_price_list_to_weight',
                    'weights_child_price_list.weight_range_flg',
                )
                ->get()->toArray();

            $data = [];

            if ($price_list_tranport_type == PRICE_LIST_TYPE_DELIVERY) {
                $data['countries'] = Country::isActive(ACTIVE)->isDelete(NO_DELETE)
                    ->select('country_id', 'country_name', 'country_code')
                    ->get()->toArray();
                $data['country_id'] = $request_data['sub_child_price_list']['country_id'];
                foreach ($weights_child_price_list as $key => $value) {
                    $weights_child_price_list[$key]['cities'] = $value['items_sub_child_price_list'];
                    unset($weights_child_price_list[$key]['items_sub_child_price_list']);
                }
            }
            if ($price_list_tranport_type == PRICE_LIST_TYPE_SERVICE) {
                $data['sub_child_price_list_types'] = config('constans.constans.sub_child_price_list_types');
                $data['sub_child_price_list_type'] = isset($request_data['sub_child_price_list']['sub_child_price_list_type']) ? $request_data['sub_child_price_list']['sub_child_price_list_type'] : null;
                $data['services'] = Service::isActive(ACTIVE)->isDelete(NO_DELETE)
                    ->where('promotion_flg', '!=', IS_PROMOTION)
                    ->select('service_id', 'service_name')
                    ->get()->toArray();
                $data['service_id'] = $request_data['sub_child_price_list']['service_id'];
                foreach ($weights_child_price_list as $key => $value) {
                    $weights_child_price_list[$key]['data'] = $value['items_sub_child_price_list'];
                    unset($weights_child_price_list[$key]['items_sub_child_price_list']);
                    if ($data['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_COUNTRY) {
                        $sub_child_price_list_area = collect($value['weight_child_price_list_area'])->keyBy('country_id')->toArray();
                        $weights_child_price_list[$key]['sub_child_price_list_area'] = [];
                        foreach ($sub_child_price_list_area as $key_sub_child_price_list_area => $value_sub_child_price_list_area) {
                            $weights_child_price_list[$key]['sub_child_price_list_area'][$key_sub_child_price_list_area] = $value_sub_child_price_list_area['country_id'];
                        }
                    } else if ($data['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_STATE) {
                        $sub_child_price_list_area = collect($value['weight_child_price_list_area'])->keyBy('state_id')->toArray();
                        if (!isset($country_id)) {
                            $state_id = collect($sub_child_price_list_area)->pluck('state_id')->flatten()->first();
                            $country_id = isset($state_id) ? State::where('state_id', $state_id)->first()->country_id : null;
                        }
                        $weights_child_price_list[$key]['sub_child_price_list_area'] = [];
                        foreach ($sub_child_price_list_area as $key_sub_child_price_list_area => $value_sub_child_price_list_area) {
                            $weights_child_price_list[$key]['sub_child_price_list_area'][$key_sub_child_price_list_area] = $value_sub_child_price_list_area['state_id'];
                        }
                    } else if ($data['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_CITY) {
                        $sub_child_price_list_area = collect($value['weight_child_price_list_area'])->keyBy('city_id')->toArray();
                        if (!isset($country_id)) {
                            $city_id = collect($sub_child_price_list_area)->pluck('city_id')->flatten()->first();
                            $country_id = isset($city_id) ? City::where('city_id', $city_id)->first()->country_id : null;
                        }
                        $weights_child_price_list[$key]['sub_child_price_list_area'] = [];
                        foreach ($sub_child_price_list_area as $key_sub_child_price_list_area => $value_sub_child_price_list_area) {
                            $weights_child_price_list[$key]['sub_child_price_list_area'][$key_sub_child_price_list_area] = $value_sub_child_price_list_area['city_id'];
                        }
                    } else if ($data['sub_child_price_list_type'] == SUB_CHILD_PRICE_LIST_TYPE_POST_CODE) {
                        $sub_child_price_list_area = collect($value['weight_child_price_list_area'])->keyBy('town_id')->toArray();
                        if (!isset($country_id)) {
                            $town_id = collect($sub_child_price_list_area)->pluck('town_id')->flatten()->first();
                            $country_id = isset($town_id) ? Town::where('town_id', $town_id)->first()->country_id : null;
                        }
                        $weights_child_price_list[$key]['sub_child_price_list_area'] = [];
                        foreach ($sub_child_price_list_area as $key_sub_child_price_list_area => $value_sub_child_price_list_area) {
                            $weights_child_price_list[$key]['sub_child_price_list_area'][$key_sub_child_price_list_area] = $value_sub_child_price_list_area['town_id'];
                        }
                    }
                    unset($weights_child_price_list[$key]['weight_child_price_list_area']);
                }
            }
            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK
                ]);
            }

            $html = view('manage.admin.system.price-list.item-child-price-list.edit', compact('price_list_tranport_type', 'data'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
                'weight_range' => $weights_child_price_list,
                'price_list_tranport_type' => $price_list_tranport_type,
                'country_id' => $country_id,
                'is_not_empty_cities' => true,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    //Chỉnh sửa Điều Khoản
    public function displayManageAdminSystemTermsInterface(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $path = 'public/config/terms-interface.json';
            $content = Storage::get($path);
            $content = isset($content) ? $content : "";

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK
                ]);
            }

            $html = view('manage.admin.system.terms-interface.index', compact('content'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleManageAdminSystemTermsInterface(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $content_terms_interface = isset($request_data['content']) ? $request_data['content'] : "";

            $path = 'public/config/terms-interface.json';
            if (Storage::exists($path)) {
                Storage::put($path, $content_terms_interface);
            } else {
                Storage::disk('local')->put($path, $content_terms_interface);
            }

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => [],
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật điều khoản dịch vụ ', $data_logs);

            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã cập nhật điều khoản dịch vụ thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    // Chỉnh sửa thông tin debit 
    public function displayManageAdminSystemInfoDebit(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $path = 'public/config/info-debit.json';
            $info_debit = Storage::get($path);
            $info_debit = json_decode($info_debit, true);
            $content = $info_debit['display'] ?? "";
            $excels = $info_debit['excels'] ?? [
                'header' => ["", "", "", "", ""],
                'footer' => [
                    'note' => [],
                    'hn' => [],
                    'hcm' => [],
                    'dn' => [],
                ],
            ];

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK
                ]);
            }

            $html = view('manage.admin.system.info-debit.index', compact('content', 'excels'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleManageAdminSystemInfoDebit(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $path = 'public/config/info-debit.json';
            // $content = Storage::get($path);

            $display = $request_data['content'] ?? "";
            $excels = $request_data['excels'] ?? [];


            $content = [
                'display' => $display,
                'excels' => [
                    'header' => $excels['header'] ?? ["", "", "", "", ""],
                    'footer' => [
                        'note' => $excels['footer']['note'] ?? [],
                        'hn' => $excels['footer']['hn'] ?? [],
                        'hcm' => $excels['footer']['hcm'] ?? [],
                        'dn' => $excels['footer']['dn'] ?? [],
                    ],
                ],
            ];

            $contentString = json_encode($content);

            if (Storage::exists($path)) {
                Storage::put($path, $contentString);
            } else {
                Storage::disk('local')->put($path, $contentString);
            }

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => [],
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật thông tin xuất debit ', $data_logs);

            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã cập nhật thông tin debit thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    //Chi phí vận hành công ty
    public function displayManageAdminSystemOperatingCost(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $operating_costs = OperatingCost::with([
                'childOperatingCost' => function ($query) {
                    return $query->isActive(ACTIVE)->isDelete(NO_DELETE)
                        ->select('operating_cost_id', 'parent_operating_cost_id', 'operating_cost_name', 'operating_cost_description', 'operating_cost_amount', 'operating_cost_default_flg');
                }
            ])
                ->whereNull('parent_operating_cost_id')
                ->isActive(ACTIVE)->isDelete(NO_DELETE)
                ->select('operating_cost_id', 'parent_operating_cost_id', 'operating_cost_name', 'operating_cost_description', 'operating_cost_type', 'operating_cost_package_number_flg')
                ->get()->toArray();

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK
                ]);
            }

            $html = view('manage.admin.system.operating-cost.index', compact('operating_costs'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleManageAdminSystemOperatingCost(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $operating_costs = collect($request_data['operating_costs']);

            foreach ($operating_costs as $key => $operating_cost) {
                if (!isset($operating_cost['operating_cost_name']) || $operating_cost['operating_cost_name'] == "") {
                    return response()->json([
                        'status' => HTTP_INTERNAL_SERVER_ERROR,
                        'message' => [
                            'title' => 'Thất bại!',
                            'text' => 'Bạn phải nhập đầy đủ thông tin trước khi tạo mới.',
                            'icon' => 'warning',
                        ]
                    ]);
                }

                $parent_operating_cost = OperatingCost::updateOrCreate([
                    'operating_cost_id' => isset($operating_cost['operating_cost_id']) ? $operating_cost['operating_cost_id'] : null,
                ], [
                    'operating_cost_name' => $operating_cost['operating_cost_name'],
                    'operating_cost_description' => $operating_cost['operating_cost_description'],
                    'operating_cost_type' => $operating_cost['operating_cost_type'],
                    'operating_cost_package_number_flg' => $operating_cost['operating_cost_package_number_flg'],
                ]);

                // Lấy tất cả id của các bản ghi con
                $child_operating_costs_ids = OperatingCost::where('parent_operating_cost_id', $operating_cost['operating_cost_id'])
                    ->isActive(ACTIVE)->isDelete(NO_DELETE)
                    ->pluck('operating_cost_id')->toArray();

                $operating_cost['child_operating_cost'] = !empty($operating_cost['child_operating_cost']) ? $operating_cost['child_operating_cost'] : [];
                // Lấy tất cả id của các bản ghi con trong request
                $child_operating_cost_ids_request = collect($operating_cost['child_operating_cost'])->pluck('operating_cost_id')->toArray();

                // Lấy ra các id cần xóa
                $child_operating_costs_ids_delete = array_diff($child_operating_costs_ids, $child_operating_cost_ids_request);

                OperatingCost::where('parent_operating_cost_id', $parent_operating_cost['operating_cost_id'])
                    ->whereIn('operating_cost_id', $child_operating_costs_ids_delete)
                    ->update(['delete_flg' => DELETED]);

                foreach ($operating_cost['child_operating_cost'] as $child_operating_cost) {
                    OperatingCost::updateOrCreate([
                        'operating_cost_id' => isset($child_operating_cost['operating_cost_id']) ? $child_operating_cost['operating_cost_id'] : null,
                    ], [
                        'parent_operating_cost_id' => $parent_operating_cost->operating_cost_id,
                        'operating_cost_name' => $child_operating_cost['operating_cost_name'],
                        'operating_cost_amount' => $child_operating_cost['operating_cost_amount'],
                        'operating_cost_default_flg' => $child_operating_cost['operating_cost_default_flg'],
                    ]);
                }
            }

            $operating_costs = OperatingCost::with([
                'childOperatingCost' => function ($query) {
                    return $query->isActive(ACTIVE)->isDelete(NO_DELETE)
                        ->select('operating_cost_id', 'parent_operating_cost_id', 'operating_cost_name', 'operating_cost_description', 'operating_cost_amount', 'operating_cost_default_flg');
                }
            ])
                ->whereNull('parent_operating_cost_id')
                ->isActive(ACTIVE)->isDelete(NO_DELETE)
                ->select('operating_cost_id', 'parent_operating_cost_id', 'operating_cost_name', 'operating_cost_description', 'operating_cost_type', 'operating_cost_package_number_flg')
                ->get()->toArray();


            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => [],
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật chi phí vận hành công ty ', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'operating_costs' => $operating_costs,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã cập nhật chi phí vận hành công ty thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function displayManageAdminSystemPriceListSettingsImportExcelChildPriceList(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $results = [];
            switch ($request_data['item_price_list_type']) {
                case 0:
                    $results = $this->importExcelPriceListNormal(NO_PROMOTION, SUB_CHILD_PRICE_LIST_TYPE_OTHER, $request_data['data']);
                    break;
                case 1:
                    $results = $this->importExcelPriceListCountry(NO_PROMOTION, SUB_CHILD_PRICE_LIST_TYPE_COUNTRY, $request_data['data']);
                    break;
                case 2:
                    $results = $this->importExcelPriceListState(NO_PROMOTION, SUB_CHILD_PRICE_LIST_TYPE_STATE, $request_data['data']);
                    break;
                case 3:
                    $results = $this->importExcelPriceListCity(NO_PROMOTION, SUB_CHILD_PRICE_LIST_TYPE_CITY, $request_data['data']);
                    break;
                case 4:
                    $results = $this->importExcelPriceListNormal(IS_EPACKET, SUB_CHILD_PRICE_LIST_TYPE_OTHER, $request_data['data']);
                    break;
                case 5:
                    $results = $this->importExcelPriceListCountry(IS_EPACKET, SUB_CHILD_PRICE_LIST_TYPE_COUNTRY, $request_data['data']);
                    break;
                case 6:
                    $results = $this->importExcelPriceListState(IS_EPACKET, SUB_CHILD_PRICE_LIST_TYPE_STATE, $request_data['data']);
                    break;
                case 7:
                    $results = $this->importExcelPriceListCity(IS_EPACKET, SUB_CHILD_PRICE_LIST_TYPE_CITY, $request_data['data']);
                    break;
                case 8:
                    $results = $this->importExcelPriceListPostCode(NO_PROMOTION, SUB_CHILD_PRICE_LIST_TYPE_POST_CODE, $request_data['data']);
                    break;
                case 9:
                    $results = $this->importExcelPriceListPostCode(IS_EPACKET, SUB_CHILD_PRICE_LIST_TYPE_POST_CODE, $request_data['data']);
                    break;
            }

            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã import excel bảng giá thành công.',
                    'icon' => 'success',
                ],
                'results' => $results,
            ], HTTP_OK);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    private function importExcelPriceListNormal($promotion_flg, $price_list_type, $data)
    {
        $count_row = isset($data) ? count($data) : 0;
        $count_column = isset($data[0]) ? count($data[0]) : 0;
        $results = [];
        for ($i = 1; $i < $count_column; $i++) {
            $service = Service::where('service_name', $data[0][$i])
                ->where('promotion_flg', $promotion_flg)
                ->where('delete_flg', NO_DELETE)
                ->first();

            if (isset($service)) {
                $weight_range = [
                    [
                        'title' => 'Giá',
                        'sub_child_price_list_area' => [],
                        'data' => [],
                    ]
                ];

                for ($j = 1; $j < $count_row; $j++) {
                    $weight = str_replace(" ", "", $data[$j][0]);
                    $price = isset($data[$j][$i]) ? $data[$j][$i] : 0;
                    $price = floatval(str_replace(" ", "", $price));
                    $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_NUMBER;
                    $child_price_list_from_weight = $weight;
                    $child_price_list_to_weight = $weight;
                    if (strpos($weight, '-') !== false) {
                        $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_NUMBER_TO_NUMBER;
                        $weight = explode('-', $weight);
                        $child_price_list_from_weight = $weight[0];
                        $child_price_list_to_weight = $weight[1];
                    } else if (strpos($weight, '>') !== false) {
                        $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER;
                        $weight = explode('>', $weight);
                        $child_price_list_from_weight = 0;
                        $child_price_list_to_weight = $weight[1];
                    } else if (strpos($weight, '>=') !== false) {
                        $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER;
                        $weight = explode('>=', $weight);
                        $child_price_list_from_weight = 0;
                        $child_price_list_to_weight = $weight[1];
                    }
                    array_push($weight_range[0]['data'], [
                        'child_price_list_from_weight' => $child_price_list_from_weight,
                        'child_price_list_to_weight' => $child_price_list_to_weight,
                        'item_child_price_list_amount' => round($price),
                        'weight_range_flg' => $weight_range_flg,
                    ]);
                }

                array_push($results, [
                    'title' => $service['service_name'],
                    'sub_child_price_list_type' => $price_list_type,
                    'service_id' => $service['service_id'],
                    'is_editing' => true,
                    'weight_range' => $weight_range
                ]);
            }
        }
        return $results;
    }

    private function importExcelPriceListCountry($promotion_flg, $price_list_type, $data)
    {
        $data_headings = [];
        $results = [];

        //Nhóm các cột theo tên dịch vụ
        foreach ($data[0] as $key => $value) {
            if ($key > 0) {
                $value = explode('[', $value);
                $data_headings[$key] = $value[0] ?? '';
            }
        }
        $data_headings = array_values(array_unique($data_headings));

        $count_row = isset($data) ? count($data) : 0;
        $count_column = isset($data_headings) ? count($data_headings) : 0;

        for ($i = 0; $i < $count_column; $i++) {
            $service_name = $data_headings[$i];
            unset($data[0][0]);

            $service = Service::where('service_name', $service_name)
                ->where('promotion_flg', $promotion_flg)
                ->where('delete_flg', NO_DELETE)
                ->first();

            $name_services = collect($data[0])->filter(function ($value) use ($service_name) {
                return explode('[', $value)[0] == $service_name;
            })->toArray();

            if (isset($service)) {
                $price_list_zone = PriceListZone::with([
                    'subPriceListZone' => function ($query) {
                        return $query->select('price_list_zone_id', 'sub_price_list_zone_id', 'sub_price_list_zone_title');
                    },
                    'subPriceListZone.listAreaOfZone' => function ($query) {
                        return $query->select('sub_price_list_zone_id', 'list_area_of_zone_id', 'country_id');
                    },
                    'subPriceListZone.listAreaOfZone.country' => function ($query) {
                        return $query->select('country_id', 'country_name');
                    },
                ])
                    ->where('service_id', $service['service_id'])
                    ->select('price_list_zone_id', 'service_id', 'country_id')
                    ->first();
            }

            if (isset($service) && isset($price_list_zone)) {
                $service = $service->toArray();
                $price_list_zone = $price_list_zone->toArray();
                $weight_range = [];

                foreach ($price_list_zone['sub_price_list_zone'] as $key_column => $column) {
                    if($column['sub_price_list_zone_title'] == "Zone28"){
                        // dd($column);
                    }
                    $count_name_services = array_key_first($name_services);

                    $country_ids = collect($column['list_area_of_zone'])->pluck('country_id')->toArray();
                    $country_ids_old = collect($weight_range)->pluck('sub_child_price_list_area')->flatten()->toArray();
                    $country_ids = array_values(collect($country_ids)->filter(function ($value) use ($country_ids_old) {
                        return !in_array($value, $country_ids_old);
                    })->toArray());

                    $weight_range[$key_column] = [
                        'title' => $column['sub_price_list_zone_title'],
                        'sub_child_price_list_area' => $country_ids,
                        'data' => [],
                    ];

                    for ($j = 1; $j < $count_row; $j++) {
                        $weight = str_replace(" ", "", $data[$j][0]);
                        $price = isset($data[$j][$count_name_services]) ? $data[$j][$count_name_services] : 0;
                        $price = floatval(str_replace(" ", "", $price));
                        $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_NUMBER;
                        $child_price_list_from_weight = $weight;
                        $child_price_list_to_weight = $weight;

                        if (strpos($weight, '-') !== false) {
                            $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_NUMBER_TO_NUMBER;
                            $weight = explode('-', $weight);
                            $child_price_list_from_weight = $weight[0];
                            $child_price_list_to_weight = $weight[1];
                        } else if (strpos($weight, '>') !== false) {
                            $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER;
                            $weight = explode('>', $weight);
                            $child_price_list_from_weight = 0;
                            $child_price_list_to_weight = $weight[1];
                        } else if (strpos($weight, '>=') !== false) {
                            $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER;
                            $weight = explode('>=', $weight);
                            $child_price_list_from_weight = 0;
                            $child_price_list_to_weight = $weight[1];
                        }

                        array_push($weight_range[$key_column]['data'], [
                            'child_price_list_from_weight' => $child_price_list_from_weight,
                            'child_price_list_to_weight' => $child_price_list_to_weight,
                            'item_child_price_list_amount' => round($price),
                            'weight_range_flg' => $weight_range_flg,
                        ]);
                    }
                    if (isset($name_services[$count_name_services])) {
                        unset($name_services[$count_name_services]);
                    }
                }

                array_push($results, [
                    'title' => $service['service_name'],
                    'sub_child_price_list_type' => $price_list_type,
                    'service_id' => $service['service_id'],
                    'is_editing' => true,
                    'weight_range' => $weight_range
                ]);
            }
        }
        return $results;
    }

    private function importExcelPriceListState($promotion_flg, $price_list_type, $data)
    {
        $data_headings = [];
        $results = [];

        //Nhóm các cột theo tên dịch vụ
        foreach ($data[0] as $key => $value) {
            if ($key > 0) {
                $value = explode('[', $value);
                $data_headings[$key] = $value[0] ?? '';
            }
        }
        $data_headings = array_values(array_unique($data_headings));

        $count_row = isset($data) ? count($data) : 0;
        $count_column = isset($data_headings) ? count($data_headings) : 0;

        for ($i = 0; $i < $count_column; $i++) {
            $service_name = $data_headings[$i];
            unset($data[0][0]);

            $service = Service::where('service_name', $service_name)
                ->where('promotion_flg', $promotion_flg)
                ->where('delete_flg', NO_DELETE)
                ->first();

            $name_services = collect($data[0])->filter(function ($value) use ($service_name) {
                return explode('[', $value)[0] == $service_name;
            })->toArray();

            if (isset($service)) {
                $price_list_zone = PriceListZone::with([
                    'subPriceListZone' => function ($query) {
                        return $query->select('price_list_zone_id', 'sub_price_list_zone_id', 'sub_price_list_zone_title');
                    },
                    'subPriceListZone.listAreaOfZone' => function ($query) {
                        return $query->select('sub_price_list_zone_id', 'list_area_of_zone_id', 'state_id');
                    },
                    'subPriceListZone.listAreaOfZone.state' => function ($query) {
                        return $query->select('state_id', 'state_name');
                    },
                ])
                    ->where('service_id', $service['service_id'])
                    ->select('price_list_zone_id', 'service_id', 'country_id')
                    ->first();

                $country = CountryAndServiceLink::isActive(ACTIVE)->isDelete(NO_DELETE)
                    ->isService($service['service_id'])
                    ->where('country_id', $price_list_zone['country_id'])
                    ->select('country_id')
                    ->first();
            }

            if (isset($service) && isset($price_list_zone) && isset($country)) {
                $service = $service->toArray();
                $price_list_zone = $price_list_zone->toArray();
                $country_id = $country['country_id'];
                $weight_range = [];

                foreach ($price_list_zone['sub_price_list_zone'] as $key_column => $column) {
                    $count_name_services = array_key_first($name_services);

                    $state_ids = collect($column['list_area_of_zone'])->pluck('state_id')->toArray();
                    $state_ids_old = collect($weight_range)->pluck('sub_child_price_list_area')->flatten()->toArray();
                    $state_ids = array_values(collect($state_ids)->filter(function ($value) use ($state_ids_old) {
                        return !in_array($value, $state_ids_old);
                    })->toArray());

                    $weight_range[$key_column] = [
                        'title' => $column['sub_price_list_zone_title'],
                        'sub_child_price_list_area' => $state_ids,
                        'data' => [],
                    ];

                    for ($j = 1; $j < $count_row; $j++) {
                        $weight = str_replace(" ", "", $data[$j][0]);
                        $price = isset($data[$j][$count_name_services]) ? $data[$j][$count_name_services] : 0;
                        $price = floatval(str_replace(" ", "", $price));
                        $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_NUMBER;
                        $child_price_list_from_weight = $weight;
                        $child_price_list_to_weight = $weight;

                        if (strpos($weight, '-') !== false) {
                            $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_NUMBER_TO_NUMBER;
                            $weight = explode('-', $weight);
                            $child_price_list_from_weight = $weight[0];
                            $child_price_list_to_weight = $weight[1];
                        } else if (strpos($weight, '>') !== false) {
                            $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER;
                            $weight = explode('>', $weight);
                            $child_price_list_from_weight = 0;
                            $child_price_list_to_weight = $weight[1];
                        } else if (strpos($weight, '>=') !== false) {
                            $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER;
                            $weight = explode('>=', $weight);
                            $child_price_list_from_weight = 0;
                            $child_price_list_to_weight = $weight[1];
                        }

                        array_push($weight_range[$key_column]['data'], [
                            'child_price_list_from_weight' => $child_price_list_from_weight,
                            'child_price_list_to_weight' => $child_price_list_to_weight,
                            'item_child_price_list_amount' => round($price),
                            'weight_range_flg' => $weight_range_flg,
                        ]);
                    }
                    if (isset($name_services[$count_name_services])) {
                        unset($name_services[$count_name_services]);
                    }
                }

                array_push($results, [
                    'title' => $service['service_name'],
                    'sub_child_price_list_type' => $price_list_type,
                    'service_id' => $service['service_id'],
                    'country_id' => $country_id,
                    'is_editing' => true,
                    'weight_range' => $weight_range
                ]);
            }
        }
        return $results;
    }

    private function importExcelPriceListCity($promotion_flg, $price_list_type, $data)
    {
        $data_headings = [];
        $results = [];

        //Nhóm các cột theo tên dịch vụ
        foreach ($data[0] as $key => $value) {
            if ($key > 0) {
                $value = explode('[', $value);
                $data_headings[$key] = $value[0] ?? '';
            }
        }
        $data_headings = array_values(array_unique($data_headings));

        $count_row = isset($data) ? count($data) : 0;
        $count_column = isset($data_headings) ? count($data_headings) : 0;

        for ($i = 0; $i < $count_column; $i++) {
            $service_name = $data_headings[$i];
            unset($data[0][0]);

            $service = Service::where('service_name', $service_name)
                ->where('promotion_flg', $promotion_flg)
                ->where('delete_flg', NO_DELETE)
                ->first();

            $name_services = collect($data[0])->filter(function ($value) use ($service_name) {
                return explode('[', $value)[0] == $service_name;
            })->toArray();

            if (isset($service)) {
                $price_list_zone = PriceListZone::with([
                    'subPriceListZone' => function ($query) {
                        return $query->select('price_list_zone_id', 'sub_price_list_zone_id', 'sub_price_list_zone_title');
                    },
                    'subPriceListZone.listAreaOfZone' => function ($query) {
                        return $query->select('sub_price_list_zone_id', 'list_area_of_zone_id', 'city_id');
                    },
                    'subPriceListZone.listAreaOfZone.town' => function ($query) {
                        return $query->select('city_id', 'city_name');
                    },
                ])
                    ->where('service_id', $service['service_id'])
                    ->select('price_list_zone_id', 'service_id', 'country_id')
                    ->first();

                $country = CountryAndServiceLink::isActive(ACTIVE)->isDelete(NO_DELETE)
                    ->isService($service['service_id'])
                    ->where('country_id', $price_list_zone['country_id'])
                    ->select('country_id')
                    ->first();
            }

            if (isset($service) && isset($price_list_zone) && isset($country)) {
                $service = $service->toArray();
                $price_list_zone = $price_list_zone->toArray();
                $country_id = $country['country_id'];
                $weight_range = [];

                foreach ($price_list_zone['sub_price_list_zone'] as $key_column => $column) {
                    $count_name_services = array_key_first($name_services);

                    $city_ids = collect($column['list_area_of_zone'])->pluck('city_id')->toArray();
                    $city_ids_old = collect($weight_range)->pluck('sub_child_price_list_area')->flatten()->toArray();
                    $city_ids = array_values(collect($city_ids)->filter(function ($value) use ($city_ids_old) {
                        return !in_array($value, $city_ids_old);
                    })->toArray());

                    $weight_range[$key_column] = [
                        'title' => $column['sub_price_list_zone_title'],
                        'sub_child_price_list_area' => $city_ids,
                        'data' => [],
                    ];

                    for ($j = 1; $j < $count_row; $j++) {
                        $weight = str_replace(" ", "", $data[$j][0]);
                        $price = isset($data[$j][$count_name_services]) ? $data[$j][$count_name_services] : 0;
                        $price = floatval(str_replace(" ", "", $price));
                        $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_NUMBER;
                        $child_price_list_from_weight = $weight;
                        $child_price_list_to_weight = $weight;

                        if (strpos($weight, '-') !== false) {
                            $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_NUMBER_TO_NUMBER;
                            $weight = explode('-', $weight);
                            $child_price_list_from_weight = $weight[0];
                            $child_price_list_to_weight = $weight[1];
                        } else if (strpos($weight, '>') !== false) {
                            $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER;
                            $weight = explode('>', $weight);
                            $child_price_list_from_weight = 0;
                            $child_price_list_to_weight = $weight[1];
                        } else if (strpos($weight, '>=') !== false) {
                            $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER;
                            $weight = explode('>=', $weight);
                            $child_price_list_from_weight = 0;
                            $child_price_list_to_weight = $weight[1];
                        }

                        array_push($weight_range[$key_column]['data'], [
                            'child_price_list_from_weight' => $child_price_list_from_weight,
                            'child_price_list_to_weight' => $child_price_list_to_weight,
                            'item_child_price_list_amount' => round($price),
                            'weight_range_flg' => $weight_range_flg,
                        ]);
                    }

                    if (isset($name_services[$count_name_services])) {
                        unset($name_services[$count_name_services]);
                    }
                }

                array_push($results, [
                    'title' => $service['service_name'],
                    'sub_child_price_list_type' => $price_list_type,
                    'service_id' => $service['service_id'],
                    'country_id' => $country_id,
                    'is_editing' => true,
                    'weight_range' => $weight_range
                ]);
            }
        }
        return $results;
    }

    private function importExcelPriceListPostCode($promotion_flg, $price_list_type, $data)
    {
        $data_headings = [];
        $results = [];

        //Nhóm các cột theo tên dịch vụ
        foreach ($data[0] as $key => $value) {
            if ($key > 0) {
                $data_headings[$key] = str_replace([" Remote", " Metro"], "", $value);
            }
        }
        $data_headings = array_values(array_unique($data_headings));

        $count_row = isset($data) ? count($data) : 0;
        $count_column = isset($data_headings) ? count($data_headings) : 0;

        for ($i = 0; $i < $count_column; $i++) {
            $service_name = $data_headings[$i];
            unset($data[0][0]);

            $service = Service::where('service_name', $service_name)
                ->where('promotion_flg', $promotion_flg)
                ->where('delete_flg', NO_DELETE)
                ->first();

            $name_services = collect($data[0])->filter(function ($value) use ($service_name) {
                return str_replace([" Remote", " Metro"], "", $value) == $service_name;
            })->toArray();

            if (isset($service)) {
                $price_list_zone = PriceListZone::with([
                    'subPriceListZone' => function ($query) {
                        return $query->select('price_list_zone_id', 'sub_price_list_zone_id', 'sub_price_list_zone_title');
                    },
                    'subPriceListZone.listAreaOfZone' => function ($query) {
                        return $query->select('sub_price_list_zone_id', 'list_area_of_zone_id', 'town_id');
                    },
                    'subPriceListZone.listAreaOfZone.town' => function ($query) {
                        return $query->select('town_id', 'town_postal_code');
                    },
                ])
                    ->where('service_id', $service['service_id'])
                    ->select('price_list_zone_id', 'service_id', 'country_id')
                    ->first();

                if (!isset($price_list_zone)) {
                    continue;
                }

                $country = CountryAndServiceLink::isActive(ACTIVE)->isDelete(NO_DELETE)
                    ->isService($service['service_id'])
                    ->where('country_id', $price_list_zone['country_id'])
                    ->select('country_id')
                    ->first();
            }

            if (isset($service) && isset($price_list_zone) && isset($country)) {
                $service = $service->toArray();
                $price_list_zone = $price_list_zone->toArray();
                $country_id = $country['country_id'];
                $weight_range = [];

                foreach ($price_list_zone['sub_price_list_zone'] as $key_column => $column) {
                    $count_name_services = array_key_first($name_services);

                    $town_ids = collect($column['list_area_of_zone'])->pluck('town_id')->toArray();
                    $town_ids_old = collect($weight_range)->pluck('sub_child_price_list_area')->flatten()->toArray();
                    $town_ids = array_values(collect($town_ids)->filter(function ($value) use ($town_ids_old) {
                        return !in_array($value, $town_ids_old);
                    })->toArray());

                    $weight_range[$key_column] = [
                        'title' => $column['sub_price_list_zone_title'],
                        'sub_child_price_list_area' => $town_ids,
                        'data' => [],
                    ];

                    for ($j = 1; $j < $count_row; $j++) {
                        $weight = str_replace(" ", "", $data[$j][0]);
                        $price = isset($data[$j][$count_name_services]) ? $data[$j][$count_name_services] : 0;
                        $price = floatval(str_replace(" ", "", $price));
                        $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_NUMBER;
                        $child_price_list_from_weight = $weight;
                        $child_price_list_to_weight = $weight;

                        if (strpos($weight, '-') !== false) {
                            $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_NUMBER_TO_NUMBER;
                            $weight = explode('-', $weight);
                            $child_price_list_from_weight = $weight[0];
                            $child_price_list_to_weight = $weight[1];
                        } else if (strpos($weight, '>') !== false) {
                            $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_BIGGER_NUMBER;
                            $weight = explode('>', $weight);
                            $child_price_list_from_weight = 0;
                            $child_price_list_to_weight = $weight[1];
                        } else if (strpos($weight, '>=') !== false) {
                            $weight_range_flg = ITEM_CHILD_PRICE_LIST_WEIGHT_RANGE_GREATER_THAN_OR_EQUAL_NUMBER;
                            $weight = explode('>=', $weight);
                            $child_price_list_from_weight = 0;
                            $child_price_list_to_weight = $weight[1];
                        }

                        array_push($weight_range[$key_column]['data'], [
                            'child_price_list_from_weight' => $child_price_list_from_weight,
                            'child_price_list_to_weight' => $child_price_list_to_weight,
                            'item_child_price_list_amount' => round($price),
                            'weight_range_flg' => $weight_range_flg,
                        ]);
                    }

                    if (isset($name_services[$count_name_services])) {
                        unset($name_services[$count_name_services]);
                    }
                }

                array_push($results, [
                    'title' => $service['service_name'],
                    'sub_child_price_list_type' => $price_list_type,
                    'service_id' => $service['service_id'],
                    'country_id' => $country_id,
                    'is_editing' => true,
                    'weight_range' => $weight_range
                ]);
            }
        }
        return $results;
    }

    public function getFwdByPickup(Request $request)
    {

        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;

            $user = $is_api ? $request->user() : auth()->user();

            $fwds = User::isShow()
                ->where(function ($query) use ($filters) {
                    return $query->where('users.user_code', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('users.user_contact_name', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('users.user_company_name', 'like', '%' . $filters['keywords'] . '%');
                })
                ->where('position_id', getPositionAccountSetting(SETTING_FWD_ACCOUNT));
            if (onCheckPositionAccount(SETTING_SALE_ACCOUNT, $user['position_id'])) {
                $fwd_link = SaleLinkFwd::isShow()->where('sale_id', $user['user_id'])->pluck('fwd_id');
                $fwds = $fwds->whereIn('user_id', $fwd_link);
            }

            if ($is_api) {
                $fwds = $fwds->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $fwds,
                ]);
            } else {
                $fwds = $fwds->get();
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $fwds,
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getListSale(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;

            $user = $is_api ? $request->user() : auth()->user();

            $sales = User::isShow()
                ->where(function ($query) use ($filters) {
                    return $query->where('users.user_code', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('users.user_contact_name', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('users.user_company_name', 'like', '%' . $filters['keywords'] . '%');
                })
                ->where('position_id', getPositionAccountSetting(SETTING_SALE_ACCOUNT));


            if ($is_api) {
                $sales = $sales->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $sales,
                ]);
            } else {
                $sales = $sales->get();
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $sales,
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function displayManageAdminSystemAssociateWithService(Request $request)
    {

        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;

            $api_labels = config('constans.constans.api_labels');

            $services = Service::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->with(['associateWithService'])
                ->isPromotion(IS_EPACKET)
                ->select('service_id', 'service_name')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'api_labels' => $api_labels,
                    'data' => $services,
                ], HTTP_OK);
            }

            $html = view('manage.admin.system.associate-with-service.index', compact('services', 'api_labels'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
            ], HTTP_OK);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataAssociateWithService(Request $request)
    {

        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;

            $api_labels = config('constans.constans.api_labels');

            $services = Service::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->with(['associateWithService'])
                ->isPromotion(IS_EPACKET)
                ->isFilters($filters)
                ->select('service_id', 'service_name')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'api_labels' => $api_labels,
                    'data' => $services,
                ], HTTP_OK);
            }

            $html = view('manage.admin.system.associate-with-service.associate-with-services-pagination', compact('services', 'api_labels'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
            ], HTTP_OK);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function updateDataAssociateWithService(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();

            foreach ($request_data['associate_with_service_apis'] as $service_id => $associate_with_service_api) {
                AssociateWithService::where('service_id', $service_id)->delete();
                AssociateWithService::create([
                    'service_id' => $service_id,
                    'associate_types' => json_encode($associate_with_service_api),
                ]);
            }

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => [],
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật liên kết api với dịch vụ ', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã cập nhật liên kết api với dịch vụ thành công.',
                    'icon' => 'success',
                ]
            ], HTTP_OK);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function uploadWeightConversion(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $weight_conversion = isset($request_data['weight-conversion']) ? $request_data['weight-conversion'] : [];
            $weight_conversion = is_string($weight_conversion) ? json_decode($weight_conversion, true) : $weight_conversion;

            $header = array_shift($weight_conversion);
            unset($header[0]);

            foreach ($header as $title) {
                $service = Service::where('service_name', $title)->isPromotion(IS_EPACKET)->first();
                if (!isset($service)) {
                    continue;
                }
                WeightConversion::where('service_id', $service['service_id'])->delete();

                $key_header = array_search($title, $header);
                foreach ($weight_conversion as $item) {
                    $initial_weight = $item[0] ?? 0;
                    $conversion = $item[$key_header] ?? 0;

                    if (preg_match('/(\d+(\.\d+)?)([a-zA-Z]+)/', $conversion, $matches)) {
                        $number = $matches[1] ?? 0;
                        $unit = Str::upper($matches[3] ?? 'KG');

                        WeightConversion::create([
                            'service_id' => $service['service_id'],
                            'initial_weight' => $initial_weight,
                            'weight_conversion' => $number,
                            'weight_unit' => $unit,
                        ]);
                    }
                }
            }

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => [],
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật quy đổi cân nặng', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã cập nhật quy đổi cân nặng thành công.',
                    'icon' => 'success',
                ]
            ], HTTP_OK);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function downloadWeightConversion(Request $reuqest)
    {
        try {
            $request_data = $reuqest->all();
            $service_id = isset($request_data['service_id']) ? $request_data['service_id'] : 0;

            $converts = WeightConversion::where('service_id', $service_id)->get()->toArray();

            return response()->json([
                'status' => HTTP_OK,
                'data' => $converts,
            ], HTTP_OK);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    //Cài đặt hình ảnh liên quan 
    public function displayImagesOfWeb(Request $request)
    {
        try {
            $path = 'public/config/setting-images.json';
            $data = Storage::exists($path) ? json_decode(Storage::get($path), true) : [];

            $html = view('manage.admin.system.setting.images-of-web', compact('data'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ], HTTP_OK);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleImagesOfWeb(Request $request)
    {
        $request->validate([
            'image_login' => 'required|file|mimes:jpeg,png,jpg',
        ]);
        try {
            $path = 'public/config/setting-images.json';
            $data = Storage::exists($path) ? json_decode(Storage::get($path), true) : [];

            $upload_path = public_path(PUBLIC_PATH_SYSTEM_IMAGE);
            if (!File::isDirectory($upload_path)) {
                File::makeDirectory($upload_path, 0777, true, true);
            }

            if ($request->hasFile('image_login')) {
                if (File::exists($data['image_login'])) {
                    File::delete($data['image_login']);
                }

                $file_name = 'image_login_' . $request->file('image_login')->getClientOriginalName();
                $request->file('image_login')->move($upload_path, $file_name);
                $file_path = PUBLIC_PATH_SYSTEM_IMAGE . '/' . $file_name;
                $data['image_login'] = $file_path;
            }

            Storage::put($path, json_encode($data));

            // Lịch sử hoạt động tài khoản
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật quy đổi cân nặng', null);

            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã cập nhật hình ảnh liên quan thành công.',
                    'icon' => 'success',
                ]
            ], HTTP_OK);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    //Cài đặt import excel bảng giá
    public function displayManageAdminSystemPriceListSettingImportExcel(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $price_list_zones = PriceListZone::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->with(['service', 'country'])
                ->orderBy('price_list_zone_id', 'desc')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
            }

            $html = view('manage.admin.system.price-list.setting-import-excel.list', compact('price_list_zones'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ], HTTP_OK);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataPriceListSettingImportExcel(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $price_list_zones = PriceListZone::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->with(['service', 'country'])
                ->orderBy('price_list_zone_id', 'desc')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
            } else {
                $html = view('manage.admin.system.price-list.setting-import-excel.pagination', compact('price_list_zones'))->render();
            }

            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ], HTTP_OK);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function displayManageAdminSystemPriceListSettingImportExcelCreate(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $services = Service::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->leftJoin('price_list_zone', 'services.service_id', '=', 'price_list_zone.service_id')
                ->whereNull('price_list_zone.service_id')
                ->select('services.service_id', 'services.service_name')
                ->get()->toArray();

            $countries = Country::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->select('country_id', 'country_name', 'country_code')
                ->get()->toArray();

            $html = view('manage.admin.system.price-list.setting-import-excel.create', compact('services', 'countries'))->render();

            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ], HTTP_OK);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleManageAdminSystemPriceListSettingImportExcelCreate(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $price_list_zone = isset($request_data['price_list_zone']) ? $request_data['price_list_zone'] : [];
            $price_list_zone = is_string($price_list_zone) ? json_decode($price_list_zone, true) : $price_list_zone;
            $service_ids = $price_list_zone['service_ids'];

            if (empty($service_ids)) {
                return response()->json([
                    'status' => HTTP_BAD_REQUEST,
                    'message' => [
                        'title' => 'Lỗi!',
                        'text' => 'Vui lòng chọn ít nhất 1 dịch vụ.',
                        'icon' => 'error',
                    ]
                ], HTTP_BAD_REQUEST);
            }

            foreach ($service_ids as $service_id) {
                $check_price_list_zone = PriceListZone::with(['service'])->where('service_id', $service_id)->first();
                if (!isset($check_price_list_zone)) {
                    $price_list_zone_created = PriceListZone::create([
                        'service_id' => $service_id,
                        'country_id' => $price_list_zone['country_id'] ?? null,
                        'price_list_zone_type' => $price_list_zone['price_list_zone_type'],
                    ]);

                    $service_name = Service::where('service_id', $service_id)->value('service_name');

                    if ($price_list_zone['price_list_zone_type'] == SUB_CHILD_PRICE_LIST_TYPE_POST_CODE) {
                        for ($i = 0; $i < 2; $i++) {
                            $sub_price_list_zone = SubPriceListZone::create([
                                'price_list_zone_id' => $price_list_zone_created['price_list_zone_id'],
                                'sub_price_list_zone_title' => $i == 0 ? $service_name . ' Remote' : $service_name . ' Metro',
                            ]);
                            if ($i == 0) {
                                foreach ($price_list_zone['data'] as $item) {
                                    $item['town'] = preg_replace('/[^A-Za-z0-9\-]/', '', $item['town']);
                                    $town = Town::where('country_id', $price_list_zone['country_id'])
                                        ->where('service_id', $service_id)
                                        ->where('town_postal_code', $item['postcode'])
                                        // ->where('town_name', 'like', '%' . $item['town'] . '%')
                                        ->first();
                                    $state = State::where('country_id', $price_list_zone['country_id'])->where('state_code', $item['state'])->first();

                                    if (!isset($town)) {
                                        $town = Town::create([
                                            'country_id' => $price_list_zone['country_id'],
                                            'state_id' => $state['state_id'] ?? null,
                                            'service_id' => $service_id,
                                            'town_name' => $item['town'] ?? '',
                                            'town_postal_code' => $item['postcode'] ?? null,
                                            'town_zone_code' => $item['zone'] ?? null,
                                            'town_note' => 'Remote',
                                        ]);
                                    }

                                    $check_list_area_of_zone = ListAreaOfZone::where('price_list_zone_id', $price_list_zone_created['price_list_zone_id'])
                                        ->where('sub_price_list_zone_id', $sub_price_list_zone['sub_price_list_zone_id'])
                                        ->where('town_id', $town['town_id'])
                                        ->first();

                                    if (!isset($check_list_area_of_zone)) {
                                        ListAreaOfZone::create([
                                            'price_list_zone_id' => $price_list_zone_created['price_list_zone_id'],
                                            'sub_price_list_zone_id' => $sub_price_list_zone['sub_price_list_zone_id'],
                                            'town_id' => $town['town_id'],
                                        ]);
                                    }
                                }
                            }
                        }
                    } else {
                        // if($price_list_zone['price_list_zone_type'] == SUB_CHILD_PRICE_LIST_TYPE_COUNTRY) {
                        //     CountryAndServiceLink::where('service_id', $service_id)->delete();
                        // }
                        foreach ($price_list_zone['data'] as $item) {
                            $sub_price_list_zone = SubPriceListZone::create([
                                'price_list_zone_id' => $price_list_zone_created['price_list_zone_id'],
                                'sub_price_list_zone_title' => $item['title'],
                            ]);

                            $this->processZones($price_list_zone_created, $item, $sub_price_list_zone);
                        }
                    }
                } else {
                    continue;
                }
            }

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã tạo cài đặt import excel bảng giá thành công.',
                    'icon' => 'success',
                ]
            ], HTTP_OK);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    private function processZones($price_list_zone, $item, $sub_price_list_zone)
    {
        switch ($price_list_zone['price_list_zone_type']) {
            case SUB_CHILD_PRICE_LIST_TYPE_COUNTRY:
                $this->processCountryZones($price_list_zone, $item, $sub_price_list_zone);
                break;
            case SUB_CHILD_PRICE_LIST_TYPE_STATE:
                $this->processStateZones($price_list_zone, $item, $sub_price_list_zone);
                break;
            case SUB_CHILD_PRICE_LIST_TYPE_CITY:
                $this->processCityZones($price_list_zone, $item, $sub_price_list_zone);
                break;
        }
    }

    private function processCountryZones($price_list_zone, $item, $sub_price_list_zone)
    {
        foreach ($item['zone'] as $zone) {
            $zone['name'] = preg_replace('/[^A-Za-z0-9\-]/', '', $zone['name']);
            $zone['code'] = preg_replace('/[^A-Za-z0-9\-]/', '', $zone['code']);
            $country = Country::isActive(ACTIVE)->isDELETE(NO_DELETE)
            ->where('country_code', 'like', $zone['code'])
                ->OrWhere('country_name', 'like', $zone['name'])
                ->first();

            if (isset($country)) {
                $check_country_service = CountryAndServiceLink::where('country_id', $country['country_id'])
                    ->where('service_id', $price_list_zone['service_id'])
                    ->first();
                if (!isset($check_country_service)) {
                    CountryAndServiceLink::create([
                        'country_id' => $country['country_id'],
                        'service_id' => $price_list_zone['service_id'],
                        'active_flg' => ACTIVE,
                    ]);
                }

                ListAreaOfZone::create([
                    'price_list_zone_id' => $price_list_zone['price_list_zone_id'],
                    'sub_price_list_zone_id' => $sub_price_list_zone['sub_price_list_zone_id'],
                    'country_id' => $country['country_id'],
                ]);
            }
        }
    }

    private function processStateZones($price_list_zone, $item, $sub_price_list_zone)
    {
        foreach ($item['zone'] as $zone) {
            $zone['name'] = preg_replace('/[^A-Za-z0-9\-]/', '', $zone['name']);
            $zone['code'] = preg_replace('/[^A-Za-z0-9\-]/', '', $zone['code']);
            $state = State::isActive(ACTIVE)->isDELETE(NO_DELETE)
            ->where('state_code', 'like',  $zone['code'])
                ->where('country_id', $price_list_zone['country_id'])
                ->first();
            if (isset($state)) {
                ListAreaOfZone::create([
                    'price_list_zone_id' => $price_list_zone['price_list_zone_id'],
                    'sub_price_list_zone_id' => $sub_price_list_zone['sub_price_list_zone_id'],
                    'state_id' => $state['state_id'],
                ]);
            }
        }
    }

    private function processCityZones($price_list_zone, $item, $sub_price_list_zone)
    {
        foreach ($item['zone'] as $zone) {
            $zone['name'] = preg_replace('/[^A-Za-z0-9\-]/', '', $zone['name']);
            $city = City::isActive(ACTIVE)->isDELETE(NO_DELETE)
            ->where('city_name', $zone['name'])
                ->where('country_id', $price_list_zone['country_id'])
                ->first();
            if (isset($city)) {
                ListAreaOfZone::create([
                    'price_list_zone_id' => $price_list_zone['price_list_zone_id'],
                    'sub_price_list_zone_id' => $sub_price_list_zone['sub_price_list_zone_id'],
                    'city_id' => $city['city_id'],
                ]);
            }
        }
    }

    public function displayManageAdminSystemPriceListSettingImportExcelEdit(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $price_list_zone_id = $request_data['price_list_zone_id'];

            $price_list_zone = PriceListZone::with([
                'subPriceListZone',
                'subPriceListZone.listAreaOfZone',
                'subPriceListZone.listAreaOfZone.country',
                'subPriceListZone.listAreaOfZone.state',
                'subPriceListZone.listAreaOfZone.city',
                'subPriceListZone.listAreaOfZone.town',
                'subPriceListZone.listAreaOfZone.town.state',
            ])->findOrFail($price_list_zone_id)->toArray();

            $service_name = Service::where('service_id', $price_list_zone['service_id'])->value('service_name');

            $result = [
                'price_list_zone_id' => $price_list_zone['price_list_zone_id'],
                'country_id' => $price_list_zone['country_id'],
                'price_list_zone_type' => $price_list_zone['price_list_zone_type'],
                'service_id' => $price_list_zone['service_id'],
                'data' => [],
            ];

            foreach ($price_list_zone['sub_price_list_zone'] as $sub_price_list_zone) {
                $zone = [];
                foreach ($sub_price_list_zone['list_area_of_zone'] as $list_area_of_zone) {
                    if ($price_list_zone['price_list_zone_type'] == SUB_CHILD_PRICE_LIST_TYPE_COUNTRY) {
                        $area = [
                            'list_area_of_zone_id' => $list_area_of_zone['list_area_of_zone_id'],
                            'name' => $list_area_of_zone['country']['country_name'],
                            'code' => $list_area_of_zone['country']['country_code'],
                        ];
                    } else if ($price_list_zone['price_list_zone_type'] == SUB_CHILD_PRICE_LIST_TYPE_STATE) {
                        $area = [
                            'list_area_of_zone_id' => $list_area_of_zone['list_area_of_zone_id'],
                            'name' => $list_area_of_zone['state']['state_name'],
                            'code' => $list_area_of_zone['state']['state_code'],
                        ];
                    } else if ($price_list_zone['price_list_zone_type'] == SUB_CHILD_PRICE_LIST_TYPE_CITY) {
                        $area = [
                            'list_area_of_zone_id' => $list_area_of_zone['list_area_of_zone_id'],
                            'name' => $list_area_of_zone['city']['city_name'],
                            'code' => '',
                        ];
                    } else if ($price_list_zone['price_list_zone_type'] == SUB_CHILD_PRICE_LIST_TYPE_POST_CODE) {
                        $area = [
                            'list_area_of_zone_id' => $list_area_of_zone['list_area_of_zone_id'],
                            'postcode' => $list_area_of_zone['town']['town_postal_code'] ?? '',
                            'zone' => $list_area_of_zone['town']['town_zone_code'] ?? '',
                            'town' => $list_area_of_zone['town']['town_name'] ?? '',
                            'state' => $list_area_of_zone['town']['state']['state_code'] ?? '',
                        ];
                    }
                    $zone[] = $area;
                }
                $result['data'][] = [
                    'sub_price_list_zone_id' => $sub_price_list_zone['sub_price_list_zone_id'],
                    'title' => $sub_price_list_zone['sub_price_list_zone_title'],
                    'zone' => $zone,
                ];
            }

            $services = Service::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->leftJoin('price_list_zone', function ($join) use ($price_list_zone_id) {
                    $join->on('services.service_id', '=', 'price_list_zone.service_id')
                        ->where('price_list_zone.price_list_zone_id', '!=', $price_list_zone_id);
                })
                ->whereNull('price_list_zone.price_list_zone_id')
                ->select('services.service_id', 'services.service_name')
                ->get()->toArray();

            $countries = Country::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->select('country_id', 'country_name', 'country_code')
                ->get()->toArray();

            $html = view('manage.admin.system.price-list.setting-import-excel.edit', compact('services', 'countries'))->render();

            return response()->json([
                'status' => HTTP_OK,
                'price_list_zone' => $result,
                'service_name' => $service_name,
                'html' => $html
            ], HTTP_OK);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleManageAdminSystemPriceListSettingImportExcelEdit(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $price_list_zone = isset($request_data['price_list_zone']) ? $request_data['price_list_zone'] : [];
            $price_list_zone = is_string($price_list_zone) ? json_decode($price_list_zone, true) : $price_list_zone;
            $service_id = $request_data['service_id'];
            if (empty($service_id)) {
                return response()->json([
                    'status' => HTTP_BAD_REQUEST,
                    'message' => [
                        'title' => 'Lỗi!',
                        'text' => 'Vui lòng chọn ít dịch vụ.',
                        'icon' => 'error',
                    ]
                ], HTTP_BAD_REQUEST);
            }

            $price_list_zone_created = PriceListZone::updateOrCreate([
                'price_list_zone_id' => $price_list_zone['price_list_zone_id']
            ], [
                'service_id' => $service_id,
                'country_id' => $price_list_zone['country_id'] ?? null,
                'price_list_zone_type' => $price_list_zone['price_list_zone_type'],
            ]);

            SubPriceListZone::where('price_list_zone_id', $price_list_zone_created['price_list_zone_id'])->delete();

            if ($price_list_zone['price_list_zone_type'] == SUB_CHILD_PRICE_LIST_TYPE_POST_CODE) {
                $service_name = Service::where('service_id', $service_id)->value('service_name');
                for ($i = 0; $i < 2; $i++) {
                    $sub_price_list_zone = SubPriceListZone::create([
                        'price_list_zone_id' => $price_list_zone_created['price_list_zone_id'],
                        'sub_price_list_zone_title' => $i == 0 ? $service_name . ' Remote' : $service_name . ' Metro',
                    ]);
                    if ($i == 0) {
                        foreach ($price_list_zone['data'] as $item) {
                            $item['town'] = preg_replace('/[^A-Za-z0-9\-]/', '', $item['town']);
                            $town = Town::where('country_id', $price_list_zone['country_id'])
                                ->where('service_id', $service_id)
                                ->where('town_postal_code', $item['postcode'])
                                // ->where('town_name', 'like', '%' . $item['town'] . '%')
                                ->first();
                            $state = State::where('country_id', $price_list_zone['country_id'])->where('state_code', $item['state'])->first();

                            if (!isset($town)) {
                                $town = Town::create([
                                    'country_id' => $price_list_zone['country_id'],
                                    'state_id' => $state['state_id'] ?? null,
                                    'service_id' => $service_id,
                                    'town_name' => $item['town'] ?? '',
                                    'town_postal_code' => $item['postcode'] ?? '',
                                    'town_zone_code' => $item['zone'] ?? '',
                                    'town_note' => 'Remote',
                                ]);
                            }

                            $check_list_area_of_zone = ListAreaOfZone::where('price_list_zone_id', $price_list_zone_created['price_list_zone_id'])
                                ->where('sub_price_list_zone_id', $sub_price_list_zone['sub_price_list_zone_id'])
                                ->where('town_id', $town['town_id'])
                                ->first();

                            if (!isset($check_list_area_of_zone)) {
                                ListAreaOfZone::create([
                                    'price_list_zone_id' => $price_list_zone_created['price_list_zone_id'],
                                    'sub_price_list_zone_id' => $sub_price_list_zone['sub_price_list_zone_id'],
                                    'town_id' => $town['town_id'],
                                ]);
                            }
                        }
                    }
                }
            } else {
                if ($price_list_zone['price_list_zone_type'] == SUB_CHILD_PRICE_LIST_TYPE_COUNTRY) {
                    CountryAndServiceLink::where('service_id', $service_id)->delete();
                }
                foreach ($price_list_zone['data'] as $item) {
                    $sub_price_list_zone = SubPriceListZone::create([
                        'price_list_zone_id' => $price_list_zone_created['price_list_zone_id'],
                        'sub_price_list_zone_title' => $item['title'],
                    ]);

                    $this->processZones($price_list_zone_created, $item, $sub_price_list_zone);
                }
            }

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => [],
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật cài đặt import excel bảng giá', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã cập nhật cài đặt import excel bảng giá thành công.',
                    'icon' => 'success',
                ]
            ], HTTP_OK);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function handleManageAdminSystemPriceListSettingImportExcelDelete(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $price_list_zone_id = $request_data['price_list_zone_id'];

            $price_list_zone = PriceListZone::findOrFail($price_list_zone_id);
            Town::where('service_id', $price_list_zone['service_id'])->delete();
            PriceListZone::findOrFail($price_list_zone_id)->delete();

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => [],
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa cài đặt import excel bảng giá', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã xóa cài đặt import excel bảng giá thành công.',
                    'icon' => 'success',
                ]
            ], HTTP_OK);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    // Danh sách remote
    public function displayManageAdminSystemRemote(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $countries = Country::isActive(ACTIVE)->isDelete(NO_DELETE)->get()->toArray();
            $services = Service::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->select('service_id', 'service_name')
                ->get()->toArray();

            $remote = Town::with(['country', 'state'])->orderBy('town_id', 'desc')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
            }

            $html = view('manage.admin.system.remote.index', compact('remote', 'countries', 'services'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ], HTTP_OK);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataRemote(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;

            $remote = Town::with(['country', 'state'])->isFilters($filters)
                ->orderBy('town_id', 'desc')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
            }

            $html = view('manage.admin.system.remote.remote-pagination', compact('remote'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ], HTTP_OK);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataRemoteDetail(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $town_id = $request_data['town_id'];

            $town = Town::with(['country', 'state'])->findOrFail($town_id);

            return response()->json([
                'status' => HTTP_OK,
                'town' => $town
            ], HTTP_OK);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleUpdateDataRemote(Request $request)
    {
        $request->validate([
            'country_id' => 'required',
            'service_id' => 'required',
            'town_postal_code' => 'required',
            // 'town_zone_code' => 'required',
        ], [
            'country_id.required' => 'Vui lòng chọn quốc gia.',
            'service_id.required' => 'Vui lòng chọn dịch vụ.',
            'town_postal_code.required' => 'Vui lòng nhập mã bưu chính.',
            // 'town_zone_code.required' => 'Vui lòng nhập mã vùng.',
        ]);
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $town = Town::updateOrCreate(
                [
                    'town_id' => isset($request_data['town_id']) ? $request_data['town_id'] : null,
                ],
                [
                    'country_id' => $request_data['country_id'],
                    'state_id' => $request_data['state_id'] ?? null,
                    'service_id' => $request_data['service_id'] ?? null,
                    'town_name' => $request_data['town_name'] ?? '',
                    'town_postal_code' => $request_data['town_postal_code'],
                    'town_zone_code' => $request_data['town_zone_code'] ?? '',
                    'town_note' => 'Remote',
                ]
            );

            if (!isset($request_data['town_id'])) {
                $price_list_zone = PriceListZone::where('country_id', $request_data['country_id'])
                    ->select('price_list_zone_id')
                    ->get()->pluck('price_list_zone_id')->toArray();

                $sub_price_list_zone = SubPriceListZone::where('sub_price_list_zone_title', 'Remote')
                    ->whereIn('price_list_zone_id', $price_list_zone)
                    ->select('sub_price_list_zone_id', 'price_list_zone_id')
                    ->get()->toArray();

                foreach ($sub_price_list_zone as $item) {
                    ListAreaOfZone::create([
                        'price_list_zone_id' => $item['price_list_zone_id'],
                        'sub_price_list_zone_id' => $item['sub_price_list_zone_id'],
                        'town_id' => $town['town_id'],
                    ]);
                }
            }

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => [],
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Cập nhật remote', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã cập nhật remote thành công.',
                    'icon' => 'success',
                ]
            ], HTTP_OK);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function handleDeleteDataRemote(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $town_id = $request_data['town_id'];

            Town::findOrFail($town_id)->delete();

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => [],
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa remote', $data_logs);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Bạn đã xóa dữ liệu thành công.',
                    'icon' => 'success',
                ]
            ], HTTP_OK);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function excelGpsUsa(Request $request)
    {
        $awb_code = explodeAwbCode('214-12457');
    }
}
