<?php

namespace App\Http\Controllers;

use App\Models\InitiallizeLabelHistory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class InitiallizeLabelHistoryController extends Controller
{
    public function displayInitiallizeLabelHistories()
    {
        return view('initiallize-label-history.index');
    }

    public function getInitiallizeLabelHistories(Request $request)
    {
        try {
            $request_data = $request->all();
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_array($filters) ? $filters : json_decode($filters, true);
            $user = $request->user();
            $is_api = $request->is('api/*');

            $initiallize_label_histories = InitiallizeLabelHistory::with(['shipment'])->isFilters($filters);

            if (!isGetAllData()) {
                $initiallize_label_histories = $initiallize_label_histories->where('user_id', $user['user_id']);
            }

            $initiallize_label_histories = $initiallize_label_histories->orderBy('initiallize_label_history_id', 'desc')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $initiallize_label_histories
                ], HTTP_OK);
            }

            $html = view('initiallize-label-history.pagination', compact('initiallize_label_histories'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ], HTTP_OK);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleDeleteInitiallizeLabelHistory(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $initiallize_label_history_id = $request_data['initiallize_label_history_id'];

            InitiallizeLabelHistory::findOrFail($initiallize_label_history_id)->delete();

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'icon' => 'success',
                    'title' => 'Thông báo',
                    'text' => 'Xóa lịch sử thành công'
                ]
            ], HTTP_OK);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }
}
