<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Branch;
use App\Models\Credit;
use App\Models\MenuByPosition;
use App\Models\Package;
use App\Models\Service;
use App\Models\Position;
use App\Models\Shipment;
use App\Models\Notification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;

class HomeController extends Controller
{

    // Giao diện trang chủ
    public function displayHome()
    {

        $position_id = auth()->user()->position_id;
        $branchs = Branch::isActive(ACTIVE)->isDelete(NO_DELETE)->select('branch_id', 'branch_name')->get()->toArray();
        $positions = Position::isShow()->leftJoin('users', 'positions.position_id', 'users.position_id')
            ->where('users.delete_flg', NO_DELETE)
            ->select(
                'positions.position_name',
                'positions.position_id',
                DB::raw('COUNT(users.user_id) as count_user')
            )
            ->groupBy('positions.position_id')->get()->toArray();

        $services = Service::isActive(ACTIVE)->isDelete(NO_DELETE)
            ->where('promotion_flg', '!=', IS_PROMOTION)
            ->select('service_id', 'service_name')->get()->toArray();
        $is_get_all = isGetAllData();

        $shipments_to_country = Shipment::isActive(ACTIVE)->isDelete(NO_DELETE)
            ->where('shipments.import_approval', ACTIVE)
            ->leftJoin('countries', 'shipments.receiver_country_id', 'countries.country_id');

        if (!$is_get_all) {
            $shipments_to_country = $shipments_to_country->where('shipments.user_id', request()->user()->user_id);
        }

        $shipments_to_country = $shipments_to_country->select(
            'countries.country_name',
            'countries.country_code',
            DB::raw('COUNT(shipment_id) as count_shipment'),
        )
            ->groupBy('receiver_country_id')
            ->get()->toArray();

        $total_shipment = collect($shipments_to_country)->sum('count_shipment');
        foreach ($shipments_to_country as $key => $item) {
            $shipments_to_country[$key]['percentage_shipment_to_country'] = $item['count_shipment'] / $total_shipment * 100;
        }

        $shipments_to_state = Shipment::isActive(ACTIVE)->isDelete(NO_DELETE)
            ->where('shipments.import_approval', ACTIVE)
            ->leftJoin('states', 'shipments.receiver_state_id', 'states.state_id');

        if (!$is_get_all) {
            $shipments_to_state = $shipments_to_state->where('shipments.user_id', request()->user()->user_id);
        }

        $shipments_to_state = $shipments_to_state->select(
            'states.state_name',
            'states.state_code',
            'states.state_latitude',
            'states.state_longitude',
        )
            ->groupBy('receiver_state_id')
            ->get()->toArray();

        $current_location = config('constans.constans.location');
        $shipment_status = config('constans.constans.shipment_status');
        return view('home.index', compact('branchs', 'positions', 'services', 'shipments_to_country', 'shipments_to_state', 'current_location', 'shipment_status', 'position_id'));
    }

    public function getDataDashboard(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $chart_type_date = isset($request_data['chart_type_date']) ? $request_data['chart_type_date'] : '%d-%m-%Y';
            $chart_type_total = isset($request_data['chart_type_total']) ? $request_data['chart_type_total'] : 'number_bill';
            $is_get_all = isGetAllData();
            $user = $request->user();


            $branchs = Branch::isActive(ACTIVE)->isDelete(NO_DELETE)->pluck('branch_name', 'branch_id');

            $fwd_position = getPositionAccountSetting(SETTING_FWD_ACCOUNT);

            if (!$is_get_all) {
                $filters['user_id'] = $user['user_id'];
            }

            $data_column_chart = Shipment::isShow()
                ->leftJoin('users', 'shipments.user_id', '=', 'users.user_id')
                ->isFiltersInDashboard($filters)
                ->where('shipments.import_approval', ACTIVE)
                ->select(
                    DB::raw('CAST(DATE_FORMAT(shipments.created_at, "' . $chart_type_date . '") AS CHAR) as date'),
                    DB::raw('COUNT(DISTINCT shipments.shipment_id) as number_bill'),
                    DB::raw("(SELECT SUM(packages.package_charged_weight) FROM packages WHERE packages.shipment_id = shipments.shipment_id AND packages.delete_flg = " . NO_DELETE . " AND packages.active_flg = " . ACTIVE . ") as total_weight"),
                    DB::raw('SUM(shipments.shipment_final_amount) as total_price'),
                    DB::raw('SUM(shipments.shipment_amount_total_customer) as total_price_customer'),
                    DB::raw('SUM(CASE WHEN shipment_status = 0 THEN 1 ELSE 0 END) as created'),
                    DB::raw('SUM(CASE WHEN shipment_status = 1 THEN 1 ELSE 0 END) as imported'),
                    DB::raw('SUM(CASE WHEN shipment_status = 2 THEN 1 ELSE 0 END) as exported'),
                    DB::raw('SUM(CASE WHEN shipment_status = 3 THEN 1 ELSE 0 END) as returned'),
                    DB::raw('SUM(CASE WHEN users.position_id != ' . $fwd_position . ' THEN shipments.shipment_amount_total_customer ELSE 0 END) as turnover_sale'),
                    DB::raw('SUM(CASE WHEN users.position_id = ' . $fwd_position . ' THEN shipments.shipment_final_amount ELSE 0 END) as turnover_fwd'),
                    'shipments.shipment_branch_id'
                )
                ->orderBy('shipments.created_at', 'ASC');



            $data_column_chart = $data_column_chart->groupBy('date', 'shipments.shipment_branch_id')
                ->get();
            $bill = Shipment::isShow()
                ->leftJoin('users', 'shipments.user_id', '=', 'users.user_id')
                ->isFiltersInDashboard($filters)
                ->leftJoin('packages', 'shipments.shipment_id', '=', 'packages.shipment_id')
                ->where('packages.delete_flg', NO_DELETE)
                ->where('packages.active_flg', ACTIVE)
                ->select([
                    DB::raw('COUNT(packages.package_id) as total_packages'),             // Tổng số package
                    DB::raw('SUM(packages.package_charged_weight) as total_weight'),    // Tổng số cân nặng
                    // DB::raw('COUNT(DISTINCT shipments.shipment_id) as total_shipments'), // Tổng số shipment
                    // DB::raw('SUM(shipments.shipment_final_amount) as total_amount')     // Tổng số tiền thu
                ])
                // ->groupBy('packages.package_id')
                ->first(); // Lấy duy nhất một kết quả
            $bill_sm = Shipment::isShow()
                ->leftJoin('users', 'shipments.user_id', '=', 'users.user_id')
                ->isFiltersInDashboard($filters)
                ->select([
                    DB::raw('COUNT(DISTINCT shipments.shipment_id) as total_shipments'),
                    DB::raw('SUM(shipments.shipment_final_amount) as total_amount'),
                ])
                ->first();
            $total_number_bill = $bill_sm['total_shipments'] ?? 0;
            $total_price = $bill_sm['total_amount'] ?? 0;
            $total_weight = $bill['total_weight'] ?? 0;
            // $total_price_customer = $data_column_chart->flatten()->sum('total_price_customer');
            $total_price_customer = 0;
            $total_created = $data_column_chart->flatten()->sum('created');
            $total_imported = $data_column_chart->flatten()->sum('imported');
            $total_exported = $data_column_chart->flatten()->sum('exported');
            $total_returned = $data_column_chart->flatten()->sum('returned');
            $per_created = $total_number_bill > 0 ? round($total_created / $total_number_bill * 100, 0) : 0;
            $per_imported = $total_number_bill > 0 ? round($total_imported / $total_number_bill * 100, 0) : 0;
            $per_exported = $total_number_bill > 0 ? round($total_exported / $total_number_bill * 100, 0) : 0;
            $per_returned = $total_number_bill > 0 ? 100 - $per_created - $per_imported - $per_exported : 0;

            $data = [
                'categories' => $data_column_chart->keys()->toArray(),
                'series' => []
            ];
            foreach ($branchs as $branch_id => $branch_name) {
                $series_data = [];
                foreach ($data['categories'] as $key => $date) {
                    $category = (string) $date;
                    $series_data[] = isset($data_column_chart[$category]->where('shipment_branch_id', $branch_id)->first()->$chart_type_total)
                        ? $data_column_chart[$category]->where('shipment_branch_id', $branch_id)->first()->$chart_type_total
                        : 0;
                }

                $data['series'][] = [
                    'name' => $branch_name,
                    'data' => $series_data
                ];
            }

            $limit_amount_flg = $user['position']['limit_amount_flg'];
            $user = collect($user)->only(['user_remaining_limit', 'user_limit_amount_for_sale'])->toArray();
            $user['limit_amount_flg'] = $limit_amount_flg;
            $user['user_remaining_limit'] = $user['user_remaining_limit'] ?? 0;
            $user['user_limit_amount_for_sale'] = $user['user_limit_amount_for_sale'] ?? 0;


            $data_credit = $this->getDataChartCredit($request_data, $user);


            $data_manager_money = $this->getDataChartManageMoney($filters);

            return response()->json([
                'status' => HTTP_OK,
                'data' => $data,
                'user' => $user,
                'total_number_bill' => $total_number_bill,
                'total_weight' => $total_weight,
                'total_price' => $total_price,
                'total_price_customer' => $total_price_customer,
                'total_created' => $total_created,
                'total_imported' => $total_imported,
                'total_exported' => $total_exported,
                'total_returned' => $total_returned,
                'per_created' => $per_created,
                'per_imported' => $per_imported,
                'per_exported' => $per_exported,
                'per_returned' => $per_returned,
                'chart_credits' => $data_credit,
                'chart_manager_money' => $data_manager_money,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getDataChartCredit($request_data, $user)
    {
        try {

            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $chart_type_date = isset($request_data['chart_type_date']) ? $request_data['chart_type_date'] : '%d-%m-%Y';
            $chart_type_total = isset($request_data['chart_type_total']) ? $request_data['chart_type_total'] : 'number_bill';
            $is_get_all = isGetAllData();

            $credits = Credit::isShow()->where('credits.credit_status', SUCCESS)
                ->leftJoin('credit_items', 'credits.credit_id', 'credit_items.credit_id')
                ->where('credit_items.active_flg', ACTIVE)
                ->where('credit_items.delete_flg', NO_DELETE);

            if (
                (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
            ) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                $credits->whereBetween("credits.created_at", [$start_date, $end_date]);
            }

            if (!$is_get_all) {
                $credits->where('credits.customer_id', $user['user_id']);
            }

            $credits = $credits
                ->select(
                    DB::raw('CAST(DATE_FORMAT(credits.created_at, "' . $chart_type_date . '") AS CHAR) as date'),
                    DB::raw('SUM(credit_items.value_package) as value_packages'),
                    DB::raw('SUM(credit_items.goods_compensation) as goods_compensations'),
                    DB::raw('SUM(credit_items.goods_compensation + credit_items.value_package) as total_credit'),
                )
                ->orderBy('credits.created_at', 'ASC')
                ->groupBy('date')
                ->get()->toArray();

            $data_chart = [
                'categories' => ['Giá trị gói', 'Tiền bồi thường'],
                'data' => $credits,
                'total_value_packages' => collect($credits)->sum('value_packages'),
                'total_goods_compensations' => collect($credits)->sum('goods_compensations'),
                'total_credits' => collect($credits)->sum('total_credit'),
            ];

            return $data_chart;
        } catch (\Throwable $th) {
            return null;
        }
    }

    public function getDataChartManageMoney($filters)
    {
        try {
            $manage = new ManageController();


            $data = $manage->queryPaymentCash($filters)->get()->toArray();
            $position_fwd_id = getPositionAccountSetting(SETTING_FWD_ACCOUNT);

            $fwd_cash = collect($data)->where('customer_position_id', $position_fwd_id)
                ->sum('amount_cash');
            $fwd_bank = collect($data)->where('customer_position_id', $position_fwd_id)
                ->sum('amount_bank');

            $sale_cash = collect($data)->where('customer_position_id', '!=', $position_fwd_id)
                ->sum('amount_cash');
            $sale_bank = collect($data)->where('customer_position_id', '!=', $position_fwd_id)
                ->sum('amount_bank');

            return [
                'fwd_cash' => $fwd_cash,
                'fwd_bank' => $fwd_bank,
                'sale_cash' => $sale_cash,
                'sale_bank' => $sale_bank,
            ];
        } catch (\Throwable $th) {
            return [
                'fwd_cash' => 0,
                'fwd_bank' => 0,
                'sale_cash' => 0,
                'sale_bank' => 0
            ];
        }
    }

    //Giao diện trang thông báo
    public function displayNotifications()
    {
        $user = auth()->user();
        $path = 'public/config/system-settings.json';
        $position_ids = collect(json_decode(Storage::get($path), true))->firstWhere('kind', SETTING_ACCOUNT_UPDATE_NOTIFICATIONS)['position_ids'];
        $is_update = in_array($user['position_id'], isset($position_ids) && $position_ids != "" ? $position_ids : []);
        return view('notifications.index', compact('is_update'));
    }

    public function getDataDashboardSetup()
    {
        try {
            $branchs = Branch::isActive(ACTIVE)->isDelete(NO_DELETE)->select('branch_id', 'branch_name')->get()->toArray();
            $positions = Position::isShow()->leftJoin('users', 'positions.position_id', 'users.position_id')
                ->select('positions.position_name', 'positions.position_id', DB::raw('COUNT(users.user_id) as count_user'))
                ->groupBy('positions.position_id')->get()->toArray();
            $services = Service::isActive(ACTIVE)->isDelete(NO_DELETE)
                ->where('promotion_flg', '!=', IS_PROMOTION)
                ->select('service_id', 'service_name')->get()->toArray();
            $shipment_status = config('constans.constans.shipment_status');
            $filters_by_date = [
                '%Hh %d-%m-%Y' => 'Giờ',
                '%d-%m-%Y' => 'Ngày',
                '%m-%Y' => 'Tháng',
                '%Y' => 'Năm'
            ];
            $filters_by_type = [
                'number_bill' => 'Tổng đơn',
                'total_weight' => 'Tổng cân nặng',
                'total_price' => 'Doanh thu',
                'total_price_customer' => 'Lợi nhuận',
            ];

            return response()->json([
                'status' => HTTP_OK,
                'positions' => $positions,
                'services' => $services,
                'shipment_status' => $shipment_status,
                'filters_by_date' => $filters_by_date,
                'filters_by_type' => $filters_by_type,
                'branchs' => $branchs,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function getNotifications(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $user = $is_api ? auth()->user() : $request->user();
            $filters = isset($request_data['filters']) ? $request_data['filters'] : [];
            $filters = is_string($filters) ? json_decode($filters, true) : $filters;

            $notifications = Notification::isActive(ACTIVE)->isDelete(NO_DELETE)->isFilters($filters)
                ->with(['user'])
                ->orderByDesc('created_at')
                ->select(
                    'notification_id',
                    'user_id',
                    'notification_title',
                    'notification_important',
                    'notification_file',
                    'created_at'
                )
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            $path = 'public/config/system-settings.json';
            $is_update = in_array($user['position_id'], collect(json_decode(Storage::get($path), true))->firstWhere('kind', SETTING_ACCOUNT_UPDATE_NOTIFICATIONS)['position_ids']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'notifications' => $notifications,
                    'is_update' => $is_update,
                ]);
            }

            $html = view('notifications.notification-pagination', compact('notifications', 'is_update'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html,
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function displayNotificationsCreate()
    {
        $user = auth()->user();
        $path = 'public/config/system-settings.json';
        $is_update = in_array($user['position_id'], collect(json_decode(Storage::get($path), true))->firstWhere('kind', SETTING_ACCOUNT_UPDATE_NOTIFICATIONS)['position_ids']);
        if (!$is_update) {
            return abort(HTTP_NOT_FOUND);
        }

        return view('notifications.create');
    }

    public function handleNotificationsCreate(Request $request)
    {
        $request->validate([
            'notification_title' => 'required|max:255',
            'notification_important' => 'required',
            'notification_content' => 'required',
        ]);
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = $request_data['is_api'] ? json_decode($request_data['is_api']) : false;
            $user = request()->user();
            $path = 'public/config/system-settings.json';

            $is_update = in_array($user['position_id'], collect(json_decode(Storage::get($path), true))->firstWhere('kind', SETTING_ACCOUNT_UPDATE_NOTIFICATIONS)['position_ids'] ?? []);
            if (!$is_update) {
                return returnResponse(HTTP_BAD_REQUEST, 'Bạn không đủ quyền hạn', null, 'warning');
            }

            if ($request_data['notification_content'] == '<p>&nbsp;</p>') {
                return response()->json([
                    'status' => HTTP_SERVICE_UNAVAILABLE,
                    'message' => [
                        'title' => 'Thất bại!',
                        'text' => 'Chưa có nội dung thông báo.',
                        'icon' => 'error',
                    ]
                ]);
            }

            Notification::create([
                'user_id' => $user['user_id'],
                'notification_title' => $request_data['notification_title'],
                'notification_important' => json_decode($request_data['notification_important']) ? NOTIFICATION_IMPORTANT : NOTIFICATION_NO_IMPORTANT,
                'notification_content' => $request_data['notification_content'],
            ]);

            Session::flash('success', 'Tạo thông báo thành công.');

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Tạo thông báo thành công.',
                    'icon' => 'success',
                ],
                'redirect' => route('notifications.show'),
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function displayNotificationsDetail($notification_id)
    {
        try {
            $is_api = request()->is('api/*');
            $path = 'public/config/system-settings.json';
            $system_settings_kinds = [SETTING_COMPANY_NAME, SETTING_HOTLINE];
            $system_settings = json_decode(Storage::get($path), true);
            $system_settings = collect($system_settings)->whereIn('kind', $system_settings_kinds)->keyBy('kind')->toArray();

            $notification = Notification::isActive(ACTIVE)->isDelete(NO_DELETE)->findOrFail($notification_id);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'notification' => $notification,
                    'system_settings' => $system_settings,
                ]);
            }
            return view('notifications.detail', compact('notification', 'system_settings'));
        } catch (\Throwable $th) {
            return abort(HTTP_NOT_FOUND);
        }
    }

    public function displayNotificationsEdit(Request $request, $notification_id)
    {
        try {
            $is_api = $request->is('api/*');
            $user = auth()->user();
            $path = 'public/config/system-settings.json';
            $is_update = in_array($user['position_id'], collect(json_decode(Storage::get($path), true))->firstWhere('kind', SETTING_ACCOUNT_UPDATE_NOTIFICATIONS)['position_ids']);
            if (!$is_update) {
                return abort(HTTP_NOT_FOUND);
            }

            $notification = Notification::isActive(ACTIVE)->isDelete(NO_DELETE)->findOrFail($notification_id);
            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'notification' => $notification,
                ]);
            }

            return view('notifications.edit', compact('notification'));
        } catch (\Throwable $th) {
            return abort(HTTP_NOT_FOUND);
        }
    }

    public function handleNotificationsEdit(Request $request)
    {
        $request->validate([
            'notification_title' => 'required|max:255',
            'notification_important' => 'required',
            'notification_content' => 'required',
        ]);
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = $request_data['is_api'] ? json_decode($request_data['is_api']) : false;
            $user = request()->user();
            $path = 'public/config/system-settings.json';

            $is_update = in_array($user['position_id'], collect(json_decode(Storage::get($path), true))->firstWhere('kind', SETTING_ACCOUNT_UPDATE_NOTIFICATIONS)['position_ids']);
            if (!$is_update) {
                return returnResponse(HTTP_BAD_REQUEST, 'Bạn không đủ quyền hạn', null, 'warning');
            }

            if ($request_data['notification_content'] == '<p>&nbsp;</p>') {
                return response()->json([
                    'status' => HTTP_SERVICE_UNAVAILABLE,
                    'message' => [
                        'title' => 'Thất bại!',
                        'text' => 'Chưa có nội dung thông báo.',
                        'icon' => 'error',
                    ]
                ]);
            }

            Notification::isActive(ACTIVE)->isDelete(NO_DELETE)->findOrFail($request_data['notification_id'])->update([
                'notification_title' => $request_data['notification_title'],
                'notification_important' => json_decode($request_data['notification_important']) ? NOTIFICATION_IMPORTANT : NOTIFICATION_NO_IMPORTANT,
                'notification_content' => $request_data['notification_content'],
            ]);

            Session::flash('success', 'Chỉnh sửa thông báo thành công.');

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Chỉnh sửa thông báo thành công.',
                    'icon' => 'success',
                ],
                'redirect' => route('notifications.show'),
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function handleNotificationsDelete(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = $request_data['is_api'] ? json_decode($request_data['is_api']) : false;
            $user = request()->user();
            $path = 'public/config/system-settings.json';
            $position_ids = collect(json_decode(Storage::get($path), true))
            ->firstWhere('kind', SETTING_ACCOUNT_UPDATE_NOTIFICATIONS)['position_ids'];
            // return response()->json([
            //     'status' => HTTP_OK,
            //     'message' => [
            //         'title' => 'Thành công!',
            //         'text' => 'Xóa thông báo thông báo.',
            //         'icon' => 'success',
            //     ],
            //     'admin' => $position_ids,
            //     'position_id' => $user['position_id'],
            //     'is_update' => in_array($user['position_id'], $position_ids),
            // ]);
            $is_update = in_array($user['position_id'], $position_ids);
            if (!$is_update) {
                return returnResponse(HTTP_BAD_REQUEST, 'Bạn không đủ quyền hạn', null, 'warning');
            }

            $notification = Notification::isActive(ACTIVE)->isDelete(NO_DELETE)->where('notification_id', $request_data['notification_id'])->first();

            if(!$notification) return returnResponse(HTTP_BAD_REQUEST, 'Khoông tìm thấy thông báo', null, 'warning');
            
            
            $notification->update([
                'delete_flg' => DELETED,
            ]);

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'title' => 'Thành công!',
                    'text' => 'Xóa thông báo thành công.',
                    'icon' => 'success',
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return response()->json([
                'status' => HTTP_BAD_REQUEST,
                'message' =>  $th->getMessage()
            ]);
            return showMessageError();
        }
    }
}
