<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Debit;
use App\Models\Branch;
use App\Models\Wallet;
use App\Models\Package;
use App\Models\Service;
use App\Models\Shipment;
use App\Models\PackageSg;
use App\Exports\ExportFile;
use App\Models\HistoryScan;
use App\Exports\ExportDebit;
use Illuminate\Http\Request;
use App\Models\SurchargeGoods;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class DebitController extends Controller
{
    public function displayDebitFwd()
    {
        try {
            $key_accountant = session('key_accountant');
            if (isset($key_accountant) && $key_accountant == auth()->user()['user_accountant_key']) {
                return view('debit-fwd.index');
            } else {
                return view('debit-fwd.sign-accountant');
            }
        } catch (\Throwable $th) {
            return viewError404();
        }
    }

    public function verifyToShowDebit(Request $request)
    {
        $user_key_accountant =  $request->user()['user_accountant_key'];
        $verifyKey = $request->input('key');

        try {
            if ($user_key_accountant == $verifyKey) {
                session(['key_accountant' => $verifyKey]);
                return response()->json([
                    'status' => HTTP_OK,
                    'message' => 'Key hợp lệ',
                    'redirect' => route('debit.index.fwd')
                ]);
            } else {
                return response()->json([
                    'status' => HTTP_BAD_REQUEST,
                    'message' => 'Key không hợp lệ'
                ]);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => HTTP_BAD_REQUEST,
                'message' => 'Có gì đúng! Vui lòng liên hệ bộ phận phát triển!'
            ]);
        }
    }

    public function showDebitsFwd(Request $request)
    {
        $request_data = $request->all();
        $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;

        try {

            $user = $request->user();

            $debits = Debit::isShow()->where('debits.customer_id', $user['user_id'])
                ->leftJoin('shipments', function ($join) {
                    $join->on('debits.debit_id', '=', 'shipments.shipment_debit_id')
                        ->where('shipments.delete_flg', NO_DELETE)
                        ->where('shipments.active_flg', ACTIVE);
                })
                ->select(
                    'debits.*',
                    DB::raw('SUM(shipment_final_amount + shipment_amount_fsc) as total_price'),
                    DB::raw('SUM(shipment_amount_vat) as total_vat'),
                    DB::raw('SUM(shipment_amount_total_customer) as total_amount_customer'),
                    DB::raw('COUNT(CASE WHEN accountant_status = 0 THEN 1 END) as total_no_confirm'),
                    DB::raw("
                        CASE 
                            WHEN debits.debit_status = 0 THEN 'Chờ thanh toán'
                            WHEN debits.debit_status = 1 THEN 'Đã thanh toán'
                            WHEN debits.debit_status = 2 THEN 'Quá hạn'
                            WHEN debits.debit_status = 3 THEN 'Đang chờ duyệt'
                            ELSE 'Không xác định'
                        END as status_label
                    "),
                    DB::raw("
                        CASE 
                            WHEN debits.debit_type = 1 THEN 'DAY'
                            WHEN debits.debit_type = 2 THEN 'WEEK'
                            WHEN debits.debit_type = 3 THEN '2 WEEK'
                            WHEN debits.debit_type = 4 THEN 'MONTH'
                            ELSE 'Không xác định'
                        END as type_label
                    ")
                );
            if (isset($request_data['filters'])) {
                $filters = $request_data['filters'];
                if (isset($filters['keywords']) && $filters['keywords'] != '') {
                    $keywords = convertSearchString($filters['keywords']);
                    $debits = $debits->where(function ($qr) use ($keywords) {
                        return $qr->where('debit_no', 'like', $keywords);
                    });
                }

                if (isset($filters['debit_status'])) {
                    switch ($filters['debit_status']) {
                        case 0:
                        case 1:
                            $debits = $debits->where('debits.debit_status', $filters['debit_status']);
                            break;

                        case 2:
                            $debits = $debits->where('debits.debit_status', $filters['debit_status'])
                                ->whereNull('debits.debit_advance_date');
                            break;

                        case 3:
                            $debits = $debits->whereNotNull('debits.debit_advance_date')
                                ->where('debits.debit_status', '!=', 1);
                            break;
                        default:
                            # code...
                            break;
                    }
                }

                if (
                    (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                    && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
                ) {
                    $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                    $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                    $debits = $debits->whereBetween("debits.created_at", [$start_date, $end_date]);
                }
            };
            $debits = $debits
                ->groupBy('debit_id')->orderBy('debits.created_at', 'desc')
                ->isPaginate($request_data['paginate']);
            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'debits' => $debits->toArray()['data']
                ]);
            } else {
                $html = view('debit-fwd.debit-paginate', compact('debits'))->render();
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html,
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }


    public function displayListDebit()
    {
        $this->updateDebitStatus();
        return viewBaoTri();
        return view('accounting-management.manager-debit.list-debit');
    }

    private function updateDebitStatus()
    {
        try {
            $debit_day = Debit::isShow()->where('debit_status', 0)
                ->where(function ($query) {
                    $query->where('debit_type', DEBIT_TYPE_DAY)
                        ->whereDate('created_at', '!=', Carbon::today());
                })
                ->orWhere(function ($query) {
                    $query->where('debit_type', DEBIT_TYPE_WEEK1)
                        ->whereNotBetween('created_at', [Carbon::now()->subWeek(), Carbon::now()]);
                })
                ->orWhere(function ($query) {
                    $query->where('debit_type', DEBIT_TYPE_WEEK2)
                        ->whereNotBetween('created_at', [Carbon::now(2)->subWeek(), Carbon::now()]);
                })
                ->orWhere(function ($query) {
                    $query->where('debit_type', DEBIT_TYPE_DAY)
                        ->whereNotBetween('created_at', [Carbon::now()->subMonth(), Carbon::now()]);
                })
                // ->whereDate('created_at', '!=', Carbon::today())
                // ->orWhereNotBetween('created_at', [Carbon::now()->subWeek(), Carbon::now()])
                // ->orWhereNotBetween('created_at', [Carbon::now()->subWeek(2), Carbon::now()])
                // ->orWhereNotBetween('created_at', [Carbon::now()->subMonth(), Carbon::now()])
                ->update(['debit_status' => 2]);

            Debit::isShow()->where('debit_status', '!=', 1)
                ->whereNotNull('debit_payment_date')
                ->update(['debit_status' => 1]);
        } catch (\Throwable $th) {
        }
    }

    private function  queryDebitList($request_data)
    {

        $query = Debit::isShow()
            ->leftJoin('users as customer', 'debits.customer_id', 'customer.user_id')
            ->leftJoin('users as creator', 'debits.created_by', 'creator.user_id')
            // ->leftJoin('checked_payment_cashs', 'debits.debit_no', 'checked_payment_cashs.code')
            ->leftJoin('checked_payment_cashs', function ($join) {
                $join->on('debits.debit_no', '=', 'checked_payment_cashs.code')
                    ->where('checked_payment_cashs.delete_flg', NO_DELETE)
                    ->where('checked_payment_cashs.active_flg', ACTIVE);
            })
            ->leftJoin('shipments', function ($join) {
                $join->on('debits.debit_id', '=', 'shipments.shipment_debit_id')
                    ->where('shipments.delete_flg', NO_DELETE)
                    ->where('shipments.active_flg', ACTIVE);
            })
            ->select(
                'customer.user_company_name as customer_company',
                'customer.position_id as customer_position_id',
                'customer.user_code as customer_code',
                'creator.user_contact_name as creator_name',
                DB::raw('SUM(shipment_final_amount + shipment_amount_fsc) as total_price'),
                DB::raw('SUM(shipment_amount_vat) as total_vat'),
                DB::raw('SUM(shipment_amount_fsc) as total_fsc'),
                DB::raw('SUM(shipment_amount_total_customer) as total_amount_customer'),
                DB::raw('COUNT(CASE WHEN accountant_status = 0 THEN 1 END) as total_no_confirm'),
                // 'debit_id',
                // 'debit_no',
                // 'debit_status',
                // 'debit_type',
                // 'debit_note',
                // 'debit_images',
                // 'debits.customer_id',
                // 'debits.created_at',
                // 'debits.debit_advance_images',
                // 'debits.debit_advance_amount',
                'checked_payment_cashs.checked as admin_confirm',
                'debits.*',
                DB::raw("
                    CASE 
                        WHEN debits.debit_status = 0 THEN 'Chờ thanh toán'
                        WHEN debits.debit_status = 1 THEN 'Đã thanh toán'
                        WHEN debits.debit_status = 2 THEN 'Quá hạn'
                        WHEN debits.debit_status = 3 THEN 'Đang chờ duyệt'
                        ELSE 'Không xác định'
                    END as status_label
                "),
                DB::raw("
                    CASE 
                        WHEN debits.debit_type = 1 THEN 'DAY'
                        WHEN debits.debit_type = 2 THEN 'WEEK'
                        WHEN debits.debit_type = 3 THEN '2 WEEK'
                        WHEN debits.debit_type = 4 THEN 'MONTH'
                        ELSE 'Không xác định'
                    END as type_label
                ")
            );
        if (isset($request_data['filters'])) {
            $filters = $request_data['filters'];
            $keywords = convertSearchString($filters['keywords'] ?? '');

            if (isset($filters['filter_by'])) {
                $filter_by = $filters['filter_by'];
                $key_filter = [
                    "debit_no" => "debits.debit_no",
                    "customer_code" => "customer.user_code",
                    "customer_company" => "customer.user_company_name",
                    "creator_name" => "creator.user_contact_name",
                ];
                $query = $query->where($key_filter[$filter_by], 'like', $keywords);
            } else {
                $query = $query->where(function ($qr) use ($keywords) {
                    return $qr->where('customer.user_company_name', 'like', $keywords)
                        ->orWhere('customer.user_code', 'like', $keywords)
                        ->orWhere('creator.user_contact_name', 'like', $keywords)
                        ->orWhere('debit_no', 'like', $keywords);
                });
            }
            if (isset($filters['admin_confirm']) && $filters['admin_confirm'] != "") {
                $query = $query->where('debits.checked_payment_status', $filters['admin_confirm']);
            }

            if (isset($filters['debit_status'])) {
                switch ($filters['debit_status']) {
                    case 0:
                    case 1:
                        $query = $query->where('debits.debit_status', $filters['debit_status']);
                        break;

                    case 2:
                        $query = $query->where('debits.debit_status', $filters['debit_status'])
                            ->whereNull('debits.debit_advance_date');
                        break;

                    case 3:
                        $query = $query->whereNotNull('debits.debit_advance_date')
                            ->where('debits.debit_status', '!=', 1);
                        break;
                    default:
                        # code...
                        break;
                }
            }

            if (isset($filters['debit_account'])) {
                $query = $query->where('debits.debit_account', $filters['debit_account']);
            }
            if (
                (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
            ) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                $query = $query->whereBetween("debits.created_at", [$start_date, $end_date]);
            }

            if (isset($filters['debit_type']) && $filters['debit_type'] != "") {
                $query = $query->where("debits.debit_type", $filters['debit_type']);
            }

            if (!onCheckPositionAccount(SETTING_ACCOUNT_DEBITS, auth()->user()['position_id']) || !isGetAllData()) {
                $query = $query->where('debits.customer_id', auth()->id());
            }

            return $query;
        };
    }

    public function showListDebit(Request $request)
    {
        $request_data = $request->all();
        $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
        try {
            // $data_debits = $this->queryDebitList($request_data)->groupBy('debit_id')->get()->toArray();

            // $number_pendding = collect($data_debits)->where('debit_status', 0)->count();
            // $price_pendding = collect($data_debits)->where('debit_status', 0)->sum('total_price');
            // $number_success = collect($data_debits)->where('debit_status', 1)->count();
            // $price_success = collect($data_debits)->where('debit_status', 1)->sum('total_price');
            // $number_warning = collect($data_debits)->where('debit_status', 2)->count();
            // $price_warning = collect($data_debits)->where('debit_status', 2)->sum('total_price');

            // $header_debit = [
            //     "number_pendding" => $number_pendding,
            //     "price_pendding" => $price_pendding,
            //     "number_success" => $number_success,
            //     "price_success" => $price_success,
            //     "number_warning" => $number_warning,
            //     "price_warning" => $price_warning,
            // ];
            // $data_chart = [
            //     "labels" => ['Chờ xác nhận', 'Đã thanh toán', 'Quá hạn'],
            //     "series" => [$price_pendding, $price_success, $price_warning],
            //     "colors" => ['#6c757d', '#28a745', '#dc3545'],
            // ];

            $debits = $this->queryDebitList($request_data);
            $debits = $debits->groupBy('debit_id')->orderBy('debits.created_at', 'desc');
            if (isset($request_data['export_excel']) && json_decode($request_data['export_excel'])) {
                $data = $debits->get()->toArray();
                $viewName = 'accounting-management.manager-debit.excels.debits';
                $name_excel = $request_data['name_excel'] ?? 'export.xlsx';
                return Excel::download(new ExportFile($data, $viewName), $name_excel);
            }

            $debits = $debits->isPaginate($request_data['paginate']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'debits' => $debits->toArray()['data']
                ]);
            } else {
                $is_cancel = false;
                if (isGetAllData()) {
                    $is_cancel = isset($request_data['is_cancel']) ? json_decode($request_data['is_cancel']) : false;
                }
                $html = view('accounting-management.manager-debit.ajax.table-debits', compact('debits', 'is_cancel'))->render();
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html,
                    // 'header_debit' => $header_debit,
                    // 'chart' => $data_chart,
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function paymentDebit(Request $request)
    {
        $this->validate($request, [
            'debit_no' => 'required|max:25',
        ]);
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
            $user = $is_api ? $request->user() : auth()->user();

            // $debit = Debit::where('debit_no', $request_data['debit_no'])->isShow()->first();
            $debit = Debit::isShow()
                ->where('debit_no', $request_data['debit_no'])
                ->leftJoin('shipments', function ($join) {
                    $join->on('debits.debit_id', '=', 'shipments.shipment_debit_id')
                        ->where('shipments.delete_flg', NO_DELETE)
                        ->where('shipments.active_flg', ACTIVE);
                })
                ->select(
                    DB::raw('COALESCE(SUM(shipment_final_amount), 0) as total_price'),
                    DB::raw('COALESCE(SUM(shipment_amount_total_customer), 0) as total_amount_customer'),
                    DB::raw('COALESCE(SUM(shipment_amount_vat), 0) as total_vat'),
                    'debits.*',
                )
                ->groupBy('debits.debit_id')
                ->first();
            if ($debit) {
                $user_debit = User::find($debit->customer_id);
                if ($debit->customer_id !== $user->user_id && !onCheckPositionAccount(SETTING_FWD_ACCOUNT, $user_debit->position_id)) {
                    return returnResponse(HTTP_BAD_REQUEST, 'Hiện tại chỉ đối tượng nợ mới có thể thanh toán');
                }
                $amount_debit = 0; // số tiền phải thanh toán cho debit

                if (onCheckPositionAccount(SETTING_FWD_ACCOUNT, $user_debit['position_id'])) {
                    $amount_debit = $debit['total_price'] ?? 0;
                } else {
                    $amount_debit = $debit['total_amount_customer'] ?? 0;
                }


                DB::beginTransaction();
                $date_pay = Carbon::now()->format('Y-m-d H:i:s');
                Debit::find($debit->debit_id)->update([
                    'debit_status' => 1,
                    'debit_payment_date' => $date_pay,
                    'debit_payment_amount' => $request_data['debit_payment_amount'] ?? $debit['total_price'],
                    'debit_note' => $request_data['debit_note'] ?? $debit['debit_note'],
                ]);

                $debit = Debit::find($debit->debit_id);

                $debit_no = $debit['debit_no'];

                $sm_update = [
                    'shipment_payment_status' => SUCCESS,
                    'accountant_status' => SUCCESS,
                    'shipment_payment_des' => "Thanh toán qua debit[$debit_no]",
                    'shipment_payment_date' => $date_pay,
                    'shipment_payment_step' => 4,
                ];

                Shipment::isShow()->where('shipment_debit_id', $debit->debit_id)
                    ->update($sm_update);

                if (onCheckPositionAccount(SETTING_FWD_ACCOUNT, $user_debit['position_id'])) {
                    onCreateCheckedPaymentCash(
                        $debit['debit_no'],
                        auth()->id(),
                        $debit['customer_id'],
                        1,
                        $amount_debit,
                        $debit['debit_payment_date'],
                        $debit['payment_method'],
                        $debit['debit_images'],
                        $request_data['bank_amount'] ?? null,
                        $request_data['cash_amount'] ?? null,
                    );
                    // if (isset($debit['debit_advance_date']) && $debit['debit_advance_amount'] > 0) {
                    //     updateUserRemainingLimit2($debit['customer_id'], $debit['debit_advance_amount'], MINUS, 'Thanh toán công nợ mã ' . $debit['debit_no']);
                    // }
                    onUpdateUserRemainingLimit($debit['customer_id']);
                } else {

                    return returnResponse(HTTP_NO_CONTENT, 'Chức năng này đang bảo trì');
                }

                DB::commit();
                return returnResponse(HTTP_OK, 'Thanh toán thành công', 'Thông báo', 'success');
            } else {
                return returnResponse(HTTP_NOT_FOUND, 'Không tìm thấy công nợ');
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            return returnResponse(HTTP_INTERNAL_SERVER_ERROR, 'Xảy ra lỗi không xác định');
        }
    }

    public function onAcountantConfimInDebit(Request $request)
    {
        $this->validate($request, ['debit_id' => 'required|numeric']);
        try {
            $request_data = $request->all();

            if (!isGetAllData()) {
                return returnResponse(HTTP_BAD_REQUEST, 'Bạn ko có đủ quyền hạn');
            }
            DB::beginTransaction();
            Shipment::where('shipment_debit_id', $request_data['debit_id'])
                ->update(['accountant_status' => SUCCESS]);
            DB::commit();
            return returnResponse(HTTP_OK, 'Xác nhận thành công', null, 'success');
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    public function paymentDebits($choosed_debit)
    {

        try {
            if (!is_array($choosed_debit)) {
                return [
                    'status' => HTTP_BAD_REQUEST,
                    'message' => 'Kiểu dữ liệu không chính xác'
                ];
            }
            $debits = Debit::isShow()
                ->whereIn('debit_no', $choosed_debit)
                ->leftJoin('shipments', function ($join) {
                    $join->on('debits.debit_id', '=', 'shipments.shipment_debit_id')
                        ->where('shipments.delete_flg', NO_DELETE)
                        ->where('shipments.active_flg', ACTIVE);
                })
                ->leftJoin('users', 'debits.customer_id', 'users.user_id')
                ->select(
                    DB::raw('COALESCE(SUM(shipment_final_amount + shipment_amount_fsc), 0) as total_price'),
                    DB::raw('COALESCE(SUM(shipment_amount_vat), 0) as total_vat'),
                    'debits.*',
                    'users.position_id',
                )
                ->groupBy('debits.debit_id')
                ->get();
            DB::beginTransaction();
            foreach ($debits as $key => $debit) {
                $pay_date = Carbon::now()->format('Y-m-d H:i:s');
                Debit::find($debit->debit_id)->update([
                    'debit_status' => 1,
                    // 'debit_payment_date' => $pay_date,
                    'debit_payment_amount' => $request_data['debit_payment_amount'] ?? $debit->total_price
                ]);

                $debit_no = $debit['debit_no'];
                $sm_update = [
                    'shipment_payment_status' => SUCCESS,
                    'accountant_status' => SUCCESS,
                    'shipment_payment_des' => "Thanh toán qua debit[$debit_no]",
                    'shipment_payment_date' => $pay_date,
                    'shipment_payment_step' => 4,
                ];
                // if (onCheckPositionAccount(SETTING_FWD_ACCOUNT, $debit->position_id)) {
                //     $sm_update['accountant_status'] = SUCCESS;
                // }

                Shipment::isShow()->where('shipment_debit_id', $debit->debit_id)
                    ->update($sm_update);
                $amount = $debit->total_price ?? 0;

                if (onCheckPositionAccount(SETTING_FWD_ACCOUNT, $debit['position_id'])) {
                    // $customer =  User::find($debit->customer_id);
                    // $remaining_limit =  $customer->user_remaining_limit - $amount;
                    // $customer->update(['user_remaining_limit' => $remaining_limit > 0 ? $remaining_limit : 0]);

                    onCreateCheckedPaymentCash(
                        $debit['debit_no'],
                        auth()->id(),
                        $debit['customer_id'],
                        1,
                        $amount,
                        $pay_date,
                        $debit['payment_method'],
                        $debit['debit_images'],
                    );
                    updateUserRemainingLimit2($debit['customer_id'], $amount, MINUS, 'Thanh toán công nợ mã ' . $debit['debit_no']);
                } else {
                    // $other_content = [
                    //     'content1' => 'Trừ tiền khi thanh toán công nợ mã ' . $debit->debit_no,
                    //     'content2' => 'Cộng tiền dư khi thanh toán công nợ mã ' . $debit->debit_no
                    // ];
                    // updateUserRemainingLimit($debit->customer_id, $amount, $other_content);
                    return returnResponse(HTTP_NO_CONTENT, 'Chức năng này đang bảo trì');
                }
            }
            DB::commit();
            return [
                'status' => HTTP_OK,
                'message' => 'Xác nhận thành công'
            ];
        } catch (\Throwable $th) {
            DB::rollBack();
            return [
                'status' => HTTP_BAD_REQUEST,
                'message' => 'Xảy ra lỗi không xác định'
            ];
        }
    }

    public function sendPaymentDebitFwd(Request $request)
    {
        $this->validate($request, [
            'debit_no' => 'required|max:25',
            'debits_images' => 'required',
            // 'debit_payment_amount' => 'required|numeric|min:0',
            'debit_note' => 'min:0|max:225'
        ]);

        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
            $user = $is_api ? $request->user() : auth()->user();

            // $debit = Debit::where('debit_no', $request_data['debit_no'])->isShow()->first();
            $debit = Debit::isShow()
                ->where('debit_no', $request_data['debit_no'])
                ->first();
            if ($debit) {
                // $user_debit = User::where('customer_id', $debit->customer_id)->first();
                $debit_images = [];
                if (!empty($request_data['debits_images'])) {
                    $debit_images = convertImagesBase64ToDirectory($request_data['debits_images'], PUBLIC_PATH_DEBIT_IMAGE);
                }
                if (empty($debit_images)) {
                    return returnResponse(HTTP_NOT_FOUND, 'Không được để trống hình ảnh');
                }

                DB::beginTransaction();
                $debit_update = Debit::find($debit->debit_id);

                if (isGetAllData()) {
                    $date_pay = Carbon::now()->format('Y-m-d H:i:s');
                    $amount_debit = $request_data['debit_payment_amount'] ?? $debit['total_price'];
                    $debit_no = $debit_update['debit_no'];

                    Debit::find($debit->debit_id)->update([
                        'debit_status' => 1,
                        'debit_payment_date' => $date_pay,
                        'debit_note' => $request_data['debit_note'] ?? null,
                        'debit_images' => empty($debit_images) ? null : json_encode($debit_images),
                        'payment_method' => $request_data['debit_payment_method'] ?? WALLET,
                        'debit_payment_amount' => $amount_debit
                    ]);
                    $debit = Debit::find($debit->debit_id);

                    $sm_update = [
                        'shipment_payment_status' => SUCCESS,
                        'accountant_status' => SUCCESS,
                        'shipment_payment_des' => "Thanh toán qua debit[$debit_no]",
                        'shipment_payment_date' => $date_pay,
                        'shipment_payment_step' => 4,
                    ];

                    Shipment::isShow()->where('shipment_debit_id', $debit_update['debit_id'])
                        ->update($sm_update);

                    onCreateCheckedPaymentCash(
                        $debit['debit_no'],
                        auth()->id(),
                        $debit['customer_id'],
                        1,
                        $amount_debit,
                        $date_pay,
                        $debit['payment_method'],
                        $debit['debit_images'],
                        $request_data['bank_amount'] ?? null,
                        $request_data['cash_amount'] ?? null,
                    );
                    if (isset($debit_update['debit_advance_date']) && $debit_update['debit_advance_amount'] > 0) {
                        updateUserRemainingLimit2($debit['customer_id'], $debit_update['debit_advance_amount'], MINUS, 'Thanh toán công nợ mã ' . $debit_update['debit_no']);
                    }
                } else {
                    Shipment::isShow()->where('shipment_debit_id', $debit->debit_id)
                        ->update([
                            'accountant_status' => SUCCESS,
                            'shipment_payment_step' => 3,
                        ]);

                    $debit_update =  $debit_update->update([
                        'debit_status' => 3, // đang chờ xác nhận
                        'debit_payment_date' => Carbon::now()->format('Y-m-d H:i:s'),
                        'debit_note' => $request_data['debit_note'] ?? null,
                        'debit_images' => empty($debit_images) ? null : json_encode($debit_images),
                        'payment_method' => $request_data['debit_payment_method'] ?? WALLET,
                        'debit_payment_amount' => $request_data['debit_payment_amount']
                    ]);
                }


                DB::commit();
                return returnResponse(HTTP_OK, 'Gửi yêu cầu thanh toán thành công', 'Thông báo', 'success');
            } else {
                return returnResponse(HTTP_NOT_FOUND, 'Không tìm thấy công nợ');
            }
        } catch (\Throwable $th) {
            if (!empty($debit_images)) {
                foreach ($debit_images as $key => $value) {
                    if (File::exists($value)) {
                        File::delete($value);
                    }
                }
            }
            DB::rollBack();
            return returnResponse(HTTP_INTERNAL_SERVER_ERROR, 'Xảy ra lỗi không xác định');
        }
    }

    public function advanceDebit(Request $request)
    {
        $this->validate($request, [
            'debit_no' => 'required|max:25',
            'debit_advance_amount' => 'required|numeric|min:0|max:100000000000',
            'debit_advance_images' => 'required',
            'debit_advance_note' => 'min:0|max:277'
        ]);
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
            $user = $is_api ? $request->user() : auth()->user();
            // $debit = Debit::where('debit_no', $request_data['debit_no'])->isShow()->first();
            $debit = Debit::isShow()
                ->where('debit_no', $request_data['debit_no'])
                ->first();
            if ($debit) {
                $debit_advance_images = [];
                if (!empty($request_data['debit_advance_images'])) {

                    $debit_advance_images = convertImagesBase64ToDirectory($request_data['debit_advance_images'], PUBLIC_PATH_DEBIT_IMAGE);
                }
                if (empty($debit_advance_images)) {
                    return returnResponse(HTTP_NOT_FOUND, 'Không được để trống hình ảnh');
                }

                DB::beginTransaction();
                $debit_update = Debit::find($debit->debit_id);

                $debit_update =  $debit_update->update([
                    'debit_advance_amount' => $request_data['debit_advance_amount'] ?? 0,
                    'debit_advance_note' => $request_data['debit_advance_note'] ?? null,
                    'debit_advance_images' => empty($debit_advance_images) ? null : json_encode($debit_advance_images),
                    'debit_advance_date' => Carbon::now()->format('Y-m-d H:i:s'),

                ]);
                Shipment::isShow()->where('shipment_debit_id', $debit->debit_id)
                    ->update([
                        'accountant_status' => SUCCESS,
                        'shipment_payment_step' => 2,
                    ]);
                DB::commit();
                updateUserRemainingLimit2($debit['customer_id'], $request_data['debit_advance_amount'] ?? 0, PLUS, 'Tạo công nợ mã ' . $debit['debit_no']);
                return returnResponse(HTTP_OK, 'Duyệt tạm ứng thành công', 'Thông báo', 'success');
            } else {
                return returnResponse(HTTP_NOT_FOUND, 'Không tìm thấy công nợ');
            }
        } catch (\Throwable $th) {
            if (!empty($debit_images)) {
                foreach ($debit_images as $key => $value) {
                    if (File::exists($value)) {
                        File::delete($value);
                    }
                }
            }
            DB::rollBack();
            return returnResponse(HTTP_INTERNAL_SERVER_ERROR, 'Xảy ra lỗi không xác định');
        }
    }

    public function displayDebitDetail($debit_code)
    {
        $is_api = request()->is('api/*');
        $debit = Debit::where('debit_no', $debit_code)->isShow()
            ->leftJoin('shipments', function ($join) {
                $join->on('debits.debit_id', '=', 'shipments.shipment_debit_id')
                    ->where('shipments.delete_flg', NO_DELETE)
                    ->where('shipments.active_flg', ACTIVE);
            })
            ->select(
                'shipment_final_amount',
                'shipment_amount_fsc',
                DB::raw('COALESCE(SUM(shipments.shipment_final_amount + IFNULL(shipments.shipment_amount_fsc, 0)), 0) as total_price'),
                DB::raw('COALESCE(SUM(shipments.shipment_amount_vat), 0) as total_vat'),
                DB::raw('COALESCE(SUM(shipments.shipment_amount_fsc), 0) as total_fsc'),
                DB::raw('COUNT(shipments.shipment_id) as total_sm'),
                DB::raw(
                    "CASE
                        WHEN debits.payment_method = 0 THEN 'Tiền mặt'
                        WHEN debits.payment_method = 1 THEN 'Chuyển khoản'
                        WHEN debits.payment_method = 2 THEN 'Ví tài khoản'
                        WHEN debits.payment_method = 3 THEN 'Tiền mặt & Ngân hàng'
                        ELSE 'Other'
                    END as method_label"
                ),
                'debits.*',
            )
            ->groupBy('debits.debit_id')
            ->first();
        $user_debit = User::where('user_id', $debit->customer_id)->first();
        $path = 'public/config/info-debit.json';
        $info_debit = Storage::get($path);
        $info_debit = isset($info_debit) ? json_decode($info_debit, true) : null;
        $content = $info_debit['display'] ?? '';

        if ($is_api) {
            return response()->json([
                'status' => HTTP_OK,
                'debit' => $debit,
                'user_debit' => $user_debit,
                'content' => $content,
            ]);
        }

        if ($debit) {
            return view('accounting-management.manager-debit.debit-detail', compact('debit', 'user_debit', 'content'));
        } else {
            abort('404');
        }
    }

    public function showListShipmentDebit(Request $request)
    {
        $request_data = $request->all();
        $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;

        try {
            $shipments = Shipment::isShow()->isFilters($request_data['filters']);

            if (isset($request_data['debit_id'])) {
                $shipments = $shipments->where('shipment_debit_id', $request_data['debit_id']);
            } else if (isset($request_data['user_id'])) {
                $shipments = $shipments->where('user_id', $request_data['user_id']);
            }


            $shipments = $shipments->isPaginate($request->paginate);
            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'debits' => $shipments->toArray()['data']
                ]);
            } else {

                if (isset($request_data['debit_id'])) {
                    $html = view('accounting-management.manager-debit.ajax.table-detail-debit', compact('shipments'))->render();
                } else if (isset($request_data['user_id'])) {
                    $html = view('accounting-management.manager-debit.ajax.table-customer-shipment', compact('shipments'))->render();
                }

                return response()->json([
                    "status" => HTTP_OK,
                    "html" => $html
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function displayCustomerDetail($user_code)
    {
        $user = User::isShow()->where('user_code', $user_code)->first();
        if ($user) {
            $packages = Package::isShow()
                ->leftJoin('shipments', 'packages.shipment_id', 'shipments.shipment_id')
                ->where('shipments.delete_flg', NO_DELETE)->where('shipments.active_flg', ACTIVE)
                ->select(
                    DB::raw('SUM(package_charged_weight) as total_weight'),
                    DB::raw('COUNT(packages.package_id) as total_package'),
                )->groupBy('packages.package_id')->first();
            $branchs = Branch::isShow()->get();
            $shipment_status = config('constans.constans.shipment_status');
            $shipment_filter_by = config('constans.constans.shipment_filter_by');
            return view('accounting-management.manager-debit.customer', compact('user', 'packages', 'branchs', 'shipment_status', 'shipment_filter_by'));
        } else {
            abort('404');
        }
    }

    public function displaySubPackage()
    {
        return view('accounting-management.manager-debit.edit-package');
    }

    public function displayListImport()
    {
        return view('accounting-management.manager-debit.list-import');
    }

    public function displayImportedGoodsDetail($package_code)
    {
        $package = null;
        $shipment = null;
        $package_types = null;
        $surcharge_goods_list = null;
        $package_surcharge_goods = null;
        $package_external_surcharge_goods = null;

        try {
            $package = Package::isShow()->where('package_code', $package_code)
                ->leftJoin('shipments', 'packages.shipment_id', 'shipments.shipment_id')
                ->first();
            $shipment = Shipment::isShow()->where('shipment_id', $package->shipment_id)->first();
            $package_types = config('constans.constans.package_types');
            $surcharge_goods_list = SurchargeGoods::isShow()->get();
            $package_surcharge_goods = PackageSg::isShow()->where('package_id', $package->package_id)->where('surcharge_type', INTERNAL_SURCHARGE)->get();
            $package_external_surcharge_goods = PackageSg::isShow()->where('package_id', $package->package_id)->where('surcharge_type', EXTERNAL_SURCHARGE)->get();
            return view('shipment.detail-imported-goods', compact('package', 'shipment', 'package_types', 'surcharge_goods_list', 'package_surcharge_goods', 'package_external_surcharge_goods'));
        } catch (\Throwable $th) {
            return viewError404();
        }
    }

    // Của FWD

    public function displayListDebitFwd()
    {
        $services = Service::isShow()->select('service_id', 'service_name')->get();
        return view('accounting-management.manager-debit.fwd.index', compact('services'));
    }

    public function displayListShipmentFwd()
    {
        $fwds = User::isShow()->where('position_id', getPositionAccountSetting(SETTING_FWD_ACCOUNT))->get();
        return view('accounting-management.manager-debit.fwd.shipments-fwd', compact('fwds'));
    }

    public function displayImportedGoods()
    {
        return view('accounting-management.manager-debit.fwd.imported-goods');
    }

    public function showListShipmentFwd(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $user = $is_api ? $request->user() : auth()->user();
            $path = 'public/config/system-settings.json';
            $is_view_all_shipment = isGetAllData();
            $filters = isset($request_data['filters']) ? (is_array($request_data['filters']) ? $request_data['filters'] : json_decode($request_data['filters'], true)) : [];

            $shipments = Shipment::with(['service', 'branch', 'country', 'packages', 'debit'])
                ->isShow()
                ->leftJoin('users', 'shipments.user_id', 'users.user_id')
                ->where('users.position_id', getPositionAccountSetting(SETTING_FWD_ACCOUNT));

            $shipments = $shipments->orderBy('shipments.created_at', 'desc');

            if (
                (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
            ) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                $shipments->whereBetween("shipments.created_at", [$start_date, $end_date]);
            }

            if (isset($filters['keywords']) && $filters['keywords'] != "") {
                $shipments->where(function ($query) use ($filters) {
                    return $query->where('shipments.sender_company_name', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('shipments.receiver_contact_name', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('users.user_api_key', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('users.user_contact_name', 'like', '%' . $filters['keywords'] . '%');
                });
            }

            if (isset($filters['payment_status']) && $filters['payment_status'] != "") {
                switch ($filters['payment_status']) {
                    case 0:
                        $shipments = $shipments->where('shipments.shipment_payment_status', 0)
                            ->where('shipments.shipment_payment_step', 0);
                        break;

                    case 1:
                        $shipments = $shipments->where('shipments.shipment_payment_status', 1);
                        break;

                    case 2:
                        $shipments = $shipments->where('shipments.shipment_payment_status', 0)
                            ->where('shipments.shipment_payment_step', '>', 0);
                        break;

                    default:
                        # code...
                        break;
                }
            }

            $shipments = $shipments->select('shipments.*', 'users.user_contact_name', 'users.user_company_name', 'users.user_code')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'shipments' => $shipments,
                ]);
            } else {
                $html = view('accounting-management.manager-debit.ajax.table-shipment', compact('shipments'))->render();
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function showImportedGoods(Request $request)
    {

        try {
            $request_data = $request->all();
            $filters = isset($request_data['filters']) ?
                (is_array($request_data['filters']) ?
                    $request_data['filters'] :
                    json_decode($request_data['filters'], true)) : [];

            $importedGoods = Package::leftJoin('history_scan', 'history_scan.package_id', 'packages.package_id')
                ->leftJoin('users', 'history_scan.scan_by', 'users.user_id')
                ->leftJoin('shipments', 'packages.shipment_id', 'shipments.shipment_id')
                ->leftJoin('users as creator', 'shipments.user_id', 'creator.user_id')
                ->leftJoin('countries', 'shipments.receiver_country_id', 'countries.country_id')
                ->leftJoin('services', 'shipments.shipment_service_id', 'services.service_id')
                ->where('packages.delete_flg', NO_DELETE)
                ->where('packages.active_flg', ACTIVE)
                ->where('history_scan.delete_flg', NO_DELETE)
                ->where('history_scan.active_flg', ACTIVE)
                ->where('packages.package_status', '!=', SHIPMENT_STATUS_CREATE)

                ->when(isset($filters['date_range']['start_date']) && isset($filters['date_range']['end_date']), function ($query) use ($filters) {
                    $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                    $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                    return $query->whereBetween('history_scan.created_at', [$start_date, $end_date]);
                })
                ->when(isset($filters['keywords']) && $filters['keywords'] != "", function ($query) use ($filters) {
                    return $query->where(function ($query) use ($filters) {
                        $keywords = isset($filters['keywords']) ? $filters['keywords'] : '';
                        return $query->where('packages.package_code', 'like', '%' . $keywords . '%')
                            ->orWhere('users.user_contact_name', 'like', '%' . $keywords . '%')
                            ->orWhere('creator.user_code', 'like', '%' . $keywords . '%')
                            ->orWhere('countries.country_name', 'like', '%' . $keywords . '%')
                            ->orWhere('services.service_name', 'like', '%' . $keywords . '%')
                            ->orWhere('shipments.sender_company_name', 'like', '%' . $keywords . '%');
                    });
                });
            if (isset($filters['status']) && $filters['status'] != "") {
                if ($filters['status'] == 2) {
                    $thirtyDaysAgo = Carbon::now()->subDays(30);
                    $importedGoods = $importedGoods->where(function ($query) use ($thirtyDaysAgo) {
                        $fwd_position_id = onGetPositionIdFWDAccount();
                        $query->where('history_scan.status', 2)
                            ->whereNull('shipments.shipment_debit_id')
                            ->where('history_scan.created_at', '<', $thirtyDaysAgo)
                            ->where('users.position_id', $fwd_position_id);
                    });
                } else {
                    $importedGoods = $importedGoods->where('shipments.shipment_payment_status', $filters['status']);
                }
            }


            $importedGoods = $importedGoods->select(
                DB::raw("CASE WHEN history_scan.status = 1 THEN history_scan.created_at ELSE NULL END as created_at"),
                'packages.package_code as package_code',
                'users.user_contact_name as scan_by_name',
                'creator.user_code as creator_code',
                'creator.position_id as creator_position_id',
                'shipments.sender_company_name as sender_company_name',
                'countries.country_name as country_name',
                'services.service_name as service_name',
                'packages.package_height as height',
                'packages.package_width as width',
                'packages.package_length as length',
                'packages.package_charged_weight as weight',
                'shipments.shipment_payment_status as status'
            );


            $importedGoods = $importedGoods
                ->orderBy('shipments.shipment_payment_status', 'asc')
                ->orderBy('history_scan.created_at', 'desc')
                ->groupBy('packages.package_code')
                ->isPaginate(['limit' => $request_data['limit'], 'page' => $request_data['page']]);

            $html = view('accounting-management.manager-debit.ajax.table-imported-goods', compact('importedGoods'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function updateInternalSurcharge(Request $request, $package_id)
    {
        $formData = json_decode($request->getContent(), true);
        try {
            $package = Package::find($package_id);
            $user = $request->user();

            $shipment = Shipment::where('shipment_id', $package['shipment_id'])
                ->leftJoin('services', 'shipment_service_id', 'service_id')
                ->select('service_id', 'promotion_flg')->first();
            if (onCheckIsEpacket($shipment['service_id'], $shipment['promotion_flg'])) {
                return returnResponse(HTTP_BAD_REQUEST, 'Kiện hàng epacket không thể cập nhật khi đã xác nhận', null, 'warning');
            }

            DB::beginTransaction();
            // Delete existing surcharges with type INTERNAL_SURCHARGE
            PackageSg::where('package_id', $package_id)
                ->where('surcharge_type', INTERNAL_SURCHARGE)
                ->delete();

            // Create new surcharges
            foreach ($formData['surcharge'] as $data) {
                PackageSg::create([
                    'package_id' => $package_id,
                    'surcharge_goods_id' => $data['surcharge_id'],
                    'count' => $data['surcharge_amount'],
                    'price' => $data['surcharge_price'],
                    'surcharge_type' => INTERNAL_SURCHARGE,
                ]);
            }
            onCreateHistoryShipment($package['shipment_id'], $user['user_id'], 'Cập nhật hàng hóa phụ thu');
            onUpdateFinalAmountShipment($package['shipment_id']);
            DB::commit();

            return response()->json([
                'status' => HTTP_OK,
                'message' => 'Thêm mặt hàng phụ thu thành công'
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return response()->json([
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'message' => 'Thêm mặt hàng phụ thu thất bại',
                'error' => $th->getMessage()
            ]);
        }
    }

    public function updateExternalSurcharge(Request $request, $package_id)
    {
        $request_data = json_decode($request->getContent(), true);
        try {
            $package = Package::find($package_id);

            $shipment = Shipment::where('shipment_id', $package['shipment_id'])
                ->leftJoin('services', 'shipment_service_id', 'service_id')
                ->select('service_id', 'promotion_flg')->first();
            if (onCheckIsEpacket($shipment['service_id'], $shipment['promotion_flg'])) {
                return returnResponse(HTTP_BAD_REQUEST, 'Kiện hàng epacket không thể cập nhật khi đã xác nhận', null, 'warning');
            }

            $user = $request->user();

            DB::beginTransaction();
            // Delete existing surcharges with type EXTERNAL_SURCHARGE
            PackageSg::where('package_id', $package_id)
                ->where('surcharge_type', EXTERNAL_SURCHARGE)
                ->delete();

            // Create new surcharges
            foreach ($request_data['external_surcharge'] as $data) {
                PackageSg::create([
                    'package_id' => $package_id,
                    'external_surcharge_name' => $data['external_surcharge_name'],
                    'count' => $data['external_surcharge_quantity'],
                    'external_surcharge_unit_price' => $data['external_surcharge_unit_price'],
                    'price' => $data['external_surcharge_unit_price'],
                    'surcharge_type' => EXTERNAL_SURCHARGE,
                ]);
            }
            onCreateHistoryShipment($package['shipment_id'], $user['user_id'], 'Cập nhật hàng hóa phụ thu');
            onUpdateFinalAmountShipment($package['shipment_id']);
            DB::commit();

            return response()->json([
                'status' => HTTP_OK,
                'message' => 'Thêm mặt hàng phụ thu ngoài hệ thống thành công'
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return response()->json([
                'status' => HTTP_INTERNAL_SERVER_ERROR,
                'message' => 'Thêm mặt hàng phụ thu ngoài hệ thống thất bại',
                'error' => $th->getMessage()
            ]);
        }
    }

    public function showListPackagesImportFwd(Request $request)
    {
        try {


            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $user = $is_api ? $request->user() : auth()->user();
            $path = 'public/config/system-settings.json';
            $is_view_all_shipment = isGetAllData();
            $filters = isset($request_data['filters']) ? (is_array($request_data['filters']) ? $request_data['filters'] : json_decode($request_data['filters'], true)) : [];


            $histories = HistoryScan::isShow()
                ->leftJoin('packages', 'history_scan.package_id', 'packages.package_id')
                ->leftJoin('shipments', 'packages.shipment_id', 'shipments.shipment_id')
                ->leftJoin('users as scaner', 'history_scan.scan_by', 'scaner.user_id')
                ->leftJoin('countries', 'shipments.receiver_country_id', 'countries.country_id')
                ->leftJoin('services', 'shipments.shipment_service_id', 'services.service_id')
                ->leftJoin('users', 'shipments.user_id', 'users.user_id')
                ->where('shipments.delete_flg', NO_DELETE)
                ->where('shipments.active_flg', ACTIVE)
                ->where('packages.package_status', SHIPMENT_STATUS_IMPORTED);

            if ($filters) {
                $histories = $histories->where(function ($query) use ($filters) {
                    $keywords = isset($filters['keywords']) ? $filters['keywords'] : '';
                    return $query->where('users.user_name', 'like', '%' . $keywords . '%')
                        ->orWhere('users.user_contact_name', 'like', '%' . $keywords . '%')
                        ->orWhere('packages.package_hawb_code', 'like', '%' . $keywords . '%')
                        ->orWhere('services.service_name', 'like', '%' . $keywords . '%')
                        ->orWhere('shipments.sender_company_name', 'like', '%' . $keywords . '%');
                });
            }
            $check_over_time = isset($request_data['over_time']);
            if ($check_over_time) {
                $time = is_numeric($request_data['over_time']) ? (int) $request_data['over_time'] : 48;
                $timeLimit = Carbon::now()->subHours($time)->format('Y-m-d H:i:s');
                $histories = $histories->where('history_scan.updated_at', '<', $timeLimit);
            }

            $histories = $histories->orderBy('history_scan.created_at', 'desc')
                ->select(
                    'shipments.receiver_contact_name',
                    'shipments.sender_contact_name',
                    'packages.*',
                    'users.user_name',
                    'scaner.user_contact_name as scan_by_name',
                    'scan_by',
                    'countries.country_name',
                    'services.service_name',
                    'history_scan_id',
                    'history_scan.created_at as scan_at',
                    DB::raw("
                    CASE 
                        WHEN packages.package_status = 0 THEN 'created_bill'
                        WHEN packages.package_status = 1 THEN 'imported'
                        WHEN packages.package_status = 3   THEN 'returned'
                        WHEN packages.package_status = 2 THEN 'expored'
                        ELSE 'Không xác định'
                    END as status_label
                    ")
                );

            $histories = $histories->isPaginate(isset($request_data['paginate']) ? $request_data['paginate'] : null);
            if ($is_api) {
                return response()->json([
                    'status' => 200,
                    'data' => $histories->toArray()['data']
                ]);
            }


            switch ($request_data['status']) {
                case SHIPMENT_STATUS_IMPORTED:
                    if ($check_over_time) {
                        $html = view('scan-system.ajax.tables-import', compact('histories'))->render();
                    }
                    break;

                case SHIPMENT_STATUS_EXPORED:
                    # code...
                    break;

                case SHIPMENT_STATUS_RETURNED:
                    # code...
                    break;
                default:
                    return response()->json([
                        'status' => HTTP_OK,
                        'html' => null
                    ]);
                    break;
            }

            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    // Tạo tự động
    public function createDebitFwd(Request $request)
    {
        return returnResponse(HTTP_NOT_FOUND, 'Chức năng đang bảo trì', null, 'warning');
        $this->validate($request, ['fwd_id' => 'required|numeric']);

        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $user = User::find($request_data['fwd_id']);

            if (!isGetAllData()) {
                return returnResponse(HTTP_BAD_REQUEST, 'Bạn không có quyền để sử dụng chức năng này');
            }
            $sm = Shipment::isShow()->where('user_id', $request_data['fwd_id'])
                ->leftJoin('services', 'shipments.shipment_service_id', 'services.service_id')
                ->where('services.promotion_flg', '!=', IS_EPACKET)
                ->where('shipment_payment_status', 0)->whereNull('shipment_debit_id')->first();
            if (!$sm) {
                return returnResponse(HTTP_BAD_REQUEST, 'Hiện tại không có đơn hàng nào để tạo debit?', null, 'warning');
            }
            $debit = Debit::create([
                "debit_no" => initializationCode('debits', 'debit_id', 'DBN'),
                "customer_id" => $request_data['fwd_id'],
                "created_by" => auth()->id(),
                "debit_type" => $user->user_debit_type,
                "debit_account" => 1
            ]);


            Shipment::isShow()->where('user_id', $request_data['fwd_id'])
                ->leftJoin('services', 'shipments.shipment_service_id', 'services.service_id')
                ->where('services.promotion_flg', '!=', IS_EPACKET)
                ->where('shipment_payment_status', 0)->whereNull('shipment_debit_id')
                ->update([
                    "shipment_debit_id" => $debit->debit_id,
                ]);

            return returnResponse(HTTP_OK, 'Khởi tạo debit thành công', null, 'success');
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    // Chọn shipment để tạo
    public function createDebitFwd2(Request $request)
    {
        $this->validate($request, [
            'fwd_id' => 'required|numeric',
            'shipment_ids' => 'required',
            'debit_vat' => 'required|numeric|min:0|max:100',
        ]);
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $user = User::find($request_data['fwd_id']);

            $has_fsc = isset($request_data['has_fsc']) ? json_decode($request_data['has_fsc']) : false;
            $debit_fsc = $has_fsc ? $request_data['debit_fsc'] : 0;

            if ($has_fsc && (!is_numeric($debit_fsc) ||  $debit_fsc < 0 || $debit_fsc > 100)) {
                return returnResponse(HTTP_BAD_REQUEST, 'Giá trị fsc phải là 1 số và phải nằm trong khoảng 0 -> 100', null, 'warning');
            }

            if (!onCheckPositionAccount(SETTING_FWD_ACCOUNT, $user['position_id'])) {
                return returnResponse(HTTP_BAD_REQUEST, 'Đây không phải tài khoản FWD', null, 'warning');
            }

            if (!isGetAllData()) {
                return returnResponse(HTTP_BAD_REQUEST, 'Bạn không có quyền để sử dụng chức năng này', null, 'warning');
            }
            $sm = Shipment::isShow()->where('user_id', $request_data['fwd_id'])
                ->whereIn('shipment_id', $request_data['shipment_ids'])
                ->where('shipment_payment_status', 0)->whereNull('shipment_debit_id')
                ->first();
            if (!$sm) {
                return returnResponse(HTTP_BAD_REQUEST, 'Không có kiện hàng nào hợp lệ khi kiểm tra', null, 'warning');
            }

            $user_debit_type = DEBIT_TYPE_DAY;
            if (isset($user['user_debit_type']) && in_array($user['user_debit_type'], [
                DEBIT_TYPE_DAY,
                DEBIT_TYPE_WEEK1,
                DEBIT_TYPE_WEEK2,
                DEBIT_TYPE_MONTH
            ])) {
                $user_debit_type = $user['user_debit_type'];
            }
            $debit = Debit::create([
                "debit_no" => initializationCode('debits', 'debit_id', 'DBN'),
                "customer_id" => $request_data['fwd_id'],
                "created_by" => auth()->id(),
                "debit_type" => $user_debit_type,
                "debit_fsc" => $debit_fsc,
                "debit_account" => 1
            ]);


            $sm_update = Shipment::isShow()->where('user_id', $request_data['fwd_id'])
                ->whereIn('shipment_id', $request_data['shipment_ids'])
                ->where('shipment_payment_status', 0)->whereNull('shipment_debit_id')
                ->select(
                    'shipment_id',
                    'shipment_domestic_charges',
                    'shipment_amount_surcharge',
                    'shipment_collection_fee',
                    'shipment_amount_insurance',
                    'shipment_amount_original',
                    'shipment_amount_operating_costs',
                    'shipment_final_amount',
                )
                ->get();
            $amount_debit = 0;
            foreach ($sm_update as $key => $shipment) {
                $vat = $request_data['debit_vat'] ?? 0;
                $amount_vat = $shipment->shipment_amount_original * $vat / 100;
                $price_fsc = $shipment->shipment_amount_original * ($vat > 0 ? VAT : 1) * ($debit_fsc / 100);
                // dd( $shipment->shipment_amount_original, ($vat > 0 ? VAT : 1), ($debit_fsc/100), $price_fsc);
                $shipment_final_amount = $shipment->shipment_final_amount + $amount_vat;
                $amount_debit = $amount_debit + $shipment_final_amount + $price_fsc;

                $shipment_update = [
                    "shipment_debit_id" => $debit->debit_id,
                    "shipment_amount_vat" => $amount_vat,
                    "shipment_amount_fsc" => $price_fsc,
                    "shipment_final_amount" => $shipment_final_amount,
                ];

                $surcharge = hasSurchargeFeeService($shipment['shipment_id']);
                if ($surcharge) {
                    $shipment_update['shipment_amount_residential'] = 150000;
                } else {
                    $shipment_update['shipment_amount_residential'] = 0;
                    $shipment_update['shipment_amount_peak'] = 0;
                }
                Shipment::find($shipment->shipment_id)
                    ->update($shipment_update);
            }

            updateUserRemainingLimit2(
                $user['user_id'],
                $amount_debit,
                PLUS,
                'Khởi tạo công nợ mã ' .  $debit['debit_no']
            );

            DB::commit();
            return returnResponse(HTTP_OK, 'Khởi tạo debit thành công', null, 'success');
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    public function onCancelDebit(Request $request)
    {
        $this->validate($request, [
            'debit_id' => 'required|numeric',
        ]);
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            if (!onCheckPositionAccounts([SETTING_ADMIN_ACCOUNT, SETTING_ACCOUNTANT_ACCOUNT, SETTING_DOCUMENT_ACCOUNT], auth()->user()['position_id'])) {
                return returnResponse(HTTP_BAD_REQUEST, 'Bạn không có quyền để sử dụng chức năng này');
            }

            $debit = Debit::isShow()->where('debit_id', $request_data['debit_id'])->first();
            if (!$debit) {
                return returnResponse(HTTP_BAD_REQUEST, 'Không tìm thấy debit');
            }
            if ($debit['debit_status'] == SUCCESS) {
                return returnResponse(HTTP_BAD_REQUEST, 'Đơn đã được thanh toán, không thể xóa');
            }
            $user = User::findOrFail($debit['customer_id']);

            DB::beginTransaction();
            Debit::find($debit->debit_id)->update([
                'delete_flg' => DELETED
            ]);
            $sm = Shipment::isShow()->where('shipment_debit_id', $debit->debit_id)
                ->select(DB::raw('SUM(shipment_final_amount + shipment_amount_fsc) as amount_debit'))
                ->groupBy('shipment_debit_id')->first();
            $amount_debit = $sm['amount_debit'] ?? 0;

            Shipment::isShow()->where('shipment_debit_id', $debit['debit_id'])->update([
                "shipment_debit_id" => null,
                'shipment_payment_step' => 0,
                'shipment_amount_vat' => 0,
                'shipment_amount_fsc' => 0,
            ]);


            // User::find($user['user_id'])
            //     ->update([
            //         'user_remaining_limit' => $user['user_remaining_limit'] - $amount_debit
            //     ]);
            updateUserRemainingLimit2(
                $user['user_id'],
                $amount_debit,
                MINUS,
                'Hoàn lại công nợ mã ' .  $debit['debit_no']
            );

            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => $debit,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Hủy lệnh debit mã ' . $debit['debit_no'], $data_logs);

            onUpdateUserRemainingLimit($user['user_id'], $user);
            DB::commit();
            return returnResponse(HTTP_OK, 'Hủy lệnh thành công', null, 'success');
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }

    function onExportShipmentByDebit(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;

            $filters = $request_data['filters'] ?? [];

            $query = Debit::isShow();
            // ->leftJoin('users as customer', 'debits.customer_id', 'customer.user_id')
            // ->leftJoin('users as creator', 'debits.created_by', 'creator.user_id')
            // ->leftJoin('shipments', function ($join) {
            //     $join->on('debits.debit_id', '=', 'shipments.shipment_debit_id')
            //         ->where('shipments.delete_flg', NO_DELETE)
            //         ->where('shipments.active_flg', ACTIVE);
            // });

            if (isset($request_data['filters'])) {
                $keywords = convertSearchString($filters['keywords'] ?? '');

                // if (isset($filters['filter_by']) && $filters['filter_by'] != "") {
                //     $filter_by = $filters['filter_by'];
                //     $key_filter = [
                //         "debit_no" => "debits.debit_no",
                //         "customer_code" => "customer.user_code",
                //         "customer_company" => "customer.user_company_name",
                //         "creator_name" => "creator.user_contact_name",
                //     ];
                //     $query = $query->where($key_filter[$filter_by], 'like', '%' . $keywords . '%');
                // } else {
                //     $query = $query->where(function ($qr) use ($keywords) {
                //         return $qr->where('customer.user_company_name', 'like', '%' . $keywords . '%')
                //             ->orWhere('customer.user_code', 'like', '%' . $keywords . '%')
                //             ->orWhere('creator.user_contact_name', 'like', '%' . $keywords . '%')
                //             ->orWhere('debit_no', 'like', '%' . $keywords . '%');
                //     });
                // }

                // if (isset($filters['debit_status'])) {
                //     $query = $query->where('debits.debit_status', $filters['debit_status']);
                // }

                // if (isset($filters['debit_account'])) {
                //     $query = $query->where('debits.debit_account', $filters['debit_account']);
                // }

                // if (isset($filters['service_id'])) {
                //     $query = $query->where('shipments.shipment_service_id', $filters['service_id']);
                // }

                if (
                    (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                    && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
                ) {
                    $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                    $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                    $query = $query->whereBetween("debits.created_at", [$start_date, $end_date]);
                }

                // if (isset($filters['debit_type']) && $filters['debit_type'] != "") {
                //     $query = $query->where("debits.debit_type", $filters['debit_type']);
                // }

                // if (!onCheckPositionAccount(SETTING_ACCOUNT_DEBITS, auth()->user()['position_id'])) {
                //     $query = $query->where('debits.customer_id', auth()->id());
                // }


            };

            $debit_ids = $query->groupBy('debit_id')->pluck('debit_id')->toArray();
            $shipment = queryExportExcel();
            // if (isset($filters['service_id'])) {
            //     $shipment = $shipment->where('shipments.shipment_service_id', $filters['service_id']);
            // }
            if (isset($filters['service_ids']) && !empty($filters['service_ids'])) {
                $shipment = $shipment->whereIn('shipments.shipment_service_id', $filters['service_ids']);
            }

            if (
                (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
            ) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                $shipment = $shipment->whereBetween("shipments.created_at", [$start_date, $end_date]);
            }

            $shipment = $shipment->where(function ($qr) use ($debit_ids, $filters) {
                $qr->whereIn('shipment_debit_id', $debit_ids);
                if (
                    isset($filters['date_range']['start_date']) && !empty($filters['date_range']['start_date']) &&
                    isset($filters['date_range']['end_date']) && !empty($filters['date_range']['end_date'])
                ) {
                    $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeString();
                    $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeString();
                    $qr->orWhereBetween("shipments.created_at", [$start_date, $end_date]);
                }

                return $qr;
            });
            $shipment = $shipment->orderBy('shipments.created_at')
                ->groupBy('shipments.shipment_id')->get();

            $data = $shipment;
            $viewName = 'accounting-management.manager-debit.excels.shipments';
            $name_excel = $request_data['name_excel'] ?? 'export.xlsx';
            return Excel::download(new ExportFile($data, $viewName), $name_excel);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function onExportShipmentByDebit2(Request $request)
    {
        $data = $request->all();
        $viewName = view('accounting-management.manager-credit.index');
        $name_excel = $request_data['name_excel'] ?? 'export.xlsx';
        return Excel::download(new ExportFile($data, $viewName), $name_excel);
    }

    public function exportBillDebit(Request $request)
    {
        $data = [];
        $debit_no = $request->query('debit_no');
        $debit = Debit::isShow()->where('debit_no', $debit_no)->first();

        if (!$debit) {
            return response()->json([
                'status' => HTTP_NOT_FOUND,
                'message' => [
                    'icon' => 'error',
                    'title' => 'Thông báo',
                    'text' => 'Không tìm thấy debit'
                ]
            ], HTTP_NOT_FOUND);
        }
        $export_name = $debit_no . '.xlsx';

        $shipments = Shipment::isShow()
            ->where('shipment_debit_id', $debit->debit_id)

            // Subquery cho bảng packages tổng hợp
            ->leftJoin(DB::raw('(
            SELECT 
                shipment_id,
                GROUP_CONCAT(package_tracking_code ORDER BY package_tracking_code ASC SEPARATOR ", ") AS list_tracking,
                COUNT(package_id) AS count_package,
                GROUP_CONCAT(package_code ORDER BY package_code ASC SEPARATOR ", ") AS list_package_code,
                SUM(package_charged_weight) AS sum_package_charged_weight
            FROM packages
            WHERE delete_flg = ' . NO_DELETE . ' 
                AND active_flg = ' . ACTIVE . ' 
                AND package_status != ' . SHIPMENT_STATUS_RETURNED . ' 
            GROUP BY shipment_id
        ) AS package_summary'), function ($join) {
                $join->on('shipments.shipment_id', '=', 'package_summary.shipment_id');
            })

            // Subquery cho bảng invoices tổng hợp
            ->leftJoin(DB::raw('(
            SELECT 
                shipment_id,
                GROUP_CONCAT(CONCAT(invoice_goods_details, " [", invoice_quantity, "]") ORDER BY invoice_goods_details ASC SEPARATOR ", ") AS list_items
            FROM invoices
            GROUP BY shipment_id
        ) AS invoice_summary'), function ($join) {
                $join->on('shipments.shipment_id', '=', 'invoice_summary.shipment_id');
            })

            // Join với các bảng đơn giản không cần xử lý tổng hợp
            ->leftJoin('services', 'shipments.shipment_service_id', '=', 'services.service_id')
            ->leftJoin('branchs', 'shipments.shipment_branch_id', '=', 'branchs.branch_id')
            ->leftJoin('states', 'shipments.receiver_state_id', '=', 'states.state_id')
            ->leftJoin('countries', 'shipments.receiver_country_id', '=', 'countries.country_id')

            // Chọn các cột dữ liệu cần thiết
            ->select(
                'shipments.shipment_id',
                'shipments.created_at',
                'shipments.updated_at',
                'shipments.shipment_code',
                'package_summary.list_tracking',
                'package_summary.count_package',
                'package_summary.list_package_code',
                'package_summary.sum_package_charged_weight',
                'invoice_summary.list_items',
                'shipments.receiver_company_name',
                'shipments.receiver_contact_name',
                'shipments.shipment_final_amount',
                'shipments.shipment_amount_fsc',
                'shipments.shipment_amount_vat',
                'services.service_name',
                'branchs.branch_name',
                'states.state_code',
                'countries.country_name',
                DB::raw('(shipment_amount_total_customer - shipment_amount_profit - shipment_amount_vat) AS total_value'),
                DB::raw('(shipment_final_amount + shipment_amount_fsc - (shipment_amount_total_customer - shipment_amount_profit)) AS amount_sub_good'),
                'shipments.shipment_amount_vat',
                'shipments.shipment_final_amount'
            )
            ->groupBy('shipments.shipment_id')->get();

        $data['debit'] = $debit;
        $data['creater'] = User::find($debit->created_by);
        $data['customer'] = User::find($debit->customer_id);
        $data['shipments'] = $shipments;


        return Excel::download(new ExportDebit($data), $export_name);
    }

    public function displayDetailCompany(Request $request)
    {
        try {
            $company = User::isShow()->where('user_code', $request->query('company_code'))->first();
            if (!$company) {
                Session::flash('warning', 'Không tìm thấy tài khoản');
                return viewError404();
            }
            $is_fwd = onCheckPositionAccount(SETTING_FWD_ACCOUNT, $company['position_id']);
            if (!$is_fwd) {
                Session::flash('warning', 'Đây không phải tài khoản fwd');
                return viewError404();
            }
            $services = Service::isShow()->select('service_id', 'service_name')->get();
            return view('accounting-management.manager-debit.fwd.detail-company', compact('company', 'services'));
        } catch (\Throwable $th) {
            return viewError404();
        }
    }

    public function paginateListShipmentFwd(Request $request)
    {
        $request_data = $request->all();
        $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
        $user = User::find($request_data['user_id']);

        try {
            $path = 'public/config/system-settings.json';
            $view_operating_costs_position_ids = collect(json_decode(Storage::get($path), true))->firstWhere('kind', SETTING_ACCOUNT_VIEW_AND_UPDATE_SHIPMENT_OPERATING_COST)['position_ids'];
            $is_view_shipment_operating_costs = in_array(auth()->user()['position_id'], $view_operating_costs_position_ids);

            $filters = isset($request_data['filters']) ? (is_array($request_data['filters']) ? $request_data['filters'] : json_decode($request_data['filters'], true)) : [];

            $shipments = Shipment::with(['service', 'branch', 'country', 'shipmentOperatingCosts'])
                ->where('shipments.user_id', $user->user_id)->isShow()->orderBy('shipments.created_at', 'desc')
                ->isFiltersInDashboard($filters);

            if (isset($request_data['debit_id'])) {
                $shipments = $shipments->where('shipments.shipment_debit_id', $request_data['debit_id']);
            }

            if (isset($filters['company_shipment_status']) && in_array($filters['company_shipment_status'], [SHIPMENT_STATUS_IMPORTED, SHIPMENT_STATUS_EXPORED])) {
                $shipments = $shipments->where('shipments.shipment_status', $filters['company_shipment_status']);
            } else {
                $shipments = $shipments->whereIn('shipments.shipment_status', [SHIPMENT_STATUS_IMPORTED, SHIPMENT_STATUS_EXPORED]);
            }

            if (isset($filters['company_shipment_payment'])) {
                switch ($filters['company_shipment_payment']) {
                    case 1:
                        $shipments = $shipments->where('shipments.shipment_payment_status', 0);
                        break;

                    case 2:
                        $shipments = $shipments->where('shipments.shipment_payment_status', 0)
                            ->where('shipments.shipment_payment_step', '>', 1);
                        break;

                    case 3:
                        $shipments = $shipments->where('shipments.shipment_payment_status', 1);
                        break;
                    default:
                        # code...
                        break;
                }
            }

            if (isset($request_data['is_excel']) && json_decode($request_data['is_excel'])) {
                $excels = $shipments->get()->toArray();

                return response()->json([
                    'status' => HTTP_OK,
                    'excels' => $excels,
                ]);
            }

            $is_check_all = isset($request_data['is_check_all']) && json_decode($request_data['is_check_all']);
            if (isset($request_data['pluck_id']) && json_decode($request_data['pluck_id'])) {
                if ($is_check_all) {
                    $shipment_ids = $shipments
                        ->leftJoin('services', 'shipments.shipment_service_id', 'services.service_id')
                        ->where('services.promotion_flg', '!=', IS_EPACKET)
                        ->whereNull('shipment_debit_id')
                        ->where('shipment_payment_status', 0)
                        ->get()->pluck('shipment_id');
                } else {
                    $shipment_ids = [];
                }

                return response()->json([
                    'status' => HTTP_OK,
                    'shipment_ids' => $shipment_ids,
                ]);
            }


            $shipments = $shipments->groupBy('shipments.shipment_id')
                ->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            $is_fwd = onCheckPositionAccount(SETTING_FWD_ACCOUNT, $user->position_id);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'shipments' => $shipments,
                ]);
            } else {
                $choosed_id = $request_data['choosed_id'] ?? [];
                $html = view('accounting-management.manager-debit.ajax.table-shipments-fwd', compact('shipments', 'is_view_shipment_operating_costs', 'choosed_id', 'is_check_all'))->render();
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }
}
