<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Branch;
use App\Models\Country;
use App\Models\Invoice;
use App\Models\Package;
use App\Models\Service;
use App\Models\Receiver;
use App\Models\Shipment;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\DB;
use App\Models\CountryAndServiceLink;
use Illuminate\Support\Facades\Session;

class BulkUploadController extends Controller
{
    public function displayBulkUpload()
    {
        $package_types = config('constans.constans.package_types');
        $invoice_exports_as = config('constans.constans.invoice_exports_as');
        $branchs = Branch::isActive(ACTIVE)->isDelete(NO_DELETE)->select('branch_name', 'branch_description')->get()->toArray();
        $countries = Country::isActive(ACTIVE)->isDelete(NO_DELETE)->select('country_id', 'country_name')->get()->toArray();

        return view('bulk-upload.index', compact('branchs', 'package_types', 'invoice_exports_as', 'countries'));
    }

    public function handleBulkUpload(Request $request)
    {
        $request->validate([
            'data_excel.*.account_code' => 'required|exists:users,user_code',

            'data_excel.*.to_company' => 'required',
            'data_excel.*.to_name' => 'required',
            'data_excel.*.to_telephone' => 'required',
            'data_excel.*.postal_code' => 'required',
            'data_excel.*.to_country' => 'required',
            // 'data_excel.*.to_state' => 'required',
            'data_excel.*.to_city' => 'required',

            'data_excel.*.service' => 'required',
            'data_excel.*.branch' => 'required',
            // 'data_excel.*.reference_code' => !empty($request->reference_code) ? 'unique:shipments,shipment_reference_code' : '',

            'data_excel.*.goods_name' => 'required',
            'data_excel.*.invoice_value' => 'required|numeric|min:0',
            'data_excel.*.export_as' => 'required|numeric',

            // 'data_excel.*.count_package' => 'required|numeric|min:1',
            // 'data_excel.*.package_type' => 'required|numeric',
            // 'data_excel.*.weight' => 'required|numeric|min:0',
            // 'data_excel.*.length' => 'required|numeric|min:0',
            // 'data_excel.*.height' => 'required|numeric|min:0',
            // 'data_excel.*.width' => 'required|numeric|min:0',

            'data_excel.packages.*.count_package' => 'required|numeric|min:1',
            'data_excel.packages.*.package_type' => 'required|numeric',
            'data_excel.packages.*.weight' => 'required|numeric|min:0',
            'data_excel.packages.*.length' => 'required|numeric|min:0',
            'data_excel.packages.*.height' => 'required|numeric|min:0',
            'data_excel.packages.*.width' => 'required|numeric|min:0',

        ], [
            'data_excel.*.account_code.required' => 'Không được để trống mã tài khoản người dùng (account_code).',
            'data_excel.*.account_code.exists' => 'Không tồn tại mã tài khoản người dùng (account_code).',

            'data_excel.*.to_company.required' => 'Không được để trống tên công ty nhận (to_company).',
            'data_excel.*.to_name.required' => 'Không được để trống tên người nhận (to_name).',
            'data_excel.*.to_telephone.required' => 'Không được để trống số điện thoại (to_telephone).',
            'data_excel.*.postal_code.required' => 'Không được để trống mã bưu chính (postal_code).',
            'data_excel.*.to_country.required' => 'Không được để trống đất nước (to_country).',

            'data_excel.*.service.required' => 'Không được để trống dịch vụ (service).',
            'data_excel.*.branch.required' => 'Không được để trống chi nhánh (branch).',
            'data_excel.*.reference_code.unique' => 'Mã này phải là duy nhất (reference_code).',
            'data_excel.*.goods_name.required' => 'Không được để trống tên hàng hóa (goods_name).',
            'data_excel.*.invoice_value.required' => 'Không được để trống giá trị kiện hàng (invoice_value).',
            'data_excel.*.invoice_value.numeric' => 'Giá trị kiện hàng phải là số (invoice_value).',
            'data_excel.*.invoice_value.min' => 'Giá trị kiện hàng không được nhỏ hơn 0 (invoice_value).',
            'data_excel.*.export_as.required' => 'Không được để trống (export_as).',
            'data_excel.*.export_as.numeric' => 'Giá trị export as phải là số (export_as).',

            // packages
            // 'data_excel.*.count_package.required' => 'Không được để trống số lượng kiện hàng (count_package).',
            // 'data_excel.*.count_package.numeric' => 'Số lượng kiện hàng phải là số (count_package).',
            // 'data_excel.*.count_package.min' => 'Số lượng kiện hàng không được nhỏ hơn 1 (count_package).',
            // 'data_excel.*.package_type.required' => 'Không được để trống số lượng kiện hàng (package_type).',
            // 'data_excel.*.package_type.numeric' => 'Số lượng kiện hàng phải là số (package_type).',
            // 'data_excel.*.weight.required' => 'Không được để trống cân nặng (weight).',
            // 'data_excel.*.weight.numeric' => 'Cân nặng phải là số (weight).',
            // 'data_excel.*.weight.min' => 'Cân nặng không được nhỏ hơn 0 (weight).',
            // 'data_excel.*.length.required' => 'Không được để trống chiều dài (length).',
            // 'data_excel.*.length.numeric' => 'Chiều dài phải là số (length).',
            // 'data_excel.*.length.min' => 'Chiều dài không được nhỏ hơn 0 (length).',
            // 'data_excel.*.height.required' => 'Không được để trống chiều cao (height).',
            // 'data_excel.*.height.numeric' => 'Chiều cao phải là số (height).',
            // 'data_excel.*.height.min' => 'Chiều cao không được nhỏ hơn 0 (height).',
            // 'data_excel.*.width.required' => 'Không được để trống chiều rộng (width).',
            // 'data_excel.*.width.numeric' => 'Chiều rộng phải là số (width).',
            // 'data_excel.*.width.min' => 'Chiều rộng không được nhỏ hơn 0 (width).',

            'data_excel.packages.*.count_package.required' => 'Không được để trống số lượng kiện hàng (count_package).',
            'data_excel.packages.*.count_package.numeric' => 'Số lượng kiện hàng phải là số (count_package).',
            'data_excel.packages.*.count_package.min' => 'Số lượng kiện hàng không được nhỏ hơn 1 (count_package).',
            'data_excel.packages.*.package_type.required' => 'Không được để trống loại kiện hàng (package_type).',
            'data_excel.packages.*.package_type.numeric' => 'Loại kiện hàng phải là số (package_type).',
            'data_excel.packages.*.weight.required' => 'Không được để trống cân nặng (weight).',
            'data_excel.packages.*.weight.numeric' => 'Cân nặng phải là số (weight).',
            'data_excel.packages.*.weight.min' => 'Cân nặng không được nhỏ hơn 0 (weight).',
            'data_excel.packages.*.length.required' => 'Không được để trống chiều dài (length).',
            'data_excel.packages.*.length.numeric' => 'Chiều dài phải là số (length).',
            'data_excel.packages.*.length.min' => 'Chiều dài không được nhỏ hơn 0 (length).',
            'data_excel.packages.*.height.required' => 'Không được để trống chiều cao (height).',
            'data_excel.packages.*.height.numeric' => 'Chiều cao phải là số (height).',
            'data_excel.packages.*.height.min' => 'Chiều cao không được nhỏ hơn 0 (height).',
            'data_excel.packages.*.width.required' => 'Không được để trống chiều rộng (width).',
            'data_excel.packages.*.width.numeric' => 'Chiều rộng phải là số (width).',
            'data_excel.packages.*.width.min' => 'Chiều rộng không được nhỏ hơn 0 (width).',
        ]);
        DB::beginTransaction();
        try {
            $request_datas = $request->all();

            foreach ($request_datas['data_excel'] as $request_data) {
                $shipment = [];

                // Kiểm tra reference code đã tồn tại chưa
                if (isset($request_data['reference_code']) && Shipment::where('shipment_reference_code', $request_data['reference_code'])->exists()) {
                    return response()->json([
                        'status' => HTTP_INTERNAL_SERVER_ERROR,
                        'message' => 'Reference code ' . $request_data['reference_code'] . ' đã được sử dụng'
                    ], HTTP_INTERNAL_SERVER_ERROR);
                }

                // Lấy thông tin user
                if (isGetAllData()) {
                    $user = User::where('user_code', $request_data['account_code'])->first();
                } else {
                    $user = $request->user();
                }
                if (!isset($user)) {
                    return response()->json([
                        'status' => HTTP_INTERNAL_SERVER_ERROR,
                        'message' => 'Không tìm thấy thông tin người dùng'
                    ], HTTP_INTERNAL_SERVER_ERROR);
                }

                // Lấy thông tin khu vực
                $area = getIdsAreaGobalByWords($request_data['to_country'], $request_data['to_state'] ?? null, $request_data['to_city'] ?? null);
                if (!$area['status']) {
                    return response()->json([
                        'status' => HTTP_NOT_FOUND,
                        'message' => 'Không tìm thấy thông tin khu vực, vui lòng kiểm tra lại đất nước hoặc thành phố'
                    ], HTTP_NOT_FOUND);
                }

                // Kiểm tra thông tin địa chỉ người dùng
                if (!isset($user['user_address_1']) || !isset($user['user_address_2']) || !isset($user['user_address_3'])) {
                    return response()->json([
                        'status' => HTTP_INTERNAL_SERVER_ERROR,
                        'message' => 'Người dùng chưa cập nhật đủ thông tin địa chỉ'
                    ], HTTP_INTERNAL_SERVER_ERROR);
                }

                // Lấy thông tin dịch vụ
                $service = CountryAndServiceLink::isShow()
                    ->leftJoin('services', 'country_and_service_links.service_id', 'services.service_id')
                    ->where('services.active_flg', ACTIVE)->where('services.delete_flg', NO_DELETE)
                    ->where('service_name', 'like', $request_data['service'])
                    ->where('country_id', $area['data']['country_id'])
                    ->select('services.service_id', 'service_volumetric_mass', 'service_kind', 'promotion_flg')
                    ->first();
                if (!$service) {
                    return response()->json([
                        'status' => HTTP_INTERNAL_SERVER_ERROR,
                        'message' => [
                            'icon' => 'error',
                            'title' => 'Không tìm thấy thông tin dịch vụ',
                            'message' => 'Dịch vụ ' . $request_data['service'] . ' không tồn tại hoặc không áp dụng cho khu vực ' . $request_data['to_country']
                        ]
                    ], HTTP_INTERNAL_SERVER_ERROR);
                }

                // Lấy chi nhánh
                $branch = Branch::isActive(ACTIVE)->isDelete(NO_DELETE)->where('branch_name', $request_data['branch'])->first();
                if (!$branch) {
                    return response()->json([
                        'status' => HTTP_NOT_FOUND,
                        'message' => 'Không tìm thấy thông tin chi nhánh'
                    ], HTTP_NOT_FOUND);
                }

                // Dữ liệu shipment
                $shipment['receiver_country_id'] = $area['data']['country_id'];
                $shipment['receiver_state_id'] = $area['data']['state_id'] ?? null;
                $shipment['receiver_state_name'] = $request_data['to_state'] ?? '';
                $shipment['receiver_city_id'] = $area['data']['city_id'] ?? null;
                $shipment['receiver_company_name'] = $request_data['to_company'];
                $shipment['receiver_contact_name'] = $request_data['to_name'];
                $shipment['receiver_telephone'] = $request_data['to_telephone'];
                $shipment['receiver_postal_code'] = isset($request_data['postal_code']) ? $request_data['postal_code'] : '';
                $shipment['receiver_address_1'] = isset($request_data['address_1']) ? $request_data['address_1'] : '';
                $shipment['receiver_address_2'] = isset($request_data['address_2']) ? $request_data['address_2'] : '';
                $shipment['receiver_address_3'] = isset($request_data['address_3']) ? $request_data['address_3'] : '';

                $shipment['user_id'] = $user['user_id'];
                $shipment['shipment_code'] = initializationShipmentCode();
                $shipment['shipment_service_id'] = $service['service_id'];
                $shipment['shipment_signature_flg'] = empty($request_data['signature_flg']) ? SHIPMENT_SIGNATURE_NO : SHIPMENT_SIGNATURE_YES;
                $shipment['shipment_branch_id'] = $branch['branch_id'];
                $shipment['shipment_reference_code'] = isset($request_data['reference_code']) ? $request_data['reference_code'] : '';
                $shipment['shipment_status'] = SHIPMENT_STATUS_CREATE_BILL;
                $shipment['shipment_goods_name'] = $request_data['goods_name'];
                $shipment['shipment_value'] = $request_data['invoice_value'];
                $shipment['shipment_export_as'] = $request_data['export_as'];
                $shipment['sender_company_name'] = $user['user_company_name'];
                $shipment['sender_contact_name'] = $user['user_contact_name'];
                $shipment['sender_telephone'] = $user['user_phone'];
                $shipment['sender_city'] = $user['user_address_1'];
                $shipment['sender_district'] = $user['user_address_2'];
                $shipment['sender_ward'] = $user['user_address_3'];
                $shipment['sender_address'] = $user['user_address'];
                $shipment['sender_address'] = $user['user_address'];
                $shipment['shipment_payment_status'] = INACTIVE;
                $shipment['shipment_paid_by'] = isset($request_data['paid_by']) && in_array($request_data['paid_by'], [0, 1]) ? $request_data['paid_by'] : SHIPMENT_PAID_BY_WALLET;
                $shipment['import_approval'] = INACTIVE;

                // Tạo shipment
                $shipment_created = Shipment::create($shipment);

                // Dữ liệu package
                $packages = $request_data['packages'];
                $total_weight = array_reduce($packages, function ($carry, $item) {
                    return $carry + ($item['count_package'] * $item['weight']);
                }, 0);

                // nêu là dịch vụ ePacket thì chỉ cho tạo 1 kiện hàng
                $total_quantity = collect($packages)->sum('count_package');
                if ($service['promotion_flg'] == IS_EPACKET && $total_quantity > 1) {
                    return response()->json([
                        'status' => HTTP_INTERNAL_SERVER_ERROR,
                        'message' => 'Dịch vụ ePacket chỉ cho phép tạo 1 kiện hàng'
                    ], HTTP_INTERNAL_SERVER_ERROR);
                }

                foreach ($packages as $key => $package_excel) {
                    $package['package_length'] = $package_excel['length'];
                    $package['package_width'] = $package_excel['width'];
                    $package['package_height'] = $package_excel['height'];
                    $package['package_weight'] = formatNumberCeil($package_excel['weight'], $total_weight, $service['promotion_flg']);;

                    $package['shipment_id'] = $shipment_created['shipment_id'];
                    $package['package_converted_weight'] = formatNumberCeil($package_excel['length'] * $package_excel['width'] * $package_excel['height'] / $service['service_volumetric_mass'], $total_weight, $service['promotion_flg']);
                    $package['package_charged_weight'] = $package_excel['weight'] < $package['package_converted_weight'] ? $package['package_converted_weight'] : $package_excel['weight'];
                    $package['package_description'] = '';

                    $package_quantity = $package_excel['count_package'];

                    for ($i = 1; $i <= $package_quantity; $i++) {
                        $package_code = getCodePackage();
                        $package['package_code'] = $package_code['package_code'];
                        $package['package_hawb_code'] = $package_code['package_code'];
                        $package['package_quantity'] = 1;
                        Package::create($package);
                    }
                }

                // Cập nhật giá trị số tiền vận chuyển
                $result_save_amount = onSaveAmountShipment($shipment_created['shipment_id']);
                // Nếu lưu số tiền vận chuyển thất bại thì hiện thông báo lỗi
                if ($result_save_amount['status'] === HTTP_INTERNAL_SERVER_ERROR) {
                    return response()->json($result_save_amount, HTTP_INTERNAL_SERVER_ERROR);
                }

                // Cập nhật giá trị chi phí vận hành
                onUpdateOperatingCostsAmount($shipment_created['shipment_id']);

                // Tính giá trị cuối cùng của đơn và lợi nhuận 
                onUpdateFinalAmountShipment($shipment_created['shipment_id']);

                // Nếu dịch vụ là ePacket thì tính tiền ở ví
                // if ($shipment_created['service']['promotion_flg'] == IS_EPACKET) {
                //     // Phân bổ tiền khi cập nhật shipment
                //     $result = allocateFundsWhenUpdatingShipment($shipment_created['shipment_id']);

                //     // Cập nhật trạng thái thanh toán của shipment
                //     $shipment_created->shipment_payment_status = $result['status'] != HTTP_OK ? PENDING : SUCCESS;
                //     $shipment_created->accountant_status = $result['status'] != HTTP_OK ? PENDING : SUCCESS;
                //     $shipment_created->save();
                // }
            }

            Session::flash('success', 'Khởi tạo shipment thành công');

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => 'Khởi tạo shipment thành công',
                'redirect_url' => route('shipments.approve.show'),
            ], HTTP_OK);
        } catch (\Throwable $th) {
            DB::rollBack();
            dd($th);
            return showMessageError();
        }
    }
}
