<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Branch;
use App\Models\Country;
use App\Models\Service;
use App\Models\Receiver;
use App\Models\Shipment;
use App\Exports\ExportFile;
use App\Models\SaleLinkFwd;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;

class AuditEpacketController extends Controller
{
    public function displayAuditEpacketList()
    {
        $branchs = Branch::isShow()->get();
        $shipment_status = config('constans.constans.shipment_status');
        $shipment_filter_by = config('constans.constans.shipment_filter_by');
        $services = Service::isShow()->where('promotion_flg', IS_EPACKET)
            ->select('service_id', 'service_name')->get();
        return view('audit-epacket.list', compact('branchs', 'services', 'shipment_status', 'shipment_filter_by'));
    }

    public function getEPackageServices(){
        try{
            $services = Service::isShow()->where('promotion_flg', IS_EPACKET)
                ->select('service_id', 'service_name')->get();
            return response()->json([
                'status' => HTTP_OK,
                'data' => $services
            ]);
        }catch (\Throwable $th) {
            return response()->json([
                'status' => HTTP_BAD_REQUEST,
                'message' => $th->getMessage()
            ]);
        }
    }
    public function getPackageManagerServices(){
        try{
            $services = Service::isShow()->select('service_id', 'service_name')->get();
            return response()->json([
                'status' => HTTP_OK,
                'data' => $services
            ]);
        }catch (\Throwable $th) {
            return response()->json([
                'status' => HTTP_BAD_REQUEST,
                'message' => $th->getMessage()
            ]);
        }
    }
    public function getShipmentStatuses(){
        $shipment_status = config('constans.constans.shipment_status');
        $data = array_map(function($key, $value) {
            return ['key' => $key, 'value' => $value];
        }, array_keys($shipment_status), $shipment_status);
        
        return response()->json([
            'status' => $shipment_status ? HTTP_OK : HTTP_BAD_REQUEST,
            'data' => $data ?? ['message' => 'Không tìm thấy danh sách trạng thái']
        ]);
    }

    public function getShipments(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = $request->is('api/*');
            $user = $is_api ? $request->user() : auth()->user();
            $path = 'public/config/system-settings.json';

            $is_view_all_shipment = isGetAllData() || onCheckDocumentAccount(SETTING_OPS_LEADER_ACCOUNT) || onCheckDocumentAccount(SETTING_SHIPPER_ACCOUNT);

            $filters = isset($request_data['filters']) ? (is_array($request_data['filters']) ? $request_data['filters'] : json_decode($request_data['filters'], true)) : [];

            $shipments = Shipment::isDelete(NO_DELETE)
                ->isFilters($filters)
                ->where('shipments.import_approval', ACTIVE)
                ->orderBy('created_at', 'desc')
                ->leftJoin('services', 'services.service_id', '=', 'shipments.shipment_service_id')
                ->where('services.promotion_flg', IS_EPACKET)
                ->select('shipments.*');

            if (!$is_view_all_shipment) {
                $shipments = $shipments->where('shipments.user_id', $user->user_id);
            }

            // Xuất file excel
            if (isset($request_data['export_excel']) && json_decode($request_data['export_excel'])) {
                $data = $shipments->get();
                $name_excel = 'export-excel-shipment.xlsx';
                $others = null;
                $viewName = 'audit-epacket.excels.shipments2';
                $column_widths = null;
                return Excel::download(new ExportFile($data, $viewName, $others, $column_widths), $name_excel);
            }

            $shipments = $shipments->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'shipments' => $shipments,
                ]);
            }

            $html = view('audit-epacket.pagination', compact('shipments'))->render();
            return response()->json([
                'status' => HTTP_OK,
                'html' => $html
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleUpdateNote(Request $request)
    {
        DB::beginTransaction();
        try {
            $request_data = $request->all();

            $shipment = Shipment::where('shipment_code', $request_data['shipment_code'])->where('shipments.import_approval', ACTIVE)->first();
            if (!isset($shipment) || onCheckDocumentAccount(SETTING_FWD_ACCOUNT)) {
                return showMessageError();
            }

            $data = [
                'old_data' => $shipment['shipment_note'],
                'new_data' =>  $request_data['shipment_note'],
            ];
            onCreateAccountActivityLogs('Cập nhật ghi chú audit epacket', null, $data);

            $shipment->shipment_note = $request_data['shipment_note'];
            $shipment->save();

            DB::commit();
            return response()->json([
                'status' => HTTP_OK,
                'message' => [
                    'icon' => 'success',
                    'title' => 'Thành công',
                    'text' => 'Cập nhật ghi chú thành công'
                ]
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }
}
