<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Branch;
use App\Models\Shipment;
use App\Exports\ExportFile;
use Illuminate\Http\Request;
use App\Models\WalletFluctuation;


use Illuminate\Support\Facades\DB;
use App\Models\FinancialManagement;

use function Laravel\Prompts\select;
use Illuminate\Support\Facades\File;
use Maatwebsite\Excel\Facades\Excel;

class AccountantController extends Controller
{
    //
    public function displayExpense() {}

    public function displayWalletFluctuation()
    {
        try {
            // if (!isGetAllData()) {
            //     return viewError404();
            // }

            return view('accounting-management.wallet-fluctuation.index');
        } catch (\Throwable $th) {
            return viewError404();
        }
    }

    public function showListWalletFluctuation(Request $request)
    {
        $request_data = $request->all();
        $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
        $filters = $request_data['filters'] ?? null;
        $user = $request->user();
        $paginate = $request_data['paginate'] ?? [
            'page' => 1,
            'limit' => 10,
        ];
        try {
            $histories = WalletFluctuation::isShow()
                ->leftJoin('wallets', 'wallet_fluctuations.wallet_id', 'wallets.wallet_id')
                ->leftJoin('users', 'wallets.user_id', 'users.user_id');

            if (!isGetAllData()) {
                $histories = $histories->where('users.user_id', $user['user_id']);
            }

            $keywords = $filters['keywords'] ?? null;
            unset($filters['keywords']);
            $keywords = convertSearchString($keywords);
            if (isset($keywords) && $keywords != '') {
                $histories = $histories->where(function ($q) use ($keywords) {
                    return $q->where('wallet_fluctuations.secure_hash', 'like', $keywords)
                        ->orWhere('wallet_fluctuations.content', 'like', $keywords)
                        ->orWhere('users.user_contact_name', 'like', $keywords)
                        ->orWhere('users.user_code', 'like', $keywords);
                });
            }

            $histories = $histories->isFilters($filters)
                ->orderBy('wallet_fluctuation_id', 'desc')
                ->select(
                    'wallet_fluctuations.*',
                    'users.user_contact_name',
                    'users.user_code',
                    'users.position_id',
                    DB::raw("
                    CASE 
                        WHEN wallet_fluctuations.kind = 0 THEN 'Cộng tiền'
                        WHEN wallet_fluctuations.kind = 1 THEN 'Trừ tiền'
                        ELSE 'Không xác định'
                    END as kind_label
                    ")
                );

            $histories = $histories->groupBy('wallet_fluctuation_id')->isPaginate($paginate);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'data' => $histories->toArray()['data'],
                    'message' => 'Danh sách yêu cầu nạp tiền'
                ]);
            } else {

                $html = view('accounting-management.wallet-fluctuation.ajax.table-fluctuation', compact('histories'))->render();
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html,
                    'message' => 'Danh sách yêu cầu nạp tiền'
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function displayShipmentPendding()
    {
        $branchs = Branch::isShow()->get();
        $shipment_status = config('constans.constans.shipment_status');
        $shipment_filter_by = config('constans.constans.shipment_filter_by');
        return view('accounting-management.shipment.index', compact('branchs', 'shipment_status', 'shipment_filter_by'));
    }

    public function showListShipment(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $user = $is_api ? $request->user() : auth()->user();
            $filters = isset($request_data['filters']) ? (is_array($request_data['filters']) ? $request_data['filters'] : json_decode($request_data['filters'], true)) : [];

            $shipments = Shipment::isShow()->isFiltersConstantsKey($filters);

            $shipment = $shipments->leftJoin('services', 'shipments.shipment_service_id', 'services.service_id')
                ->where('services.promotion_flg', '!=', IS_EPACKET)->select('shipments.*');

            $shipments = $shipments->leftJoin('users as creator', 'shipments.user_id', 'creator.user_id');
            $fwd_position_id = onGetPositionIdFWDAccount();
            $shipments = $shipments->where('creator.position_id', '!=', $fwd_position_id);
            if (isset($filters['keywords']) && $filters['keywords'] != '') {
                $keywords = convertSearchString($filters['keywords']);
                $shipments = $shipments->where(function ($query) use ($keywords) {
                    return $query->where('shipments.shipment_code', 'like', $keywords)
                        ->orWhere('shipments.shipment_code', 'like', $keywords)
                        ->orWhere('creator.user_contact_name', 'like', $keywords)
                        ->orWhere('creator.user_code', 'like', $keywords);
                });
            }

            $shipments = $shipments->groupBy('shipments.shipment_id')
                ->orderBy('shipments.created_at', 'desc');

            $shipments = $shipments->paginate($request_data['limit'], ['*'], 'page', $request_data['page']);

            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'shipments' => $shipments,
                ]);
            } else {
                $html = view('accounting-management.shipment.ajax.table-shipment', compact('shipments'))->render();
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function handleShipmentAction(Request $request)
    {
        $validate = [
            'accountant_status' => 'required|numeric|min:0|max:2',
        ];
        if ($request->accountant_status == 2) {
            $validate['accountant_cancel_note'] = 'required|max:225';
        }
        $this->validate($request, $validate);
        DB::beginTransaction();
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : false;
            $is_manager = isGetAllData();

            if (!$is_manager) {
                return returnResponse(HTTP_BAD_REQUEST, 'Bạn không đủ quyền hạn để thao tác');
            }

            $shipment = Shipment::isShow()->where('shipment_code', $request_data['shipment_code'])->first();

            if (!$shipment) {
                return returnResponse(HTTP_BAD_REQUEST, 'Không tìm thấy đơn hàng vận chuyển' . $request_data['shipment_code']);
            }
            $user = User::with(['position'])->findOrFail($shipment['user_id']);
            $data_update = [];
            if (isset($request_data['is_only_confirm'])) {
                Shipment::find($shipment['shipment_id'])->update(['accountant_status' => 1]);
                DB::commit();
                return returnResponse(HTTP_OK, 'Xác nhận thành công', null, 'success');
            }
            if ($request_data['accountant_status'] == 2) {
                $shipment_payment_step = 0;
                if($shipment['shipment_paid_by'] == SHIPMENT_PAID_BY_REMAINING && $shipment['shipment_paid_by'] == 3){
                    $shipment_payment_step = 2;
                }
                $data_update = [
                    "shipment_payment_step" => $shipment_payment_step,
                    'accountant_cancel_note' => $request_data['accountant_status'] == 2 ? $request_data['accountant_cancel_note'] : null
                ];
                if (File::exists($shipment['shipment_file_proof_of_payment'])) {
                    File::delete($shipment['shipment_file_proof_of_payment']);
                    $data_update['shipment_file_proof_of_payment'] = null;
                }
            } else {
                if ($shipment['shipment_paid_by'] == SHIPMENT_PAID_BY_REMAINING) {
                    $data_update = [
                        "shipment_payment_step" => $shipment['shipment_payment_step'] + 1,
                        "shipment_payment_status" => $shipment['shipment_payment_step'] == 3 ? 1 : 0,
                        'accountant_status' => $shipment['shipment_payment_step'] == 3 ? 1 : 0,
                    ];
                    // Duyệt lần đầu tiên trừ tiền vô hạn mức
                    $amount = $shipment['shipment_amount_total_customer'];
                    $limit = $user['user_limit_amount_for_sale'] - $user['user_remaining_limit'];
                    if ($data_update['shipment_payment_step'] == 2) {
                        if ($user['position']['limit_amount_flg'] == NO_LIMIT || ($user['position']['limit_amount_flg'] == LIMITED && $amount <= $limit)) {

                            $note = 'Xác nhận công nợ shipment ' . $shipment['shipment_code'];
                            updateUserRemainingLimit2($user['user_id'], $amount, PLUS, $note);
                        } else {
                            return returnResponse(HTTP_BAD_REQUEST, 'Tài khoản này đã đến giới hạn mức nợ', null, 'warning');
                        }
                    } else if ($data_update['shipment_payment_step'] == 4) {
                        updateUserRemainingLimit2($user['user_id'], $amount, MINUS, 'Thanh toán công nợ shipment ' . $shipment['shipment_code']);
                    }
                } else {
                    $data_update = [
                        "shipment_payment_step" => 4,
                        "shipment_payment_status" => 1,
                        'accountant_status' => in_array($request_data['accountant_status'], [0, 1]) ? $request_data['accountant_status'] : 0,
                    ];
                }
                $data_update['shipment_payment_des'] = $request_data['shipment_payment_des'] ?? null;
                if ($data_update['shipment_payment_status'] == SUCCESS) {
                    onCreateCheckedPaymentCash(
                        $shipment['shipment_code'],
                        request()->user()['user_id'],
                        $shipment['user_id'],
                        0,
                        $shipment['shipment_amount_total_customer'],
                        $shipment['shipment_payment_date'],
                        $shipment['shipment_payment_method'],
                        $shipment['shipment_file_proof_of_payment'],
                        $request_data['payment_bank'] ?? null,
                        $request_data['payment_cash'] ?? null,
                    );
                }
            }

            $data = [
                'old_data' => $shipment,
                'new_data' =>  $data_update,
            ];
            onCreateAccountActivityLogs('Cập nhật trạng thái thanh toán của lô hàng', null, $data);
            onUpdateUserRemainingLimit($user['user_id'], $user);

            Shipment::find($shipment['shipment_id'])->update($data_update);
            DB::commit();

            return returnResponse(HTTP_OK, 'Cập nhật thành công', null, 'success');
        } catch (\Throwable $th) {
            DB::rollback();
            return showMessageError();
        }
    }


    // Màn hình quản lý chi tiêu
    public function displayFinancial()
    {
        try {
            if (!isGetAllData()) {
                return viewError404();
            }
            $branchs =  Branch::isShow()
                ->select('branch_name', 'branch_id')->get();

            return view('accounting-management.financial.index', compact('branchs'));
        } catch (\Throwable $th) {
            return viewError404();
        }
    }

    // Tạo hoặc cập nhật thu chi
    public function handleCreateOrUpdateFinancial(Request $request)
    {
        $validate = [
            'financial_branch_id' => 'required|numeric|min:0',
            'financial_type' => 'required|numeric|min:0|max:1',
            'financial_amount' => 'required|numeric',
            'financial_method' => 'required|numeric|min:0|max:1',
            'financial_customer_name' => 'required|max:225',
            'financial_content' => 'required|max:325',
            'financial_is_salary' => 'required|numeric|min:0|max:1',
        ];
        if ($request->financial_type == 1) {
            $validate['financial_images'] = 'required';
        }

        $this->validate($request, $validate);

        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
            $user = $is_api ? $request->user() : auth()->user();

            $financial_images = [];
            DB::beginTransaction();

            if (!empty($request_data['financial_images'])) {
                $images = json_decode($request_data['financial_images'], true);
                $financial_images = convertImagesBase64ToDirectory($images, PUBLIC_PATH_FINANCIAL_IMAGE);
            }
            if (isset($request_data['financial_code'])) {
                $financial = FinancialManagement::isShow()
                    ->where('financial_code', $request_data['financial_code'])
                    ->first();
                if (!$financial) {
                    return returnResponse(HTTP_NOT_FOUND, 'Không tìm thấy ghi chép thu/chi');
                }

                $oldImage = json_decode($request_data['financial_old_imgs'], true);
                if (
                    $request_data['financial_method'] == 1 &&
                    empty($oldImage) &&
                    empty(json_decode($request_data['financial_images'], true))
                ) {
                    return returnResponse(HTTP_BAD_REQUEST, 'Không được để trống hình ảnh');
                }

                $oldImaData = json_decode($financial->financial_images, true);
                if (!empty($oldImaData)) {
                    foreach ($oldImaData as $key => $old_img) {
                        if (!in_array($old_img, $oldImage) && File::exists($old_img)) {
                            File::delete($old_img);
                        } else {
                            array_push($financial_images, $old_img);
                        }
                    }
                }

                $data_update = [
                    'financial_branch_id' => $request_data['financial_branch_id'],
                    'financial_type' => $request_data['financial_type'],
                    'financial_amount' => $request_data['financial_amount'],
                    'financial_method' => $request_data['financial_method'],
                    'created_by' => $user->user_id,
                    'financial_customer_id' => $request_data['financial_customer_id'] ?? null,
                    'financial_customer_name' => $request_data['financial_customer_name'],
                    'financial_content' => $request_data['financial_content'],
                    'financial_is_salary' => isset($request_data['financial_is_salary']) ? json_decode($request_data['financial_is_salary']) : false,
                    'financial_images' => json_encode($financial_images),
                ];


                $data = [
                    'old_data' => $financial,
                    'new_data' =>  $data_update,
                ];
                onCreateAccountActivityLogs('Tạo thu chi', null, $data);

                $financial->update($data_update);
            } else {
                if (empty($financial_images) && $request_data['financial_method'] == 1) {
                    return returnResponse(HTTP_BAD_REQUEST, 'Không được để trống hình ảnh');
                }

                $data_update = [
                    'financial_code' => initializationCode('financial_management', 'financial_code', 'FM', 12),
                    'financial_branch_id' => $request_data['financial_branch_id'],
                    'financial_type' => $request_data['financial_type'],
                    'financial_amount' => $request_data['financial_amount'],
                    'financial_method' => $request_data['financial_method'],
                    'created_by' => $user->user_id,
                    'financial_customer_id' => $request_data['financial_customer_id'] ?? null,
                    'financial_customer_name' => $request_data['financial_customer_name'],
                    'financial_content' => $request_data['financial_content'],
                    'financial_is_salary' => isset($request_data['financial_is_salary']) ? json_decode($request_data['financial_is_salary']) : false,
                    'financial_images' => json_encode($financial_images),
                ];

                FinancialManagement::create($data_update);

                $data = [
                    'old_data' => '',
                    'new_data' =>  $data_update,
                ];
                onCreateAccountActivityLogs('Tạo thu chi', null, $data);
            }



            DB::commit();
            return returnResponse(HTTP_OK, 'Thao tác thành công', 'Thông báo', 'success');
        } catch (\Throwable $th) {
            if (!empty($debit_images)) {
                foreach ($debit_images as $key => $value) {
                    if (File::exists($value)) {
                        File::delete($value);
                    }
                }
            }
            DB::rollBack();
            return returnResponse(HTTP_INTERNAL_SERVER_ERROR, 'Xảy ra lỗi không xác định');
        }
    }

    private function queryListFinancials($request_data)
    {

        $financials = FinancialManagement::isShow($request_data)
            ->leftJoin('branchs', 'financial_management.financial_branch_id', 'branchs.branch_id')
            ->leftJoin('users', 'financial_management.created_by', 'users.user_id');

        if (isset($request_data['filters'])) {
            $filters = $request_data['filters'];

            if (isset($filters['date_range']['start_date']) && isset($filters['date_range']['end_date'])) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->format('Y-m-d H:i:s');
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->format('Y-m-d H:i:s');
                $financials = $financials->whereBetween('financial_management.created_at', [$start_date, $end_date]);
            }

            if (isset($filters['financial_type'])) {
                $financials = $financials->where('financial_type', $filters['financial_type']);
            }

            if (isset($filters['financial_method'])) {
                $financials = $financials->where('financial_method', $filters['financial_method']);
            }

            if (isset($filters['financial_branch_id'])) {
                $financials = $financials->where('financial_branch_id', $filters['financial_branch_id']);
            }

            if (isset($filters['financial_is_salary'])) {
                $financials = $financials->where('financial_is_salary', $filters['financial_is_salary']);
            }

            if (isset($filters['keywords'])) {
                $financials = $financials->where(function ($query) use ($filters) {
                    $query->where('financial_code', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('financial_customer_name', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('user_contact_name', 'like', '%' . $filters['keywords'] . '%');
                });
            }
        }

        return $financials;
    }

    public function showListFinancial(Request $request)
    {
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
            $user = $is_api ? $request->user() : auth()->user();

            $financials = $this->queryListFinancials($request_data);

            // Phần lấy dữ liệu chart
            $data_table = $this->queryListFinancials($request_data);
            $data_chart = $data_table->select(
                DB::raw('DATE_FORMAT(financial_management.created_at, "%m-%Y") as month'),
                DB::raw('SUM(CASE WHEN financial_management.financial_type = 0 THEN financial_management.financial_amount ELSE 0 END) as total_thu'), // Tổng Thu
                DB::raw('SUM(CASE WHEN financial_management.financial_type = 1 THEN financial_management.financial_amount ELSE 0 END) as total_chi')  // Tổng Chi
            )
                ->groupBy(DB::raw('DATE_FORMAT(financial_management.created_at, "%m-%Y")'))
                ->orderBy(DB::raw('DATE_FORMAT(financial_management.created_at, "%Y-%m")'), 'asc')
                ->get();

            $month = [];
            $data1 = [];
            $data2 = [];
            foreach ($data_chart as $key => $value) {
                array_push($month, $value['month']);
                array_push($data1, $value['total_thu']);
                array_push($data2, $value['total_chi']);
            }
            $charts = [
                'month' => $month,
                'total_thu' => $data1,
                'total_chi' => $data2,
            ];
            // end chart

            $financials = $financials->select(
                'financial_management.*',
                'branchs.branch_name',
                'users.user_contact_name',
                'users.user_code',
                DB::raw(
                    'CASE 
                        WHEN financial_type = 0 THEN "Thu"
                        WHEN financial_type = 1 THEN "Chi"
                        ELSE "Khác"
                    END as financial_type_label'
                ),
                DB::raw(
                    'CASE 
                        WHEN financial_method = 0 THEN "Tiền mặt"
                        WHEN financial_method = 1 THEN "Chuyển khoản"
                        ELSE "Khác"
                    END as financial_method_label'
                ),
            )->orderByDesc('created_at');

            if (isset($request_data['export_excel']) && json_decode($request_data['export_excel'])) {
                $data = $financials->get();
                $viewName = 'accounting-management.financial.ajax.export-excel';
                $name_excel = $request_data['name_excel'] ?? 'export-kango.xlsx';
                return Excel::download(new ExportFile($data, $viewName), $name_excel);
            }

            $data_total = $this->queryListFinancials($request_data);
            $data_total = $data_total->select(
                DB::raw('SUM(CASE WHEN financial_management.financial_type = 0 AND financial_management.financial_method = 0 THEN financial_management.financial_amount ELSE 0 END) as total_thu_cash'),
                DB::raw('SUM(CASE WHEN financial_management.financial_type = 0 AND financial_management.financial_method = 1 THEN financial_management.financial_amount ELSE 0 END) as total_thu_bank'),
                DB::raw('SUM(CASE WHEN financial_management.financial_type = 1 AND financial_management.financial_method = 0 THEN financial_management.financial_amount ELSE 0 END) as total_chi_cash'),
                DB::raw('SUM(CASE WHEN financial_management.financial_type = 1 AND financial_management.financial_method = 1 THEN financial_management.financial_amount ELSE 0 END) as total_chi_bank'),
                DB::raw('SUM(CASE WHEN financial_management.financial_is_salary = 1 THEN financial_management.financial_amount ELSE 0 END) as total_salary'),
            )->first();
            if ($data_total) {
                $statis_amount = [
                    'total_chi_cash' => $data_total['total_chi_cash'],
                    'total_chi_bank' => $data_total['total_chi_bank'],
                    'total_thu_cash' => $data_total['total_thu_cash'],
                    'total_thu_bank' => $data_total['total_thu_bank'],
                    'total_salary' => $data_total['total_salary'],
                ];
            } else {
                $statis_amount = [
                    'total_chi_cash' => 0,
                    'total_chi_bank' => 0,
                    'total_thu_cash' => 0,
                    'total_thu_bank' => 0,
                    'total_salary' => 0,
                ];
            }

            $financials = $financials->isPaginate($request->paginate);
            if ($is_api) {
                return response()->json([
                    'status' => HTTP_OK,
                    'financials' => $financials,
                    'charts' => $charts,
                    'statis_amount' => $statis_amount,
                ]);
            } else {
                $html = view('accounting-management.financial.ajax.table-financial', compact('financials'))->render();
                return response()->json([
                    'status' => HTTP_OK,
                    'html' => $html,
                    'charts' => $charts,
                    'statis_amount' => $statis_amount,
                ]);
            }
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }

    public function onDeleteFinancial(Request $request)
    {
        $this->validate($request, [
            'financial_code' => 'required|max:20'
        ]);
        try {
            $request_data = $request->all();
            $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
            $user = $is_api ? $request->user() : auth()->user();

            if (!isGetAllData()) {
                return returnResponse(HTTP_BAD_REQUEST, 'Bạn không có đủ quyền hạn để thao tác');
            }
            $financial = FinancialManagement::isShow()->where('financial_code', $request_data['financial_code'])->first();
            if (!$financial) {
                return returnResponse(HTTP_BAD_REQUEST, 'Không tìm thấy thu/chi');
            }
            DB::beginTransaction();
            // Lịch sử hoạt động tài khoản
            $data_logs = [
                'old_data' => $financial,
                'new_data' => $request_data
            ];
            onCreateAccountActivityLogs('Quản lý hệ thống', 'Xóa thu chi', $data_logs);

            $financial->update(['delete_flg' => DELETED]);

            DB::commit();
            return returnResponse(HTTP_OK, 'Xóa thu chi thành công', null, 'success');
        } catch (\Throwable $th) {
            DB::rollBack();
            return showMessageError();
        }
    }

    public function showDetailFinancial(Request $request)
    {
        $request_data = $request->all();
        $is_api = isset($request_data['is_api']) ? json_decode($request_data['is_api']) : true;
        $user = $is_api ? $request->user() : auth()->user();

        try {
            if (!isGetAllData()) {
                return returnResponse(HTTP_BAD_REQUEST, 'Bạn không có đủ quyền hạn để thao tác');
            }
            $financial = FinancialManagement::isShow()->where('financial_code', $request_data['financial_code'])->first();
            if (!$financial) {
                return returnResponse(HTTP_BAD_REQUEST, 'Không tìm thấy thu/chi');
            }

            return response()->json([
                'status' => HTTP_OK,
                'financial' => $financial
            ]);
        } catch (\Throwable $th) {
            return showMessageError();
        }
    }
}
