<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;

use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class SaleTeamExport implements WithStyles, WithEvents
{
    protected $data;   // Dữ liệu được truyền vào

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function styles(Worksheet $sheet)
    {

        $sheet->getColumnDimension('B')->setWidth(20);
        $sheet->getColumnDimension('C')->setWidth(20);
        $sheet->getColumnDimension('D')->setWidth(30);
        $sheet->getColumnDimension('E')->setWidth(30);
        $sheet->getColumnDimension('F')->setWidth(20);
        $sheet->getColumnDimension('G')->setWidth(20);
        $sheet->getColumnDimension('H')->setWidth(20);
        $sheet->getColumnDimension('I')->setWidth(5);
        $sheet->getColumnDimension('J')->setWidth(20);

        return [
            'A1:J1' => [
                'font' => [
                    'bold' => true,
                    'color' => ['argb' => 'FFFFFF'], // Màu chữ trắng
                ],
                'fill' => [
                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'startColor' => ['argb' => '17A2B8'], // Màu nền info
                ],
            ],
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $borderStyle = [
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '000000'],
                        ],
                    ],
                ];

                $sheet = $event->sheet->getDelegate();

                $sheet->setCellValue('A1', 'STT');
                $sheet->setCellValue('B1', 'ACCOUNT NUMBER');
                $sheet->setCellValue('C1', 'DATE');
                $sheet->setCellValue('D1', 'HỌ VÀ TÊN (NVKD)');
                $sheet->setCellValue('E1', 'LEADER');
                $sheet->setCellValue('F1', 'LƯƠNG CƠ BẢN');
                $sheet->setCellValue('G1', 'DOANH THU');
                $sheet->setCellValue('H1', 'LỢI NHUẬN CÔNG TY');
                $sheet->setCellValue('I1', 'KPI');
                $sheet->setCellValue('J1', 'HOA HỒNG NHẬN');


                $teams = $this->data['teams'] ?? [];
                $leader = $this->data['leader'];
                $date = $this->data['date'];
                $num_start = 2;
                foreach ($teams as $key => $team) {
                    $sheet->setCellValue('A' . $num_start, $key + 1);
                    $sheet->setCellValue('B' . $num_start, $team['user_code']);
                    $sheet->setCellValue('C' . $num_start, $date);
                    $sheet->setCellValue('D' . $num_start, $team['user_contact_name']);
                    $sheet->setCellValue('E' . $num_start, $leader['user_contact_name']);
                    $sheet->setCellValue('F' . $num_start, formatNumber($team['salary']));
                    $sheet->setCellValue('G' . $num_start, formatNumber($team['total_price']));
                    $sheet->setCellValue('H' . $num_start, formatNumber($team['total_profit']));
                    $sheet->setCellValue('I' . $num_start, formatNumber($team['ratio_commission']) . '%');
                    $sheet->setCellValue('J' . $num_start, formatNumber($team['price_commission']));

                    $num_start++;
                }
                $num_start++;

                $total_team = $this->data['total_team'];
                $start_row = $num_start; // Lưu dòng bắt đầu
                $end_row = $num_start;   // Lưu dòng kết thúc (ban đầu bằng dòng bắt đầu)

                $sheet->mergeCells("A$num_start:G$num_start");
                $sheet->setCellValue("A$num_start", "TOTAL (THỐNG KÊ THÁNG $date)");
                $sheet->setCellValue("H$num_start", formatNumber($total_team['team_profit']) . ' vnd');
                $num_start++;

                $sheet->mergeCells("A$num_start:G$num_start");
                $sheet->setCellValue("A$num_start", "THƯỞNG KPI THÁNG TEAM LEADER (THỐNG KÊ THÁNG $date)");
                $sheet->setCellValue("H$num_start", formatNumber(0) . ' vnd');
                $num_start++;

                $sheet->mergeCells("A$num_start:G$num_start");
                $sheet->setCellValue("A$num_start", "KPI LEADER (THỐNG KÊ THÁNG $date)");
                $sheet->setCellValue("H$num_start", formatNumber(7) . '%');
                $num_start++;

                $sheet->mergeCells("A$num_start:G$num_start");
                $sheet->setCellValue("A$num_start", "TOTAL LEADER THỰC (THỐNG KÊ THÁNG $date)");
                $sheet->setCellValue("H$num_start", formatNumber($total_team['commission_leader_team']) . ' vnd');
                $num_start++;

                 // Lưu dòng kết thúc
                 $end_row = $num_start - 1;
                // Thêm viền cho toàn bộ vùng dữ liệu
                $sheet->getStyle("A$start_row:H$end_row")->applyFromArray([
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '000000'],
                        ],
                    ],
                ]);
                $sheet->getStyle("A$start_row:H$end_row")->applyFromArray([
                    'font' => [
                        'bold' => true, // In đậm
                        'color' => ['argb' => 'FFFFFF'], // Màu chữ trắng
                    ],
                    'fill' => [
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'startColor' => ['argb' => '17A2B8'], // Màu nền xanh (info)
                    ],
                ]);
            },
        ];
    }
}
