<?php

namespace App\Exports;


use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class SaleExport implements WithStyles, WithEvents
{
    protected $data;   // Dữ liệu được truyền vào

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function styles(Worksheet $sheet)
    {

        $sheet->getColumnDimension('B')->setWidth(30);
        $sheet->getColumnDimension('C')->setWidth(20);
        $sheet->getColumnDimension('E')->setWidth(30);
        $sheet->getColumnDimension('F')->setWidth(30);
        $sheet->getColumnDimension('H')->setWidth(15);
        $sheet->getColumnDimension('U')->setWidth(15);
        $sheet->getColumnDimension('V')->setWidth(15);
        $sheet->getColumnDimension('W')->setWidth(15);
        $sheet->getColumnDimension('X')->setWidth(15);
        $sheet->getColumnDimension('Z')->setWidth(30);
        $sheet->getColumnDimension('AA')->setWidth(30);
        $sheet->getColumnDimension('AB')->setWidth(30);

        return [
            'A1:AE1' => [
                'font' => [
                    'bold' => true,
                    'color' => ['argb' => 'FFFFFF'], // Màu chữ trắng
                ],
                'fill' => [
                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'startColor' => ['argb' => '17A2B8'], // Màu nền info
                ],
            ],
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $borderStyle = [
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '000000'],
                        ],
                    ],
                ];

                $sheet = $event->sheet->getDelegate();

                $sheet->setCellValue('A1', 'No');
                $sheet->setCellValue('B1', 'Date');
                $sheet->setCellValue('C1', 'KG BILL NO');
                $sheet->setCellValue('D1', 'TRACKING');
                $sheet->setCellValue('E1', 'CONTACT NAME');
                $sheet->setCellValue('F1', 'SERVICE');
                $sheet->setCellValue('G1', 'Chi nhánh');
                $sheet->setCellValue('H1', 'DESTINATION');
                $sheet->setCellValue('I1', 'TYPE');
                $sheet->setCellValue('J1', 'Số Kiện');
                $sheet->setCellValue('K1', 'Weight Tính Khách');
                $sheet->setCellValue('L1', 'CHARGEABLE WEIGHT');
                $sheet->setCellValue('M1', 'TOTAL KHÁCH THANH TOÁN');
                $sheet->setCellValue('N1', 'Cước Phụ thu');
                $sheet->setCellValue('O1', 'Cước Nội Địa');
                $sheet->setCellValue('P1', 'Thu Hộ');
                $sheet->setCellValue('Q1', 'Cước xuất VAT');
                $sheet->setCellValue('R1', 'VAT 8%');
                $sheet->setCellValue('S1', 'Phí mua bảo hiểm');
                $sheet->setCellValue('T1', 'Chi Phí Vận Hành');
                $sheet->setCellValue('U1', 'Còn lại');
                $sheet->setCellValue('V1', 'Cước Gốc');
                $sheet->setCellValue('W1', 'Lợi nhuận công ty');
                $sheet->setCellValue('X1', 'Hoa Hồng Nhận');
                $sheet->setCellValue('Y1', 'KPI %');
                $sheet->setCellValue('Z1', '');
                $sheet->setCellValue('AA1', 'KẾ TOÁN DUYỆT');
                $sheet->setCellValue('AB1', 'BIÊN LAI THANH TOÁN');
                $sheet->setCellValue('AC1', 'Trạng Thái');
                $sheet->setCellValue('AD1', 'Trạng thái giao hàng');
                $sheet->setCellValue('AE1', 'Ghi chú mặt hàng');


                $shipments = $this->data['shipments'] ?? [];
                $user = $this->data['user'];
                $num_start = 2;
                $sale_statistic = $this->data['sale_statistic'];
                foreach ($shipments as $key => $shipment) {
                    $sheet->setCellValue('A' . $num_start, $key + 1);
                    $sheet->setCellValue('B' . $num_start, formatDate($shipment['created_at']));
                    $sheet->setCellValue('C' . $num_start, $shipment['shipment_code']);
                    $sheet->setCellValue('D' . $num_start, $shipment['shipment_reference_code']);
                    $sheet->setCellValue('E' . $num_start, $shipment['receiver_contact_name']);
                    $sheet->setCellValue('F' . $num_start, $shipment['service_name']);
                    $sheet->setCellValue('G' . $num_start, $shipment['branch_name']);
                    $sheet->setCellValue('H' . $num_start, $shipment['country_name']);
                    $sheet->setCellValue('I' . $num_start, 'SPX');
                    $sheet->setCellValue('J' . $num_start, $shipment['count_package']);
                    $sheet->setCellValue('K' . $num_start, $shipment['receive_weight']);
                    $sheet->setCellValue('L' . $num_start, $shipment['charged_weight']);
                    $sheet->setCellValue('M' . $num_start, $shipment['shipment_amount_total_customer']);
                    $sheet->setCellValue('N' . $num_start, $shipment['shipment_amount_surcharge']);
                    $sheet->setCellValue('O' . $num_start, $shipment['shipment_domestic_charges']);
                    $sheet->setCellValue('P' . $num_start, $shipment['shipment_collection_fee']);
                    $sheet->setCellValue('Q' . $num_start, $shipment['shipment_amount_vat']);
                    $sheet->setCellValue('R' . $num_start, 0);
                    $sheet->setCellValue('S' . $num_start, $shipment['shipment_amount_insurance']);
                    $sheet->setCellValue('T' . $num_start, $shipment['shipment_amount_operating_costs']);
                    $amount2 = $shipment['shipment_amount_total_customer']
                        - $shipment['shipment_amount_surcharge']
                        - $shipment['shipment_domestic_charges']
                        - $shipment['shipment_collection_fee']
                        - $shipment['shipment_amount_vat']
                        - 0
                        - $shipment['shipment_amount_insurance']
                        - $shipment['shipment_amount_operating_costs'];
                    $sheet->setCellValue('U' . $num_start, $amount2);
                    $sheet->setCellValue('V' . $num_start, $shipment['shipment_amount_original']);
                    $sheet->setCellValue('W' . $num_start, $shipment['shipment_amount_profit']);

                    $commisstion_shipment = getCommistionShipment(
                        $sale_statistic['total_amount_profit'] ?? 0, 
                        $sale_statistic['salary'] ?? 0, 
                        $shipment['shipment_amount_profit'], 
                        $sale_statistic['ratio_commission']
                    );
                    $sheet->setCellValue('X' . $num_start, $commisstion_shipment);
                    $sheet->setCellValue('Y' . $num_start, $sale_statistic['ratio_commission']);
                    $sheet->setCellValue('Z' . $num_start, $this->data['leader_name'] ?? '');
                    $sheet->setCellValue('AA' . $num_start, 'Như - KT TỔNG HỢP');

                    if (!empty($shipment['shipment_file_proof_of_payment']) && $shipment['shipment_payment_status'] == 1) {
                        $imagePaths = onConvertStrArrImage($shipment['shipment_file_proof_of_payment']); // Chuyển chuỗi thành mảng

                        // Kết hợp các đường link vào một ô
                        $links = '';
                        foreach ($imagePaths as $path) {
                            $links .= "Bằng chứng thanh toán\n";
                        }

                        // Đặt văn bản vào ô AB
                        $sheet->setCellValue('AB' . $num_start, $links);
                        $sheet->getStyle('AB' . $num_start)->getAlignment()->setWrapText(true); // Bật chế độ xuống dòng trong ô

                        // Tạo hyperlink cho mỗi đường link
                        $currentRow = $num_start; // Dòng bắt đầu của ô AB
                        $currentColumn = 'AB'; // Cột AB

                        foreach ($imagePaths as $path) {
                            $cell = $sheet->getCell($currentColumn . $currentRow);

                            // Đặt hyperlink cho từng đường link
                            $cell->getHyperlink()->setUrl($path);

                            // Định dạng font: Màu xanh, gạch chân
                            $sheet->getStyle($currentColumn . $currentRow)
                                ->getFont()
                                ->setColor(new \PhpOffice\PhpSpreadsheet\Style\Color('0000FF')) // Màu xanh
                                ->setUnderline(true); // Gạch chân

                            $currentRow++; // Di chuyển xuống dòng tiếp theo nếu có nhiều đường link
                        }
                    } else {
                        // Nếu không có hình ảnh, để ô AB trống
                        $sheet->setCellValue('AB' . $num_start, '');
                    }

                    $sheet->setCellValue('AC' . $num_start, $shipment['shipment_payment_status'] == 1 ? 'Đã thanh toán' : 'Chưa thanh toán');
                    $status_labels = config('constans.constans.shipment_status') ?? [];
                    $sheet->setCellValue('AD' . $num_start, $status_labels[$shipment['shipment_status']] ?? '');
                    $sheet->setCellValue('AE' . $num_start, $shipment['shipment_goods_name']);

                    $num_start++;
                }
                $num_start++;

                if ($sale_statistic) {
                    $start_row = $num_start; // Lưu dòng bắt đầu
                    $end_row = $num_start;   // Lưu dòng kết thúc (ban đầu bằng dòng bắt đầu)

                    // Các thông tin xuất ra Excel
                    //Tổng lợi nhuận công ty
                    $sheet->setCellValue("D$num_start", 'Tổng lợi nhuận công ty');
                    $sheet->setCellValue("G$num_start", $sale_statistic['total_amount_profit'] . ' ');
                    $sheet->setCellValue("I$num_start", ' ');

                    $sheet->mergeCells("D$num_start:F$num_start");
                    $sheet->mergeCells("G$num_start:H$num_start");
                    $sheet->mergeCells("I$num_start:J$num_start");
                    $num_start++;

                    //Tổng số kg thực tế
                    $sheet->setCellValue("D$num_start", 'Tổng số kg thực tế');
                    $sheet->setCellValue("G$num_start", $sale_statistic['total_charged_weight'] . ' ');
                    $sheet->setCellValue("I$num_start", ' ');

                    $sheet->mergeCells("D$num_start:F$num_start");
                    $sheet->mergeCells("G$num_start:H$num_start");
                    $sheet->mergeCells("I$num_start:J$num_start");
                    $num_start++;

                    //Tổng số tiền thực thu
                    $sheet->setCellValue("D$num_start", 'Tổng số tiền thực thu');
                    $sheet->setCellValue("G$num_start", $sale_statistic['total_amount_customer'] . ' ');
                    $sheet->setCellValue("I$num_start", ' ');

                    $sheet->mergeCells("D$num_start:F$num_start");
                    $sheet->mergeCells("G$num_start:H$num_start");
                    $sheet->mergeCells("I$num_start:J$num_start");
                    $num_start++;

                    //Hoa hồng theo KPI
                    $sheet->setCellValue("D$num_start", 'Hoa hồng theo KPI');
                    $sheet->setCellValue("G$num_start", $sale_statistic['commission_amount'] . ' ');
                    $sheet->setCellValue("I$num_start", $sale_statistic['ratio_commission'] . '%');

                    $sheet->mergeCells("D$num_start:F$num_start");
                    $sheet->mergeCells("G$num_start:H$num_start");
                    $sheet->mergeCells("I$num_start:J$num_start");
                    $num_start++;

                    //Lợi nhuận FWD
                    $sheet->setCellValue("D$num_start", 'Lợi nhuận FWD');
                    $sheet->setCellValue("G$num_start", $sale_statistic['cost_fwd_amount'] . ' ');
                    $sheet->setCellValue("I$num_start", $sale_statistic['cost_fwd_weight'] . ' kg');

                    $sheet->mergeCells("D$num_start:F$num_start");
                    $sheet->mergeCells("G$num_start:H$num_start");
                    $sheet->mergeCells("I$num_start:J$num_start");
                    $num_start++;

                    if ($this->data['is_leader']) {
                        //Hoa hồng Leader
                        $sheet->setCellValue("D$num_start", 'Hoa hồng Leader');
                        $sheet->setCellValue("G$num_start", $sale_statistic['commission_leader_team'] . ' ');
                        $amount_commission_leader_team = $sale_statistic['commission_leader_team'] * 0.07 * 100;
                        $sheet->setCellValue("I$num_start","[$amount_commission_leader_team]" . '7%');

                    $sheet->mergeCells("D$num_start:F$num_start");
                    $sheet->mergeCells("G$num_start:H$num_start");
                        $sheet->mergeCells("I$num_start:J$num_start");
                        $num_start++;

                        //Hoa hồng Leader Member FWD
                        $sheet->setCellValue("D$num_start", 'Hoa hồng Leader Member FWD');
                        $sheet->setCellValue("G$num_start", $sale_statistic['fw_weight_cost_leader_team'] . ' ');
                        $sheet->setCellValue("I$num_start", ' ');

                    $sheet->mergeCells("D$num_start:F$num_start");
                    $sheet->mergeCells("G$num_start:H$num_start");
                        $sheet->mergeCells("I$num_start:J$num_start");
                        $num_start++;
                    }

                    if (isset($user['user_kpi_id'])) {
                        //Mức lương cơ bản theo KPI
                        $sheet->setCellValue("D$num_start", 'Mức lương cơ bản theo KPI');
                        $sheet->setCellValue("G$num_start", $sale_statistic['salary'] . ' ');
                        $sheet->setCellValue("I$num_start", ' ');

                    $sheet->mergeCells("D$num_start:F$num_start");
                    $sheet->mergeCells("G$num_start:H$num_start");
                        $sheet->mergeCells("I$num_start:J$num_start");
                        $num_start++;

                        //TỔNG THANH TOÁN
                        $sheet->setCellValue("D$num_start", 'TỔNG THANH TOÁN');
                        $sheet->setCellValue("G$num_start", $sale_statistic['final_salary_sale'] . ' ');
                        $sheet->setCellValue("I$num_start", ' ');

                    $sheet->mergeCells("D$num_start:F$num_start");
                    $sheet->mergeCells("G$num_start:H$num_start");
                        $sheet->mergeCells("I$num_start:J$num_start");
                        $num_start++;
                    } else {
                        $sheet->setCellValue("D$num_start", 'Sale chưa gắn KPI');
                        $num_start++;
                    }

                    // Lưu dòng kết thúc
                    $end_row = $num_start - 1;

                    // Thêm viền cho toàn bộ vùng dữ liệu
                    $sheet->getStyle("D$start_row:H$end_row")->applyFromArray([
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                                'color' => ['argb' => '000000'],
                            ],
                        ],
                    ]);
                    $sheet->getStyle("D$end_row:H$end_row")->applyFromArray([
                        'font' => [
                            'bold' => true, // In đậm
                            'color' => ['argb' => 'FFFFFF'], // Màu chữ trắng
                        ],
                        'fill' => [
                            'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                            'startColor' => ['argb' => '17A2B8'], // Màu nền xanh (info)
                        ],
                    ]);
                }
            },
        ];
    }
}
