<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ExportFile implements FromView, WithColumnWidths, WithStyles
{
    protected $data;   // Dữ liệu được truyền vào
    protected $other;  // Dữ liệu phụ truyền vào (nếu có)
    protected $view;   // Tên view để render Excel
    protected $column_widths;   // Tên view để render Excel

    public function __construct($data, $view, $other = [], $column_widths = null)
    {
        $this->data = $data;
        $this->view = $view;
        $this->other = $other;
        $this->column_widths = $column_widths;
    }

    // Trả về view với dữ liệu
    public function view(): View
    {
        return view($this->view, [
            'data_excel' => $this->data,
            'data_other' => $this->other,
        ]);
    }

    // Định nghĩa chiều rộng cho các cột
    public function columnWidths(): array
    {
        $widths = [];
        if (!isset($this->column_widths)) {
            $columns = range('A', 'Z'); // Tạo mảng các cột từ A đến Z

            // Định nghĩa chiều rộng từ cột A đến Z
            foreach ($columns as $column) {
                $widths[$column] = 40;
            }

            // Tiếp tục từ AA đến AZ
            foreach ($columns as $column) {
                $widths['A' . $column] = 40; // VD: AA, AB, AC...
            }
        }else{
            $widths = $this->column_widths;
        }

        return $widths;
    }

    // Thêm border cho tất cả các ô trong bảng
    public function styles(Worksheet $sheet)
    {
        // Xác định phạm vi ô cần thêm viền (A1 đến cột cuối cùng và hàng cuối cùng)
        $sheet->getStyle('A1:' . $sheet->getHighestColumn() . $sheet->getHighestRow())->applyFromArray([
            'borders' => [
                'allBorders' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['argb' => '000000'], // Màu đen cho viền
                ],
            ],
        ]);
    }
}
