<?php

namespace App\Exports;

use App\Models\Package;
use App\Models\PackageSg;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\FromCollection;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ExportDebit implements WithStyles, WithEvents
{
    protected $data;   // Dữ liệu được truyền vào

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function styles(Worksheet $sheet)
    {
        $sheet->mergeCells('A1:D6');
        $sheet->mergeCells('E1:L1');
        $sheet->mergeCells('E2:L2');
        $sheet->mergeCells('E3:L3');
        $sheet->mergeCells('E4:L4');
        $sheet->mergeCells('E5:L5');
        $sheet->mergeCells('E6:L6');
        $sheet->mergeCells('M1:Q6');

        $sheet->mergeCells('B10:I10');
        $sheet->mergeCells('B11:I11');
        $sheet->mergeCells('B12:I12');
        $sheet->mergeCells('B13:I13');
        $sheet->mergeCells('B14:I14');


        return [
            'A1:D6' => ['alignment' => ['horizontal' => 'center', 'vertical' => 'center']],
            'M1:Q6' => [
                'font' => ['bold' => true, 'size' => 15],
                'alignment' => ['horizontal' => 'center', 'vertical' => 'center'],
            ],
            'E1' => [
                'bold' => true,
                'size' => 13,
                'color' => ['argb' => 'FFFF0000'], // Red color in ARGB format
            ],
            'E6' => [
                'font' => [
                    'bold' => true,
                    'size' => 12,
                    'color' => ['argb' => '000000'], // 
                ],
            ],
            'B9' => [
                'font' => [
                    'bold' => true,
                ],
            ],
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $borderStyle = [
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '000000'],
                        ],
                    ],
                ];

                $debit = $this->data['debit'];
                $creater = $this->data['creater'];
                $customer = $this->data['customer'];

                $path = 'public/config/info-debit.json';
                $info_debit = Storage::get($path);
                $info_debit = json_decode($info_debit, true);
                $info_debit = $info_debit['excels'];
                $header = $info_debit['header'];

                $sheet = $event->sheet->getDelegate();

                $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
                $drawing->setName('Logo');
                $drawing->setDescription('Company Logo');
                $drawing->setPath(public_path(LOGO));
                $drawing->setHeight(50);
                $drawing->setCoordinates('B2');
                $drawing->setOffsetX(10);
                $drawing->setOffsetY(10);
                $drawing->setWorksheet($sheet);;

                $sheet->setCellValue('E1', $header[0] ?? '');

                $sheet->setCellValue('E2', $header[1] ?? '');
                $sheet->setCellValue('E3', $header[2] ?? '');
                $sheet->setCellValue('E4', $header[3] ?? '');
                $sheet->setCellValue('E5', $header[4] ?? '');
                $sheet->setCellValue('E6', 'Prepared by: ' . $creater->user_contact_name);
                $sheet->setCellValue('M1', 'PAYMENT NOTIFICATION');

                $sheet->setCellValue('B9', 'Bill To');
                $sheet->setCellValue('B10', 'Customer: ' . $customer->user_company_name);
                $sheet->setCellValue('B11', 'Adress: ' . $customer->user_address);
                $sheet->setCellValue('B12', 'VAT/CODE: ' . $customer->user_phone);
                $sheet->setCellValue('B13', 'Tel/Fax No: ' . $customer->user_phone);
                $sheet->setCellValue('B14', 'Contact Name: ' . $customer->user_contact_name);

                $debit_type_name = [
                    DEBIT_TYPE_DAY => 'DAY',
                    DEBIT_TYPE_WEEK1 => '1 WEEK',
                    DEBIT_TYPE_WEEK2 => '2 WEEK',
                    DEBIT_TYPE_MONTH => 'MONTH',
                ];
                $sheet->setCellValue('M10', 'No: ' . $debit->debit_no);
                $sheet->setCellValue('M11', 'Date time: ' . Carbon::now()->format('Y-m-d H:i:s'));
                $sheet->setCellValue('M12', 'CREDIT TERM: ' . ($debit_type_name[$debit['debit_type']] ?? ''));
                $sheet->setCellValue('M13', 'CURRENCY: VND');

                $sheet->setCellValue('A16', 'DATE');
                $sheet->setCellValue('B16', 'BILL NO');
                $sheet->setCellValue('C16', 'TRACKING');
                $sheet->setCellValue('D16', 'COMPANY NAME');
                $sheet->setCellValue('E16', 'CONTACT NAME');
                $sheet->setCellValue('F16', 'SERVICE');
                $sheet->setCellValue('G16', 'BRAND');
                $sheet->setCellValue('H16', 'STATE');
                $sheet->setCellValue('I16', 'DESTINATION');
                $sheet->setCellValue('J16', 'QTY PACKAGES');
                $sheet->setCellValue('K16', 'HAWB#');
                $sheet->setCellValue('L16', 'TYPE');
                $sheet->setCellValue('M16', 'CHARGEABLE WEIGHT');
                $sheet->setCellValue('N16', 'TOTAL VALUE');
                $sheet->setCellValue('O16', 'SUR CHANGE');
                $sheet->setCellValue('P16', 'VAT');
                $sheet->setCellValue('Q16', 'TOTAL PRICE');
                $sheet->setCellValue('R16', 'DESCRIPTION OF GOODS');
                $sheet->getStyle('A16:R16')->applyFromArray([
                    'font' => [
                        'bold' => true,
                        'color' => ['argb' => 'FFFFFFFF'], // White color for text in ARGB
                    ],
                    'fill' => [
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'startColor' => ['argb' => 'FF007D88'],
                    ],
                ]);

                $shipments = $this->data['shipments'] ?? [];
                $num_start = 17;
                $amount_fsc = 0;
                foreach ($shipments as $key => $shipment) {
                    $package_sub_goods = getDataSurchargeGoodPackagesByShipment($shipment['shipment_id']);
                    $list_items = '';
                    $amount_sub_goods = 0;
                    foreach ($package_sub_goods as $key => $items) {
                        $sg_name = $items['surcharge_goods_name'] ?? $items['external_surcharge_name'];
                        $list_items = $list_items . $sg_name . '[' . $items['count'] . '], ';

                        $amount_sub_goods += $items['count']* $items['price'];
                    }
                    if (isset($shipment['shipment_amount_peak']) && $shipment['shipment_amount_peak'] > 0) {
                        $list_items = ' Phí cao điểm ' . '[' . $shipment['shipment_amount_peak'] . '], ';

                        $amount_sub_goods += $shipment['shipment_amount_peak'];
                    }
                    if (isset($shipment['shipment_amount_residential']) && $shipment['shipment_amount_residential'] > 0) {
                        $list_items = ' Phí dân cư ' . '[' . $shipment['shipment_amount_residential'] . '%], ';

                        $amount_sub_goods += $shipment['shipment_amount_peak'];
                    }
                    $amount_fsc += $shipment['shipment_amount_fsc'];

                    $crated_at = getFirstScanImportShipment($shipment['shipment_id'])['created_at'];
                    $sheet->setCellValue('A' . $num_start, $crated_at);
                    $sheet->setCellValue('B' . $num_start, $shipment['shipment_code']);
                    $sheet->setCellValue('C' . $num_start, $shipment['list_tracking']);
                    $sheet->setCellValue('D' . $num_start, $shipment['receiver_company_name']);
                    $sheet->setCellValue('E' . $num_start, $shipment['receiver_contact_name']);
                    $sheet->setCellValue('F' . $num_start, $shipment['service_name']);
                    $sheet->setCellValue('G' . $num_start, $shipment['branch_name']);
                    $sheet->setCellValue('H' . $num_start, $shipment['state_code']);
                    $sheet->setCellValue('I' . $num_start, $shipment['country_name']);
                    $sheet->setCellValue('J' . $num_start, $shipment['count_package']);
                    $sheet->setCellValue('K' . $num_start, $shipment['list_package_code']);
                    $sheet->setCellValue('L' . $num_start, 'SPX');
                    $sheet->setCellValue('M' . $num_start, $shipment['sum_package_charged_weight']);
                    $sheet->setCellValue('N' . $num_start, number_format($shipment['shipment_final_amount'] - $amount_sub_goods - $shipment['shipment_amount_vat']));
                    $sheet->setCellValue('O' . $num_start, number_format($amount_sub_goods));
                    $sheet->setCellValue('P' . $num_start, number_format($shipment['shipment_amount_vat']));
                    $sheet->setCellValue('Q' . $num_start, number_format($shipment['shipment_final_amount']));

                    $sheet->setCellValue('R' . $num_start, $list_items);

                    $num_start++;
                }
                $sheet->mergeCells("A$num_start:P$num_start");
                $sheet->setCellValue("A$num_start", 'TOTAL');
                $total_amount = collect($shipments)->sum('shipment_final_amount');
                $sheet->setCellValue("Q$num_start", number_format($total_amount + $amount_fsc));
                if ($amount_fsc > 0) {
                    $sheet->setCellValue("R$num_start", 'Phụ phí xăng dầu ' . '[' . $debit['debit_fsc'] . '] ' . number_format($amount_fsc));
                }
                $sheet->getStyle("A$num_start:P$num_start")->applyFromArray([
                    'font' => [
                        'bold' => true,
                        'size' => 15,
                        'color' => ['argb' => '000000'], // 
                    ],
                ]);
                $sheet->getStyle("A16:R$num_start")->applyFromArray($borderStyle);


                // *Ghi chú
                $num_start = $num_start + 2;
                $sheet->setCellValue("A$num_start", '*Ghi chú');
                $sheet->getStyle("A$num_start")->applyFromArray([
                    'font' => [
                        'color' => ['argb' => 'FF0000'], // 
                    ],
                ]);
                $content_note = $info_debit['footer']['note'] ?? [];
                foreach ($content_note as $key => $note) {
                    $num_start = $num_start + 1;
                    $sheet->setCellValue("A$num_start", $note);
                    if (strpos($note, '*') === 0) {
                        $sheet->getStyle("A$num_start")->applyFromArray([
                            'font' => [
                                'color' => ['argb' => 'FF0000'], // 
                            ],
                        ]);
                    }
                }
                // * Thông Tin Tài Khoản chuyển khoản
                $num_start = $num_start + 2;
                onSetInfoDebitForExport($sheet, $customer, $num_start, $info_debit);

                $sheet->getStyle('A1:D6')->applyFromArray($borderStyle);
                $sheet->getStyle('E1:L6')->applyFromArray($borderStyle);
                $sheet->getStyle('M1:Q6')->applyFromArray($borderStyle);
                $sheet->getStyle('A16:R16')->applyFromArray($borderStyle);

                $sheet->getColumnDimension('A')->setWidth(9);
                $sheet->getColumnDimension('B')->setWidth(13);
                $sheet->getColumnDimension('C')->setWidth(20);
                $sheet->getColumnDimension('D')->setWidth(20);
                $sheet->getColumnDimension('E')->setWidth(50);
                $sheet->getColumnDimension('F')->setWidth(15);
                $sheet->getColumnDimension('G')->setWidth(15);
                $sheet->getColumnDimension('H')->setWidth(15);
                $sheet->getColumnDimension('I')->setWidth(15);
                $sheet->getColumnDimension('J')->setWidth(15);
                $sheet->getColumnDimension('K')->setWidth(15);
                $sheet->getColumnDimension('L')->setWidth(10);
                $sheet->getColumnDimension('M')->setWidth(15);
                $sheet->getColumnDimension('N')->setWidth(15);
                $sheet->getColumnDimension('O')->setWidth(15);
                $sheet->getColumnDimension('P')->setWidth(20);
                $sheet->getColumnDimension('Q')->setWidth(20);
                $sheet->getColumnDimension('R')->setWidth(100);
            },
        ];
    }
}
