<?php

namespace App\Exports;

use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\FromCollection;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class CreditExport implements WithStyles, WithEvents
{
    protected $data;   // Dữ liệu được truyền vào

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function styles(Worksheet $sheet)
    {
        $sheet->mergeCells('A1:D6');
        $sheet->mergeCells('E1:L1');
        $sheet->mergeCells('E2:L2');
        $sheet->mergeCells('E3:L3');
        $sheet->mergeCells('E4:L4');
        $sheet->mergeCells('E5:L5');
        $sheet->mergeCells('E6:L6');
        $sheet->mergeCells('M1:Q6');

        $sheet->mergeCells('B10:I10');
        $sheet->mergeCells('B11:I11');
        $sheet->mergeCells('B12:I12');
        $sheet->mergeCells('B13:I13');
        $sheet->mergeCells('B14:I14');


        return [
            'A1:D6' => ['alignment' => ['horizontal' => 'center', 'vertical' => 'center']],
            'M1:Q6' => [
                'font' => ['bold' => true, 'size' => 15],
                'alignment' => ['horizontal' => 'center', 'vertical' => 'center'],
            ],
            'E1' => [
                'bold' => true,
                'size' => 13,
                'color' => ['argb' => 'FFFF0000'], // Red color in ARGB format
            ],
            'E6' => [
                'font' => [
                    'bold' => true,
                    'size' => 12,
                    'color' => ['argb' => '000000'], // 
                ],
            ],
            'B9' => [
                'font' => [
                    'bold' => true,
                ],
            ],
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $borderStyle = [
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '000000'],
                        ],
                    ],
                ];

                $credit = $this->data['credit'];
                $creater = $this->data['creater'];
                $customer = $this->data['customer'];

                $path = 'public/config/info-debit.json';
                $info_credit = Storage::get($path);
                $info_credit = json_decode($info_credit, true);
                $info_credit = $info_credit['excels'];
                $header = $info_credit['header'];

                $sheet = $event->sheet->getDelegate();

                $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
                $drawing->setName('Logo');
                $drawing->setDescription('Company Logo');
                $drawing->setPath(public_path(LOGO));
                $drawing->setHeight(50);
                $drawing->setCoordinates('B2');
                $drawing->setOffsetX(10);
                $drawing->setOffsetY(10);
                $drawing->setWorksheet($sheet);;

                $sheet->setCellValue('E1', $header[0] ?? '');

                $sheet->setCellValue('E2', $header[1] ?? '');
                $sheet->setCellValue('E3', $header[2] ?? '');
                $sheet->setCellValue('E4', $header[3] ?? '');
                $sheet->setCellValue('E5', $header[4] ?? '');
                $sheet->setCellValue('E6', 'Prepared by: ' . $creater->user_contact_name);
                $sheet->setCellValue('M1', 'CREDIT NO');

                $sheet->setCellValue('B9', 'Bill To');
                $sheet->setCellValue('B10', 'Customer: ' . $customer->user_company_name);
                $sheet->setCellValue('B11', 'Adress: ' . $customer->user_address);
                $sheet->setCellValue('B12', 'VAT/CODE: ' . $customer->user_phone);
                $sheet->setCellValue('B13', 'Tel/Fax No: ' . $customer->user_phone);
                $sheet->setCellValue('B14', 'Contact Name: ' . $customer->user_contact_name);

                $sheet->setCellValue('M10', 'CREDIT NO: ' . $credit['credit_no']);
                $sheet->setCellValue('M11', 'Date time: ' . Carbon::now()->format('Y-m-d H:i:s'));
                $sheet->setCellValue('M12', 'CREDIT TERM: ' );
                $sheet->setCellValue('M13', 'CURRENCY: VND');

                $sheet->setCellValue('A16', 'DATE');
                $sheet->setCellValue('B16', 'KG BILL NO');
                $sheet->setCellValue('C16', 'TRACKING');
                $sheet->setCellValue('D16', 'COMPANY NAME');
                $sheet->setCellValue('E16', 'CONTACT NAME');
                $sheet->setCellValue('F16', 'SERVICE');
                $sheet->setCellValue('G16', 'BRAND');
                $sheet->setCellValue('H16', 'STATE');
                $sheet->setCellValue('I16', 'DESTINATION');
                $sheet->setCellValue('J16', 'QTY PACKAGES');
                $sheet->setCellValue('K16', 'HAWB#');
                $sheet->setCellValue('L16', 'TYPE');
                $sheet->setCellValue('M16', 'CHARGEABLE WEIGHT');
                $sheet->setCellValue('N16', 'TOTAL VALUE');
                $sheet->setCellValue('O16', 'GOODS COMPENSATION');
                $sheet->setCellValue('P16', 'TOTAL');
                $sheet->setCellValue('Q16', 'NOTE');
                $sheet->getStyle('A16:Q16')->applyFromArray([
                    'font' => [
                        'bold' => true,
                        'color' => ['argb' => 'FFFFFFFF'], // White color for text in ARGB
                    ],
                    'fill' => [
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'startColor' => ['argb' => 'FF007D88'],
                    ],
                ]);

                $packages = $this->data['packages'] ?? [];
                $num_start = 17;
                foreach ($packages as $key => $package) {
                    $sheet->setCellValue('A' . $num_start, formatDate($package['created_at']));
                    $sheet->setCellValue('B' . $num_start, $package['shipment_code']);
                    $sheet->setCellValue('C' . $num_start, $package['package_tracking_code']);
                    $sheet->setCellValue('D' . $num_start, $package['receiver_company_name']);
                    $sheet->setCellValue('E' . $num_start, $package['receiver_contact_name']);
                    $sheet->setCellValue('F' . $num_start, $package['service_name']);
                    $sheet->setCellValue('G' . $num_start, $package['branch_name']);
                    $sheet->setCellValue('H' . $num_start, $package['state_code']);
                    $sheet->setCellValue('I' . $num_start, $package['country_name']);
                    $sheet->setCellValue('J' . $num_start, 1);
                    $sheet->setCellValue('K' . $num_start, $package['package_code']);
                    $sheet->setCellValue('L' . $num_start, $package['package_type_name']);
                    $sheet->setCellValue('M' . $num_start, $package['package_charged_weight']);
                    $sheet->setCellValue('N' . $num_start, number_format($package['value_package']));
                    $sheet->setCellValue('O' . $num_start, number_format($package['goods_compensation']));
                    $sheet->setCellValue('P' . $num_start, number_format($package['total_value']));
                    $sheet->setCellValue('Q' . $num_start, $package['credit_item_note']);

                    $num_start++;
                }
                $sheet->mergeCells("A$num_start:O$num_start");
                $sheet->setCellValue("A$num_start", 'TOTAL');
                $total_amount = collect($packages)->sum('total_value');
                $sheet->setCellValue("P$num_start", number_format($total_amount));
                $sheet->getStyle("A$num_start:O$num_start")->applyFromArray([
                    'font' => [
                        'bold' => true,
                        'size' => 15,
                        'color' => ['argb' => '000000'], // 
                    ],
                ]);
                $sheet->getStyle("A16:Q$num_start")->applyFromArray($borderStyle);


                // *Ghi chú
                $num_start = $num_start + 2;
                $sheet->setCellValue("A$num_start", '*Ghi chú');

                $sheet->getStyle('A1:D6')->applyFromArray($borderStyle);
                $sheet->getStyle('E1:L6')->applyFromArray($borderStyle);
                $sheet->getStyle('M1:O6')->applyFromArray($borderStyle);
                $sheet->getStyle('A16:Q16')->applyFromArray($borderStyle);

                $sheet->getColumnDimension('A')->setWidth(9);
                $sheet->getColumnDimension('B')->setWidth(13);
                $sheet->getColumnDimension('C')->setWidth(20);
                $sheet->getColumnDimension('D')->setWidth(20);
                $sheet->getColumnDimension('E')->setWidth(50);
                $sheet->getColumnDimension('F')->setWidth(15);
                $sheet->getColumnDimension('G')->setWidth(15);
                $sheet->getColumnDimension('H')->setWidth(15);
                $sheet->getColumnDimension('I')->setWidth(15);
                $sheet->getColumnDimension('J')->setWidth(15);
                $sheet->getColumnDimension('K')->setWidth(15);
                $sheet->getColumnDimension('L')->setWidth(10);
                $sheet->getColumnDimension('M')->setWidth(15); 
                $sheet->getColumnDimension('N')->setWidth(15);
                $sheet->getColumnDimension('O')->setWidth(15);
                $sheet->getColumnDimension('P')->setWidth(20);
                $sheet->getColumnDimension('Q')->setWidth(20);
            },
        ];
    }
}
