<?php

namespace App\Console\Commands;

use App\Models\State;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class ImportPostalCodeByState extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'task:import_postal_code_by_state';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create postal code by state';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try {
            $states = State::isDelete(NO_DELETE)
            ->whereNotNull('state_latitude')
            ->whereNotNull('state_longitude')
            ->whereNull('state_post_code')
            ->take(3000)->get()->toArray();
            foreach ($states as $state) {
                $response = Http::get('https://api.geoapify.com/v1/geocode/reverse', [
                    'lat' => $state['state_latitude'],
                    'lon' => $state['state_longitude'],
                    'type' => 'postcode',
                    'format' => 'json',
                    'apiKey' => '19375db5602841fa81f6ac5a48620d44'
                ]);
                if ($response->successful()) {
                    $data = json_decode($response->body(), true);
                    if(isset($data['results'][0]['postcode'])){
                        State::findOrFail($state['state_id'])->update([
                            'state_post_code' => $data['results'][0]['postcode'],
                        ]);
                    }
                }
            }
            $this->info('Successfully updated!');
        } catch (\Throwable $th) {
            $this->error('Error updating!');
        }
    }
}
