<?php

namespace App\Console\Commands;

use App\Models\City;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class ImportPostalCodeByCity extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'task:import_postal_code_by_city';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create postal code by city';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try {
            $cities = City::isDelete(NO_DELETE)
            ->whereNotNull('city_latitude')
            ->whereNotNull('city_longitude')
            ->whereNull('city_post_code')
            ->take(3000)->get()->toArray();
            foreach ($cities as $city) {
                $response = Http::get('https://api.geoapify.com/v1/geocode/reverse', [
                    'lat' => $city['city_latitude'],
                    'lon' => $city['city_longitude'],
                    'type' => 'postcode',
                    'format' => 'json',
                    'apiKey' => '19375db5602841fa81f6ac5a48620d44'
                ]);
                if ($response->successful()) {
                    $data = json_decode($response->body(), true);
                    if(isset($data['results'][0]['postcode'])){
                        City::findOrFail($city['city_id'])->update([
                            'city_post_code' => $data['results'][0]['postcode'],
                        ]);
                    }
                }
            }
            $this->info('Successfully updated!');
        } catch (\Throwable $th) {
            $this->error('Error updating!');
        }
    }
}
