<?php

namespace App\Console\Commands;

use App\Models\Country;
use App\Models\State;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class GetStates extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'task:create_states';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create states';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        DB::beginTransaction();
        try {
            $countries = Country::get()->toArray();
            
            foreach ($countries as $country) {
                $states = collect(config('constans.states'))->where('country_name', $country['country_name'])->where('country_code', $country['country_code'])->toArray();
                foreach ($states as $state) {
                    State::create([
                        'country_id' => $country['country_id'],
                        'state_name' => $state['name'],
                        'state_code' => $state['state_code'],
                        'state_details' => 'remote',
                        'state_latitude' => $state['latitude'],
                        'state_longitude' => $state['longitude'],
                        'active_flg' => ACTIVE,
                    ]);
                }
            }
            DB::commit();
            $this->info('Successfully updated!');
        } catch (\Throwable $th) {
            DB::rollback();
            $this->error('Error updating!');
        }
    }
}
