<?php

namespace App\Console\Commands;

use App\Models\Country;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class GetCountries extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'task:create_countries';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create countries';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        DB::beginTransaction();
        try {
            $countries = collect(config('constans.countries'))->pluck('name', 'iso2');
            foreach ($countries as $iso2 => $country) {
                Country::create([
                    'country_name' => $country,
                    'country_code' => $iso2,
                    'active_flg' => ACTIVE
                ]);
            }
            DB::commit();
            $this->info('Successfully updated!');
        } catch (\Throwable $th) {
            DB::rollback();
            $this->error('Error updating!');
        }
    }
}
