<?php

namespace App\Console\Commands;

use App\Models\City;
use App\Models\State;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class GetCities extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'task:create_cities';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create cities';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        ini_set('memory_limit', '4095M');
        // DB::beginTransaction();
        try {
            $response = Http::get('https://raw.githubusercontent.com/dr5hn/countries-states-cities-database/master/cities.json');
            if ($response->successful()) {
                $cities = $response->json();
                foreach ($cities as $city) {
                    $state = State::where('state_name', $city['state_name'])->where('state_code', $city['state_code'])->first();
                    if(isset($state)){
                        City::create([
                            'country_id' => $state['country_id'],
                            'state_id' => $state['state_id'],
                            'city_name' => $city['name'],
                            'city_latitude' => $city['latitude'],
                            'city_longitude' => $city['longitude'],
                            'active_flg' => ACTIVE, 
                        ]);
                    }
                }
                $this->info('Countries data fetched and processed successfully!');
            } else {
                $this->error('Failed to fetch data');
            }
            // DB::commit();
        } catch (\Throwable $th) {
            // DB::rollback();
            dump($th);
            $this->error('Error updating!');
        }
    }
}
