<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class ConvertData extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'task:convert_data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Handle data conversion';

    /**
     * Execute the console command.
     * @return void
     */
    public function handle()
    {
        try {
            DB::beginTransaction();

            // Cập nhật loại bảng giá cho user
            $this->handleUpdatePriceListType();

            DB::commit();
            $this->info('Data conversion completed successfully!');
        } catch (\Throwable $th) {
            $this->error('Error occurred while converting data');
        }
    }

    /**
     * Cập nhật loại bảng giá cho user FWD
     * @return void
     */
    private function handleUpdatePriceListType()
    {
        // Cập nhật loại bảng giá là F1 cho tất cả user
        User::query()->update([
            'user_price_list_main_type' => USER_TYPE_F1,
        ]);
    }
}
